/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ProjectParticipationOrderStep;
import at.cdes.impl.dao.ProjectParticipationOrderStepDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcProjectParticipationOrderStepDAO
extends AbstrIdDAO<ProjectParticipationOrderStep>
implements ProjectParticipationOrderStepDAO {
    public JdbcProjectParticipationOrderStepDAO() {
        super(ProjectParticipationOrderStep.class, "orderStepId", "project_participation_order_step", new String[]{"order_step_id", "project_participation_id", "signer_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcProjectParticipationOrderStepDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_step_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participation_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signer_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcProjectParticipationOrderStepDAO.getSelectClauseForDto("project_participation_order_step", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcProjectParticipationOrderStepDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".order_step_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "order_step_id") + "," + entityLocalName + ".project_participation_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participation_id") + "," + entityLocalName + ".signer_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signer_id") + " ";
    }

    protected ProjectParticipationOrderStep fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ProjectParticipationOrderStep projectParticipationOrderStep = new ProjectParticipationOrderStep();
        projectParticipationOrderStep.setOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        projectParticipationOrderStep.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        projectParticipationOrderStep.setSignerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return projectParticipationOrderStep;
    }

    public static ProjectParticipationOrderStep fillProjectParticipationOrderStepFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ProjectParticipationOrderStep projectParticipationOrderStep = new ProjectParticipationOrderStep();
        projectParticipationOrderStep.setOrderStepId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        projectParticipationOrderStep.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        projectParticipationOrderStep.setSignerId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return projectParticipationOrderStep;
    }

    public static ProjectParticipationOrderStep fillProjectParticipationOrderStepFromResultSet(ResultSet rs) throws SQLException {
        return JdbcProjectParticipationOrderStepDAO.fillProjectParticipationOrderStepFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 3;
    }

    @Override
    public void deleteByOrderStep(final Long orderStepId) {
        String sql = "DELETE FROM project_participation_order_step WHERE order_step_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, orderStepId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(ProjectParticipationOrderStep dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ProjectParticipationOrderStep> dtos) {
        Iterator<ProjectParticipationOrderStep> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ProjectParticipationOrderStep projectParticipationOrderStep) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)projectParticipationOrderStep.getOrderStepId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)projectParticipationOrderStep.getProjectParticipationId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)projectParticipationOrderStep.getSignerId());
    }

    @Override
    public List<ProjectParticipationOrderStep> getByOrderStep(OrderStep orderStep) {
        return this.getByOrderStep(orderStep.getId());
    }

    @Override
    public List<ProjectParticipationOrderStep> getByOrderStep(final Long orderStepId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_step_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, orderStepId);
            }
        });
    }

    @Override
    public List<ProjectParticipationOrderStep> getByProjectParticipation(ProjectParticipation projectParticipation) {
        return this.getByProjectParticipation(projectParticipation.getId());
    }

    @Override
    public List<ProjectParticipationOrderStep> getByProjectParticipation(final Long projectParticipationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participation_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectParticipationId);
            }
        });
    }

    @Override
    public List<ProjectParticipationOrderStep> getBySigner(ProjectParticipant projectParticipant) {
        return this.getBySigner(projectParticipant.getId());
    }

    @Override
    public List<ProjectParticipationOrderStep> getBySigner(final Long projectParticipantId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signer_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectParticipantId);
            }
        });
    }

    @Override
    public List<ProjectParticipationOrderStep> getByOrderSteps(Collection<Long> orderStepId) {
        if (orderStepId.isEmpty()) {
            return new ArrayList<ProjectParticipationOrderStep>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[orderStepId.size()];
        int n = 0;
        Iterator<Long> it = orderStepId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"order_step_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ProjectParticipationOrderStep> getByProjectParticipations(Collection<Long> projectParticipationId) {
        if (projectParticipationId.isEmpty()) {
            return new ArrayList<ProjectParticipationOrderStep>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectParticipationId.size()];
        int n = 0;
        Iterator<Long> it = projectParticipationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participation_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ProjectParticipationOrderStep> getBySigners(Collection<Long> projectParticipantId) {
        if (projectParticipantId.isEmpty()) {
            return new ArrayList<ProjectParticipationOrderStep>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectParticipantId.size()];
        int n = 0;
        Iterator<Long> it = projectParticipantId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signer_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

