/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DigestCalculator;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentReference;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.impl.dao.GenDocumentReferenceDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcDocumentReferenceDAO
extends AbstrIdDAO<DocumentReference>
implements GenDocumentReferenceDAO {
    public AbstractJdbcDocumentReferenceDAO() {
        super(DocumentReference.class, "id", "document_reference", new String[]{"id", "realm", "gz", "reference", "url", "comment", "created", "document_id", "since_docversion_id", "until_docversion_id", "referenced_version_id", "attachment_filename", "attachment_original_filename", "attachment_filetype", "digest", "digest_calculator_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcDocumentReferenceDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "realm") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "gz") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "reference") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "url") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "created") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "since_docversion_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "until_docversion_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "referenced_version_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "attachment_filename") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "attachment_original_filename") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "attachment_filetype") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcDocumentReferenceDAO.getSelectClauseForDto("document_reference", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcDocumentReferenceDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".realm" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "realm") + "," + entityLocalName + ".gz" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "gz") + "," + entityLocalName + ".reference" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "reference") + "," + entityLocalName + ".url" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "url") + "," + entityLocalName + ".comment" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + "," + entityLocalName + ".created" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "created") + "," + entityLocalName + ".document_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_id") + "," + entityLocalName + ".since_docversion_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "since_docversion_id") + "," + entityLocalName + ".until_docversion_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "until_docversion_id") + "," + entityLocalName + ".referenced_version_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "referenced_version_id") + "," + entityLocalName + ".attachment_filename" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "attachment_filename") + "," + entityLocalName + ".attachment_original_filename" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "attachment_original_filename") + "," + entityLocalName + ".attachment_filetype" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "attachment_filetype") + "," + entityLocalName + ".digest" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest") + "," + entityLocalName + ".digest_calculator_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + " ";
    }

    protected DocumentReference fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        DocumentReference documentReference = new DocumentReference();
        documentReference.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentReference.setRealm(rs.getString(++columnIndex));
        documentReference.setGz(rs.getString(++columnIndex));
        documentReference.setReference(rs.getString(++columnIndex));
        documentReference.setUrl(rs.getString(++columnIndex));
        documentReference.setComment(rs.getString(++columnIndex));
        documentReference.setCreated(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        documentReference.setDocumentId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentReference.setSinceDocversionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentReference.setUntilDocversionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentReference.setReferencedVersionId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentReference.setAttachmentFilename(rs.getString(++columnIndex));
        documentReference.setAttachmentOriginalFilename(rs.getString(++columnIndex));
        documentReference.setAttachmentFiletype(rs.getString(++columnIndex));
        documentReference.setDigest(rs.getString(++columnIndex));
        documentReference.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return documentReference;
    }

    public static DocumentReference fillDocumentReferenceFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        DocumentReference documentReference = new DocumentReference();
        documentReference.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentReference.setRealm(rs.getString(columnIndex.incrementAndGet()));
        documentReference.setGz(rs.getString(columnIndex.incrementAndGet()));
        documentReference.setReference(rs.getString(columnIndex.incrementAndGet()));
        documentReference.setUrl(rs.getString(columnIndex.incrementAndGet()));
        documentReference.setComment(rs.getString(columnIndex.incrementAndGet()));
        documentReference.setCreated(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentReference.setDocumentId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentReference.setSinceDocversionId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentReference.setUntilDocversionId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentReference.setReferencedVersionId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentReference.setAttachmentFilename(rs.getString(columnIndex.incrementAndGet()));
        documentReference.setAttachmentOriginalFilename(rs.getString(columnIndex.incrementAndGet()));
        documentReference.setAttachmentFiletype(rs.getString(columnIndex.incrementAndGet()));
        documentReference.setDigest(rs.getString(columnIndex.incrementAndGet()));
        documentReference.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return documentReference;
    }

    public static DocumentReference fillDocumentReferenceFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcDocumentReferenceDAO.fillDocumentReferenceFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 16;
    }

    public int update(DocumentReference dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<DocumentReference> dtos) {
        Iterator<DocumentReference> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, DocumentReference documentReference) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentReference.getId());
        statement.setString(2, documentReference.getRealm());
        statement.setString(3, documentReference.getGz());
        statement.setString(4, documentReference.getReference());
        statement.setString(5, documentReference.getUrl());
        statement.setString(6, documentReference.getComment());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)7, (Double)documentReference.getCreated());
        JDBCHelper.setLong((PreparedStatement)statement, (int)8, (Number)documentReference.getDocumentId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)9, (Number)documentReference.getSinceDocversionId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)10, (Number)documentReference.getUntilDocversionId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)11, (Number)documentReference.getReferencedVersionId());
        statement.setString(12, documentReference.getAttachmentFilename());
        statement.setString(13, documentReference.getAttachmentOriginalFilename());
        statement.setString(14, documentReference.getAttachmentFiletype());
        statement.setString(15, documentReference.getDigest());
        JDBCHelper.setLong((PreparedStatement)statement, (int)16, (Number)documentReference.getDigestCalculatorId());
    }

    @Override
    public List<DocumentReference> getByDocument(Document document) {
        return this.getByDocument(document.getId());
    }

    @Override
    public List<DocumentReference> getByDocument(final Long documentId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentId);
            }
        });
    }

    @Override
    public List<DocumentReference> getBySinceDocversion(DocumentVersion documentVersion) {
        return this.getBySinceDocversion(documentVersion.getId());
    }

    @Override
    public List<DocumentReference> getBySinceDocversion(final Long documentVersionId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"since_docversion_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentVersionId);
            }
        });
    }

    @Override
    public List<DocumentReference> getByUntilDocversion(DocumentVersion documentVersion) {
        return this.getByUntilDocversion(documentVersion.getId());
    }

    @Override
    public List<DocumentReference> getByUntilDocversion(final Long documentVersionId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"until_docversion_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentVersionId);
            }
        });
    }

    @Override
    public List<DocumentReference> getByReferencedVersion(DocumentVersion documentVersion) {
        return this.getByReferencedVersion(documentVersion.getId());
    }

    @Override
    public List<DocumentReference> getByReferencedVersion(final Long documentVersionId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"referenced_version_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentVersionId);
            }
        });
    }

    @Override
    public List<DocumentReference> getByDigestCalculator(DigestCalculator digestCalculator) {
        return this.getByDigestCalculator(digestCalculator.getId());
    }

    @Override
    public List<DocumentReference> getByDigestCalculator(final Long digestCalculatorId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, digestCalculatorId);
            }
        });
    }

    @Override
    public List<DocumentReference> getByDocuments(Collection<Long> documentId) {
        if (documentId.isEmpty()) {
            return new ArrayList<DocumentReference>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentId.size()];
        int n = 0;
        Iterator<Long> it = documentId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentReference> getBySinceDocversions(Collection<Long> documentVersionId) {
        if (documentVersionId.isEmpty()) {
            return new ArrayList<DocumentReference>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentVersionId.size()];
        int n = 0;
        Iterator<Long> it = documentVersionId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"since_docversion_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentReference> getByUntilDocversions(Collection<Long> documentVersionId) {
        if (documentVersionId.isEmpty()) {
            return new ArrayList<DocumentReference>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentVersionId.size()];
        int n = 0;
        Iterator<Long> it = documentVersionId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"until_docversion_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentReference> getByReferencedVersions(Collection<Long> documentVersionId) {
        if (documentVersionId.isEmpty()) {
            return new ArrayList<DocumentReference>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentVersionId.size()];
        int n = 0;
        Iterator<Long> it = documentVersionId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"referenced_version_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentReference> getByDigestCalculators(Collection<Long> digestCalculatorId) {
        if (digestCalculatorId.isEmpty()) {
            return new ArrayList<DocumentReference>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[digestCalculatorId.size()];
        int n = 0;
        Iterator<Long> it = digestCalculatorId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

