/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ConsortiumMember;
import at.cdes.api.dto.Organisation;
import at.cdes.impl.dao.ConsortiumMemberDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcConsortiumMemberDAO
extends AbstrIdDAO<ConsortiumMember>
implements ConsortiumMemberDAO {
    public JdbcConsortiumMemberDAO() {
        super(ConsortiumMember.class, "consortiumId", "consortium_member", new String[]{"consortium_id", "organisation_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcConsortiumMemberDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "consortium_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcConsortiumMemberDAO.getSelectClauseForDto("consortium_member", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcConsortiumMemberDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".consortium_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "consortium_id") + "," + entityLocalName + ".organisation_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_id") + " ";
    }

    protected ConsortiumMember fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ConsortiumMember consortiumMember = new ConsortiumMember();
        consortiumMember.setConsortiumId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        consortiumMember.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return consortiumMember;
    }

    public static ConsortiumMember fillConsortiumMemberFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ConsortiumMember consortiumMember = new ConsortiumMember();
        consortiumMember.setConsortiumId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        consortiumMember.setOrganisationId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return consortiumMember;
    }

    public static ConsortiumMember fillConsortiumMemberFromResultSet(ResultSet rs) throws SQLException {
        return JdbcConsortiumMemberDAO.fillConsortiumMemberFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 2;
    }

    @Override
    public void deleteByConsortium(final Long consortiumId) {
        String sql = "DELETE FROM consortium_member WHERE consortium_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, consortiumId);
                statement.execute();
                return null;
            }
        });
    }

    @Override
    public void deleteByOrganisation(final Long organisationId) {
        String sql = "DELETE FROM consortium_member WHERE organisation_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, organisationId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(ConsortiumMember dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ConsortiumMember> dtos) {
        Iterator<ConsortiumMember> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ConsortiumMember consortiumMember) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)consortiumMember.getConsortiumId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)consortiumMember.getOrganisationId());
    }

    @Override
    public List<ConsortiumMember> getByConsortium(Organisation organisation) {
        return this.getByConsortium(organisation.getId());
    }

    @Override
    public List<ConsortiumMember> getByConsortium(final Long organisationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"consortium_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationId);
            }
        });
    }

    @Override
    public List<ConsortiumMember> getByOrganisation(Organisation organisation) {
        return this.getByOrganisation(organisation.getId());
    }

    @Override
    public List<ConsortiumMember> getByOrganisation(final Long organisationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationId);
            }
        });
    }

    @Override
    public List<ConsortiumMember> getByConsortiums(Collection<Long> organisationId) {
        if (organisationId.isEmpty()) {
            return new ArrayList<ConsortiumMember>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationId.size()];
        int n = 0;
        Iterator<Long> it = organisationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"consortium_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ConsortiumMember> getByOrganisations(Collection<Long> organisationId) {
        if (organisationId.isEmpty()) {
            return new ArrayList<ConsortiumMember>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationId.size()];
        int n = 0;
        Iterator<Long> it = organisationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

