/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.MasterDataSet;
import at.cdes.api.dto.Network;
import at.cdes.api.joinDto.LabelContentDocTypeJoin;
import at.cdes.impl.dao.GenDocumentTypeDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcDocumentTypeDAO
extends AbstrIdDAO<DocumentType>
implements GenDocumentTypeDAO {
    public AbstractJdbcDocumentTypeDAO() {
        super(DocumentType.class, "id", "document_type", new String[]{"id", "document_type_group_id", "network_id", "code", "name", "description", "master_data_set_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcDocumentTypeDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_type_group_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "master_data_set_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcDocumentTypeDAO.getSelectClauseForDto("document_type", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcDocumentTypeDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".document_type_group_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_type_group_id") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + "," + entityLocalName + ".code" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + "," + entityLocalName + ".master_data_set_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "master_data_set_id") + " ";
    }

    protected DocumentType fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        DocumentType documentType = new DocumentType();
        documentType.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentType.setDocumentTypeGroupId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentType.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentType.setCode(rs.getString(++columnIndex));
        documentType.setName(rs.getString(++columnIndex));
        documentType.setDescription(rs.getString(++columnIndex));
        documentType.setMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return documentType;
    }

    public static DocumentType fillDocumentTypeFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        DocumentType documentType = new DocumentType();
        documentType.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentType.setDocumentTypeGroupId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentType.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentType.setCode(rs.getString(columnIndex.incrementAndGet()));
        documentType.setName(rs.getString(columnIndex.incrementAndGet()));
        documentType.setDescription(rs.getString(columnIndex.incrementAndGet()));
        documentType.setMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return documentType;
    }

    public static DocumentType fillDocumentTypeFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcDocumentTypeDAO.fillDocumentTypeFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 7;
    }

    public static LabelContentDocTypeJoin fillLabelContentDocTypeJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        LabelContentDocTypeJoin labelContentDocTypeJoin = new LabelContentDocTypeJoin();
        labelContentDocTypeJoin.setDocumentTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelContentDocTypeJoin.setDocumentTypeDocumentTypeGroupId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelContentDocTypeJoin.setDocumentTypeNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelContentDocTypeJoin.setDocumentTypeCode(rs.getString(++columnIndex));
        labelContentDocTypeJoin.setDocumentTypeName(rs.getString(++columnIndex));
        labelContentDocTypeJoin.setDocumentTypeDescription(rs.getString(++columnIndex));
        labelContentDocTypeJoin.setDocumentTypeMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelContentDocTypeJoin.setDocumentTypeLabelContentDocumentTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelContentDocTypeJoin.setDocumentTypeLabelContentLabelContentId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelContentDocTypeJoin.setMasterDataSetId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        labelContentDocTypeJoin.setMasterDataSetName(rs.getString(++columnIndex));
        labelContentDocTypeJoin.setMasterDataSetDescription(rs.getString(++columnIndex));
        labelContentDocTypeJoin.setMasterDataSetNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return labelContentDocTypeJoin;
    }

    public static int getNumberOfLabelContentDocTypeJoinAttributes() {
        return 13;
    }

    @Override
    public void deleteByNetworkId(final Long networkId) {
        String sql = "DELETE FROM document_type WHERE network_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, networkId);
                statement.execute();
                return null;
            }
        });
    }

    protected String getSelectClauseForLabelContentDocTypeJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("documentType") ? result + "document_type.id, document_type.document_type_group_id, document_type.network_id, document_type.code, document_type.name, document_type.description, document_type.master_data_set_id" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("documentTypeLabelContent") ? result + "document_type_label_content.document_type_id, document_type_label_content.label_content_id" : result + "NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("masterDataSet") ? result + "master_data_set.id, master_data_set.name, master_data_set.description, master_data_set.network_id" : result + "NULL, NULL, NULL, NULL";
        return result;
    }

    public int update(DocumentType dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<DocumentType> dtos) {
        Iterator<DocumentType> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getLabelContentDocTypeJoinSelectClause() {
        return "document_type.id, document_type.document_type_group_id, document_type.network_id, document_type.code, document_type.name, document_type.description, document_type.master_data_set_id, document_type_label_content.document_type_id, document_type_label_content.label_content_id, master_data_set.id, master_data_set.name, master_data_set.description, master_data_set.network_id ";
    }

    public static String getPrefixedLabelContentDocTypeJoinSelectClause() {
        return "document_type.id AS document_type_id, document_type.document_type_group_id AS document_type_document_type_group_id, document_type.network_id AS document_type_network_id, document_type.code AS document_type_code, document_type.name AS document_type_name, document_type.description AS document_type_description, document_type.master_data_set_id AS document_type_master_data_set_id, document_type_label_content.document_type_id AS document_type_label_content_document_type_id, document_type_label_content.label_content_id AS document_type_label_content_label_content_id, master_data_set.id AS master_data_set_id, master_data_set.name AS master_data_set_name, master_data_set.description AS master_data_set_description, master_data_set.network_id AS master_data_set_network_id ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, DocumentType documentType) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentType.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)documentType.getDocumentTypeGroupId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)documentType.getNetworkId());
        statement.setString(4, documentType.getCode());
        statement.setString(5, documentType.getName());
        statement.setString(6, documentType.getDescription());
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)documentType.getMasterDataSetId());
    }

    @Override
    public List<DocumentType> getByDocumentTypeGroup(DocumentType documentType) {
        return this.getByDocumentTypeGroup(documentType.getId());
    }

    @Override
    public List<DocumentType> getByDocumentTypeGroup(final Long documentTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_type_group_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentTypeId);
            }
        });
    }

    @Override
    public List<DocumentType> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<DocumentType> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<DocumentType> getByMasterDataSet(MasterDataSet masterDataSet) {
        return this.getByMasterDataSet(masterDataSet.getId());
    }

    @Override
    public List<DocumentType> getByMasterDataSet(final Long masterDataSetId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"master_data_set_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, masterDataSetId);
            }
        });
    }

    @Override
    public List<DocumentType> getByDocumentTypeGroups(Collection<Long> documentTypeId) {
        if (documentTypeId.isEmpty()) {
            return new ArrayList<DocumentType>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentTypeId.size()];
        int n = 0;
        Iterator<Long> it = documentTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_type_group_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentType> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<DocumentType>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentType> getByMasterDataSets(Collection<Long> masterDataSetId) {
        if (masterDataSetId.isEmpty()) {
            return new ArrayList<DocumentType>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[masterDataSetId.size()];
        int n = 0;
        Iterator<Long> it = masterDataSetId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"master_data_set_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

