/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.joinDto.ExecutingParticipationJoin;
import at.cdes.api.joinDto.ProjectParticipantJoin;
import at.cdes.api.voc.RoleTypeEnum;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcProjectParticipantDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcProjectParticipantDAO
extends AbstractJdbcProjectParticipantDAO
implements ProjectParticipantDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcProjectParticipantDAO.class);

    @Override
    public ProjectParticipant getSigner(final Long organisationPersonId, final Long projectId, final String ... actionNames) {
        String sql = "SELECT " + JdbcProjectParticipantDAO.getSelectClauseForDto() + JdbcProjectParticipantDAO.getGetSignerFromWhereClause(actionNames.length);
        List projectParticipants = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipant>>(){

            public List<ProjectParticipant> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                for (String actionName : actionNames) {
                    statement.setString(currIndex++, actionName);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipant> ret = new ArrayList<ProjectParticipant>();
                while (rs.next()) {
                    ret.add(JdbcProjectParticipantDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
        String actionNameString = "";
        for (int n = 0; n < actionNames.length; ++n) {
            actionNameString = actionNameString + actionNames[n];
            actionNameString = actionNameString + (n < actionNames.length - 1 ? "," : "");
        }
        if (projectParticipants.size() == 0) {
            return null;
        }
        if (projectParticipants.size() >= 1) {
            if (projectParticipants.size() > 1) {
                log.warn("Could not find a unique projectParticipant for organisationPersonId = [" + organisationPersonId + "], projectId = [" + projectId + "] and actionName = [" + actionNameString + "]; " + projectParticipants.size() + " candidate instances found. Please take care about this case.");
            }
            return (ProjectParticipant)projectParticipants.get(0);
        }
        throw new DAOException("Could not find a unique ProjectParticipant for organisationPersonId = [" + organisationPersonId + "], projectId = [" + projectId + "] and actionName = [" + actionNameString + "]");
    }

    public static String getGetSignerFromWhereClause(int numberOfActions) {
        return "FROM (((((((project_participant JOIN organisation_person         ON project_participant.organisation_person_id = organisation_person.id) JOIN person                      ON organisation_person.person_id = person.id) JOIN project_participation       ON project_participant.participation_id = project_participation.id) CROSS JOIN action ) JOIN action_rule                 ON     action_rule.action_id = action.id) JOIN cdes_role                   ON     project_participation.role_id = cdes_role.id) JOIN role_action_rule            ON     role_action_rule.action_rule_id = action_rule.id AND role_action_rule.cdes_role_id = cdes_role.id) WHERE project_participant.organisation_person_id = ? AND project_participant.inactive_flag = 0 AND project_participation.project_id = ? AND action.name IN (" + QueryHelper.getPlaceHolderSequence(numberOfActions) + ")";
    }

    public static int populateSignerClause(PreparedStatement statement, int currIndex, Long organisationPersonId, Long projectId, String ... actionNames) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
        for (String actionName : actionNames) {
            statement.setString(currIndex++, actionName);
        }
        return currIndex;
    }

    @Override
    public List<ProjectParticipant> getSignerByOriginal(final Long organisationPersonId, final Long originalDocumentOrderId) {
        String sql = "SELECT " + JdbcProjectParticipantDAO.getSelectClauseForDto() + "FROM original_document_order JOIN project_participation ON original_document_order.document_owner_id = project_participation.id JOIN project_participant   ON project_participant.participation_id = project_participation.id WHERE original_document_order.id = ? AND project_participant.organisation_person_id = ? AND project_participant.inactive_flag = 0 ";
        List projectParticipants = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipant>>(){

            public List<ProjectParticipant> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)originalDocumentOrderId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipant> ret = new ArrayList<ProjectParticipant>();
                while (rs.next()) {
                    ret.add(JdbcProjectParticipantDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
        return projectParticipants;
    }

    @Override
    public List<ProjectParticipant> getByProject(final Long projectId) {
        String sql = "SELECT " + JdbcProjectParticipantDAO.getSelectClauseForDto() + "FROM (        project_participation LEFT JOIN project_participant                     ON project_participant.participation_id = project_participation.id) WHERE project_participation.project_id = ? ";
        List projectParticipants = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipant>>(){

            public List<ProjectParticipant> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipant> ret = new ArrayList<ProjectParticipant>();
                while (rs.next()) {
                    ret.add(JdbcProjectParticipantDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
        return projectParticipants;
    }

    @Override
    public ProjectParticipantJoin getParticipantJoinById(final Long projectParticipantId) {
        String sql = "SELECT " + JdbcProjectParticipantDAO.getProjectParticipantJoinSelectClause() + "FROM ((((( project_participant JOIN project_participation   ON project_participant.participation_id = project_participation.id) JOIN project                 ON project_participation.project_id = project.id) JOIN network                 ON project.network_id = network.id) JOIN organisation_person     ON project_participant.organisation_person_id = organisation_person.id) JOIN person                  ON organisation_person.person_id = person.id) WHERE project_participant.id = ?";
        ProjectParticipantJoin projectParticipantJoin = (ProjectParticipantJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ProjectParticipantJoin>(){

            public ProjectParticipantJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectParticipantId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    return AbstractJdbcProjectParticipantDAO.fillProjectParticipantJoinFromResultSet(rs);
                }
                return null;
            }
        });
        return projectParticipantJoin;
    }

    @Override
    public void deactiveBatch(Collection<Long> ids, String inactive_comment) {
        String sql = "UPDATE project_participant SET inactive_flag = 1, inactive_comment = ? WHERE project_participant.id IN (" + QueryHelper.getPlaceHolderSequence(ids.size()) + ")";
        this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            statement.setString(currIndex++, inactive_comment);
            for (Long id : ids) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)id);
            }
            statement.execute();
            return null;
        });
    }

    @Override
    public ProjectParticipant getByParticipationAndOrganisationPerson(Long projectParticipationid, Long organisationPersonId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM project_participant\nWHERE project_participant.inactive_flag = 0\n  AND project_participant.participation_id = ?\n  AND project_participant.organisation_person_id = ?\n";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(projectParticipationid).addLong(organisationPersonId));
    }

    @Override
    public ProjectParticipant getObjectPlannerReleasePlannerMainParticipant(Long objectPlannerReleaseId) {
        String sql = "SELECT " + JdbcProjectParticipantDAO.getSelectClauseForDto() + "FROM object_planner_release JOIN project_participation ON object_planner_release.planner_id = project_participation.id JOIN project_participant   ON project_participant.participation_id = project_participation.id AND project_participant.main_participant_flag = 1 AND project_participant.inactive_flag = 0 WHERE object_planner_release.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectPlannerReleaseId);
        });
    }

    @Override
    public List<ExecutingParticipationJoin> getProjectParticipantForTask(Long organisationPersonId, Long taskId) {
        String sql = "SELECT " + this.getExecutingParticipationJoinSelectClause() + "\n     FROM (document_version_task\n     JOIN document_version      ON document_version.id = document_version_task.document_version_id\n     JOIN document              ON document.id = document_version.document_id\n     JOIN document_list         ON document_list.id = document.document_list_id\n     JOIN sub_project           ON sub_project.id = document_list.sub_project_id\n     JOIN project               ON project.id = sub_project.project_id)\nLEFT JOIN organisation_person   ON organisation_person.id = ?\nLEFT JOIN (project_participant overriding_participant\n     JOIN project_participation ON project_participation.id = overriding_participant.participation_id\n     JOIN cdes_role             ON cdes_role.id = project_participation.role_id\n     JOIN role_action_rule      ON role_action_rule.cdes_role_id = cdes_role.id\n     JOIN action_rule           ON action_rule.id = role_action_rule.action_rule_id\n     JOIN action                ON action.id = action_rule.action_id\n                               AND action.name = '" + Action.OVERRIDE_LATE_REVIEWS.getName() + "'\n     JOIN role_type             ON role_type.id = cdes_role.type_id\n                               AND role_type.type = " + RoleTypeEnum.PROJECT_SURVEILLANT.getValue() + "\n                              ) ON overriding_participant.organisation_person_id = organisation_person.id\n                               AND overriding_participant.inactive_flag = 0\n                               AND project_participation.project_id = project.id\nLEFT JOIN project_participant   ON project_participant.participation_id = document_version_task.project_participation_id\n                               AND project_participant.inactive_flag = 0\n                               AND ((overriding_participant.id IS     NULL) OR project_participant.main_participant_flag = 1)\n                               AND ((overriding_participant.id IS NOT NULL) OR project_participant.organisation_person_id = organisation_person.id)\nLEFT JOIN project_participant actual_proxy_participant ON actual_proxy_participant.participation_id = document_version_task.project_participation_id\n                               AND actual_proxy_participant.inactive_flag = 0\n                               AND actual_proxy_participant.main_participant_flag = 0\n                               AND actual_proxy_participant.organisation_person_id = ?\nWHERE document_version_task.task_id = ?\n";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, AbstractJdbcProjectParticipantDAO::fillExecutingParticipationJoinFromResultSet, filler -> filler.addLong(organisationPersonId).addLong(organisationPersonId).addLong(taskId));
    }
}

