/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.temp;

import at.cdes.api.dao.TemporaryDocumentDAO;
import at.cdes.api.document.compositeDto.TemporaryDocumentVersion;
import at.cdes.api.dto.DocumentReference;
import at.cdes.impl.dao.temp.AbstractTempDAO;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TempTemporaryDocumentDAO
extends AbstractTempDAO<TemporaryDocumentVersion>
implements TemporaryDocumentDAO {
    private static final Logger log = LoggerFactory.getLogger(TempTemporaryDocumentDAO.class);

    public TempTemporaryDocumentDAO() {
        super(TemporaryDocumentVersion::getId, TemporaryDocumentVersion::setId, TemporaryDocumentVersion::getCreated, TemporaryDocumentVersion::setCreated);
    }

    @Override
    protected void cleanup(TemporaryDocumentVersion value) {
        try {
            Files.deleteIfExists(Paths.get(value.getStoredFileName(), new String[0]));
            for (DocumentReference ref : value.getDocumentReferences().values()) {
                Files.deleteIfExists(Paths.get(ref.getAttachmentFilename(), new String[0]));
            }
        }
        catch (IOException e) {
            log.warn("Error when deleting expired temporary document version.", (Throwable)e);
        }
    }
}

