/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.document.compositeDto.DocumentListOtherVersionNodeResultInfo;
import at.cdes.api.joinDto.ReviewProtocolBaseJoin;
import at.cdes.api.joinDto.ReviewProtocolVersionJoin;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.api.review.compositeDto.ReviewCycleNodeInstanceReleasedInfo;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.reviewCycle.ReviewProtocolContext;
import at.cdes.impl.reviewCycle.ReviewProtocolGeometry;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.holiday.HolidayCalculator;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.clazzes.util.datetime.CalendarHelper;
import org.clazzes.util.datetime.UtcTimestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewProtocolSvgCalculator {
    private Boolean reversePreduration;
    private static final Logger log = LoggerFactory.getLogger(ReviewProtocolSvgCalculator.class);
    public static int MIN_SPACE_DRAW_WEEKS = 120;
    public static int SPACE_FOR_XAXIS_LABEL = 140;
    public static int SIZE_OF_VERSION_LABEL = 20;
    public static int HEIGHT_OUTER_LABEL = 20;
    public static int HEIGHT_OF_NODE = 20;

    public void setReversePreduration(Boolean reversePreduration) {
        this.reversePreduration = reversePreduration;
    }

    private ReviewProtocolGeometry initializeGeomtry(ReviewProtocolContext context, double totalWidth, double totalHeight) {
        ReviewProtocolGeometry geometry = new ReviewProtocolGeometry();
        double graphWidth = totalWidth - (double)SPACE_FOR_XAXIS_LABEL;
        geometry.setTotalWidth(totalWidth);
        geometry.setTotalHeight(totalHeight);
        geometry.setGraphWidth(graphWidth);
        geometry.setDrawPlannedReviewCycle(false);
        geometry.setCalculateNewAxis(false);
        geometry.setPlannedStart(null);
        Double actualReviewCycleStart = ReviewProtocolSvgCalculator.getActualReviewCycleStart(context);
        geometry.setActualReviewCycleStart(actualReviewCycleStart);
        Double actualReviewCycleEnd = ReviewProtocolSvgCalculator.getActualReviewCycleEnd(context);
        int test = ReviewProtocolSvgCalculator.calculateWeeksToDraw(actualReviewCycleStart, actualReviewCycleEnd);
        if (test < 4) {
            actualReviewCycleEnd = ReviewProtocolSvgCalculator.jumpByMonths(actualReviewCycleEnd, 1);
        }
        geometry.setActualReviewCycleEnd(actualReviewCycleEnd);
        geometry.setAxisStart(actualReviewCycleStart);
        geometry.setAxisEnd(actualReviewCycleEnd);
        geometry.setAxisStartTwo(null);
        geometry.setAxisEndTwo(null);
        return geometry;
    }

    public ReviewProtocolGeometry calculateAxis(ReviewProtocolContext context, double totalWidth, double totalHeight) {
        double axisWidth;
        double spacePerTimeUnit;
        double graphWidth;
        boolean doDrawWeeks;
        int weeksNew;
        ReviewProtocolBaseJoin baseJoin = context.getBaseJoin();
        HolidayCalculator holidayCalculator = context.getHolidayCalculator();
        ReviewProtocolGeometry geometry = this.initializeGeomtry(context, totalWidth, totalHeight);
        Double actualReviewCycleStart = geometry.getActualReviewCycleStart();
        Double actualReviewCycleEnd = geometry.getActualReviewCycleEnd();
        Double plannedStart = geometry.getPlannedStart();
        Double plannedEnd = geometry.getPlannedEnd();
        Double axisStart = geometry.getAxisStart();
        Double axisEnd = geometry.getAxisEnd();
        Double axisStartTwo = geometry.getAxisStartTwo();
        Double axisEndTwo = geometry.getAxisEndTwo();
        int newDuration = -1;
        if (baseJoin.getDocumentReleaseId() != null && baseJoin.getDocumentReleaseEndDate() != null) {
            plannedEnd = baseJoin.getDocumentReleaseEndDate();
            if (baseJoin.getDocumentReleaseStartDate() != null) {
                plannedStart = baseJoin.getDocumentReleaseStartDate();
            } else {
                plannedStart = plannedEnd;
                plannedStart = holidayCalculator.addWorkingDays(plannedStart, -baseJoin.getReviewCycleInstanceReleasedDuration().intValue());
            }
            int preDuration = baseJoin.getReviewCycleInstanceReleasedDurationPre();
            if (log.isDebugEnabled()) {
                ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
                log.debug("reviewCycleInstance duration : [" + baseJoin.getReviewCycleInstanceReleasedDuration() + "]; ");
                log.debug("plannedStart = [" + DateHelper.formatUtcSeconds(plannedStart, "Europe/Vienna", resourceBundle.getString("yearToSecondFormat")) + "]; plannedEnd = " + DateHelper.formatUtcSeconds(plannedEnd, "Europe/Vienna", resourceBundle.getString("yearToSecondFormat")) + "]");
            }
            Double startDate = plannedStart < plannedEnd ? (actualReviewCycleStart != null && actualReviewCycleStart < plannedStart ? actualReviewCycleStart : plannedStart) : (actualReviewCycleStart != null && plannedEnd < actualReviewCycleStart ? plannedEnd : actualReviewCycleStart);
            Double endDate = actualReviewCycleEnd > plannedEnd ? actualReviewCycleEnd : plannedEnd;
            geometry.setDrawPlannedReviewCycle(true);
            int durationBetweenPlannedAndReal = 0;
            if (plannedStart < actualReviewCycleStart) {
                durationBetweenPlannedAndReal = ReviewProtocolSvgCalculator.calculateMonthToDraw(plannedStart, actualReviewCycleStart);
            }
            if (durationBetweenPlannedAndReal > 6) {
                axisStartTwo = new Double(plannedStart);
                axisEndTwo = new Double(plannedEnd);
                geometry.setCalculateNewAxis(true);
                double tmp = axisEndTwo - axisStartTwo;
                double tmp2 = axisEnd - axisStart;
                if (tmp > tmp2) {
                    axisEnd = axisEnd + (tmp - tmp2);
                } else {
                    Double end;
                    Double newTime = axisEndTwo + (tmp2 - tmp);
                    double graphWidth2 = geometry.getGraphWidth();
                    if (graphWidth2 / (double)ReviewProtocolSvgCalculator.calculateMonthToDraw(axisStart, axisEnd) > (double)MIN_SPACE_DRAW_WEEKS) {
                        end = ReviewProtocolSvgCalculator.jumpToStartOfWeek(axisStart);
                    } else {
                        end = ReviewProtocolSvgCalculator.jumpByMonths(axisStart, -1);
                        end = ReviewProtocolSvgCalculator.jumpToEndOfMonth(end);
                    }
                    if (newTime > end) {
                        axisEndTwo = end;
                        axisStartTwo = axisEndTwo - tmp2;
                    } else {
                        axisEndTwo = newTime;
                    }
                }
                if (preDuration > 0 && !this.reversePreduration.booleanValue()) {
                    axisStart = holidayCalculator.addWorkingDays(axisStart, -preDuration);
                    axisStartTwo = holidayCalculator.addWorkingDays(axisStartTwo, -preDuration);
                }
                Calendar axisEndCalendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Vienna"));
                axisEndCalendar.setTimeInMillis((long)(axisEnd * 1000.0));
                if (holidayCalculator.isHolidayOrWeekend(axisEndCalendar)) {
                    axisEnd = holidayCalculator.addWorkingDays(axisEnd, 1);
                }
                Calendar axisEndTwoCalendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Vienna"));
                axisEndTwoCalendar.setTimeInMillis((long)(axisEndTwo * 1000.0));
                if (holidayCalculator.isHolidayOrWeekend(axisEndTwoCalendar)) {
                    axisEndTwo = holidayCalculator.addWorkingDays(axisEndTwo, 1);
                }
                newDuration = -1;
            } else {
                newDuration = ReviewProtocolSvgCalculator.calculateMonthToDraw(startDate, endDate);
                axisStart = startDate;
                if (preDuration > 0 && !this.reversePreduration.booleanValue()) {
                    axisStart = holidayCalculator.addWorkingDays(axisStart, -preDuration);
                }
                axisEnd = endDate;
                Calendar axisEndCalendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Vienna"));
                axisEndCalendar.setTimeInMillis((long)(axisEnd * 1000.0));
                if (holidayCalculator.isHolidayOrWeekend(axisEndCalendar)) {
                    axisEnd = holidayCalculator.addWorkingDays(axisEnd, 1);
                }
            }
        }
        int projectDurationInMonths = newDuration > 0 ? newDuration : ReviewProtocolSvgCalculator.calculateMonthToDraw(axisStart, axisEnd);
        Calendar axisEndCalendar = ReviewProtocolSvgCalculator.getAsCalendar(axisEnd);
        int axisEndMax = axisEndCalendar.getActualMaximum(5);
        axisEndCalendar.add(5, axisEndMax);
        int projectDurationInDays = ReviewProtocolSvgCalculator.calculateDaysToDraw(ReviewProtocolSvgCalculator.jumpByDays(axisStart, 1), ReviewProtocolSvgCalculator.getAsUtcSeconds(axisEndCalendar));
        int projectDurationInWeeks = ReviewProtocolSvgCalculator.calculateWeeksToDraw(axisStart, axisEnd);
        if (geometry.isCalculateNewAxis() && (weeksNew = ReviewProtocolSvgCalculator.calculateWeeksToDraw(axisStartTwo, axisEndTwo)) > projectDurationInWeeks) {
            projectDurationInWeeks = weeksNew;
        }
        boolean bl = doDrawWeeks = (graphWidth = geometry.getGraphWidth()) / (double)projectDurationInMonths > (double)MIN_SPACE_DRAW_WEEKS;
        if (doDrawWeeks) {
            Double startOfWeek = ReviewProtocolSvgCalculator.jumpToStartOfWeek(axisEnd);
            axisEnd = ReviewProtocolSvgCalculator.jumpByDays(startOfWeek, 6);
            spacePerTimeUnit = Math.floor(graphWidth / (double)projectDurationInWeeks);
            axisWidth = spacePerTimeUnit * (double)projectDurationInWeeks;
        } else {
            spacePerTimeUnit = graphWidth / (double)projectDurationInDays;
            axisWidth = spacePerTimeUnit * (double)projectDurationInDays;
        }
        geometry.setSpacePerTimeUnit(spacePerTimeUnit);
        geometry.setAxisWidth(axisWidth);
        geometry.setActualReviewCycleStart(actualReviewCycleStart);
        geometry.setActualReviewCycleEnd(actualReviewCycleEnd);
        geometry.setPlannedStart(plannedStart);
        geometry.setPlannedEnd(plannedEnd);
        geometry.setAxisStart(axisStart);
        geometry.setAxisEnd(axisEnd);
        geometry.setAxisStartTwo(axisStartTwo);
        geometry.setAxisEndTwo(axisEndTwo);
        geometry.setDoDrawWeeks(doDrawWeeks);
        geometry.setProjectDurationInDays(projectDurationInDays);
        geometry.setProjectDurationInWeeks(projectDurationInWeeks);
        geometry.setProjectDurationInMonths(projectDurationInMonths);
        return geometry;
    }

    private static Double getActualReviewCycleStart(ReviewProtocolContext context) {
        List<ReviewProtocolVersionJoin> versionJoins = context.getCellResultJoinsSortedByUploaded();
        for (ReviewProtocolVersionJoin versionJoin : versionJoins) {
            if (versionJoins.size() > 1 && versionJoin.getDocumentVersionStatus().intValue() == DocumentVersionStatus.DELETED.getValue()) continue;
            return versionJoin.getReviewCycleCellResultArrivalDate();
        }
        return null;
    }

    private static Double getActualReviewCycleEnd(ReviewProtocolContext context) {
        Double result;
        List<ReviewProtocolVersionJoin> versionJoins = context.getCellResultJoinsSortedByUploaded();
        ReviewProtocolVersionJoin lastCellResult = versionJoins.size() > 0 ? versionJoins.get(versionJoins.size() - 1) : null;
        Double d = result = lastCellResult != null ? lastCellResult.getReviewCycleCellResultDepartureDate() : null;
        if (result == null) {
            result = lastCellResult != null ? lastCellResult.getReviewCycleCellResultArrivalDate() : null;
            Long lastCellResultId = lastCellResult.getReviewCycleCellResultId();
            List<ReviewProtocolVersionJoin> nodeResultJoins = context.getNodeResultJoinsSortedByPosition(lastCellResultId);
            for (ReviewProtocolVersionJoin nodeResultJoin : nodeResultJoins) {
                boolean finishCell;
                boolean endOfReviewCycle = ReviewProtocolSvgCalculator.isEndOfReviewCycle(nodeResultJoin, context);
                Long resultOptionId = lastCellResult.getReviewCycleCellResultReviewCycleResultOptionId();
                ReviewProtocolVersionJoin resultOptionJoin = context.getResultOptionJoin(resultOptionId);
                boolean bl = finishCell = resultOptionJoin != null && resultOptionJoin.isReviewCycleResultOptionFinishCellFlag() != false;
                if (nodeResultJoin.getReviewCycleNodeResultDepartureDate() != null && result < nodeResultJoin.getReviewCycleNodeResultDepartureDate()) {
                    result = nodeResultJoin.getReviewCycleNodeResultDepartureDate();
                    continue;
                }
                if (nodeResultJoin.getReviewCycleNodeResultDepartureDate() != null || endOfReviewCycle && !finishCell) continue;
                result = new Double(System.currentTimeMillis()) / 1000.0;
            }
        }
        return result;
    }

    public static boolean isEndOfReviewCycle(ReviewProtocolVersionJoin nodeResultJoin, ReviewProtocolContext context) {
        Boolean endCell = nodeResultJoin.getReviewCycleCellIsEndCell();
        Boolean endNode = context.isEndPositionType(nodeResultJoin.getReviewCycleNodeReviewCyclePositionTypeId());
        return endCell != null && endNode != null && endCell != false && endNode != false;
    }

    public static int calculateMonthToDraw(Double startDate, Double endDate) {
        UtcTimestamp endDateTimeStamp;
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Vienna");
        UtcTimestamp startDateTimeStamp = new UtcTimestamp(timeZone, (long)(startDate * 1000.0));
        if (ReviewProtocolSvgCalculator.compareDateOnly(startDateTimeStamp, endDateTimeStamp = new UtcTimestamp(timeZone, (long)(endDate * 1000.0))) < 0) {
            return ReviewProtocolSvgCalculator.getMonthsBetween(startDateTimeStamp, endDateTimeStamp) + 1;
        }
        return ReviewProtocolSvgCalculator.getMonthsBetween(endDateTimeStamp, startDateTimeStamp) + 1;
    }

    public static int calculateWeeksToDraw(Double startDate, Double endDate) {
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Vienna");
        UtcTimestamp startDateTimeStamp = new UtcTimestamp(timeZone, (long)(startDate * 1000.0));
        UtcTimestamp endDateTimeStamp = new UtcTimestamp(timeZone, (long)(endDate * 1000.0));
        Calendar startCalendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Vienna"));
        startCalendar.setTimeInMillis((long)(startDate * 1000.0));
        Calendar endCalendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Vienna"));
        endCalendar.setTimeInMillis((long)(endDate * 1000.0));
        if (ReviewProtocolSvgCalculator.compareDateOnly(startDateTimeStamp, endDateTimeStamp) < 0) {
            return CalendarHelper.weeksBetween((Calendar)startCalendar, (Calendar)endCalendar, (int)startCalendar.getFirstDayOfWeek()) + 1;
        }
        return CalendarHelper.weeksBetween((Calendar)endCalendar, (Calendar)startCalendar, (int)startCalendar.getFirstDayOfWeek()) + 1;
    }

    public static int calculateDaysToDraw(Double startDate, Double endDate) {
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Vienna");
        UtcTimestamp startDateTimeStamp = new UtcTimestamp(timeZone, (long)(startDate * 1000.0));
        UtcTimestamp endDateTimeStamp = new UtcTimestamp(timeZone, (long)(endDate * 1000.0));
        Calendar startCalendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Vienna"));
        startCalendar.setTimeInMillis((long)(startDate * 1000.0));
        Calendar endCalendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Vienna"));
        endCalendar.setTimeInMillis((long)(endDate * 1000.0));
        if (ReviewProtocolSvgCalculator.compareDateOnly(startDateTimeStamp, endDateTimeStamp) < 0) {
            return CalendarHelper.daysBetween((Calendar)startCalendar, (Calendar)endCalendar) + 1;
        }
        return CalendarHelper.daysBetween((Calendar)endCalendar, (Calendar)startCalendar) + 1;
    }

    public static Calendar getAsCalendar(Double utcSeconds) {
        if (utcSeconds == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("Europe/Vienna"));
        calendar.setTimeInMillis((long)(utcSeconds * 1000.0));
        return calendar;
    }

    public static Double getAsUtcSeconds(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        long utcMillis = calendar.getTimeInMillis();
        return new Double(utcMillis) / 1000.0;
    }

    private static int compareDateOnly(UtcTimestamp tsOne, UtcTimestamp tsTwo) {
        int monthTwo;
        int yearTwo;
        int yearOne = tsOne.getYear();
        int r = yearOne - (yearTwo = tsTwo.getYear());
        if (r != 0) {
            return r;
        }
        int monthOne = tsOne.getMonth();
        r = monthOne - (monthTwo = tsTwo.getMonth());
        if (r != 0) {
            return r;
        }
        int dayOne = tsOne.getDay();
        int dayTwo = tsTwo.getDay();
        return dayOne - dayTwo;
    }

    private static int getMonthsBetween(UtcTimestamp tsOne, UtcTimestamp tsTwo) {
        int y1 = tsOne.getYear();
        int y2 = tsTwo.getYear();
        int monthsBetween = (y2 - y1) * 12;
        return monthsBetween + tsTwo.getMonth() - tsOne.getMonth();
    }

    public static Double jumpToStartOfWeek(Double utcSeconds) {
        Calendar calendar = ReviewProtocolSvgCalculator.getAsCalendar(utcSeconds);
        calendar.set(7, calendar.getFirstDayOfWeek());
        return ReviewProtocolSvgCalculator.getAsUtcSeconds(calendar);
    }

    private static Double jumpByMonths(Double utcSeconds, int numberOfMonths) {
        Calendar calendar = ReviewProtocolSvgCalculator.getAsCalendar(utcSeconds);
        calendar.add(2, 1);
        return ReviewProtocolSvgCalculator.getAsUtcSeconds(calendar);
    }

    public static Double jumpByDays(Double utcSeconds, int numberOfDays) {
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Vienna");
        UtcTimestamp utcTimeStamp = new UtcTimestamp(timeZone, (long)(utcSeconds * 1000.0));
        utcTimeStamp.addDays((long)numberOfDays);
        return new Double(utcTimeStamp.getUtcMillis().longValue()) / 1000.0;
    }

    private static Double jumpToEndOfMonth(Double utcSeconds) {
        TimeZone timeZone = TimeZone.getTimeZone("Europe/Vienna");
        UtcTimestamp utcTimeStamp = new UtcTimestamp(timeZone, (long)(utcSeconds * 1000.0));
        int daysOfMonth = UtcTimestamp.getDaysOfMonth((int)utcTimeStamp.getYear(), (int)utcTimeStamp.getMonth());
        utcTimeStamp.setDate(utcTimeStamp.getYear(), daysOfMonth, utcTimeStamp.getDay());
        return new Double(utcTimeStamp.getUtcMillis().longValue()) / 1000.0;
    }

    public static double getXPositionFromStart(boolean drawWeeks, Double startDate, Double actualDate, double spacePerTimeUnit) {
        if (actualDate < startDate) {
            return -1.0;
        }
        Calendar startDateCalendar = ReviewProtocolSvgCalculator.getAsCalendar(startDate);
        Calendar actualDateCalendar = ReviewProtocolSvgCalculator.getAsCalendar(actualDate);
        if (drawWeeks) {
            int weeks = ReviewProtocolSvgCalculator.calculateWeeksToDraw(startDate, actualDate) - 1;
            int dayOfWeek = actualDateCalendar.get(7) - actualDateCalendar.getFirstDayOfWeek();
            return (double)weeks * spacePerTimeUnit + spacePerTimeUnit / 7.0 * (double)((dayOfWeek + 7) % 7);
        }
        int days = 0;
        Calendar start = (Calendar)startDateCalendar.clone();
        int startMonth = startDateCalendar.get(2);
        int actMonth = actualDateCalendar.get(2);
        int actYear = actualDateCalendar.get(1);
        for (int startYear = startDateCalendar.get(1); startYear < actYear; ++startYear) {
            while (startMonth <= 11) {
                days += start.getActualMaximum(5);
                ++startMonth;
                start.add(2, 1);
            }
            startMonth = 0;
        }
        while (startMonth < actMonth) {
            days += start.getActualMaximum(5);
            ++startMonth;
            start.add(2, 1);
        }
        return (double)(days += actualDateCalendar.get(5)) * spacePerTimeUnit;
    }

    public int getVAreaOfNodesToDraw(ReviewProtocolContext context, int heightUnit) {
        Map<Long, ReviewProtocolVersionJoin> nodeResultIdToResultJoin = context.getNodeResultIdToResultJoin();
        Collection<ReviewProtocolVersionJoin> allNodeResultJoins = nodeResultIdToResultJoin.values();
        int count = 0;
        for (ReviewProtocolVersionJoin nodeResultJoin : allNodeResultJoins) {
            Boolean isDeleted = DocumentVersionStatus.getByValue((Integer)nodeResultJoin.getDocumentVersionStatus()) == DocumentVersionStatus.DELETED;
            Long reviewCycleResultOptionId = nodeResultJoin.getReviewCycleNodeResultReviewCycleResultOptionId();
            Long emptyNodeResultOptionId = nodeResultJoin.getReviewCycleEmptyNodeResultOptionId();
            Boolean isFree = nodeResultJoin.getReviewCycleNodeFree();
            if (reviewCycleResultOptionId != null && reviewCycleResultOptionId.longValue() == emptyNodeResultOptionId.longValue() || isFree.booleanValue() || isDeleted.booleanValue()) continue;
            ++count;
        }
        return count * heightUnit;
    }

    public static int calculateTypeOfEdges(ReviewCycleNodeInstanceReleasedInfo nodeInstanceReleasedInfo, ReviewCycleInfo cycleInfo, boolean delayed) {
        Integer nodePosition = nodeInstanceReleasedInfo.getNodePosition();
        Long nodeId = nodeInstanceReleasedInfo.getNodeId();
        boolean isEndNode = cycleInfo.isNodeEndOfCell(nodeId);
        return ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodePosition, isEndNode, delayed);
    }

    public static int calculateTypeOfEdges(DocumentListOtherVersionNodeResultInfo nodeResultInfo, ReviewCycleInfo cycleInfo, boolean delayed) {
        Integer nodePosition = nodeResultInfo.getNodePosition();
        Long nodeId = nodeResultInfo.getNodeId();
        boolean isEndNode = cycleInfo.isNodeEndOfCell(nodeId);
        return ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodePosition, isEndNode, delayed);
    }

    public static int calculateTypeOfEdges(ReviewProtocolVersionJoin nodeResultJoin, boolean delayed) {
        int nodePosition = nodeResultJoin.getReviewCycleNodePosition();
        Long endNodeId = nodeResultJoin.getEndNodeId();
        return ReviewProtocolSvgCalculator.calculateTypeOfEdges(nodePosition, endNodeId != null, delayed);
    }

    public static int calculateTypeOfEdges(Integer nodePosition, boolean isEndNode, boolean delayed) {
        int typeOfEdges = nodePosition == 1 ? 2 : 0;
        return typeOfEdges += isEndNode && !delayed ? 1 : 0;
    }

    public static double getPlannedNodeStartX(ReviewProtocolGeometry geometry) {
        boolean drawWeeks = geometry.isDoDrawWeeks();
        boolean calculateNewAxis = geometry.isCalculateNewAxis();
        Double axisStartTwo = geometry.getAxisStartTwo();
        Double axisStart = geometry.getAxisStart();
        Double plannedStart = geometry.getPlannedStart();
        double spacePerTimeUnit = geometry.getSpacePerTimeUnit();
        return ReviewProtocolSvgCalculator.getXPositionFromStart(drawWeeks, calculateNewAxis ? axisStartTwo : axisStart, plannedStart, spacePerTimeUnit) + (double)SPACE_FOR_XAXIS_LABEL;
    }
}

