/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.task;

import at.cdes.api.dto.AttachedReviewCycleNodePosition;
import at.cdes.api.dto.AttachedReviewTask;
import at.cdes.api.dto.AttachedReviewTaskDone;
import at.cdes.api.dto.AttachedReviewTaskDoneResultsMap;
import at.cdes.api.dto.AttachedReviewTaskPositionMap;
import at.cdes.api.dto.BaseTask;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentTask;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.DocumentVersionTask;
import at.cdes.api.dto.Email;
import at.cdes.api.dto.EmailAttachment;
import at.cdes.api.dto.EmailSnippet;
import at.cdes.api.dto.FutureEmail;
import at.cdes.api.dto.ObjectListRelease;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PlotOrderAcceptanceTask;
import at.cdes.api.dto.PlotOrderAcceptanceTaskDone;
import at.cdes.api.dto.PlottOrderItem;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.dto.ReviewCycleEntryTask;
import at.cdes.api.dto.ReviewCycleEntryTaskDone;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodePositionReleased;
import at.cdes.api.dto.ReviewCycleNodeResult;
import at.cdes.api.dto.ReviewCyclePlottTask;
import at.cdes.api.dto.ReviewCyclePlottTaskDone;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.dto.ReviewTask;
import at.cdes.api.dto.ReviewTaskDone;
import at.cdes.api.dto.ReviewTaskDoneResultsMap;
import at.cdes.api.dto.ReviewTaskPositionMap;
import at.cdes.api.dto.SelectCellConnectionMap;
import at.cdes.api.dto.SelectCellConnectionTask;
import at.cdes.api.dto.SelectCellConnectionTaskDone;
import at.cdes.api.dto.StatusEmailSnippet;
import at.cdes.api.dto.TaskEmailSnippet;
import at.cdes.api.guiService.PlotService;
import at.cdes.api.joinDto.AttachedReviewTaskParticipationDeleteJoin;
import at.cdes.api.joinDto.AttachmentMailJoin;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.DocumentReleaseContextJoin;
import at.cdes.api.joinDto.EntryTaskJoin;
import at.cdes.api.joinDto.GenReviewTaskBaseJoin;
import at.cdes.api.joinDto.GenReviewTaskPositionJoin;
import at.cdes.api.joinDto.GenSelectCellTaskConnectionJoin;
import at.cdes.api.joinDto.GenSelectCellTaskVersionJoin;
import at.cdes.api.joinDto.GenerateTaskDeadlinesJoin;
import at.cdes.api.joinDto.GenerateTaskEmailSnippetJoin;
import at.cdes.api.joinDto.IDoReviewTaskPositionResultJoin;
import at.cdes.api.joinDto.IObjectPlannerReleaseObjectJoin;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.joinDto.PlanDeliverReleaseJoin;
import at.cdes.api.joinDto.PlotOrderTemplateJoin;
import at.cdes.api.joinDto.ProjectLocalisationJoin;
import at.cdes.api.joinDto.ProjectParticipationJoin;
import at.cdes.api.joinDto.ReviewCycleTreeJoin;
import at.cdes.api.joinDto.TaskTreeJoin;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.api.task.voc.TaskStatus;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.FutureEmailType;
import at.cdes.api.voc.ReviewCycleTaskUrgency;
import at.cdes.api.voc.RoleTypeEnum;
import at.cdes.api.voc.StatusEmailSnippetType;
import at.cdes.api.voc.TaskEmailSnippetType;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.AttachedReviewCycleNodePositionDAO;
import at.cdes.impl.dao.AttachedReviewTaskDAO;
import at.cdes.impl.dao.AttachedReviewTaskDoneDAO;
import at.cdes.impl.dao.AttachedReviewTaskDoneResultsMapDAO;
import at.cdes.impl.dao.AttachedReviewTaskPositionMapDAO;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentReleaseDAO;
import at.cdes.impl.dao.DocumentTaskDAO;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.DocumentVersionTaskDAO;
import at.cdes.impl.dao.EmailAttachmentDAO;
import at.cdes.impl.dao.EmailSnippetDAO;
import at.cdes.impl.dao.FutureEmailDAO;
import at.cdes.impl.dao.ObjectListReleaseDAO;
import at.cdes.impl.dao.ObjectPlannerReleaseDAO;
import at.cdes.impl.dao.OrderStepDAO;
import at.cdes.impl.dao.OrganisationDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.OriginalDocumentTaskDAO;
import at.cdes.impl.dao.OriginalDocumentTaskDoneDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.PlotOrderAcceptanceTaskDAO;
import at.cdes.impl.dao.PlotOrderAcceptanceTaskDoneDAO;
import at.cdes.impl.dao.PlottOrderDAO;
import at.cdes.impl.dao.PlottOrderItemDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectHolidayDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.ReviewCycleCellConnectionDAO;
import at.cdes.impl.dao.ReviewCycleDAO;
import at.cdes.impl.dao.ReviewCycleEntryTaskDAO;
import at.cdes.impl.dao.ReviewCycleEntryTaskDoneDAO;
import at.cdes.impl.dao.ReviewCycleInstanceReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodeDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstanceReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodePositionReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodeResultDAO;
import at.cdes.impl.dao.ReviewCyclePlottTaskDAO;
import at.cdes.impl.dao.ReviewCyclePlottTaskDoneDAO;
import at.cdes.impl.dao.ReviewTaskDAO;
import at.cdes.impl.dao.ReviewTaskDoneDAO;
import at.cdes.impl.dao.ReviewTaskDoneResultsMapDAO;
import at.cdes.impl.dao.ReviewTaskPositionMapDAO;
import at.cdes.impl.dao.SelectCellConnectionMapDAO;
import at.cdes.impl.dao.SelectCellConnectionTaskDAO;
import at.cdes.impl.dao.SelectCellConnectionTaskDoneDAO;
import at.cdes.impl.dao.StatusEmailSnippetDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.dao.TaskDAO;
import at.cdes.impl.dao.TaskEmailSnippetDAO;
import at.cdes.impl.dao.jdbc.JdbcReviewCycleDAO;
import at.cdes.impl.dao.jdbc.JdbcReviewTaskDAO;
import at.cdes.impl.dao.unionComponent.GenReviewTaskBaseComponent;
import at.cdes.impl.dao.unionComponent.GenerateTaskDeadlinesJoinComponent;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.document.context.GenerateTaskEmailSnippetsContext;
import at.cdes.impl.document.context.GenerateTaskEmailSnippetsContextImpl;
import at.cdes.impl.document.util.DocumentVersionHelper;
import at.cdes.impl.email.EmailHelper;
import at.cdes.impl.email.EmailUtils;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.reviewCycle.DurationCalcContext;
import at.cdes.impl.reviewCycle.DurationCalculator;
import at.cdes.impl.reviewCycle.DurationInfo;
import at.cdes.impl.reviewCycle.ReducedWriteOnlyTaskEmailContext;
import at.cdes.impl.reviewCycle.ReviewCycleContext;
import at.cdes.impl.reviewCycle.ReviewOgnlHelper;
import at.cdes.impl.reviewCycle.ReviewUtils;
import at.cdes.impl.reviewCycle.WriteOnlyReviewTaskContext;
import at.cdes.impl.reviewCycle.WriteOnlyTaskEmailContext;
import at.cdes.impl.task.TaskHelper;
import at.cdes.impl.util.BatchedExecutor;
import at.cdes.impl.util.ContainerHelper;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.ObjectCriteria;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.TapestryHelper;
import at.cdes.impl.util.holiday.HolidayCalculator;
import at.cdes.impl.util.holiday.HolidayCalculatorFactory;
import at.cdes.impl.util.odf.OdfHelper;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.stream.Collectors;
import org.clazzes.util.datetime.CalendarHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskUtils {
    private static final Logger log = LoggerFactory.getLogger(TaskUtils.class);
    private static final Logger futureEmailLog = LoggerFactory.getLogger((String)"at.cdes.impl.task.TaskUtils_FutureEmail");
    private String applicationName;
    private AttachedReviewTaskDAO attachedReviewTaskDAO;
    private AttachedReviewTaskDoneDAO attachedReviewTaskDoneDAO;
    private AttachedReviewTaskPositionMapDAO attachedReviewTaskPositionMapDAO;
    private AttachedReviewCycleNodePositionDAO attachedReviewCycleNodePositionDAO;
    private DocumentDAO documentDAO;
    private DocumentReleaseDAO documentReleaseDAO;
    private DocumentTaskDAO documentTaskDAO;
    private DocumentVersionDAO documentVersionDAO;
    private DocumentVersionTaskDAO documentVersionTaskDAO;
    private DurationCalculator durationCalculator;
    private EmailAttachmentDAO emailAttachmentDAO;
    private EmailSnippetDAO emailSnippetDAO;
    private FutureEmailDAO futureEmailDAO;
    private ProjectDAO projectDAO;
    private EmailUtils mailUtils;
    private ObjectListReleaseDAO objectListReleaseDAO;
    private ObjectPlannerReleaseDAO objectPlannerReleaseDAO;
    private OrganisationDAO organisationDAO;
    private OriginalDocumentTaskDAO originalDocumentTaskDAO;
    private OriginalDocumentTaskDoneDAO originalDocumentTaskDoneDAO;
    private PlotOrderAcceptanceTaskDAO plotOrderAcceptanceTaskDAO;
    private PersonVariablesDAO personVariablesDAO;
    private PlotOrderAcceptanceTaskDoneDAO plotOrderAcceptanceTaskDoneDAO;
    private ProjectHolidayDAO projectHolidayDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private Boolean reversePreduration;
    private ReviewCycleCellConnectionDAO reviewCycleCellConnectionDAO;
    private ReviewCycleNodeInstanceReleasedDAO reviewCycleNodeInstanceReleasedDAO;
    private ReviewCycleDAO reviewCycleDAO;
    private ReviewCycleNodeDAO reviewCycleNodeDAO;
    private ReviewCyclePlottTaskDAO reviewCyclePlotTaskDAO;
    private ReviewCyclePlottTaskDoneDAO reviewCyclePlotTaskDoneDAO;
    private ReviewTaskDAO reviewTaskDAO;
    private ReviewTaskPositionMapDAO reviewTaskPositionMapDAO;
    private ReviewUtils reviewUtils;
    private ReviewOgnlHelper reviewOgnlHelper;
    private SelectCellConnectionMapDAO selectCellConnectionMapDAO;
    private SelectCellConnectionTaskDAO selectCellConnectionTaskDAO;
    private SelectCellConnectionTaskDoneDAO selectCellConnectionTaskDoneDAO;
    private StatusEmailSnippetDAO statusEmailSnippetDAO;
    private ReviewCycleEntryTaskDAO reviewCycleEntryTaskDAO;
    private ReviewCycleEntryTaskDoneDAO reviewCycleEntryTaskDoneDAO;
    private TaskDAO taskDAO;
    private TaskEmailSnippetDAO taskEmailSnippetDAO;
    private ReviewCycleInstanceReleasedDAO reviewCycleInstanceReleasedDAO;
    private ReviewCycleNodePositionReleasedDAO reviewCycleNodePositionReleasedDAO;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;
    private ReviewTaskDoneDAO reviewTaskDoneDAO;
    private ReviewTaskDoneResultsMapDAO reviewTaskDoneResultsMapDAO;
    private int sqlQueryBatchSize;
    private AttachedReviewTaskDoneResultsMapDAO attachedReviewTaskDoneResultsMapDAO;
    private SubProjectDAO subProjectDAO;
    private PlottOrderDAO plottOrderDAO;
    private PlottOrderItemDAO plottOrderItemDAO;
    private OrderStepDAO orderStepDAO;
    private PlotService plotService;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setAttachedReviewTaskDAO(AttachedReviewTaskDAO attachedReviewTaskDAO) {
        this.attachedReviewTaskDAO = attachedReviewTaskDAO;
    }

    public void setAttachedReviewTaskDoneDAO(AttachedReviewTaskDoneDAO attachedReviewTaskDoneDAO) {
        this.attachedReviewTaskDoneDAO = attachedReviewTaskDoneDAO;
    }

    public void setAttachedReviewTaskPositionMapDAO(AttachedReviewTaskPositionMapDAO attachedReviewTaskPositionMapDAO) {
        this.attachedReviewTaskPositionMapDAO = attachedReviewTaskPositionMapDAO;
    }

    public void setAttachedReviewCycleNodePositionDAO(AttachedReviewCycleNodePositionDAO attachedReviewCycleNodePositionDAO) {
        this.attachedReviewCycleNodePositionDAO = attachedReviewCycleNodePositionDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentReleaseDAO(DocumentReleaseDAO documentReleaseDAO) {
        this.documentReleaseDAO = documentReleaseDAO;
    }

    public void setDocumentTaskDAO(DocumentTaskDAO documentTaskDAO) {
        this.documentTaskDAO = documentTaskDAO;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setDocumentVersionTaskDAO(DocumentVersionTaskDAO documentVersionTaskDAO) {
        this.documentVersionTaskDAO = documentVersionTaskDAO;
    }

    public void setDurationCalculator(DurationCalculator durationCalculator) {
        this.durationCalculator = durationCalculator;
    }

    public void setEmailAttachmentDAO(EmailAttachmentDAO emailAttachmentDAO) {
        this.emailAttachmentDAO = emailAttachmentDAO;
    }

    public void setEmailSnippetDAO(EmailSnippetDAO emailSnippetDAO) {
        this.emailSnippetDAO = emailSnippetDAO;
    }

    public void setFutureEmailDAO(FutureEmailDAO futureEmailDAO) {
        this.futureEmailDAO = futureEmailDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setMailUtils(EmailUtils mailUtils) {
        this.mailUtils = mailUtils;
    }

    public void setObjectListReleaseDAO(ObjectListReleaseDAO objectListReleaseDAO) {
        this.objectListReleaseDAO = objectListReleaseDAO;
    }

    public void setObjectPlannerReleaseDAO(ObjectPlannerReleaseDAO objectPlannerReleaseDAO) {
        this.objectPlannerReleaseDAO = objectPlannerReleaseDAO;
    }

    public void setOrganisationDAO(OrganisationDAO organisationDAO) {
        this.organisationDAO = organisationDAO;
    }

    public void setOriginalDocumentTaskDAO(OriginalDocumentTaskDAO originalDocumentTaskDAO) {
        this.originalDocumentTaskDAO = originalDocumentTaskDAO;
    }

    public void setOriginalDocumentTaskDoneDAO(OriginalDocumentTaskDoneDAO originalDocumentTaskDoneDAO) {
        this.originalDocumentTaskDoneDAO = originalDocumentTaskDoneDAO;
    }

    public void setPlotOrderAcceptanceTaskDAO(PlotOrderAcceptanceTaskDAO plotOrderAcceptanceTaskDAO) {
        this.plotOrderAcceptanceTaskDAO = plotOrderAcceptanceTaskDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setPlotOrderAcceptanceTaskDoneDAO(PlotOrderAcceptanceTaskDoneDAO plotOrderAcceptanceTaskDoneDAO) {
        this.plotOrderAcceptanceTaskDoneDAO = plotOrderAcceptanceTaskDoneDAO;
    }

    public void setProjectHolidayDAO(ProjectHolidayDAO projectHolidayDAO) {
        this.projectHolidayDAO = projectHolidayDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setReversePreduration(Boolean reversePreduration) {
        this.reversePreduration = reversePreduration;
    }

    public void setReviewCycleCellConnectionDAO(ReviewCycleCellConnectionDAO reviewCycleCellConnectionDAO) {
        this.reviewCycleCellConnectionDAO = reviewCycleCellConnectionDAO;
    }

    public void setReviewCycleNodeInstanceReleasedDAO(ReviewCycleNodeInstanceReleasedDAO reviewCycleNodeInstanceReleasedDAO) {
        this.reviewCycleNodeInstanceReleasedDAO = reviewCycleNodeInstanceReleasedDAO;
    }

    public void setReviewCycleDAO(ReviewCycleDAO reviewCycleDAO) {
        this.reviewCycleDAO = reviewCycleDAO;
    }

    public void setReviewCycleNodeDAO(ReviewCycleNodeDAO reviewCycleNodeDAO) {
        this.reviewCycleNodeDAO = reviewCycleNodeDAO;
    }

    public void setReviewCyclePlotTaskDAO(ReviewCyclePlottTaskDAO reviewCyclePlottTaskDAO) {
        this.reviewCyclePlotTaskDAO = reviewCyclePlottTaskDAO;
    }

    public void setReviewCyclePlotTaskDoneDAO(ReviewCyclePlottTaskDoneDAO reviewCyclePlottTaskDoneDAO) {
        this.reviewCyclePlotTaskDoneDAO = reviewCyclePlottTaskDoneDAO;
    }

    public void setReviewTaskDAO(ReviewTaskDAO reviewTaskDAO) {
        this.reviewTaskDAO = reviewTaskDAO;
    }

    public void setReviewTaskPositionMapDAO(ReviewTaskPositionMapDAO reviewTaskPositionMapDAO) {
        this.reviewTaskPositionMapDAO = reviewTaskPositionMapDAO;
    }

    public void setReviewUtils(ReviewUtils reviewUtils) {
        this.reviewUtils = reviewUtils;
    }

    public void setReviewOgnlHelper(ReviewOgnlHelper reviewOgnlHelper) {
        this.reviewOgnlHelper = reviewOgnlHelper;
    }

    public void setSelectCellConnectionMapDAO(SelectCellConnectionMapDAO selectCellConnectionMapDAO) {
        this.selectCellConnectionMapDAO = selectCellConnectionMapDAO;
    }

    public void setSelectCellConnectionTaskDAO(SelectCellConnectionTaskDAO selectCellConnectionTaskDAO) {
        this.selectCellConnectionTaskDAO = selectCellConnectionTaskDAO;
    }

    public void setSelectCellConnectionTaskDoneDAO(SelectCellConnectionTaskDoneDAO selectCellConnectionTaskDoneDAO) {
        this.selectCellConnectionTaskDoneDAO = selectCellConnectionTaskDoneDAO;
    }

    public void setStatusEmailSnippetDAO(StatusEmailSnippetDAO statusEmailSnippetDAO) {
        this.statusEmailSnippetDAO = statusEmailSnippetDAO;
    }

    public void setReviewCycleEntryTaskDAO(ReviewCycleEntryTaskDAO reviewCycleEntryTaskDAO) {
        this.reviewCycleEntryTaskDAO = reviewCycleEntryTaskDAO;
    }

    public void setReviewCycleEntryTaskDoneDAO(ReviewCycleEntryTaskDoneDAO reviewCycleEntryTaskDoneDAO) {
        this.reviewCycleEntryTaskDoneDAO = reviewCycleEntryTaskDoneDAO;
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    public void setTaskEmailSnippetDAO(TaskEmailSnippetDAO taskEmailSnippetDAO) {
        this.taskEmailSnippetDAO = taskEmailSnippetDAO;
    }

    public void setReviewCycleInstanceReleasedDAO(ReviewCycleInstanceReleasedDAO reviewCycleInstanceReleasedDAO) {
        this.reviewCycleInstanceReleasedDAO = reviewCycleInstanceReleasedDAO;
    }

    public void setReviewCycleNodePositionReleasedDAO(ReviewCycleNodePositionReleasedDAO reviewCycleNodePositionReleasedDAO) {
        this.reviewCycleNodePositionReleasedDAO = reviewCycleNodePositionReleasedDAO;
    }

    public void setReviewCycleNodeResultDAO(ReviewCycleNodeResultDAO reviewCycleNodeResultDAO) {
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
    }

    public void setReviewTaskDoneDAO(ReviewTaskDoneDAO reviewTaskDoneDAO) {
        this.reviewTaskDoneDAO = reviewTaskDoneDAO;
    }

    public void setReviewTaskDoneResultsMapDAO(ReviewTaskDoneResultsMapDAO reviewTaskDoneResultsMapDAO) {
        this.reviewTaskDoneResultsMapDAO = reviewTaskDoneResultsMapDAO;
    }

    public void setSqlQueryBatchSize(int sqlQueryBatchSize) {
        this.sqlQueryBatchSize = sqlQueryBatchSize;
    }

    public void setAttachedReviewTaskDoneResultsMapDAO(AttachedReviewTaskDoneResultsMapDAO attachedReviewTaskDoneResultsMapDAO) {
        this.attachedReviewTaskDoneResultsMapDAO = attachedReviewTaskDoneResultsMapDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setPlottOrderDAO(PlottOrderDAO plottOrderDAO) {
        this.plottOrderDAO = plottOrderDAO;
    }

    public void setPlottOrderItemDAO(PlottOrderItemDAO plottOrderItemDAO) {
        this.plottOrderItemDAO = plottOrderItemDAO;
    }

    public void setOrderStepDAO(OrderStepDAO orderStepDAO) {
        this.orderStepDAO = orderStepDAO;
    }

    public void setPlotService(PlotService plotService) {
        this.plotService = plotService;
    }

    public boolean generateSelectCellTask(DebugContext debugContext, Long objectListReleaseId, Long documentVersionId, Long reviewCycleNodeInstanceReleasedId, boolean fixMissingTasks, boolean evaluateCellConnections) {
        debugContext.openDebugNode("generateSelectCellTask");
        GenSelectCellTaskVersionJoin versionJoin = this.documentVersionDAO.getGenSelectCellTaskVersionJoin(documentVersionId);
        List<GenSelectCellTaskConnectionJoin> connectionJoinsBeforeEvaluation = this.reviewCycleCellConnectionDAO.getGenSelectCellTaskConnectionJoin(reviewCycleNodeInstanceReleasedId);
        List<GenSelectCellTaskConnectionJoin> connectionJoins = this.getMatchingConnectionJoins(versionJoin, connectionJoinsBeforeEvaluation);
        if (connectionJoins.size() == 0) {
            if (evaluateCellConnections) {
                log.error("generateSelectCellTask: no valid cellConnections found. Check the connection rules!");
                throw new RuntimeException("12");
            }
            log.warn("generateSelectCellTask: no valid cellConnections found. Check the connection rules!");
            debugContext.closeDebugNode("no valid cellConnection found --> return");
            return false;
        }
        boolean taskFound = false;
        if (versionJoin.getSelectDocumentVersionTaskTaskId() != null) {
            if (versionJoin.getSelectDocumentVersionTaskProjectParticipationId() != null && versionJoin.getProjectParticipationId() != null && versionJoin.getSelectDocumentVersionTaskProjectParticipationId().longValue() == versionJoin.getProjectParticipationId().longValue()) {
                taskFound = true;
            } else {
                Long taskId = versionJoin.getSelectDocumentVersionTaskTaskId();
                this.deleteSelectCellConnectionTask(taskId);
                debugContext.addDeleteMessage(taskId, "SelectCellConnectionTask", "");
            }
        }
        if (taskFound) {
            debugContext.closeDebugNode("taskFound --> return");
            return false;
        }
        String locale = versionJoin.getPersonVariablesUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        BaseTask task = new BaseTask();
        DocumentVersionTask documentVersionTask = new DocumentVersionTask();
        SelectCellConnectionTask selectCellConnectionTask = new SelectCellConnectionTask();
        task.setBeginDate(fixMissingTasks ? versionJoin.getReviewCycleNodeResultArrivalDate() : null);
        task.setName(resourceBundle.getString("selectCellConnectionTaskName"));
        task.setDone(Boolean.valueOf(false));
        documentVersionTask.setProjectParticipationId(versionJoin.getProjectParticipationId());
        documentVersionTask.setObjectPlannerId(versionJoin.getObjectPlannerId());
        documentVersionTask.setDocumentVersionId(documentVersionId);
        selectCellConnectionTask.setReviewCycleNodeInstanceId(reviewCycleNodeInstanceReleasedId);
        Long projectId = versionJoin.getProjectId();
        Long subProjectId = versionJoin.getSubProjectId();
        List<GenerateTaskDeadlinesJoin> taskDeadlinesJoins = this.reviewCycleDAO.getGenerateTaskDeadlinesJoin(documentVersionId, projectId, subProjectId);
        List<GenerateTaskDeadlinesJoin> reviewCycleJoins = JdbcReviewCycleDAO.extractForComponent(GenerateTaskDeadlinesJoinComponent.REVIEW_CYCLE, taskDeadlinesJoins);
        reviewCycleJoins.addAll(JdbcReviewCycleDAO.extractForComponent(GenerateTaskDeadlinesJoinComponent.RESULT_OPTION, taskDeadlinesJoins));
        ReviewCycleContext reviewCycleContext = new ReviewCycleContext(reviewCycleJoins);
        List<ProjectHoliday> projectHolidays = this.extractProjectHolidays(taskDeadlinesJoins);
        Double documentReleaseEndDate = versionJoin.getDocumentReleaseEndDate();
        ReviewCycleNodeInstanceReleased reviewCycleNodeInstanceReleased = versionJoin.getReviewCycleNodeInstanceReleased();
        this.generateTaskDeadlines(reviewCycleContext, task, documentVersionTask, null, documentReleaseEndDate, projectHolidays, reviewCycleNodeInstanceReleased, false, projectId);
        Project project = (Project)this.projectDAO.get(projectId);
        task.setLocalisationId(project.getLocalisationId());
        task.setBeginDelay(Integer.valueOf(0));
        task.setDone(Boolean.valueOf(false));
        task = (BaseTask)this.taskDAO.save(task);
        debugContext.addSaveTaskMessage(task);
        Long taskId = task.getId();
        documentVersionTask.setTaskId(taskId);
        this.documentVersionTaskDAO.save(documentVersionTask);
        debugContext.addSaveDocumentVersionTaskMessage(documentVersionTask);
        selectCellConnectionTask.setTaskId(taskId);
        this.selectCellConnectionTaskDAO.save(selectCellConnectionTask);
        debugContext.addSaveSelectCellConnectionTaskMessage(selectCellConnectionTask);
        this.linkTaskWithReviewCycleCellConnections(debugContext, taskId, connectionJoins);
        GenerateTaskEmailSnippetsContextImpl taskContext = new GenerateTaskEmailSnippetsContextImpl(projectHolidays);
        Long currParticipationId = versionJoin.getProjectParticipantParticipationId();
        List<ProjectParticipation> projectRoleParticipations = this.projectParticipationDAO.getParticipationsByProjectAndRoleTypeAndAction(projectId, RoleTypeEnum.PROJECT_SURVEILLANT.getValue(), Action.MONITOR_LATE_REVIEWS.getName());
        Set<Long> projectRoleParticipationIds = ContainerHelper.getPersistentIdsSet(projectRoleParticipations);
        List<FutureEmail> futureEmails = taskContext.getFutureEmailsForTask(task.getId());
        this.generateTaskEmailSnippets(debugContext, taskContext, futureEmails, projectHolidays, currParticipationId, task, TaskEmailSnippetType.TYPE_NEW_TASK);
        if (futureEmailLog.isDebugEnabled()) {
            futureEmailLog.debug("generateSelectCellTask will call generateTaskLateFutureEmail");
        }
        this.generateTaskLateFutureEMail(debugContext, taskContext, projectHolidays, projectRoleParticipationIds, task);
        taskContext.commitAll(debugContext, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
        this.createSelectCellConnectionAttachmentMail(debugContext, (AttachmentMailJoin)versionJoin);
        return true;
    }

    private List<GenSelectCellTaskConnectionJoin> getMatchingConnectionJoins(GenSelectCellTaskVersionJoin versionJoin, List<GenSelectCellTaskConnectionJoin> connectionJoins) {
        ArrayList<GenSelectCellTaskConnectionJoin> matchingJoins = new ArrayList<GenSelectCellTaskConnectionJoin>();
        for (GenSelectCellTaskConnectionJoin connectionJoin : connectionJoins) {
            if (!this.reviewOgnlHelper.verifyCellConnectionRule(versionJoin, connectionJoin)) continue;
            matchingJoins.add(connectionJoin);
        }
        return matchingJoins;
    }

    public void deleteReviewCycleEntryTask(Long taskId) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        this.deleteReviewCycleEntryTasksImproved(taskIds);
    }

    public void deleteReviewCycleEntryTasksImproved(final Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            ArrayList<Long> taskIdsList = new ArrayList<Long>();
            taskIdsList.addAll(taskIds);
            QueryHelper.executeBatch(taskIdsList, this.sqlQueryBatchSize, new BatchedExecutor<Long>(){

                @Override
                public void execute(List<Long> ids) {
                    TaskHelper.deleteTaskEmails(taskIds, TaskUtils.this.emailSnippetDAO, TaskUtils.this.taskEmailSnippetDAO, TaskUtils.this.futureEmailDAO);
                    TaskUtils.this.reviewCycleEntryTaskDAO.deleteBatch(taskIds);
                    TaskUtils.this.documentTaskDAO.deleteBatch(taskIds);
                    TaskUtils.this.taskDAO.deleteBatch(taskIds);
                }
            });
        }
    }

    public void deleteReviewCycleEntryTasks(final Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            ArrayList<Long> taskIdsList = new ArrayList<Long>();
            final ArrayList taskIdsToDeleteFinalList = new ArrayList();
            taskIdsList.addAll(taskIds);
            QueryHelper.executeBatch(taskIdsList, this.sqlQueryBatchSize, new BatchedExecutor<Long>(){

                @Override
                public void execute(List<Long> ids) {
                    TaskHelper.deleteTaskEmails(taskIds, TaskUtils.this.emailSnippetDAO, TaskUtils.this.taskEmailSnippetDAO, TaskUtils.this.futureEmailDAO);
                    TaskUtils.this.reviewCycleEntryTaskDAO.deleteBatch(taskIds);
                    for (Long taskId : taskIds) {
                        boolean foundDoneTask = false;
                        List<ReviewCycleEntryTaskDone> entryTasksDone = TaskUtils.this.reviewCycleEntryTaskDoneDAO.getByTask(taskId);
                        for (ReviewCycleEntryTaskDone entryTaskDone : entryTasksDone) {
                            if (!entryTaskDone.getTaskId().equals(taskId)) continue;
                            foundDoneTask = true;
                        }
                        if (foundDoneTask) continue;
                        taskIdsToDeleteFinalList.add(taskId);
                    }
                    TaskUtils.this.documentTaskDAO.deleteBatch(taskIdsToDeleteFinalList);
                    TaskUtils.this.taskDAO.deleteBatch(taskIdsToDeleteFinalList);
                }
            });
        }
    }

    public void deleteOriginalDocumentTask(Long taskId) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        this.deleteOriginalDocumentTasks(taskIds);
    }

    public void deleteOriginalDocumentTasks(Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            this.originalDocumentTaskDAO.deleteBatch(taskIds);
            this.documentVersionTaskDAO.deleteBatch(taskIds);
            TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
            this.taskDAO.deleteBatch(taskIds);
        }
    }

    public void deleteOriginalDocumentTasksDone(Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            this.originalDocumentTaskDoneDAO.deleteBatch(taskIds);
            this.documentVersionTaskDAO.deleteBatch(taskIds);
            this.taskDAO.deleteBatch(taskIds);
        }
    }

    public void deletePlotOrderAcceptanceTasks(Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            this.plotOrderAcceptanceTaskDAO.deleteBatch(taskIds);
            this.documentVersionTaskDAO.deleteBatch(taskIds);
            TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
            this.taskDAO.deleteBatch(taskIds);
        }
    }

    public void deleteReviewCyclePlotTask(Long taskId) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        this.deleteReviewCyclePlotTasks(taskIds);
    }

    public void deleteReviewCyclePlotTasks(Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            this.reviewCyclePlotTaskDAO.deleteBatch(taskIds);
            this.documentVersionTaskDAO.deleteBatch(taskIds);
            TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
            this.taskDAO.deleteBatch(taskIds);
        }
    }

    public void deleteReviewTask(Long taskId) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        this.deleteReviewTasks(taskIds);
    }

    public void deleteReviewTasks(Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            for (Long taskId : taskIds) {
                this.reviewTaskPositionMapDAO.deleteByTask(taskId);
            }
            this.reviewTaskDAO.deleteBatch(taskIds);
            this.documentVersionTaskDAO.deleteBatch(taskIds);
            TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
            this.taskDAO.deleteBatch(taskIds);
        }
    }

    public void deleteReviewTasksDone(Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            this.reviewTaskDoneDAO.deleteBatch(taskIds);
            this.documentVersionTaskDAO.deleteBatch(taskIds);
            this.taskDAO.deleteBatch(taskIds);
        }
    }

    public void deleteAttachedReviewTask(Long taskId) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        this.deleteAttachedReviewTasks(taskIds);
    }

    public void deleteAttachedReviewTasks(Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            this.attachedReviewTaskPositionMapDAO.deleteBatch(taskIds);
            this.attachedReviewTaskDAO.deleteBatch(taskIds);
            this.documentVersionTaskDAO.deleteBatch(taskIds);
            TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
            this.taskDAO.deleteBatch(taskIds);
        }
    }

    public void deleteAttachedReviewTasksDone(Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            this.attachedReviewTaskDoneDAO.deleteBatch(taskIds);
            this.documentVersionTaskDAO.deleteBatch(taskIds);
            this.taskDAO.deleteBatch(taskIds);
        }
    }

    public void deleteSelectCellConnectionTasks(Collection<Long> taskIds) {
        if (taskIds.size() > 0) {
            for (Long taskId : taskIds) {
                this.selectCellConnectionMapDAO.deleteByTaskId(taskId);
            }
            this.selectCellConnectionTaskDAO.deleteBatch(taskIds);
            this.documentVersionTaskDAO.deleteBatch(taskIds);
            this.taskDAO.deleteBatch(taskIds);
        }
    }

    public void deleteSelectCellConnectionTask(Long taskId) {
        this.selectCellConnectionMapDAO.deleteByTaskId(taskId);
        this.selectCellConnectionTaskDAO.delete(taskId);
        this.documentVersionTaskDAO.delete(taskId);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(taskId);
        TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
        this.taskDAO.delete(taskId);
    }

    private List<ProjectHoliday> extractProjectHolidays(List<GenerateTaskDeadlinesJoin> taskDeadlinesJoins) {
        ArrayList<ProjectHoliday> projectHolidays = new ArrayList<ProjectHoliday>();
        for (GenerateTaskDeadlinesJoin taskDeadlinesJoin : taskDeadlinesJoins) {
            projectHolidays.add(taskDeadlinesJoin.getProjectHoliday());
        }
        return projectHolidays;
    }

    private void linkTaskWithReviewCycleCellConnections(DebugContext debugContext, Long taskId, List<GenSelectCellTaskConnectionJoin> connectionJoins) {
        debugContext.openDebugNode("TaskUtils.linkTaskWithReviewCycleCellConnections");
        List<SelectCellConnectionMap> maps = new ArrayList();
        for (GenSelectCellTaskConnectionJoin connectionJoin : connectionJoins) {
            Long reviewCycleCellConnectionId = connectionJoin.getReviewCycleCellConnectionId();
            SelectCellConnectionMap selectCellConnectionMap = new SelectCellConnectionMap();
            selectCellConnectionMap.setReviewCycleCellConnectionId(reviewCycleCellConnectionId);
            selectCellConnectionMap.setSelectCellConnectionTaskId(taskId);
            maps.add(selectCellConnectionMap);
        }
        maps = this.selectCellConnectionMapDAO.saveBatch(maps);
        for (SelectCellConnectionMap map : maps) {
            debugContext.addSaveSelectCellConnectionMapMessage(map);
        }
        debugContext.closeDebugNode();
    }

    public void checkForObsoleteReviewTasks(DebugContext debugContext, Long documentVersionId, Long reviewCycleNodeInstanceReleasedId) {
        debugContext.openDebugNode("TaskUtils.checkForObsoleteReviewTasks");
        List<ReviewTask> obsoleteReviewTasks = this.reviewTaskDAO.getObsoleteReviewTasks(documentVersionId, reviewCycleNodeInstanceReleasedId);
        ArrayList<Long> toBeRemovedTaskIds = new ArrayList<Long>();
        for (ReviewTask obsoleteReviewTask : obsoleteReviewTasks) {
            toBeRemovedTaskIds.add(obsoleteReviewTask.getTaskId());
            debugContext.addDeleteReviewTaskMessage(obsoleteReviewTask);
            if (!log.isInfoEnabled()) continue;
            log.info("Obsolete reviewTask with taskId [" + obsoleteReviewTask.getTaskId() + "] of documentVersionId = [" + documentVersionId + "] and reviewCycleNodeInstanceReleasedId = [" + reviewCycleNodeInstanceReleasedId + "] is about to be removed.");
        }
        if (toBeRemovedTaskIds.size() > 0) {
            this.deleteReviewTasks(toBeRemovedTaskIds);
        }
        debugContext.closeDebugNode();
    }

    public void generateReviewTasks(DebugContext debugContext, Long documentVersionId, Long reviewCycleNodeInstanceReleasedId, ReviewCycleNodeResult reviewCycleNodeResult, boolean fixMissingTasks) {
        debugContext.openDebugNode("TaskUtils.generateReviewTasks");
        this.generateReviewTasksInner(debugContext, documentVersionId, reviewCycleNodeInstanceReleasedId, reviewCycleNodeResult, fixMissingTasks, new ReviewTasksStrategy(), null);
        debugContext.closeDebugNode();
    }

    public void generateAttachedReviewTasks(DebugContext debugContext, Long documentVersionId, Long reviewCycleNodeInstanceReleasedId, ReviewCycleNodeResult reviewCycleNodeResult, boolean fixMissingTasks, List<AttachedReviewCycleNodePosition> attachedReviewCycleNodePositions) {
        debugContext.openDebugNode("TaskUtils.generateAttachedReviewTasks");
        this.generateReviewTasksInner(debugContext, documentVersionId, reviewCycleNodeInstanceReleasedId, reviewCycleNodeResult, fixMissingTasks, new AttachedReviewTasksStrategy(), attachedReviewCycleNodePositions);
        debugContext.closeDebugNode();
    }

    public void generateReviewTasksForParticipation(DebugContext debugContext, Long documentVersionId, Long nodeInstanceReleasedId, Long participationId, List<ReviewCycleNodePositionReleased> nodePositionReleaseds) {
        debugContext.openDebugNode("TaskUtils.generateReviewTasksForParticipation(documentVersionId [" + documentVersionId + "], participationId [" + participationId + "], nodeInstanceReleased [" + nodeInstanceReleasedId + "])");
        Set<Long> nodePositionIds = ContainerHelper.getPersistentIdsSet(nodePositionReleaseds);
        ReviewTasksStrategy strategy = new ReviewTasksStrategy();
        List<GenReviewTaskBaseJoin> baseJoins = this.reviewTaskDAO.getGenReviewTaskBaseJoin(documentVersionId, nodeInstanceReleasedId);
        GenReviewTaskBaseJoin versionJoin = JdbcReviewTaskDAO.extractUniqueForComponent(GenReviewTaskBaseComponent.DOCUMENT_VERSION, baseJoins);
        GenReviewTaskBaseJoin nodeInstanceReleasedJoin = JdbcReviewTaskDAO.extractUniqueForComponent(GenReviewTaskBaseComponent.NODE_INSTANCE_RELEASED, baseJoins);
        if (log.isDebugEnabled()) {
            log.debug("documentVersionId = {}, reviewCycleNodeInstanceReleasedId = {}, without explicit reviewCycleNodeResult", new Object[]{documentVersionId, nodeInstanceReleasedId});
        }
        List<GenReviewTaskPositionJoin> unfilteredParticipationJoins = this.reviewTaskDAO.getReviewTaskPositionJoins(documentVersionId, nodeInstanceReleasedId, null, participationId);
        ArrayList<GenReviewTaskPositionJoin> participationJoins = new ArrayList<GenReviewTaskPositionJoin>();
        for (GenReviewTaskPositionJoin participationJoin : unfilteredParticipationJoins) {
            if (!nodePositionIds.contains(participationJoin.getReviewCycleNodePositionReleasedId())) continue;
            participationJoins.add(participationJoin);
        }
        this.generateReviewTasks(debugContext, documentVersionId, participationId, versionJoin, nodeInstanceReleasedJoin, participationJoins, nodeInstanceReleasedId, null, false, strategy, null);
        debugContext.closeDebugNode();
    }

    private void generateReviewTasksInner(DebugContext debugContext, Long documentVersionId, Long reviewCycleNodeInstanceReleasedId, ReviewCycleNodeResult reviewCycleNodeResult, boolean fixMissingTasks, GenerateReviewTasksStrategy strategy, List<AttachedReviewCycleNodePosition> attachedReviewCycleNodePositions) {
        debugContext.openDebugNode("TaskUtils.geerateReviewTasksInner");
        List<GenReviewTaskBaseJoin> baseJoins = this.reviewTaskDAO.getGenReviewTaskBaseJoin(documentVersionId, reviewCycleNodeInstanceReleasedId);
        GenReviewTaskBaseJoin versionJoin = JdbcReviewTaskDAO.extractUniqueForComponent(GenReviewTaskBaseComponent.DOCUMENT_VERSION, baseJoins);
        GenReviewTaskBaseJoin nodeInstanceReleasedJoin = JdbcReviewTaskDAO.extractUniqueForComponent(GenReviewTaskBaseComponent.NODE_INSTANCE_RELEASED, baseJoins);
        log.info("documentVersionId = {}, reviewCycleNodeInstanceReleasedId = {}, reviewCycleNodeResult = {}", new Object[]{documentVersionId, reviewCycleNodeInstanceReleasedId, reviewCycleNodeResult});
        List<GenReviewTaskPositionJoin> positionJoins = strategy.fetchPositionJoins(documentVersionId, reviewCycleNodeInstanceReleasedId, reviewCycleNodeResult != null ? reviewCycleNodeResult.getId() : null);
        Map<Long, List<GenReviewTaskPositionJoin>> participationIdToReviewTaskJoins = this.groupPositionJoinsByParticipation(positionJoins);
        for (Long participationId : participationIdToReviewTaskJoins.keySet()) {
            List<GenReviewTaskPositionJoin> participationJoins = participationIdToReviewTaskJoins.get(participationId);
            ArrayList<AttachedReviewCycleNodePosition> currAttachedPositions = new ArrayList<AttachedReviewCycleNodePosition>();
            if (attachedReviewCycleNodePositions != null) {
                for (AttachedReviewCycleNodePosition attachedReviewCycleNodePosition : attachedReviewCycleNodePositions) {
                    if (attachedReviewCycleNodePosition.getProjectParticipationId().longValue() != participationId.longValue()) continue;
                    currAttachedPositions.add(attachedReviewCycleNodePosition);
                }
            }
            this.generateReviewTasks(debugContext, documentVersionId, participationId, versionJoin, nodeInstanceReleasedJoin, participationJoins, reviewCycleNodeInstanceReleasedId, reviewCycleNodeResult, fixMissingTasks, strategy, currAttachedPositions);
        }
        debugContext.closeDebugNode();
    }

    private void generateReviewTasks(DebugContext debugContext, Long documentVersionId, Long participationId, GenReviewTaskBaseJoin versionJoin, GenReviewTaskBaseJoin nodeInstanceReleaseJoin, List<GenReviewTaskPositionJoin> positionJoins, Long reviewCycleNodeInstanceReleasedId, ReviewCycleNodeResult reviewCycleNodeResult, boolean fixMissingTasks, GenerateReviewTasksStrategy strategy, List<AttachedReviewCycleNodePosition> attachedReviewCycleNodePositions) {
        String realmDescription;
        debugContext.openDebugNode("TaskUtils.generateReviewTasks");
        boolean hasUnSignedPositionResult = false;
        HashSet<Long> reviewCyclePositionIdsForTask = new HashSet<Long>();
        HashMap<Long, String> positionReleasedIdToRealmCode = new HashMap<Long, String>();
        if (strategy.withNodePositionReleaseds()) {
            Map<Long, List<GenReviewTaskPositionJoin>> positionReleaseIdToJoins = this.groupPositionJoinsByPositionRelease(positionJoins);
            for (Long positionReleaseId : positionReleaseIdToJoins.keySet()) {
                List<GenReviewTaskPositionJoin> joins = positionReleaseIdToJoins.get(positionReleaseId);
                boolean foundPositionResult = false;
                for (GenReviewTaskPositionJoin join : joins) {
                    if (join.getRealmCode() != null) {
                        positionReleasedIdToRealmCode.put(positionReleaseId, join.getRealmCode());
                    }
                    if (join.getDocumentVersionTaskTaskId() != null) {
                        debugContext.closeDebugNode("join.documentVersionTaskTaskId == null --> return");
                        return;
                    }
                    foundPositionResult |= join.getReviewCyclePositionResultId() != null;
                }
                if (foundPositionResult) continue;
                hasUnSignedPositionResult = true;
                reviewCyclePositionIdsForTask.add(positionReleaseId);
            }
        } else if (attachedReviewCycleNodePositions != null && attachedReviewCycleNodePositions.size() > 0) {
            boolean foundPositionResult = false;
            for (GenReviewTaskPositionJoin join : positionJoins) {
                if (join.getRealmCode() != null) {
                    positionReleasedIdToRealmCode.put(999L, join.getRealmCode());
                }
                if (join.getDocumentVersionTaskTaskId() != null) {
                    debugContext.openDebugNode("join.documetVerisonTaskTaskId null --> return");
                    return;
                }
                foundPositionResult |= join.getReviewCyclePositionResultId() != null;
            }
            if (!foundPositionResult) {
                hasUnSignedPositionResult = true;
                reviewCyclePositionIdsForTask.add(999L);
            }
        }
        if (!hasUnSignedPositionResult) {
            debugContext.closeDebugNode("!hasUnsignedPositionResult --> return");
            return;
        }
        if (log.isInfoEnabled()) {
            log.info("Generating " + (fixMissingTasks ? "missing " : "") + "ReviewTask for documentVersion = [" + documentVersionId + "]");
        }
        GenReviewTaskPositionJoin somePositionJoin = positionJoins.get(0);
        versionJoin.setCountry(somePositionJoin.getCountry());
        versionJoin.setPerson(somePositionJoin.getPerson());
        versionJoin.setOrganisationPerson(somePositionJoin.getOrganisationPerson());
        versionJoin.setPersonVariables(somePositionJoin.getPersonVariables());
        versionJoin.setProjectParticipation(somePositionJoin.getProjectParticipation());
        versionJoin.setProject(somePositionJoin.getProject());
        versionJoin.setNetwork(somePositionJoin.getNetwork());
        BaseTask task = new BaseTask();
        DocumentVersionTask documentVersionTask = new DocumentVersionTask();
        strategy.initialize();
        if (fixMissingTasks && reviewCycleNodeResult != null) {
            task.setBeginDate(reviewCycleNodeResult.getArrivalDate());
        }
        Long projectId = versionJoin.getProjectId();
        Long subProjectId = versionJoin.getSubProjectId();
        Double documentReleaseEndDate = versionJoin.getDocumentReleaseEndDate();
        List<GenerateTaskDeadlinesJoin> taskDeadlinesJoins = this.reviewCycleDAO.getGenerateTaskDeadlinesJoin(documentVersionId, projectId, subProjectId);
        List<GenerateTaskDeadlinesJoin> reviewCycleJoins = JdbcReviewCycleDAO.extractForComponent(GenerateTaskDeadlinesJoinComponent.REVIEW_CYCLE, taskDeadlinesJoins);
        reviewCycleJoins.addAll(JdbcReviewCycleDAO.extractForComponent(GenerateTaskDeadlinesJoinComponent.RESULT_OPTION, taskDeadlinesJoins));
        ReviewCycleContext reviewCycleContext = new ReviewCycleContext(reviewCycleJoins);
        List<ProjectHoliday> projectHolidays = this.extractProjectHolidays(taskDeadlinesJoins);
        ReviewCycleNodeInstanceReleased reviewCycleNodeInstanceReleased = nodeInstanceReleaseJoin.getReviewCycleNodeInstanceReleased();
        this.generateTaskDeadlines(reviewCycleContext, task, documentVersionTask, null, documentReleaseEndDate, projectHolidays, reviewCycleNodeInstanceReleased, false, positionJoins.get(0).getProjectId());
        String reviewCycleNodeName = nodeInstanceReleaseJoin.getReviewCycleNodeName();
        Long objectPlannerId = versionJoin.getObjectPlannerId();
        Long reviewCycleNodeInstanceId = nodeInstanceReleaseJoin.getReviewCycleNodeInstanceId();
        Long sampleControlReviewCycleResultOptionId = nodeInstanceReleaseJoin.getReviewCyclePositionTypeSampleControlReviewCycleResultOptionId();
        if (strategy.withNodePositionReleaseds()) {
            realmDescription = this.makeRealmDescription(reviewCyclePositionIdsForTask, positionReleasedIdToRealmCode);
        } else {
            realmDescription = "";
            HashSet<Long> realmsOfPP = new HashSet<Long>();
            for (AttachedReviewCycleNodePosition attachedReviewCycleNodePosition : attachedReviewCycleNodePositions) {
                realmsOfPP.add(attachedReviewCycleNodePosition.getRealmId());
            }
            for (GenReviewTaskPositionJoin genReviewTaskPositionJoin : positionJoins) {
                if (genReviewTaskPositionJoin.getRealmCode() == null || !realmsOfPP.contains(genReviewTaskPositionJoin.getRealmId())) continue;
                if (realmDescription.length() > 0) {
                    realmDescription = realmDescription + ", ";
                }
                realmDescription = realmDescription + genReviewTaskPositionJoin.getRealmCode();
            }
        }
        task.setName(reviewCycleNodeName);
        task.setDone(Boolean.valueOf(false));
        task.setBeginDelay(Integer.valueOf(0));
        task.setLocalisationId(versionJoin.getProjectLocalisationId());
        documentVersionTask.setObjectPlannerId(objectPlannerId);
        documentVersionTask.setDocumentVersionId(documentVersionId);
        documentVersionTask.setProjectParticipationId(participationId);
        strategy.setReviewTaskData(realmDescription, reviewCycleNodeInstanceId, sampleControlReviewCycleResultOptionId != null);
        task = (BaseTask)this.taskDAO.save(task);
        debugContext.addSaveTaskMessage(task);
        Long taskId = task.getId();
        documentVersionTask.setTaskId(taskId);
        strategy.setReviewTaskTaskId(taskId);
        log.info("save documentVersionTask = {}", (Object)documentVersionTask);
        this.documentVersionTaskDAO.save(documentVersionTask);
        debugContext.addSaveDocumentVersionTaskMessage(documentVersionTask);
        strategy.saveReviewTask(debugContext);
        if (strategy.withNodePositionReleaseds()) {
            ArrayList<ReviewTaskPositionMap> reviewTaskPositionMaps = new ArrayList<ReviewTaskPositionMap>();
            for (Long reviewCyclePositionIdForTask : reviewCyclePositionIdsForTask) {
                ReviewTaskPositionMap reviewTaskPositionMap = new ReviewTaskPositionMap();
                reviewTaskPositionMap.setReviewCycleNodePositionReleasedId(reviewCyclePositionIdForTask);
                reviewTaskPositionMap.setReviewTaskId(taskId);
                reviewTaskPositionMaps.add(reviewTaskPositionMap);
                debugContext.addSaveReviewTaskPositionMapMessage(reviewTaskPositionMap);
            }
            this.reviewTaskPositionMapDAO.saveBatch(reviewTaskPositionMaps);
        } else {
            ArrayList<AttachedReviewTaskPositionMap> attachedReviewTaskPositionMaps = new ArrayList<AttachedReviewTaskPositionMap>();
            for (AttachedReviewCycleNodePosition attachedReviewCycleNodePosition : attachedReviewCycleNodePositions) {
                AttachedReviewTaskPositionMap attachedReviewTaskPositionMap = new AttachedReviewTaskPositionMap();
                attachedReviewTaskPositionMap.setAttachedReviewCycleNodePositionId(attachedReviewCycleNodePosition.getId());
                attachedReviewTaskPositionMap.setAttachedReviewTaskId(taskId);
                attachedReviewTaskPositionMaps.add(attachedReviewTaskPositionMap);
                debugContext.addSaveAttachedReviewTaskPositionMapMessage(attachedReviewTaskPositionMap);
            }
            this.attachedReviewTaskPositionMapDAO.saveBatch(attachedReviewTaskPositionMaps);
        }
        GenerateTaskEmailSnippetsContextImpl taskContext = new GenerateTaskEmailSnippetsContextImpl(projectHolidays);
        Long l = somePositionJoin.getProjectParticipantParticipationId();
        List<ProjectParticipation> projectRoleParticipations = this.projectParticipationDAO.getParticipationsByProjectAndRoleTypeAndAction(projectId, RoleTypeEnum.PROJECT_SURVEILLANT.getValue(), Action.MONITOR_LATE_REVIEWS.getName());
        Set<Long> projectRoleParticipationIds = ContainerHelper.getPersistentIdsSet(projectRoleParticipations);
        List<FutureEmail> futureEmails = taskContext.getFutureEmailsForTask(task.getId());
        this.generateTaskEmailSnippets(debugContext, taskContext, futureEmails, projectHolidays, l, task, TaskEmailSnippetType.TYPE_NEW_TASK);
        if (futureEmailLog.isDebugEnabled()) {
            futureEmailLog.debug("generateReviewTasks will call generateTaskLateFutureEmail");
        }
        this.generateTaskLateFutureEMail(debugContext, taskContext, projectHolidays, projectRoleParticipationIds, task);
        taskContext.commitAll(debugContext, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
        this.createSelectCellConnectionAttachmentMail(debugContext, (AttachmentMailJoin)versionJoin);
        debugContext.closeDebugNode();
    }

    private Map<Long, List<GenReviewTaskPositionJoin>> groupPositionJoinsByParticipation(List<GenReviewTaskPositionJoin> positionJoins) {
        HashMap<Long, List<GenReviewTaskPositionJoin>> participationIdToJoins = new HashMap<Long, List<GenReviewTaskPositionJoin>>();
        for (GenReviewTaskPositionJoin positionJoin : positionJoins) {
            Long projectParticipationId = positionJoin.getProjectParticipationId();
            if (!participationIdToJoins.containsKey(projectParticipationId)) {
                participationIdToJoins.put(projectParticipationId, new ArrayList());
            }
            ((List)participationIdToJoins.get(projectParticipationId)).add(positionJoin);
        }
        return participationIdToJoins;
    }

    private Map<Long, List<GenReviewTaskPositionJoin>> groupPositionJoinsByPositionRelease(List<GenReviewTaskPositionJoin> positionJoins) {
        HashMap<Long, List<GenReviewTaskPositionJoin>> positionReleaseIdToPositionJoins = new HashMap<Long, List<GenReviewTaskPositionJoin>>();
        for (GenReviewTaskPositionJoin positionJoin : positionJoins) {
            Long positionReleasedId = positionJoin.getReviewCycleNodePositionReleasedId();
            if (!positionReleaseIdToPositionJoins.containsKey(positionReleasedId)) {
                positionReleaseIdToPositionJoins.put(positionReleasedId, new ArrayList());
            }
            ((List)positionReleaseIdToPositionJoins.get(positionReleasedId)).add(positionJoin);
        }
        return positionReleaseIdToPositionJoins;
    }

    private String makeRealmDescription(Set<Long> reviewCyclePositionIdsForTask, Map<Long, String> positionReleasedIdToRealmCode) {
        String realmDescription = "";
        for (Long reviewCyclePositionIdForTask : reviewCyclePositionIdsForTask) {
            String realmCode = positionReleasedIdToRealmCode.get(reviewCyclePositionIdForTask);
            if (realmCode == null) {
                throw new IllegalArgumentException("No realm code found for reviewCyclePositionReleasedId = [" + reviewCyclePositionIdForTask + "]");
            }
            if (realmDescription.length() > 0) {
                realmDescription = realmDescription + ", ";
            }
            realmDescription = realmDescription + realmCode;
        }
        return realmDescription;
    }

    public void generateTaskDeadlines(DurationCalcContext cycleContext, BaseTask task, DocumentVersionTask documentVersionTask, Double documentReleaseStartDate, Double documentReleaseEndDate, List<ProjectHoliday> projectHolidays, ReviewCycleNodeInstanceReleased nodeInstanceReleased, boolean usePDCStartDate, Long projectId) {
        DurationInfo nodeDuration;
        DurationInfo remainingDuration = this.durationCalculator.calculateReviewCycleInstanceRemainingDurations(cycleContext, nodeInstanceReleased, projectId);
        DurationInfo durationInfo = nodeDuration = nodeInstanceReleased != null && nodeInstanceReleased.getId() != null ? new DurationInfo(nodeInstanceReleased.getDuration(), nodeInstanceReleased.getDurationMin()) : new DurationInfo(0, 0);
        if (log.isDebugEnabled()) {
            log.debug("........ generateTaskDeadlines: remaining_cycle_duration [" + remainingDuration.getDuration() + "," + remainingDuration.getDurationMin() + "]; node_duration [" + nodeDuration.getDuration() + "," + nodeDuration.getDurationMin() + "]");
        }
        this.generateTaskDeadlinesInner(task, documentVersionTask, documentReleaseStartDate, documentReleaseEndDate, projectHolidays, remainingDuration, nodeDuration, usePDCStartDate);
    }

    private void generateTaskDeadlinesInner(BaseTask task, DocumentVersionTask documentVersionTask, Double documentReleaseStartDate, Double documentReleaseEndDate, List<ProjectHoliday> projectHolidays, DurationInfo remainingDuration, DurationInfo nodeDuration, boolean usePDCStartDate) {
        HolidayCalculator holidayCalculator = HolidayCalculatorFactory.getInstance("at", projectHolidays);
        Double beginUtcSeconds = null;
        if (task.getBeginDate() != null) {
            beginUtcSeconds = usePDCStartDate && documentReleaseStartDate != null && documentReleaseStartDate.compareTo(task.getBeginDate()) > 0 ? documentReleaseStartDate : task.getBeginDate();
            task.setBeginDate(beginUtcSeconds);
            if (log.isDebugEnabled()) {
                log.debug(".......... Using task.begin = [" + this.utcSecondsToDebugString(beginUtcSeconds) + "] as begin.");
            }
        } else {
            beginUtcSeconds = usePDCStartDate && documentReleaseStartDate != null && documentReleaseStartDate.compareTo(new Double((double)System.currentTimeMillis() / 1000.0)) > 0 ? documentReleaseStartDate : new Double((double)System.currentTimeMillis() / 1000.0);
            task.setBeginDate(beginUtcSeconds);
            if (log.isDebugEnabled()) {
                log.debug(".......... Using current time [" + this.utcSecondsToDebugString(beginUtcSeconds) + "] as begin since task.beginDate == null");
            }
        }
        task.setDeltaT(Integer.valueOf(nodeDuration.getDuration()));
        Double overallEndDate = holidayCalculator.addWorkingDays(beginUtcSeconds, remainingDuration.getDuration());
        documentVersionTask.setOverallEndDate(overallEndDate);
        Double contractualDeadline = holidayCalculator.addWorkingDays(beginUtcSeconds, nodeDuration.getDuration());
        documentVersionTask.setContractualDeadline(contractualDeadline);
        task.setEndDate(contractualDeadline);
        Double minimumDeadline = holidayCalculator.addWorkingDays(beginUtcSeconds, nodeDuration.getDurationMin());
        documentVersionTask.setMinimalDeadline(minimumDeadline);
        Double requiredEndDate = documentReleaseEndDate;
        if (log.isDebugEnabled()) {
            log.debug(".......... overallEndDate = [" + this.utcSecondsToDebugString(overallEndDate) + "]; contractualDeadline = [" + this.utcSecondsToDebugString(contractualDeadline) + "]; minimalDeadLine = [" + this.utcSecondsToDebugString(minimumDeadline) + "]; requiredEndDate = " + (requiredEndDate != null ? this.utcSecondsToDebugString(requiredEndDate) : "null"));
        }
        int requiredDuration = requiredEndDate != null ? holidayCalculator.getWorkingDaysBetween(beginUtcSeconds, requiredEndDate).intValue() : remainingDuration.getDuration();
        if (log.isDebugEnabled()) {
            log.debug(".......... required_duration [" + requiredDuration + "]");
        }
        if (remainingDuration.getDuration() <= requiredDuration) {
            documentVersionTask.setMinDeltaT(Integer.valueOf(nodeDuration.getDuration()));
            documentVersionTask.setNodeOptimalDeadline(documentVersionTask.getContractualDeadline());
            documentVersionTask.setOptimalDeadline(documentVersionTask.getContractualDeadline());
            documentVersionTask.setUrgency(Integer.valueOf(ReviewCycleTaskUrgency.URGENCY_NORMAL.getValue()));
            if (log.isDebugEnabled()) {
                log.debug(".......... Case 1: minDeltaT = " + documentVersionTask.getMinDeltaT() + "; optimalDeadLine = [" + this.utcSecondsToDebugString(documentVersionTask.getOptimalDeadline()) + "]; urgency = [" + documentVersionTask.getUrgency() + "]");
            }
        } else {
            int myDuration = requiredDuration - (remainingDuration.getDuration() - nodeDuration.getDuration());
            Double nodeOptimalDeadline = holidayCalculator.addWorkingDays(beginUtcSeconds, myDuration);
            documentVersionTask.setNodeOptimalDeadline(nodeOptimalDeadline);
            int remainingCyleDurationReducedToCurrentMinDeltaT = remainingDuration.getDuration() - nodeDuration.getDuration() + nodeDuration.getDurationMin();
            if (log.isDebugEnabled()) {
                log.debug(".......... Case 2/3: my_duration = " + myDuration + "; nodeOptimalDeadline = [" + this.utcSecondsToDebugString(documentVersionTask.getNodeOptimalDeadline()) + "]; remaining_cycle_duration_reduced... = [" + remainingCyleDurationReducedToCurrentMinDeltaT);
            }
            if (remainingCyleDurationReducedToCurrentMinDeltaT <= requiredDuration) {
                documentVersionTask.setMinDeltaT(Integer.valueOf(myDuration));
                documentVersionTask.setOptimalDeadline(documentVersionTask.getNodeOptimalDeadline());
                documentVersionTask.setUrgency(Integer.valueOf(ReviewCycleTaskUrgency.URGENCY_DELAYED_NODE.getValue()));
                if (log.isDebugEnabled()) {
                    log.debug(".......... Case 2: minDeltaT = " + documentVersionTask.getMinDeltaT() + "; optimalDeadLine = [" + this.utcSecondsToDebugString(documentVersionTask.getOptimalDeadline()) + "]; urgency = [" + documentVersionTask.getUrgency() + "]");
                }
            } else {
                documentVersionTask.setMinDeltaT(Integer.valueOf(nodeDuration.getDurationMin()));
                Double optimalDeadline = holidayCalculator.addWorkingDays(beginUtcSeconds, nodeDuration.getDurationMin());
                documentVersionTask.setOptimalDeadline(optimalDeadline);
                if (remainingDuration.getDurationMin() <= requiredDuration) {
                    documentVersionTask.setUrgency(Integer.valueOf(ReviewCycleTaskUrgency.URGENCY_DELAYED_CYCLE.getValue()));
                } else {
                    documentVersionTask.setUrgency(Integer.valueOf(ReviewCycleTaskUrgency.URGENCY_DELAYED_HOPELESS.getValue()));
                }
                if (log.isDebugEnabled()) {
                    log.debug(".......... Case 3: minDeltaT = " + documentVersionTask.getMinDeltaT() + "; optimalDeadLine = [" + this.utcSecondsToDebugString(documentVersionTask.getOptimalDeadline()) + "]; urgency = [" + documentVersionTask.getUrgency() + "]");
                }
            }
        }
    }

    private String utcSecondsToDebugString(Double utcSeconds) {
        return utcSeconds != null ? new Date((long)(utcSeconds * 1000.0)).toString() : "null";
    }

    public void generateMultipleTaskEmailSnippets(DebugContext debugContext, ReducedWriteOnlyTaskEmailContext taskContext, List<FutureEmail> futureEmails, List<ProjectHoliday> projectHolidays, List<? extends GenerateTaskEmailSnippetJoin> generateTaskEmailSnippetJoins, BaseTask task, Long participationId, TaskEmailSnippetType taskEmailSnippetType) {
        debugContext.openDebugNode("generateMultipleTaskEmailSnippets");
        for (GenerateTaskEmailSnippetJoin generateTaskEmailSnippetJoin : generateTaskEmailSnippetJoins) {
            if (generateTaskEmailSnippetJoin.getProjectParticipationId() == null || generateTaskEmailSnippetJoin.getProjectParticipationId().longValue() != participationId.longValue() || generateTaskEmailSnippetJoin.getOrganisationPersonRetiredFlag() != null && generateTaskEmailSnippetJoin.getOrganisationPersonRetiredFlag().booleanValue()) continue;
            this.generateTaskEmailSnippets(debugContext, taskContext, futureEmails, projectHolidays, participationId, task, taskEmailSnippetType);
        }
        debugContext.closeDebugNode();
    }

    public void generateTaskEmailSnippets(ReducedWriteOnlyTaskEmailContext taskContext, List<FutureEmail> futureEmails, List<ProjectHoliday> projectHolidays, GenerateTaskEmailSnippetJoin generateTaskEmailSnippetJoin, BaseTask task, Long participationId, TaskEmailSnippetType taskEmailSnippetType) {
        if (!(generateTaskEmailSnippetJoin.getProjectParticipantParticipationId() == null || generateTaskEmailSnippetJoin.getProjectParticipantParticipationId().longValue() != participationId.longValue() || generateTaskEmailSnippetJoin.getOrganisationPersonRetiredFlag() != null && generateTaskEmailSnippetJoin.getOrganisationPersonRetiredFlag().booleanValue())) {
            this.generateTaskEmailSnippets(new DebugContext(), taskContext, futureEmails, projectHolidays, participationId, task, taskEmailSnippetType);
        }
    }

    public void generateTaskEmailSnippets(DebugContext debugContext, ReducedWriteOnlyTaskEmailContext taskContext, List<FutureEmail> existingFutureEmailsForTask, List<ProjectHoliday> projectHolidays, Long participationId, BaseTask task, TaskEmailSnippetType taskEmailSnippetType) {
        debugContext.openDebugNode("generateTaskEmailSnippets (participationId [" + participationId + "], taskId [" + task.getId() + "]");
        if (log.isDebugEnabled()) {
            log.debug("........ Called generateTaskEmailSnippets: task [" + task.getId() + "]; Participation [" + participationId + "]; type = " + taskEmailSnippetType.toString());
        }
        List<ProjectParticipant> projectParticipants = this.projectParticipantDAO.getByParticipation(participationId);
        for (ProjectParticipant projectParticipant : projectParticipants) {
            OrganisationPerson organisationPerson = (OrganisationPerson)this.organisationPersonDAO.get(projectParticipant.getOrganisationPersonId());
            if (!EmailHelper.doSendEmail(organisationPerson) || projectParticipant.isInactiveFlag().booleanValue()) continue;
            if (log.isDebugEnabled()) {
                log.debug("........ Decided to send a mail to OrgPerson " + organisationPerson.getId());
            }
            EmailSnippet newEmailSnippet = new EmailSnippet();
            newEmailSnippet.setOrganisationPersonId(organisationPerson.getId());
            Double sendTime = EmailHelper.getNextEmailSendTime(organisationPerson);
            newEmailSnippet.setSendTime(sendTime);
            TaskEmailSnippet newTaskEmailSnippet = new TaskEmailSnippet();
            newTaskEmailSnippet.setTaskId(task.getId());
            newTaskEmailSnippet.setType(Integer.valueOf(taskEmailSnippetType.getValue()));
            if (log.isDebugEnabled()) {
                log.debug(".......... Filling TaskEmailSnippet: OrgPerson [" + organisationPerson.getId() + "]; sendTime [" + this.utcSecondsToDebugString(sendTime) + "]; task [" + task.getId() + "]; type [" + taskEmailSnippetType.toString() + "]");
            }
            debugContext.addRegisterAddEmailSnippetMessage(newEmailSnippet);
            debugContext.addRegisterAddTaskEmailSnippetMessage(newTaskEmailSnippet);
            taskContext.registerNewTaskEmailSnippet(newEmailSnippet, newTaskEmailSnippet);
        }
        if (task.getEndDate() != null) {
            if (futureEmailLog.isDebugEnabled()) {
                futureEmailLog.debug("generateTaskEmailSnippets will call generateTaskLateFutureEmail");
            }
            this.generateTaskReminderFutureEmail(debugContext, taskContext, existingFutureEmailsForTask, projectHolidays, task, participationId);
        }
        debugContext.closeDebugNode();
    }

    private void generateTaskReminderFutureEmail(DebugContext debugContext, ReducedWriteOnlyTaskEmailContext taskContext, List<FutureEmail> existingFutureEmails, List<ProjectHoliday> projectHolidays, BaseTask task, Long participationId) {
        HolidayCalculator holidayCalculator;
        int diffDays;
        int warnBefore;
        debugContext.openDebugNode("generateTaskReminderFutureEmail (taskId [" + task.getId() + "], participationId [" + participationId + "])");
        if (log.isDebugEnabled()) {
            log.debug("............ Called generateTaskReminderFutureEMail for task [" + task.getId() + "]; participation [" + participationId + "]");
        }
        int n = warnBefore = (diffDays = (holidayCalculator = HolidayCalculatorFactory.getInstance("at", projectHolidays)).getWorkingDaysBetween(task.getBeginDate(), task.getEndDate()).intValue()) > 3 ? 3 : 1;
        if (log.isDebugEnabled()) {
            log.debug("............ task.endDate = [" + this.utcSecondsToDebugString(task.getEndDate()) + "]; diffDays = " + diffDays + "; warnBefore = " + warnBefore);
        }
        Double sendTime = holidayCalculator.addWorkingDays(task.getEndDate(), -warnBefore);
        for (FutureEmail futureEmail : existingFutureEmails) {
            if (log.isDebugEnabled()) {
                log.debug("............ Processing TaskFutureEMail [" + futureEmail.getId() + "]");
            }
            if (futureEmail.getType().intValue() != FutureEmailType.TASK_REMINDER.getValue() || futureEmail.getProjectParticipationId() == null || futureEmail.getProjectParticipationId().longValue() != participationId.longValue()) continue;
            if (log.isDebugEnabled()) {
                log.debug(".............. Deleting it since type = " + futureEmail.getType() + "; participation [" + participationId + "] matches.");
            }
            taskContext.registerFutureEmailForDelete(futureEmail);
            debugContext.addRegisterDeleteFutureEmailMessage(futureEmail);
        }
        if (log.isDebugEnabled()) {
            log.debug(".............. Considering to send it: " + this.utcSecondsToDebugString(task.getBeginDate()) + "; sendTime = " + sendTime.toString());
        }
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTimeInMillis((long)(task.getBeginDate() * 1000.0));
        Calendar sendTimeCalendar = Calendar.getInstance();
        sendTimeCalendar.setTimeInMillis((long)(sendTime * 1000.0));
        if (CalendarHelper.daysBetween((Calendar)beginCalendar, (Calendar)sendTimeCalendar) > 0) {
            FutureEmail newFutureEmail = new FutureEmail();
            newFutureEmail.setType(Integer.valueOf(FutureEmailType.TASK_REMINDER.getValue()));
            newFutureEmail.setProjectParticipationId(participationId);
            newFutureEmail.setTaskId(task.getId());
            newFutureEmail.setSendTime(sendTime);
            newFutureEmail.setMainParticipantOnly(Boolean.valueOf(false));
            if (log.isDebugEnabled()) {
                log.debug("................ Sending it with type " + newFutureEmail.getType() + "; Participation " + newFutureEmail.getProjectParticipationId() + "; task " + task.getId() + "; sendTime " + sendTime.toString());
            }
            if (futureEmailLog.isDebugEnabled()) {
                futureEmailLog.debug("generateTaskReminderFutureEmail will register new FutureEmail for participationId [" + participationId + "] and taskId [" + task.getId() + "]");
            }
            taskContext.registerNewFutureEmail(newFutureEmail, task);
            debugContext.addRegisterAddFutureEmailMessage(newFutureEmail);
        }
        debugContext.closeDebugNode();
    }

    public void generateTaskLateFutureEMail(final DebugContext debugContext, ReducedWriteOnlyTaskEmailContext taskContext, List<ProjectHoliday> projectHolidays, Set<Long> projectRoleParticipationIds, BaseTask task) {
        debugContext.openDebugNode("TaskUtils.generateTaskLateFutureEmail");
        if (log.isDebugEnabled()) {
            log.debug("........ Called generateTaskLateFutureEmail with task [" + task.getId() + "];");
        }
        for (final Long projectRoleParticipationId : projectRoleParticipationIds) {
            if (log.isDebugEnabled()) {
                log.debug("............ Processing Participation " + projectRoleParticipationId);
            }
            taskContext.registerFutureEmailsForDelete(new ObjectCriteria<FutureEmail>(){

                @Override
                public boolean matches(FutureEmail futureEmail) {
                    boolean result;
                    boolean bl = result = futureEmail.getProjectParticipationId() != null && futureEmail.getProjectParticipationId().longValue() == projectRoleParticipationId.longValue() && futureEmail.getType().intValue() == FutureEmailType.LATE_TASK.getValue();
                    if (log.isDebugEnabled() && result) {
                        log.debug("............ Deleting futureEmail with ProjectParticipation " + futureEmail.getProjectParticipationId() + ",type = " + futureEmail.getType());
                    }
                    if (result) {
                        debugContext.addRegisterDeleteFutureEmailMessage(futureEmail);
                    }
                    return result;
                }
            });
        }
        for (final Long projectRoleParticipationId : projectRoleParticipationIds) {
            this.createLateTaskFutureEmail(debugContext, taskContext, projectHolidays, task, projectRoleParticipationId);
        }
        debugContext.closeDebugNode();
    }

    private void createLateTaskFutureEmail(DebugContext debugContext, ReducedWriteOnlyTaskEmailContext taskContext, List<ProjectHoliday> projectHolidays, BaseTask task, Long projectParticipationId) {
        debugContext.openDebugNode("TaskUtils.createLateTaskFutureEmail(task [" + task.getId() + "], participation [" + projectParticipationId + "])");
        HolidayCalculator holidayCalculator = HolidayCalculatorFactory.getInstance("at", projectHolidays);
        int daysBetween = holidayCalculator.getWorkingDaysBetween(task.getEndDate(), (double)System.currentTimeMillis() / 1000.0);
        if (daysBetween > 0) {
            FutureEmail newFutureEmail = new FutureEmail();
            newFutureEmail.setType(Integer.valueOf(FutureEmailType.LATE_TASK.getValue()));
            newFutureEmail.setProjectParticipationId(projectParticipationId);
            newFutureEmail.setTaskId(task.getId());
            newFutureEmail.setSendTime(task.getEndDate());
            newFutureEmail.setMainParticipantOnly(Boolean.valueOf(false));
            if (futureEmailLog.isDebugEnabled()) {
                futureEmailLog.debug("createLateTaskFutureEmail will register new FutureEmail for participationId [" + projectParticipationId + "] and taskId [" + task.getId() + "]");
            }
            taskContext.registerNewFutureEmail(newFutureEmail, task);
            debugContext.addRegisterAddFutureEmailMessage(newFutureEmail);
        }
        debugContext.closeDebugNode();
    }

    public void createSelectCellConnectionAttachmentMail(DebugContext debugContext, AttachmentMailJoin attachmentMailJoin) {
        debugContext.openDebugNode("createSelectCellConnectionAttachmentMail");
        String toMailAddress = attachmentMailJoin.getProjectParticipationAttachmentEmailAddress();
        if (toMailAddress == null || toMailAddress.length() <= 0) {
            debugContext.closeDebugNode("toMailAddress not set");
            return;
        }
        String toMailName = PersonHelper.getCommonName(attachmentMailJoin.getPerson());
        Long documentVersionId = attachmentMailJoin.getDocumentVersionId();
        Long attachmentFileSize = this.mailUtils.getDocumentVersionAttachmentMailSize(documentVersionId);
        boolean attachmentSizeOk = this.mailUtils.checkDocumentVersionAttachmentSizeAndSendWarnMailIfNecessary(attachmentFileSize, attachmentMailJoin);
        if (attachmentSizeOk) {
            String locale = attachmentMailJoin.getPersonVariablesUserLocale();
            ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
            String subject = resourceBundle.getString("documentVersionAttachmentMailSubject");
            String prefix = MessageFormat.format(resourceBundle.getString("requestOriginalsFileSendMessagePrefix"), this.applicationName);
            String postfix = MessageFormat.format(resourceBundle.getString("requestOriginalsFileSendMessagePostfix"), this.applicationName);
            String contextString = this.mailUtils.getMailContextString(resourceBundle, attachmentMailJoin);
            OrganisationPerson receiver = attachmentMailJoin.getOrganisationPerson();
            Person receiverPerson = attachmentMailJoin.getPerson();
            List<Email> mails = this.mailUtils.createMail(debugContext, toMailName, toMailAddress, receiver.getId(), subject, prefix + contextString + postfix, null, null, null);
            for (Email email : mails) {
                Object[] parameters = new Object[]{documentVersionId};
                String parameterString = TapestryHelper.constructParametersString(parameters);
                EmailAttachment emailAttachment = new EmailAttachment();
                emailAttachment.setEmailId(email.getId());
                emailAttachment.setMimeSource("documentVersionMimeSource");
                emailAttachment.setParameters(parameterString);
                this.emailAttachmentDAO.save(emailAttachment);
                debugContext.addSaveEmailAttachmentMessage(emailAttachment);
            }
        }
        debugContext.closeDebugNode();
    }

    public void generateReviewCyclePlotTask(Long documentVersionId, Long plotOrderId, Long acceptanceStepId, PlotOrderTemplateJoin templateJoin, ContextJoin contextJoin) {
        Long projectId = contextJoin.getProjectId();
        String locale = templateJoin.getPlotterPersonVariablesUserLocale();
        Long localisationId = contextJoin.getProjectLocalisationId();
        Long plotterId = templateJoin.getPlottOrderTemplatePlotterId();
        Long objectPlannerId = contextJoin.getObjectPlannerId();
        this.generateReviewCyclePlotTask(new DebugContext(), documentVersionId, plotOrderId, acceptanceStepId, projectId, locale, localisationId, plotterId, objectPlannerId);
    }

    public Long generateReviewCyclePlotTask(DebugContext debugContext, Long documentVersionId, Long plotOrderId, Long acceptanceStepId, Long projectId, String locale, Long localisationId, Long plotterId, Long objectPlannerId) {
        debugContext.openDebugNode("generateReviewCyclePlotTask");
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        String taskName = resourceBundle.getString("reviewCyclePlotTaskName");
        BaseTask task = new BaseTask();
        task.setName(taskName);
        task.setBeginDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
        task.setLocalisationId(localisationId);
        task.setDeltaT(Integer.valueOf(0));
        task.setBeginDelay(Integer.valueOf(0));
        task.setDone(Boolean.valueOf(false));
        task = (BaseTask)this.taskDAO.save(task);
        debugContext.addSaveTaskMessage(task);
        DocumentVersionTask documentVersionTask = new DocumentVersionTask();
        documentVersionTask.setTaskId(task.getId());
        documentVersionTask.setProjectParticipationId(plotterId);
        documentVersionTask.setObjectPlannerId(objectPlannerId);
        documentVersionTask.setDocumentVersionId(documentVersionId);
        documentVersionTask.setUrgency(Integer.valueOf(ReviewCycleTaskUrgency.URGENCY_NORMAL.getValue()));
        documentVersionTask.setMinDeltaT(Integer.valueOf(0));
        documentVersionTask = (DocumentVersionTask)this.documentVersionTaskDAO.save(documentVersionTask);
        debugContext.addSaveDocumentVersionTaskMessage(documentVersionTask);
        if (log.isInfoEnabled()) {
            log.info("Generating  ReviewCyclePlotTask for documentVersion = [" + documentVersionId + "]");
        }
        ReviewCyclePlottTask reviewCyclePlotTask = new ReviewCyclePlottTask();
        reviewCyclePlotTask.setTaskId(task.getId());
        reviewCyclePlotTask.setOrderId(plotOrderId);
        reviewCyclePlotTask.setOrderStepId(acceptanceStepId);
        reviewCyclePlotTask = (ReviewCyclePlottTask)this.reviewCyclePlotTaskDAO.save(reviewCyclePlotTask);
        debugContext.addSaveReviewCyclePlotTaskMessage(reviewCyclePlotTask);
        List<ProjectHoliday> projectHolidays = this.projectHolidayDAO.getByProject(projectId);
        GenerateTaskEmailSnippetsContextImpl taskEmailSnippetContext = new GenerateTaskEmailSnippetsContextImpl(projectHolidays);
        Long plotterProjectParticipationId = plotterId;
        List<ProjectParticipationJoin> plotterParticipationJoins = this.projectParticipationDAO.getParticipationJoins(plotterProjectParticipationId, false);
        List<FutureEmail> futureEmails = taskEmailSnippetContext.getFutureEmailsForTask(task.getId());
        this.generateTaskEmailSnippets(debugContext, taskEmailSnippetContext, futureEmails, projectHolidays, plotterProjectParticipationId, task, TaskEmailSnippetType.TYPE_NEW_TASK);
        taskEmailSnippetContext.commitAll(debugContext, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
        debugContext.closeDebugNode();
        return task.getId();
    }

    public void generatePlotOrderAcceptanceTasks(BaseTask oldTask, DocumentVersionTask oldDocumentVersionTask, ReviewCyclePlottTask oldReviewCyclePlotTask, Set<Long> participationIdSet) {
        ArrayList<Long> participationIds = new ArrayList<Long>();
        participationIds.addAll(participationIdSet);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        List<DocumentVersionTask> newDocumentVersionTasks = new ArrayList();
        List<PlotOrderAcceptanceTask> plotOrderAcceptanceTasks = new ArrayList();
        for (int n = 0; n < participationIds.size(); ++n) {
            BaseTask newTask = new BaseTask();
            newTask.setLocalisationId(oldTask.getLocalisationId());
            newTask.setBeginDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
            newTask.setName(resourceBundle.getString("plotOrderAcceptanceTaskName"));
            newTask.setDeltaT(Integer.valueOf(0));
            newTask.setBeginDelay(Integer.valueOf(0));
            newTask.setDone(Boolean.valueOf(false));
            newTask = (BaseTask)this.taskDAO.save(newTask);
            DocumentVersionTask newDocumentVersionTask = new DocumentVersionTask();
            newDocumentVersionTask.setTaskId(newTask.getId());
            newDocumentVersionTask.setProjectParticipationId((Long)participationIds.get(n));
            newDocumentVersionTask.setDocumentVersionId(oldDocumentVersionTask.getDocumentVersionId());
            newDocumentVersionTask.setObjectPlannerId(oldDocumentVersionTask.getObjectPlannerId());
            newDocumentVersionTask.setMinDeltaT(Integer.valueOf(0));
            newDocumentVersionTask.setUrgency(Integer.valueOf(0));
            newDocumentVersionTasks.add(newDocumentVersionTask);
            if (log.isInfoEnabled()) {
                log.info("Generating  PlotOrderAcceptanceTask for documentVersion = [" + oldDocumentVersionTask.getDocumentVersionId() + "]");
            }
            PlotOrderAcceptanceTask newPlotOrderAcceptanceTask = new PlotOrderAcceptanceTask();
            newPlotOrderAcceptanceTask.setTaskId(newTask.getId());
            newPlotOrderAcceptanceTask.setOrderId(oldReviewCyclePlotTask.getOrderId());
            newPlotOrderAcceptanceTask.setOrderStepId(oldReviewCyclePlotTask.getOrderStepId());
            plotOrderAcceptanceTasks.add(newPlotOrderAcceptanceTask);
        }
        newDocumentVersionTasks = this.documentVersionTaskDAO.saveBatch(newDocumentVersionTasks);
        plotOrderAcceptanceTasks = this.plotOrderAcceptanceTaskDAO.saveBatch(plotOrderAcceptanceTasks);
    }

    public void generateReviewCycleEntryTask(DebugContext debugContext, ReducedWriteOnlyTaskEmailContext taskContext, List<PlanDeliverReleaseJoin> objectPlannerJoins, List<ProjectHoliday> projectHolidays, Set<Long> projectRoleParticipationIds, Long localisationId, ObjectPlannerRelease releasedObjectPlanner, ReviewCycleInstanceReleased reviewCycleInstanceReleased, Document document, DocumentRelease documentRelease) {
        debugContext.openDebugNode("TaskUtils.generateReviewCycleEntryTask");
        Long plannerParticipationId = releasedObjectPlanner.getPlannerId();
        BaseTask task = new BaseTask();
        DocumentTask documentTask = new DocumentTask();
        ReviewCycleEntryTask reviewCycleEntryTask = new ReviewCycleEntryTask();
        task.setBeginDelay(Integer.valueOf(0));
        task.setName("Planupload");
        task.setLocalisationId(localisationId);
        task.setDone(Boolean.valueOf(false));
        documentTask.setDocumentId(document.getId());
        documentTask.setObjectPlannerId(releasedObjectPlanner.getObjectPlannerId());
        documentTask.setProjectParticipationId(plannerParticipationId);
        if (documentRelease != null && documentRelease.getStartDate() != null) {
            this.generateTaskDeadlines(projectHolidays, task, documentTask, reviewCycleEntryTask, documentRelease, reviewCycleInstanceReleased.getDuration(), reviewCycleInstanceReleased.getDurationPre());
        }
        task = (BaseTask)this.taskDAO.save(task);
        debugContext.addSaveTaskMessage(task);
        documentTask.setTaskId(task.getId());
        reviewCycleEntryTask.setTaskId(task.getId());
        this.documentTaskDAO.save(documentTask);
        debugContext.addSaveDocumentTaskMessage(documentTask);
        this.reviewCycleEntryTaskDAO.save(reviewCycleEntryTask);
        debugContext.addSaveReviewCycleEntryTaskMessage(reviewCycleEntryTask);
        ArrayList<FutureEmail> existingFutureEmails = new ArrayList<FutureEmail>();
        this.generateTaskEmailSnippets(debugContext, taskContext, existingFutureEmails, projectHolidays, plannerParticipationId, task, TaskEmailSnippetType.TYPE_NEW_TASK);
        if (futureEmailLog.isDebugEnabled()) {
            futureEmailLog.debug("generateReviewCycleEntryTask will call generateTaskLateFutureEmail");
        }
        this.generateTaskLateFutureEMail(debugContext, taskContext, projectHolidays, projectRoleParticipationIds, task);
        debugContext.closeDebugNode();
    }

    public void generateTaskDeadlines(List<ProjectHoliday> projectHolidays, BaseTask task, DocumentTask documentTask, ReviewCycleEntryTask reviewCycleEntryTask, DocumentRelease documentRelease, int remainingCycleDuration, int cyclePreDuration) {
        HolidayCalculator holidayCalculator = HolidayCalculatorFactory.getInstance("at", projectHolidays);
        Double beginUtcSeconds = task.getBeginDate() == null ? (double)System.currentTimeMillis() / 1000.0 : task.getBeginDate();
        Double endUtcSeconds = documentRelease.getStartDate() != null ? documentRelease.getStartDate() : (task.getBeginDate() == null ? Double.valueOf((double)System.currentTimeMillis() / 1000.0) : task.getBeginDate());
        task.setBeginDate(beginUtcSeconds);
        if (cyclePreDuration == 0 || this.reversePreduration != null && this.reversePreduration.booleanValue()) {
            task.setEndDate(endUtcSeconds);
        } else {
            Double effectiveEndUtcSeconds = holidayCalculator.addWorkingDays(endUtcSeconds, -cyclePreDuration);
            task.setEndDate(effectiveEndUtcSeconds);
        }
        Double diffAsDouble = endUtcSeconds - beginUtcSeconds;
        long diffAsLong = diffAsDouble.longValue();
        int diffInDays = (int)(diffAsLong / 3600L / 24L);
        task.setDeltaT(Integer.valueOf(diffInDays));
        if (documentRelease.getEndDate() != null) {
            reviewCycleEntryTask.setOverallEndDate(endUtcSeconds);
        } else {
            Double effectiveEndUtcSeconds = holidayCalculator.addWorkingDays(endUtcSeconds, remainingCycleDuration);
            reviewCycleEntryTask.setOverallEndDate(effectiveEndUtcSeconds);
        }
    }

    public void doReviewCycleEntryTask(ReviewCycleEntryTask task, Long reviewCycleEntryResultId) {
        BaseTask baseTask = (BaseTask)this.taskDAO.get(task.getTaskId());
        baseTask.setDone(Boolean.valueOf(true));
        this.taskDAO.update(baseTask);
        ReviewCycleEntryTaskDone doneTask = new ReviewCycleEntryTaskDone();
        doneTask.setTaskId(task.getTaskId());
        doneTask.setOverallEndDate(task.getOverallEndDate());
        doneTask.setDoneDate(Double.valueOf((double)Instant.now().toEpochMilli() / 1000.0));
        doneTask.setReviewCycleEntryResultId(reviewCycleEntryResultId);
        this.reviewCycleEntryTaskDAO.delete(task.getTaskId());
        this.reviewCycleEntryTaskDoneDAO.save(doneTask);
    }

    public void doReviewTask(Long reviewTaskId, boolean reviewTaskCase, List<IDoReviewTaskPositionResultJoin> donePositions, boolean breakingResult) {
        DocumentVersionTask documentVersionTask = (DocumentVersionTask)this.documentVersionTaskDAO.get(reviewTaskId);
        BaseTask baseTask = (BaseTask)this.taskDAO.get(reviewTaskId);
        BaseTask baseTaskDone = new BaseTask(baseTask);
        baseTaskDone.setId(null);
        baseTaskDone.setDone(Boolean.valueOf(true));
        DocumentVersionTask documentVersionTaskDone = new DocumentVersionTask(documentVersionTask);
        documentVersionTaskDone.setTaskId(null);
        baseTaskDone = (BaseTask)this.taskDAO.save(baseTaskDone);
        documentVersionTaskDone.setTaskId(baseTaskDone.getId());
        documentVersionTaskDone = (DocumentVersionTask)this.documentVersionTaskDAO.save(documentVersionTaskDone);
        ReviewTask reviewTask = null;
        AttachedReviewTask attachedReviewTask = null;
        Map<Object, Object> doneNotDoneMaps = new HashMap();
        Map<Object, Object> attachedDoneNotDoneMaps = new HashMap();
        if (reviewTaskCase) {
            ReviewTaskDone reviewTaskDone = new ReviewTaskDone();
            reviewTask = (ReviewTask)this.reviewTaskDAO.get(reviewTaskId);
            reviewTaskDone.setRealmDescription(reviewTask.getRealmDescription());
            reviewTaskDone.setReviewCycleNodeInstanceId(reviewTask.getReviewCycleNodeInstanceId());
            reviewTaskDone.setSampleControlReview(reviewTask.getSampleControlReview());
            reviewTaskDone.setDoneDate(Double.valueOf((double)Instant.now().toEpochMilli() / 1000.0));
            reviewTaskDone.setTaskId(documentVersionTaskDone.getTaskId());
            reviewTaskDone = (ReviewTaskDone)this.reviewTaskDoneDAO.save(reviewTaskDone);
            List<ReviewTaskPositionMap> taskPositions = this.reviewTaskPositionMapDAO.getByReviewTask(reviewTaskId);
            long taskDoneId = reviewTaskDone.getTaskId();
            List newMaps = donePositions.stream().map(join -> {
                ReviewTaskDoneResultsMap ret = new ReviewTaskDoneResultsMap();
                ret.setReviewTaskDoneId(Long.valueOf(taskDoneId));
                ret.setReviewCyclePositionResultId(join.getReviewCyclePositionResultId());
                return ret;
            }).collect(Collectors.toList());
            this.reviewTaskDoneResultsMapDAO.saveBatch(newMaps);
            Set donePositionResultId = donePositions.stream().map(reviewTaskCase ? IDoReviewTaskPositionResultJoin::getReviewCycleNodePositionReleasedId : IDoReviewTaskPositionResultJoin::getAttachedReviewCycleNodePositionId).collect(Collectors.toSet());
            doneNotDoneMaps = taskPositions.stream().collect(Collectors.partitioningBy(position -> donePositionResultId.contains(position.getReviewCycleNodePositionReleasedId())));
            this.reviewTaskPositionMapDAO.deleteBatch((Collection)doneNotDoneMaps.get(true));
        } else {
            AttachedReviewTaskDone attachedReviewTaskDone = new AttachedReviewTaskDone();
            attachedReviewTask = (AttachedReviewTask)this.attachedReviewTaskDAO.get(reviewTaskId);
            attachedReviewTaskDone.setRealmDescription(attachedReviewTask.getRealmDescription());
            attachedReviewTaskDone.setReviewCycleNodeInstanceId(attachedReviewTask.getReviewCycleNodeInstanceId());
            attachedReviewTaskDone.setSampleControlReview(attachedReviewTask.getSampleControlReview());
            attachedReviewTaskDone.setDoneDate(Double.valueOf((double)Instant.now().toEpochMilli() / 1000.0));
            attachedReviewTaskDone.setTaskId(documentVersionTaskDone.getTaskId());
            attachedReviewTaskDone = (AttachedReviewTaskDone)this.attachedReviewTaskDoneDAO.save(attachedReviewTaskDone);
            List<AttachedReviewTaskPositionMap> taskPositions = this.attachedReviewTaskPositionMapDAO.getByAttachedReviewTask(reviewTaskId);
            long taskDoneId = attachedReviewTaskDone.getTaskId();
            List newMaps = donePositions.stream().map(join -> {
                AttachedReviewTaskDoneResultsMap ret = new AttachedReviewTaskDoneResultsMap();
                ret.setAttachedReviewTaskDoneId(Long.valueOf(taskDoneId));
                ret.setReviewCyclePositionResultId(join.getReviewCyclePositionResultId());
                return ret;
            }).collect(Collectors.toList());
            this.attachedReviewTaskDoneResultsMapDAO.saveBatch(newMaps);
            Set donePositionResultId = donePositions.stream().map(reviewTaskCase ? IDoReviewTaskPositionResultJoin::getReviewCycleNodePositionReleasedId : IDoReviewTaskPositionResultJoin::getAttachedReviewCycleNodePositionId).collect(Collectors.toSet());
            attachedDoneNotDoneMaps = taskPositions.stream().collect(Collectors.partitioningBy(position -> donePositionResultId.contains(position.getAttachedReviewCycleNodePositionId())));
            this.attachedReviewTaskPositionMapDAO.deleteByTask(reviewTaskId);
        }
        if (breakingResult) {
            this.deleteSameNodeTasks(reviewTaskId);
        } else if (!doneNotDoneMaps.isEmpty() && ((List)doneNotDoneMaps.get(false)).isEmpty() || !attachedDoneNotDoneMaps.isEmpty() && ((List)attachedDoneNotDoneMaps.get(false)).isEmpty()) {
            if (reviewTaskCase) {
                this.deleteReviewTask(reviewTaskId);
            } else {
                this.deleteAttachedReviewTask(reviewTaskId);
            }
        } else if (reviewTaskCase) {
            reviewTask.setTaskStatus(TaskStatus.UNREVIEWED.getValue());
            this.reviewTaskDAO.update(reviewTask);
        } else {
            attachedReviewTask.setTaskStatus(TaskStatus.UNREVIEWED.getValue());
            this.attachedReviewTaskDAO.update(attachedReviewTask);
        }
    }

    private void deleteSameNodeTasks(Long reviewTaskId) {
        List<ReviewTask> reviewTasks = this.reviewTaskDAO.getByReviewTaskWithSameNodeAndVersion(reviewTaskId);
        ArrayList<Long> reviewTaskIds = new ArrayList<Long>();
        for (ReviewTask reviewTask : reviewTasks) {
            reviewTaskIds.add(reviewTask.getTaskId());
        }
        this.deleteReviewTasks(reviewTaskIds);
        List<AttachedReviewTask> attachedReviewTasks = this.attachedReviewTaskDAO.getByReviewTaskWithSameNodeAndVersion(reviewTaskId);
        ArrayList<Long> attachedReviewTaskIds = new ArrayList<Long>();
        for (AttachedReviewTask attachedReviewTask : attachedReviewTasks) {
            attachedReviewTaskIds.add(attachedReviewTask.getTaskId());
        }
        this.deleteAttachedReviewTasks(attachedReviewTaskIds);
    }

    public void doSelectCellTask(Long selectCellTaskId, Long reviewCycleCellConnectionResultId) {
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(selectCellTaskId);
        TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
        SelectCellConnectionTask connectionTask = (SelectCellConnectionTask)this.selectCellConnectionTaskDAO.get(selectCellTaskId);
        SelectCellConnectionTaskDone connectionTaskDone = new SelectCellConnectionTaskDone();
        BaseTask baseTask = (BaseTask)this.taskDAO.get(selectCellTaskId);
        baseTask.setDone(Boolean.valueOf(true));
        this.taskDAO.update(baseTask);
        connectionTaskDone.setDoneDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
        connectionTaskDone.setTaskId(selectCellTaskId);
        connectionTaskDone.setReviewCycleNodeInstanceId(connectionTask.getReviewCycleNodeInstanceId());
        connectionTaskDone.setReviewCycleCellConnectionResultId(reviewCycleCellConnectionResultId);
        this.selectCellConnectionMapDAO.deleteByTaskId(selectCellTaskId);
        this.selectCellConnectionTaskDAO.delete(selectCellTaskId);
        this.selectCellConnectionTaskDoneDAO.save(connectionTaskDone);
    }

    public void doReviewCyclePlotTask(Long reviewCyclePlotTaskId, Long orderStepId) {
        ReviewCyclePlottTask reviewCyclePlottTask = (ReviewCyclePlottTask)this.reviewCyclePlotTaskDAO.get(reviewCyclePlotTaskId);
        ReviewCyclePlottTaskDone reviewCyclePlotTaskDone = new ReviewCyclePlottTaskDone();
        BaseTask baseTask = (BaseTask)this.taskDAO.get(reviewCyclePlotTaskId);
        baseTask.setDone(Boolean.valueOf(true));
        this.taskDAO.update(baseTask);
        reviewCyclePlotTaskDone.setDoneDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
        reviewCyclePlotTaskDone.setTaskId(reviewCyclePlotTaskId);
        reviewCyclePlotTaskDone.setOrderId(reviewCyclePlottTask.getOrderId());
        reviewCyclePlotTaskDone.setOrderStepId(orderStepId);
        this.reviewCyclePlotTaskDAO.delete(reviewCyclePlotTaskId);
        this.reviewCyclePlotTaskDoneDAO.save(reviewCyclePlotTaskDone);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        taskIds.add(reviewCyclePlotTaskId);
        TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
    }

    public void doPlotOrderAcceptanceTask(Long plotOrderAcceptanceTaskId) {
        PlotOrderAcceptanceTask plotOrderAcceptanceTask = (PlotOrderAcceptanceTask)this.plotOrderAcceptanceTaskDAO.get(plotOrderAcceptanceTaskId);
        PlotOrderAcceptanceTaskDone plotOrderAcceptanceTaskDone = new PlotOrderAcceptanceTaskDone();
        plotOrderAcceptanceTaskDone.setOrderId(plotOrderAcceptanceTask.getOrderId());
        plotOrderAcceptanceTaskDone.setOrderStepId(plotOrderAcceptanceTask.getOrderStepId());
        plotOrderAcceptanceTaskDone.setTaskId(plotOrderAcceptanceTaskId);
        plotOrderAcceptanceTaskDone.setObsoleteDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
        plotOrderAcceptanceTaskDone.setDoneDate(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
        this.plotOrderAcceptanceTaskDAO.delete(plotOrderAcceptanceTaskId);
        this.plotOrderAcceptanceTaskDoneDAO.save(plotOrderAcceptanceTaskDone);
        BaseTask task = (BaseTask)this.taskDAO.get(plotOrderAcceptanceTaskId);
        task.setDone(Boolean.valueOf(true));
        this.taskDAO.update(task);
    }

    public void deleteAttachedReviewTasksByParticipation(Long participationId) {
        List<AttachedReviewTaskParticipationDeleteJoin> deleteJoins = this.attachedReviewTaskDAO.getParticipationDeleteJoins(participationId);
        HashMap attachedReviewCycleNodePositionIdToJoins = new HashMap();
        HashMap<Long, ReviewCycleNodeInstanceReleased> taskIdToReviewCycleNodeInstanceReleased = new HashMap<Long, ReviewCycleNodeInstanceReleased>();
        HashMap<Long, AttachedReviewTaskParticipationDeleteJoin> taskIdToSomeDeleteJoin = new HashMap<Long, AttachedReviewTaskParticipationDeleteJoin>();
        for (AttachedReviewTaskParticipationDeleteJoin deleteJoin : deleteJoins) {
            Long attachedReviewCycleNodePositionId = deleteJoin.getAttachedReviewCycleNodePositionId();
            if (!attachedReviewCycleNodePositionIdToJoins.containsKey(attachedReviewCycleNodePositionId)) {
                attachedReviewCycleNodePositionIdToJoins.put(attachedReviewCycleNodePositionId, new ArrayList());
            }
            ((List)attachedReviewCycleNodePositionIdToJoins.get(attachedReviewCycleNodePositionId)).add(deleteJoin);
            Long taskId = deleteJoin.getDocumentVersionTaskTaskId();
            ReviewCycleNodeInstanceReleased reviewCycleNodeInstanceReleased = deleteJoin.getReviewCycleNodeInstanceReleased();
            if (reviewCycleNodeInstanceReleased != null) {
                if (taskIdToReviewCycleNodeInstanceReleased.containsKey(taskId)) {
                    throw new IllegalArgumentException("Unique mapping taskId --> reviewCycleNodeInstanceReleasedId expected, found taskId = [" + taskId + "], reviewCycleNodeInstanceReleasedIds = [" + reviewCycleNodeInstanceReleased.getId() + "] and [" + ((ReviewCycleNodeInstanceReleased)taskIdToReviewCycleNodeInstanceReleased.get(taskId)).getId() + "]");
                }
                taskIdToReviewCycleNodeInstanceReleased.put(taskId, reviewCycleNodeInstanceReleased);
            }
            taskIdToSomeDeleteJoin.put(taskId, deleteJoin);
        }
        for (Long attachedReviewCycleNodePositionId : attachedReviewCycleNodePositionIdToJoins.keySet()) {
            List currDeleteJoins = (List)attachedReviewCycleNodePositionIdToJoins.get(attachedReviewCycleNodePositionId);
            HashMap reviewCyclePositionResultIdToJoins = new HashMap();
            for (AttachedReviewTaskParticipationDeleteJoin currDeleteJoin : currDeleteJoins) {
                Long reviewCyclePositionResultId = currDeleteJoin.getReviewCyclePositionResultId();
                if (reviewCyclePositionResultId == null) continue;
                if (!reviewCyclePositionResultIdToJoins.containsKey(reviewCyclePositionResultId)) {
                    reviewCyclePositionResultIdToJoins.put(reviewCyclePositionResultId, new ArrayList());
                }
                ((List)reviewCyclePositionResultIdToJoins.get(reviewCyclePositionResultId)).add(currDeleteJoin);
            }
            if (reviewCyclePositionResultIdToJoins.size() > 1) {
                throw new RuntimeException("Found multiple reviewCyclePositionResultIds [" + reviewCyclePositionResultIdToJoins.keySet() + "] for attachedReviewCycleNodePositionId [" + attachedReviewCycleNodePositionId + "]; expecting either none or exactly one.");
            }
            if (reviewCyclePositionResultIdToJoins.size() != 1) continue;
            for (Long reviewCyclePositionResultId : reviewCyclePositionResultIdToJoins.keySet()) {
                AttachedReviewTaskParticipationDeleteJoin deleteJoin = (AttachedReviewTaskParticipationDeleteJoin)((List)reviewCyclePositionResultIdToJoins.get(reviewCyclePositionResultId)).get(0);
                DocumentVersion documentVersion = deleteJoin.getDocumentVersion();
                ReviewCycleNodeResult reviewCycleNodeResult = deleteJoin.getReviewCycleNodeResult();
                ReviewCycleCellResult reviewCycleCellResult = deleteJoin.getReviewCycleCellResult();
                ReviewCycleResultOption reviewCycleResultOption = deleteJoin.getReviewCycleResultOption();
                this.reviewUtils.deleteReviewCyclePositionResultsWithSubElementsId(reviewCyclePositionResultId, reviewCycleNodeResult, reviewCycleCellResult, documentVersion, reviewCycleResultOption, false, false);
            }
        }
        ArrayList attachedReviewCycleNodePositionIdsToDelete = new ArrayList();
        attachedReviewCycleNodePositionIdsToDelete.addAll(attachedReviewCycleNodePositionIdToJoins.keySet());
        if (attachedReviewCycleNodePositionIdsToDelete.size() > 0) {
            this.attachedReviewCycleNodePositionDAO.deleteBatch(attachedReviewCycleNodePositionIdsToDelete);
        }
        HashSet<Long> taskIds = new HashSet<Long>();
        for (AttachedReviewTaskParticipationDeleteJoin deleteJoin : deleteJoins) {
            taskIds.add(deleteJoin.getDocumentVersionTaskTaskId());
        }
        this.deleteAndMoveTasks(taskIds, taskIdToReviewCycleNodeInstanceReleased, taskIdToSomeDeleteJoin);
    }

    public void deleteAndMoveTasks(Collection<Long> taskIds, Map<Long, ReviewCycleNodeInstanceReleased> taskIdToReviewCycleNodeInstanceReleased, Map<Long, AttachedReviewTaskParticipationDeleteJoin> taskIdToSomeDeleteJoin) {
        TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
        this.deleteAttachedReviewTasks(taskIds);
        for (Long taskId : taskIds) {
            ReviewCycleNodeInstanceReleased reviewCycleNodeInstanceReleased = taskIdToReviewCycleNodeInstanceReleased.get(taskId);
            Long reviewCycleNodeInstanceReleasedId = reviewCycleNodeInstanceReleased != null ? reviewCycleNodeInstanceReleased.getId() : null;
            Long documentVersionId = taskIdToSomeDeleteJoin.get(taskId).getDocumentVersionId();
            AttachedReviewTaskParticipationDeleteJoin someJoin = taskIdToSomeDeleteJoin.get(taskId);
            if (reviewCycleNodeInstanceReleasedId != null) {
                if (!this.reviewCycleNodeInstanceReleasedDAO.isNodeFinished(reviewCycleNodeInstanceReleasedId, documentVersionId).booleanValue()) continue;
                ArrayList<String> messages = new ArrayList<String>();
                ReviewCycleNodeResult nodeResult = someJoin.getActiveNodeResult();
                DocumentVersion documentVersion = someJoin.getDocumentVersion();
                this.reviewUtils.moveDocumentVersionToNextNode(new DebugContext(), messages, reviewCycleNodeInstanceReleased, (IObjectPlannerReleaseObjectJoin)someJoin, nodeResult, documentVersion, false);
                continue;
            }
            log.warn("deleteAndMoveTask: No ReviewCycleInstanceRelease found for taskId [" + taskId + "]. Task was deleted but not moved.");
        }
    }

    public void removeTasks(DebugContext debugContext, Long documentVersionId, Long projectId) {
        debugContext.openDebugNode("removeTasks (documentVersionId = [" + documentVersionId + "], projectId = [" + projectId + "]");
        List<TaskTreeJoin> taskTreeJoins = this.taskDAO.getTaskTreeJoinsByVersionId(documentVersionId);
        for (TaskTreeJoin taskTreeJoin : taskTreeJoins) {
            if (taskTreeJoin.getReviewCyclePlotTaskTaskId() != null || taskTreeJoin.getPlotOrderAcceptanceTaskTaskId() != null) {
                boolean atLeastOneOrdersDocumentVersionValid = false;
                Long orderId = taskTreeJoin.getReviewCyclePlotTaskOrderId();
                if (orderId == null) {
                    orderId = taskTreeJoin.getPlotOrderAcceptanceTaskOrderId();
                }
                List<PlottOrderItem> orderItems = this.plottOrderItemDAO.getByOrderContract(orderId);
                for (PlottOrderItem orderItem : orderItems) {
                    if (documentVersionId.equals(orderItem.getDocumentVersionId())) continue;
                    DocumentVersion itemsDocumentVersion = (DocumentVersion)this.documentVersionDAO.get(orderItem.getDocumentVersionId());
                    DocumentVersionStatus documentVersionStatus = DocumentVersionStatus.getByValue((Integer)itemsDocumentVersion.getStatus());
                    boolean itemsDocumentVersionInvalidated = documentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION || documentVersionStatus == DocumentVersionStatus.INVALIDATEDALL || documentVersionStatus == DocumentVersionStatus.DELETED;
                    atLeastOneOrdersDocumentVersionValid |= !itemsDocumentVersionInvalidated;
                }
                Long orderStepId = taskTreeJoin.getReviewCyclePlotTaskOrderStepId();
                OrderStep tasksOrderStep = null;
                if (orderStepId != null) {
                    tasksOrderStep = (OrderStep)this.orderStepDAO.get(orderStepId);
                }
                boolean isOpen = false;
                if (atLeastOneOrdersDocumentVersionValid && taskTreeJoin.getReviewCyclePlotTaskTaskId() != null && tasksOrderStep != null && tasksOrderStep.getSignatureId() == null) {
                    isOpen = true;
                    continue;
                }
                boolean allStepsSigned = true;
                block2: for (PlottOrderItem orderItem : orderItems) {
                    List<OrderStep> orderSteps = this.orderStepDAO.getByOrderItem(orderItem.getId());
                    if (orderSteps.size() == 0) {
                        allStepsSigned = false;
                        break;
                    }
                    for (OrderStep orderStep : orderSteps) {
                        if (orderStep.getSignatureId() != null) continue;
                        allStepsSigned = false;
                        continue block2;
                    }
                }
                if (isOpen) continue;
                if (taskTreeJoin.getReviewCyclePlotTaskTaskId() != null) {
                    this.deleteReviewCyclePlotTask(taskTreeJoin.getTaskId());
                    debugContext.addDeleteDocumentVersionTaskMessage(taskTreeJoin, "ReviewCyclePlotTask");
                    continue;
                }
                if (taskTreeJoin.getPlotOrderAcceptanceTaskTaskId() == null) continue;
                ArrayList<Long> plotOrderAcceptanceTaskIds = new ArrayList<Long>();
                plotOrderAcceptanceTaskIds.add(taskTreeJoin.getTaskId());
                this.deletePlotOrderAcceptanceTasks(plotOrderAcceptanceTaskIds);
                debugContext.addDeleteDocumentVersionTaskMessage(taskTreeJoin, "PlotOrderAcceptanceTask");
                continue;
            }
            if (taskTreeJoin.getReviewTaskTaskId() != null || taskTreeJoin.getAttachedReviewTaskTaskId() != null) {
                this.generateStatusEMailSnippetsForReviewTask(debugContext, documentVersionId, projectId, taskTreeJoin, StatusEmailSnippetType.TASKS_INVALIDATED);
                if (taskTreeJoin.getReviewTaskTaskId() != null) {
                    this.deleteReviewTask(taskTreeJoin.getTaskId());
                    debugContext.addDeleteDocumentVersionTaskMessage(taskTreeJoin, "ReviewTask");
                    continue;
                }
                this.deleteAttachedReviewTask(taskTreeJoin.getTaskId());
                debugContext.addDeleteDocumentVersionTaskMessage(taskTreeJoin, "AttachedReviewTask");
                continue;
            }
            if (taskTreeJoin.getOriginalDocumentTaskTaskId() != null) {
                this.deleteOriginalDocumentTask(taskTreeJoin.getTaskId());
                debugContext.addDeleteDocumentVersionTaskMessage(taskTreeJoin, "OriginalDocumentTask");
                continue;
            }
            if (taskTreeJoin.getReviewCycleEntryTaskTaskId() != null) {
                DocumentTask task = (DocumentTask)this.documentTaskDAO.get(taskTreeJoin.getTaskId());
                this.deleteReviewCycleEntryTask(taskTreeJoin.getTaskId());
                debugContext.addDeleteDocumentTaskMessage(task);
                continue;
            }
            if (taskTreeJoin.getSelectCellConnectionTaskTaskId() != null) {
                this.deleteSelectCellConnectionTask(taskTreeJoin.getTaskId());
                debugContext.addDeleteDocumentVersionTaskMessage(taskTreeJoin, "SelectCellConnectionTask");
                continue;
            }
            throw new RuntimeException("Impossible case, all task cases should be handled above.");
        }
        debugContext.closeDebugNode();
    }

    public void generateStatusEMailSnippetsForReviewTask(DebugContext debugContext, Long documentVersionId, Long projectId, TaskTreeJoin taskTreeJoin, StatusEmailSnippetType statusEmailSnippetType) {
        debugContext.openDebugNode("generateStatusEMailSnippetsForReviewTask (documentVersionId = [" + documentVersionId + "], projectId = [" + projectId + "], taskId = [" + taskTreeJoin.getTaskId() + "], type = [" + statusEmailSnippetType.getValue() + "]");
        if (log.isDebugEnabled()) {
            log.debug("generateStatusEMailSnippetsForReviewTask (documentVersionId = [" + documentVersionId + "], projectId = [" + projectId + "], taskId = [" + taskTreeJoin.getTaskId() + "], type = [" + statusEmailSnippetType.getValue() + "]");
        }
        Long participationId = taskTreeJoin.getDocumentVersionTaskProjectParticipationId();
        List<ProjectParticipant> projectParticipants = this.projectParticipantDAO.getByParticipation(participationId);
        for (ProjectParticipant projectParticipant : projectParticipants) {
            OrganisationPerson organisationPerson = (OrganisationPerson)this.organisationPersonDAO.get(projectParticipant.getOrganisationPersonId());
            if (!EmailHelper.doSendEmail(organisationPerson) || projectParticipant.isInactiveFlag().booleanValue()) continue;
            Double nextEmailSendTime = EmailHelper.getNextEmailSendTime(organisationPerson);
            EmailSnippet emailSnippet = new EmailSnippet();
            emailSnippet.setOrganisationPersonId(organisationPerson.getId());
            emailSnippet.setSendTime(nextEmailSendTime);
            emailSnippet = (EmailSnippet)this.emailSnippetDAO.save(emailSnippet);
            StatusEmailSnippet statusEmailSnippet = new StatusEmailSnippet();
            statusEmailSnippet.setEmailSnippetId(emailSnippet.getId());
            statusEmailSnippet.setType(Integer.valueOf(statusEmailSnippetType.getValue()));
            statusEmailSnippet.setDocumentVersionId(documentVersionId);
            this.statusEmailSnippetDAO.save(statusEmailSnippet);
            if (statusEmailSnippetType == StatusEmailSnippetType.TASKS_INVALIDATED || statusEmailSnippetType == StatusEmailSnippetType.TASKS_OBSOLETED) continue;
            GenerateTaskReminderFutureEmailContext context = new GenerateTaskReminderFutureEmailContext(projectId);
            List<ProjectHoliday> projectHolidays = context.getAllProjectHolidays();
            List<FutureEmail> futureEmails = context.getFutureEmailsForTask(taskTreeJoin.getTaskId());
            if (futureEmailLog.isDebugEnabled()) {
                futureEmailLog.debug("generateStatusEMailSnippetsForReviewTask will call generateTaskLateFutureEmail");
            }
            this.generateTaskReminderFutureEmail(debugContext, context, futureEmails, projectHolidays, taskTreeJoin.getTask(), participationId);
            context.commit(debugContext);
        }
        debugContext.closeDebugNode();
    }

    public int insertCreateMissingTasks(DebugContext debugContext, ReviewCycleInfo cycleInfo, Map<Long, ReviewCycleResultOption> idToResultOption, ReviewCycleNodeResult nodeResult, DocumentVersion documentVersion, boolean checkAndRestore, int type) {
        debugContext.openDebugNode("TaskUtils.insertCreateMissingTasks");
        int count = 0;
        int generatedReviewTasks = 0;
        int generatedAttachedReviewTasks = 0;
        int generatedSelectCellTasks = 0;
        Long documentVersionId = documentVersion.getId();
        DocumentVersionStatus documentVersionStatus = DocumentVersionStatus.getByValue((Integer)documentVersion.getStatus());
        Long nodeResultId = nodeResult.getId();
        Long nodeResultNodeId = nodeResult.getReviewCycleNodeId();
        ReviewCycleNode nodeResultNode = cycleInfo.getNodeById(nodeResultNodeId);
        Long nodeResultCellId = nodeResultNode.getReviewCycleCellId();
        ReviewCycleCell nodeResultCell = cycleInfo.getCellById(nodeResultCellId);
        ReviewCycleNodeInstanceReleased nodeInstanceReleased = this.reviewCycleNodeInstanceReleasedDAO.getByDocumentVersionAndNodeResult(documentVersionId, nodeResultId);
        Long nodeInstanceReleasedId = nodeInstanceReleased.getId();
        ReviewCycleNode activeNode = this.reviewCycleNodeDAO.getActiveByDocumentVersion(documentVersion.getId());
        boolean activeNodeIsEndNode = cycleInfo.isEndNode(activeNode.getId());
        if (type == 0 || type == 1 || type == 2) {
            log.info("checking for obsolete reviewTasks and trying to generate missing tasks for documentVersion=[" + documentVersion.getName() + "] docVerId=[" + documentVersion.getId() + "]");
            if (!activeNodeIsEndNode) {
                this.checkForObsoleteReviewTasks(debugContext, documentVersionId, nodeInstanceReleasedId);
                if (documentVersionStatus != DocumentVersionStatus.RELEASEDPOSITIV) {
                    if (type == 0 || type == 1) {
                        this.generateReviewTasks(debugContext, documentVersionId, nodeInstanceReleasedId, nodeResult, true);
                    }
                    if (type == 0 || type == 2) {
                        this.generateAttachedReviewTasks(debugContext, documentVersionId, nodeInstanceReleasedId, nodeResult, true, new ArrayList<AttachedReviewCycleNodePosition>());
                    }
                } else {
                    log.info("skipping generating reviewTasks because documentVersion is already released.");
                }
            } else {
                log.info("skipping generating reviewTasks because actualReviewCycleNode is endNode.");
            }
        }
        if (type == 0 || type == 3) {
            boolean isEndCell;
            Long prevNodeId = cycleInfo.getPrevNodeId(activeNode.getId());
            ReviewCycleNodeResult prevNodeResult = null;
            boolean evaluateCellConnections = false;
            if (prevNodeId != null && (prevNodeResult = this.reviewCycleNodeResultDAO.getByNodeAndDocumentVersion(prevNodeId, documentVersionId)) != null) {
                Long prevNodeResultOptionId = prevNodeResult.getReviewCycleResultOptionId();
                ReviewCycleResultOption prevNodeResultOption = idToResultOption.get(prevNodeResultOptionId);
                evaluateCellConnections = prevNodeResultOption.isEvaluateCellConnections();
            }
            boolean nodeResultIsFinishedandNotInvalidated = nodeResult.isFinished() != false && documentVersionStatus != DocumentVersionStatus.INVALIDATEDVERSION && documentVersionStatus != DocumentVersionStatus.RELEASEDNEGATIV;
            boolean bl = isEndCell = nodeResultCell.getIsEndCell() != null && nodeResultCell.getIsEndCell() != false;
            if (documentVersionStatus == DocumentVersionStatus.RELEASEDPOSITIV || activeNodeIsEndNode && !nodeResultIsFinishedandNotInvalidated && documentVersionStatus != DocumentVersionStatus.INVALIDATEDALL && documentVersionStatus != DocumentVersionStatus.DELETED && (!isEndCell || isEndCell && (evaluateCellConnections || !evaluateCellConnections && (documentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION || documentVersionStatus == DocumentVersionStatus.RELEASEDNEGATIV)))) {
                this.generateSelectCellTask(debugContext, prevNodeId, documentVersionId, nodeInstanceReleasedId, isEndCell, evaluateCellConnections);
                ObjectListRelease activeObjectListRelease = this.objectListReleaseDAO.getActiveByDocumentVersion(documentVersionId);
                boolean generated = this.generateSelectCellTask(debugContext, activeObjectListRelease.getId(), documentVersionId, nodeInstanceReleasedId, true, evaluateCellConnections);
                if (generated) {
                    ++generatedSelectCellTasks;
                }
            } else {
                log.info("skipping generating selectCellTask because documentVersion is already released or invalidatedAll or actual node is not endNode or is endNode/endCell not fullfilling required conditions");
            }
        }
        count = generatedReviewTasks + generatedAttachedReviewTasks + generatedSelectCellTasks;
        debugContext.closeDebugNode();
        return count;
    }

    public int insertCreateMissingTasksOfSubProject(Long organisationPersonId, Long subProjectId, boolean checkAndRestore, int type) {
        int count = 0;
        ContextJoin contextJoin = this.subProjectDAO.getSubProjectContextJoin(subProjectId);
        if (type == 0 || type == 1 || type == 2) {
            ObjectListRelease objectListRel = this.objectListReleaseDAO.getActiveBySubProject(subProjectId);
            if (objectListRel == null) {
                return 0;
            }
            List<DocumentVersion> documentVersions = this.getDocumentHighestVersions(subProjectId);
            log.info("Starting check for missing reviewTasks and selectCellTasks in " + (checkAndRestore ? "validate and restore mode" : "validate only mode") + " for project [" + contextJoin.getProjectCode() + " " + contextJoin.getProjectName() + "] and subProject [" + contextJoin.getSubProjectCode() + " " + contextJoin.getSubProjectName() + "]");
            ProjectLocalisationJoin localisationJoin = this.projectDAO.getLocalisationJoinBySubProject(subProjectId);
            List<String> contentLocales = null;
            OrganisationPersonJoin orgPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(organisationPersonId);
            String personVariablesUserLocale = orgPersonJoin.getPersonVariablesUserLocale();
            List<ReviewCycleTreeJoin> reviewCycleTreeJoins = this.reviewCycleDAO.getAllReviewCycleTreeJoins();
            ReviewCycleInfo cycleInfo = this.reviewUtils.constructReviewCycleInfoByTreeJoins(reviewCycleTreeJoins, personVariablesUserLocale, contentLocales);
            List<ReviewCycleResultOption> resultOptions = this.reviewUtils.fetchAndConvertResultOptions(personVariablesUserLocale, contentLocales);
            Map<Long, ReviewCycleResultOption> idToResultOption = ContainerHelper.groupById(resultOptions);
            for (DocumentVersion documentVersion : documentVersions) {
                Long documentVersionId = documentVersion.getId();
                ReviewCycleNodeResult reviewCycleNodeResult = this.reviewCycleNodeResultDAO.getByActiveNodeAndDocumentVersion(documentVersionId);
                if (reviewCycleNodeResult == null) continue;
                count += this.insertCreateMissingTasks(new DebugContext(), cycleInfo, idToResultOption, reviewCycleNodeResult, documentVersion, checkAndRestore, type);
            }
        }
        if (type == 0 || type == 3) {
            log.info("starting check for missing plannerEntryTasks in " + (checkAndRestore ? "validate and restore mode" : "validate only mode") + " for project [" + contextJoin.getProjectCode() + " " + contextJoin.getProjectName() + "] and subProject [" + contextJoin.getSubProjectCode() + " " + contextJoin.getSubProjectName() + "]");
            count += this.checkAndRestorePlannerEntryTasks(subProjectId, checkAndRestore);
        }
        return count;
    }

    private List<DocumentVersion> getDocumentHighestVersions(Long subProjectId) {
        List<DocumentVersion> allDocumentVersions = this.documentVersionDAO.getBySubProjectViaNonInvalidatedDocument(subProjectId);
        Map<Long, DocumentVersion> idToDocumentVersion = ContainerHelper.groupById(allDocumentVersions);
        HashMap<Long, DocumentVersion> documentIdToMaxUploadedVersion = new HashMap<Long, DocumentVersion>();
        for (DocumentVersion documentVersion : allDocumentVersions) {
            Long documentId = documentVersion.getDocumentId();
            Double uploaded = documentVersion.getUploaded();
            if (documentIdToMaxUploadedVersion.containsKey(documentId)) {
                DocumentVersion prevVersion = (DocumentVersion)documentIdToMaxUploadedVersion.get(documentId);
                Double prevUploaded = prevVersion.getUploaded();
                if (uploaded == null || !(uploaded > prevUploaded)) continue;
                documentIdToMaxUploadedVersion.put(documentId, documentVersion);
                continue;
            }
            documentIdToMaxUploadedVersion.put(documentId, documentVersion);
        }
        ArrayList documentVersionsBeforeReactivateRevise = new ArrayList();
        documentVersionsBeforeReactivateRevise.addAll(documentIdToMaxUploadedVersion.values());
        ArrayList<DocumentVersion> documentVersions = new ArrayList<DocumentVersion>();
        for (DocumentVersion documentVersion : documentVersionsBeforeReactivateRevise) {
            Long revisedDocumentVersionId;
            Long reactivatedDocumentVersionId = documentVersion.getReactivatedDocumentVersionId();
            if (reactivatedDocumentVersionId != null) {
                documentVersion = idToDocumentVersion.get(reactivatedDocumentVersionId);
            }
            if ((revisedDocumentVersionId = documentVersion.getRevisedDocumentVersionId()) != null) {
                DocumentVersion revisedDocumentVersion = idToDocumentVersion.get(revisedDocumentVersionId);
                DocumentVersionStatus versionStatus = DocumentVersionStatus.getByValue((Integer)documentVersion.getStatus());
                if (!(DocumentVersionHelper.isInvalidatedOrDeleted(revisedDocumentVersion) || versionStatus != DocumentVersionStatus.INREVIEW && versionStatus != DocumentVersionStatus.DELETED && versionStatus != DocumentVersionStatus.INVALIDATEDVERSION)) {
                    documentVersion = revisedDocumentVersion;
                }
            }
            documentVersions.add(documentVersion);
        }
        return documentVersions;
    }

    public int checkAndRestorePlannerEntryTasks(Long subProjectId, boolean checkAndRestore) {
        int countEt = 0;
        String personVariablesUserLocale = OdfHelper.getPersonVariablesUserLocaleByPrincipal(this.personVariablesDAO);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        ObjectListRelease objectListRelease = this.objectListReleaseDAO.getActiveBySubProject(subProjectId);
        List<DocumentReleaseContextJoin> contextJoins = this.documentReleaseDAO.getDocumentReleaseContextJoinsBySubProject(subProjectId);
        if (contextJoins.size() == 0) {
            return 0;
        }
        DocumentReleaseContextJoin someContextJoin = contextJoins.get(0);
        Long projectId = someContextJoin.getProjectId();
        Long localisationId = someContextJoin.getProjectLocalisationId();
        List<ProjectHoliday> projectHolidays = this.projectHolidayDAO.getByProject(projectId);
        for (DocumentReleaseContextJoin contextJoin : contextJoins) {
            BaseTask task;
            Long documentId = contextJoin.getDocumentId();
            boolean hasNonDeletedDocumentVersions = false;
            List<DocumentVersion> documentVersions = this.documentVersionDAO.getByDocument(documentId);
            for (DocumentVersion documentVersion : documentVersions) {
                if (DocumentVersionStatus.getByValue((Integer)documentVersion.getStatus()) == DocumentVersionStatus.DELETED) continue;
                hasNonDeletedDocumentVersions = true;
            }
            if (contextJoin.getObjectPlannerReleaseId() == null || contextJoin.getObjectPlannerReleasePlannerId() == null || contextJoin.getDocumentReleaseStartDate() == null || hasNonDeletedDocumentVersions) continue;
            Double docsStartDate = contextJoin.getDocumentReleaseStartDate();
            Long objectPlannerReleaseId = contextJoin.getObjectPlannerReleaseId();
            ProjectParticipant mainParticipant = this.projectParticipantDAO.getObjectPlannerReleasePlannerMainParticipant(objectPlannerReleaseId);
            OrganisationPersonJoin organisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(mainParticipant.getOrganisationPersonId());
            Long participationId = contextJoin.getObjectPlannerReleasePlannerId();
            ProjectParticipation participation = (ProjectParticipation)this.projectParticipationDAO.get(participationId);
            Long organisationId = participation.getOrganisationId();
            Organisation organisation = (Organisation)this.organisationDAO.get(organisationId);
            String plannerString = organisation.getName() + " (" + organisationPersonJoin.getPersonSurName() + " " + organisationPersonJoin.getPersonGivenName() + ")";
            String objectString = contextJoin.getObjectCode() + " [" + contextJoin.getObjectPlannerCode() + "]";
            DocumentRelease documentRelease = (DocumentRelease)this.documentReleaseDAO.get(contextJoin.getDocumentReleaseId());
            Document document = (Document)this.documentDAO.get(contextJoin.getDocumentId());
            ObjectPlannerRelease objectPlannerRelease = (ObjectPlannerRelease)this.objectPlannerReleaseDAO.get(contextJoin.getObjectPlannerReleaseId());
            Long reviewCycleInstanceReleasedId = objectPlannerRelease.getReviewCycleInstanceId();
            ReviewCycleInstanceReleased instanceReleased = reviewCycleInstanceReleasedId != null ? (ReviewCycleInstanceReleased)this.reviewCycleInstanceReleasedDAO.get(reviewCycleInstanceReleasedId) : null;
            ReviewCycleEntryTask reviewCycleEntryTask = this.reviewCycleEntryTaskDAO.getByDocument(documentId);
            BaseTask baseTask = task = reviewCycleEntryTask != null ? (BaseTask)this.taskDAO.get(reviewCycleEntryTask.getTaskId()) : null;
            if (reviewCycleEntryTask == null) {
                ++countEt;
                log.info("++++++++ " + (checkAndRestore ? "generating " : "generating (only checkmode) ") + "missing plannerEntryTask for planner " + plannerString + " in object " + objectString + " to document " + contextJoin.getDocumentName() + " (id=" + contextJoin.getDocumentReleaseId() + ") documentListId=" + contextJoin.getDocumentListReleaseId());
                if (!checkAndRestore) continue;
                WriteOnlyReviewTaskContext taskContext = new WriteOnlyReviewTaskContext();
                List<ProjectParticipation> projectRoleParticipations = this.projectParticipationDAO.getParticipationsByProjectAndRoleTypeAndAction(projectId, RoleTypeEnum.PROJECT_SURVEILLANT.getValue(), Action.MONITOR_LATE_REVIEWS.getName());
                Set<Long> projectRoleParticipationIds = ContainerHelper.getPersistentIdsSet(projectRoleParticipations);
                this.generateReviewCycleEntryTask(new DebugContext(), taskContext, null, projectHolidays, projectRoleParticipationIds, localisationId, objectPlannerRelease, instanceReleased, document, documentRelease);
                taskContext.commitAll(null, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO, this.taskDAO, this.documentTaskDAO, this.reviewCycleEntryTaskDAO);
                continue;
            }
            if (docsStartDate == null || task.getEndDate() == null || !(Math.abs(task.getEndDate() - docsStartDate) > 1.0E-9)) continue;
            log.info((checkAndRestore ? "updating " : "updating (only checkmode) ") + "different dates of plannerEntryTask for planner " + plannerString + " in object " + objectString + " to document " + contextJoin.getDocumentName() + " (id=" + contextJoin.getDocumentReleaseId() + ") documentListId=" + contextJoin.getDocumentListReleaseId() + ") docsStartDate=" + DateHelper.formatUtcSeconds(docsStartDate, "Europe/Vienna", resourceBundle.getString("yearToSecondFormat")) + " taskEndDate=" + DateHelper.formatUtcSeconds(task.getEndDate(), "Europe/Vienna", resourceBundle.getString("yearToSecondFormat")));
            if (!checkAndRestore) continue;
            WriteOnlyReviewTaskContext context = new WriteOnlyReviewTaskContext();
            this.updateDocumentTasksOfDocument(document, documentRelease, objectPlannerRelease, instanceReleased, localisationId, projectId, projectHolidays, context);
            context.commitAll(null, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO, this.taskDAO, this.documentTaskDAO, this.reviewCycleEntryTaskDAO);
        }
        if (countEt > 0) {
            log.info(countEt + " missing plannerEntryTask " + (checkAndRestore ? "restored!" : "!"));
        } else {
            log.info("no missing plannerTasks found");
        }
        return countEt;
    }

    private void updateDocumentTasksOfDocument(Document document, DocumentRelease documentRelease, ObjectPlannerRelease releasedObjectPlanner, ReviewCycleInstanceReleased reviewCycleInstanceReleased, Long projectLocalisationId, Long projectId, List<ProjectHoliday> projectHolidays, WriteOnlyTaskEmailContext taskContext) {
        boolean noObjectPlanner;
        Long unreleasedDocumentId = documentRelease.getDocumentId();
        List<EntryTaskJoin> entryTaskJoins = this.reviewCycleEntryTaskDAO.getEntryTaskJoinsByDocument(unreleasedDocumentId);
        HashMap<Long, EntryTaskJoin> idToReviewCycleEntryTaskJoin = new HashMap<Long, EntryTaskJoin>();
        for (EntryTaskJoin entryTaskJoin : entryTaskJoins) {
            if (entryTaskJoin.getDocumentTaskTaskId() == null) continue;
            if (log.isDebugEnabled()) {
                log.debug(".... Registering documentTask " + entryTaskJoin.getDocumentTaskTaskId() + " in map.");
            }
            idToReviewCycleEntryTaskJoin.put(entryTaskJoin.getDocumentTaskTaskId(), entryTaskJoin);
        }
        if (idToReviewCycleEntryTaskJoin.size() > 1) {
            throw new IllegalArgumentException("The old code called from at.cdes.controller.actionhandler.TaskOperationsImpl.updateDocumentTasksOfDocument(ReleasedDocument, ReleasedObjectList, Project) queries this using uniqueResult.");
        }
        EntryTaskJoin taskJoin = idToReviewCycleEntryTaskJoin.size() == 0 ? null : (EntryTaskJoin)idToReviewCycleEntryTaskJoin.values().iterator().next();
        BaseTask task = taskJoin != null ? taskJoin.getBaseTask() : null;
        DocumentTask documentTask = taskJoin != null ? taskJoin.getDocumentTask() : null;
        ReviewCycleEntryTask reviewCycleEntryTask = taskJoin != null ? taskJoin.getReviewCycleEntryTask() : null;
        boolean bl = noObjectPlanner = releasedObjectPlanner == null || releasedObjectPlanner.getPlannerId() == null;
        if (log.isDebugEnabled()) {
            log.debug(".... noObjectPlanner = " + noObjectPlanner + "; documentTask = " + (documentTask != null ? documentTask.getTaskId() : "null"));
        }
        List<ProjectParticipation> projectRoleParticipations = this.projectParticipationDAO.getParticipationsByProjectAndRoleTypeAndAction(projectId, RoleTypeEnum.PROJECT_SURVEILLANT.getValue(), Action.MONITOR_LATE_REVIEWS.getName());
        HashSet<Long> projectRoleParticipationIds = new HashSet<Long>();
        for (ProjectParticipation projectRoleParticipation : projectRoleParticipations) {
            projectRoleParticipationIds.add(projectRoleParticipation.getId());
        }
        if (!noObjectPlanner && documentTask == null) {
            if (document.getStartDate() != null && !document.isHasDocumentVersions().booleanValue()) {
                if (log.isDebugEnabled()) {
                    log.debug(".... Will generate ReviewCycleEntryTask for relObjectPlanner " + releasedObjectPlanner.getId() + ", document " + document.getId());
                }
                this.generateReviewCycleEntryTask(new DebugContext(), taskContext, null, projectHolidays, projectRoleParticipationIds, projectLocalisationId, releasedObjectPlanner, reviewCycleInstanceReleased, document, documentRelease);
            }
        } else if (documentTask != null) {
            if (log.isDebugEnabled()) {
                log.debug(".... Case documentTask != null; taskId = " + documentTask.getTaskId());
            }
            if (document.getStartDate() == null || noObjectPlanner) {
                if (log.isDebugEnabled()) {
                    log.debug(".... Case startDate == null OR noObjectPlanner");
                }
                for (EntryTaskJoin entryTaskJoin : entryTaskJoins) {
                    if (entryTaskJoin.getReviewCycleEntryTaskTaskId() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug(".... Scheduling reviewCycleEntryTask " + entryTaskJoin.getReviewCycleEntryTaskTaskId() + " for deletion.");
                        }
                        taskContext.registerReviewCycleEntryTaskForDelete(entryTaskJoin.getReviewCycleEntryTask());
                        taskContext.registerDocumentTaskForDelete(entryTaskJoin.getDocumentTask());
                        taskContext.registerTaskForDelete(entryTaskJoin.getBaseTask());
                    }
                    if (entryTaskJoin.getTaskEmailSnippetEmailSnippetId() != null) {
                        if (log.isDebugEnabled()) {
                            log.debug(".... Scheduling taskEmailSnippet " + entryTaskJoin.getTaskEmailSnippetEmailSnippetId() + " for deletion");
                        }
                        taskContext.registerTaskEmailSnippetForDelete(entryTaskJoin.getTaskEmailSnippet());
                    }
                    if (entryTaskJoin.getFutureEmailId() == null) continue;
                    if (log.isDebugEnabled()) {
                        log.debug(".... Scheduling futureEmail " + entryTaskJoin.getFutureEmailId() + " for deletion");
                    }
                    taskContext.registerFutureEmailForDelete(entryTaskJoin.getFutureEmail());
                }
            } else {
                this.generateTaskDeadlines(projectHolidays, task, documentTask, reviewCycleEntryTask, documentRelease, reviewCycleInstanceReleased.getDuration(), reviewCycleInstanceReleased.getDurationPre());
                if (log.isDebugEnabled()) {
                    log.debug(".... Will update reviewCycleEntryTask " + reviewCycleEntryTask.getTaskId());
                }
                taskContext.registerTaskForUpdate(task);
                taskContext.registerReviewCycleEntryTaskForUpdate(reviewCycleEntryTask);
                List<FutureEmail> existingFutureEmails = this.futureEmailDAO.getByTask(documentTask.getTaskId());
                this.generateTaskEmailSnippets(new DebugContext(), taskContext, existingFutureEmails, projectHolidays, releasedObjectPlanner.getPlannerId(), task, TaskEmailSnippetType.TYPE_TASK_RESCHEDULED);
                if (futureEmailLog.isDebugEnabled()) {
                    futureEmailLog.debug("updateDocumentTasksOfDocument will call generateTaskLateFutureEmail");
                }
                this.generateTaskLateFutureEMail(new DebugContext(), taskContext, projectHolidays, projectRoleParticipationIds, task);
            }
        }
    }

    private class ReviewTasksStrategy
    implements GenerateReviewTasksStrategy {
        private ReviewTask reviewTask;

        private ReviewTasksStrategy() {
        }

        @Override
        public void initialize() {
            this.reviewTask = new ReviewTask();
        }

        @Override
        public boolean withNodePositionReleaseds() {
            return true;
        }

        @Override
        public List<GenReviewTaskPositionJoin> fetchPositionJoins(Long documentVersionId, Long reviewCycleNodeInstanceReleasedId, Long reviewCycleNodeResultId) {
            return TaskUtils.this.reviewTaskDAO.getReviewTaskPositionJoins(documentVersionId, reviewCycleNodeInstanceReleasedId, reviewCycleNodeResultId, null);
        }

        @Override
        public void setReviewTaskData(String realmDescription, Long reviewCycleNodeInstanceId, Boolean sampleControlReview) {
            this.reviewTask.setRealmDescription(realmDescription);
            this.reviewTask.setReviewCycleNodeInstanceId(reviewCycleNodeInstanceId);
            this.reviewTask.setSampleControlReview(sampleControlReview);
            this.reviewTask.setTaskStatus(Integer.valueOf(0));
        }

        @Override
        public void setReviewTaskTaskId(Long taskId) {
            this.reviewTask.setTaskId(taskId);
        }

        @Override
        public void saveReviewTask(DebugContext debugContext) {
            this.reviewTask = (ReviewTask)TaskUtils.this.reviewTaskDAO.save(this.reviewTask);
            debugContext.addSaveReviewTaskMessage(this.reviewTask);
        }
    }

    private static interface GenerateReviewTasksStrategy {
        public void initialize();

        public boolean withNodePositionReleaseds();

        public List<GenReviewTaskPositionJoin> fetchPositionJoins(Long var1, Long var2, Long var3);

        public void setReviewTaskData(String var1, Long var2, Boolean var3);

        public void setReviewTaskTaskId(Long var1);

        public void saveReviewTask(DebugContext var1);
    }

    private class AttachedReviewTasksStrategy
    implements GenerateReviewTasksStrategy {
        private AttachedReviewTask attachedReviewTask;

        private AttachedReviewTasksStrategy() {
        }

        @Override
        public void initialize() {
            this.attachedReviewTask = new AttachedReviewTask();
        }

        @Override
        public boolean withNodePositionReleaseds() {
            return false;
        }

        @Override
        public List<GenReviewTaskPositionJoin> fetchPositionJoins(Long documentVersionId, Long reviewCycleNodeInstanceReleasedId, Long reviewCycleNodeResultId) {
            return TaskUtils.this.reviewTaskDAO.getAttachedReviewTaskPositionJoins(documentVersionId, reviewCycleNodeInstanceReleasedId, reviewCycleNodeResultId);
        }

        @Override
        public void setReviewTaskData(String realmDescription, Long reviewCycleNodeInstanceId, Boolean sampleControlReview) {
            this.attachedReviewTask.setRealmDescription(realmDescription);
            this.attachedReviewTask.setReviewCycleNodeInstanceId(reviewCycleNodeInstanceId);
            this.attachedReviewTask.setSampleControlReview(sampleControlReview);
            this.attachedReviewTask.setTaskStatus(Integer.valueOf(0));
        }

        @Override
        public void setReviewTaskTaskId(Long taskId) {
            this.attachedReviewTask.setTaskId(taskId);
        }

        @Override
        public void saveReviewTask(DebugContext debugContext) {
            this.attachedReviewTask = (AttachedReviewTask)TaskUtils.this.attachedReviewTaskDAO.save(this.attachedReviewTask);
            debugContext.addSaveAttachedReviewTaskMessage(this.attachedReviewTask);
        }
    }

    private class GenerateTaskReminderFutureEmailContext
    implements GenerateTaskEmailSnippetsContext {
        private List<ProjectHoliday> projectHolidays;
        private List<FutureEmail> newFutureEmails = new ArrayList<FutureEmail>();
        private List<Long> futureEmailIdsToDelete = new ArrayList<Long>();

        public GenerateTaskReminderFutureEmailContext(Long projectId) {
            this.projectHolidays = TaskUtils.this.projectHolidayDAO.getByProject(projectId);
        }

        @Override
        public List<ProjectHoliday> getAllProjectHolidays() {
            return this.projectHolidays;
        }

        @Override
        public List<FutureEmail> getFutureEmailsForTask(Long taskId) {
            return TaskUtils.this.futureEmailDAO.getByTask(taskId);
        }

        @Override
        public void registerNewFutureEmail(FutureEmail futureEmail, BaseTask refTask) {
            this.newFutureEmails.add(futureEmail);
        }

        @Override
        public void registerNewTaskEmailSnippet(EmailSnippet emailSnippet, TaskEmailSnippet taskEmailSnippet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void registerFutureEmailForDelete(FutureEmail futureEmail) {
            this.futureEmailIdsToDelete.add(futureEmail.getId());
        }

        @Override
        public void registerFutureEmailsForDelete(ObjectCriteria<FutureEmail> criteria) {
            throw new UnsupportedOperationException();
        }

        public Collection<ProjectParticipation> getAllProjectRoleParticipations() {
            throw new UnsupportedOperationException();
        }

        public void commit(DebugContext debugContext) {
            if (this.newFutureEmails.size() > 0) {
                this.newFutureEmails = TaskUtils.this.futureEmailDAO.saveBatch(this.newFutureEmails);
                for (FutureEmail futureEmail : this.newFutureEmails) {
                    debugContext.addSaveFutureEmailMessage(futureEmail);
                }
            }
            if (this.futureEmailIdsToDelete.size() > 0) {
                TaskUtils.this.futureEmailDAO.deleteBatch(this.futureEmailIdsToDelete);
                for (Long id : this.futureEmailIdsToDelete) {
                    debugContext.addDeleteFutureEmailMessage(id);
                }
            }
        }
    }
}

