/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DocumentVersionTask;
import at.cdes.impl.dao.DocumentVersionTaskDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcDocumentVersionTaskDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.util.Collection;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcDocumentVersionTaskDAO
extends AbstractJdbcDocumentVersionTaskDAO
implements DocumentVersionTaskDAO {
    @Override
    public List<DocumentVersionTask> getPlotTasksByParticipationId(Long projectParticipationId) {
        String sql = "SELECT " + JdbcDocumentVersionTaskDAO.getSelectClauseForDto() + "FROM document_version_task JOIN review_cycle_plott_task  ON document_version_task.task_id = review_cycle_plott_task.task_id WHERE document_version_task.project_participation_id = ? UNION ALL SELECT " + JdbcDocumentVersionTaskDAO.getSelectClauseForDto() + "FROM document_version_task JOIN plot_order_acceptance_task ON document_version_task.task_id = plot_order_acceptance_task.task_id WHERE document_version_task.project_participation_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectParticipationId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectParticipationId);
        });
    }

    @Override
    public List<DocumentVersionTask> getPlotOrderAcceptanceTasks(Long plotOrderId, Collection<Long> projectParticipationIds) {
        String sql = "SELECT " + JdbcDocumentVersionTaskDAO.getSelectClauseForDto() + "FROM plott_order plot_order JOIN plot_order_acceptance_task ON plot_order_acceptance_task.order_id = plot_order.id JOIN document_version_task      ON document_version_task.task_id = plot_order_acceptance_task.task_id JOIN task                       ON document_version_task.task_id = task.id WHERE plot_order.id = ? ";
        if (projectParticipationIds != null) {
            sql = sql + "AND document_version_task.project_participation_id IN (" + QueryHelper.getPlaceHolderSequence(projectParticipationIds.size()) + ") ";
        }
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)plotOrderId);
            if (projectParticipationIds != null) {
                for (Long projectParticipationId : projectParticipationIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectParticipationId);
                }
            }
        });
    }
}

