/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Job;
import at.cdes.api.job.core.JobSearchModel;
import at.cdes.api.joinDto.JobJoin;
import at.cdes.api.voc.job.JobState;
import at.cdes.api.voc.job.JobType;
import at.cdes.impl.dao.JobDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcJobDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcJobDAO
extends AbstractJdbcJobDAO
implements JobDAO {
    @Override
    public List<Job> getByTypeAndState(final JobType jobType, final JobState jobState) {
        String sql = "SELECT " + JdbcJobDAO.getSelectClauseForDto() + "FROM job WHERE job.type = ? AND job.state = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Job>>(){

            public List<Job> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)jobType.getValue());
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)jobState.getValue());
                ResultSet rs = statement.executeQuery();
                ArrayList<Job> ret = new ArrayList<Job>();
                while (rs.next()) {
                    Job job = JdbcJobDAO.fillJobFromResultSet(rs);
                    ret.add(job);
                }
                return ret;
            }
        });
    }

    @Override
    public JobJoin getById(final Long jobId) {
        String sql = "SELECT " + JdbcJobDAO.getJobJoinSelectClause() + "FROM (((((      job LEFT JOIN organisation_person ON job.organisation_person_id = organisation_person.id) LEFT JOIN person              ON organisation_person.person_id = person.id) LEFT JOIN network             ON job.network_id = network.id) LEFT JOIN project             ON job.project_id = project.id) LEFT JOIN trx create_trx      ON job.create_trx = create_trx.id) WHERE job.id = ? ";
        return (JobJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<JobJoin>(){

            public JobJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)jobId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    return JdbcJobDAO.fillJobJoinFromResultSet(rs);
                }
                return null;
            }
        });
    }

    @Override
    public List<JobJoin> getBySearchModel(final JobSearchModel searchModel) {
        String sql = "SELECT " + JdbcJobDAO.getJobJoinSelectClause() + "FROM (((((       job LEFT JOIN organisation_person ON job.organisation_person_id = organisation_person.id) LEFT JOIN person              ON organisation_person.person_id = person.id) LEFT JOIN network             ON job.network_id = network.id) LEFT JOIN project             ON job.project_id = project.id) LEFT JOIN trx create_trx      ON job.create_trx = create_trx.id) WHERE 1=1 ";
        if (searchModel.getNetworkId() != null) {
            sql = sql + "AND job.network_id = ? ";
        }
        if (searchModel.getOrganisationPersonId() != null) {
            sql = sql + "AND job.organisation_person_id = ? ";
        }
        sql = sql + "AND (0 = 1 ";
        if (searchModel.getIncludeFailed() != null && searchModel.getIncludeFailed().booleanValue()) {
            sql = sql + "OR job.state = ? ";
        }
        if (searchModel.getIncludeFinished() != null && searchModel.getIncludeFinished().booleanValue()) {
            sql = sql + "OR job.state = ? ";
        }
        if (searchModel.getIncludeInterrupted() != null && searchModel.getIncludeInterrupted().booleanValue()) {
            sql = sql + "OR job.state = ? ";
        }
        if (searchModel.getIncludeScheduled() != null && searchModel.getIncludeScheduled().booleanValue()) {
            sql = sql + "OR job.state = ? ";
        }
        if (searchModel.getIncludeStarted() != null && searchModel.getIncludeStarted().booleanValue()) {
            sql = sql + "OR job.state = ? ";
        }
        sql = sql + ") ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<JobJoin>>(){

            public List<JobJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (searchModel.getNetworkId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getNetworkId());
                }
                if (searchModel.getOrganisationPersonId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getOrganisationPersonId());
                }
                if (searchModel.getIncludeFailed() != null && searchModel.getIncludeFailed().booleanValue()) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)JobState.FAILED.getValue());
                }
                if (searchModel.getIncludeFinished() != null && searchModel.getIncludeFinished().booleanValue()) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)JobState.FINISHED.getValue());
                }
                if (searchModel.getIncludeInterrupted() != null && searchModel.getIncludeInterrupted().booleanValue()) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)JobState.INTERRUPTED.getValue());
                }
                if (searchModel.getIncludeScheduled() != null && searchModel.getIncludeScheduled().booleanValue()) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)JobState.SCHEDULED.getValue());
                }
                if (searchModel.getIncludeStarted() != null && searchModel.getIncludeStarted().booleanValue()) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)JobState.STARTED.getValue());
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<JobJoin> ret = new ArrayList<JobJoin>();
                while (rs.next()) {
                    JobJoin jobJoin = JdbcJobDAO.fillJobJoinFromResultSet(rs);
                    ret.add(jobJoin);
                }
                return ret;
            }
        });
    }
}

