/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.imp;

import at.cdes.api.compositeDto.ImportDocument;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.joinDto.ObjectPlannerWithObject;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.DocumentNumberPartDAO;
import at.cdes.impl.dao.DocumentTypeDAO;
import at.cdes.impl.dao.ObjectPlannerDAO;
import at.cdes.impl.dao.ObjectPlannerReleaseDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.document.DocumentNumberCalculator;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.i18n.I18nHelper;
import java.io.BufferedReader;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TimeZone;
import org.clazzes.util.datetime.UtcTimestamp;
import org.clazzes.util.sched.impl.HasLoggingCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewDocumentCsvCallable
extends HasLoggingCallable<List<ImportDocument>> {
    private static final Logger log = LoggerFactory.getLogger(NewDocumentCsvCallable.class);
    private static final String SEPARATOR = ";";
    private static final String TIMEZONE = "Europe/Vienna";
    private byte[] data;
    private Long subProjectId;
    private Long orgPersonId;
    private DocumentTypeDAO documentTypeDAO;
    private DocumentNumberPartDAO documentNumberPartDAO;
    private ProjectDAO projectDAO;
    private ObjectPlannerReleaseDAO objectPlannerReleaseDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private ActionDAO actionDAO;

    public NewDocumentCsvCallable(byte[] data, Long subProjectId, Long orgPersonId, DocumentTypeDAO documentTypeDAO, ProjectDAO projectDAO, DocumentNumberPartDAO documentNumberPartDAO, ObjectPlannerReleaseDAO objectPlannerReleaseDAO, ObjectPlannerDAO objectPlannerDAO, ActionDAO actionDAO) {
        this.data = data;
        this.subProjectId = subProjectId;
        this.orgPersonId = orgPersonId;
        this.documentTypeDAO = documentTypeDAO;
        this.documentNumberPartDAO = documentNumberPartDAO;
        this.projectDAO = projectDAO;
        this.objectPlannerReleaseDAO = objectPlannerReleaseDAO;
        this.objectPlannerDAO = objectPlannerDAO;
        this.actionDAO = actionDAO;
    }

    private static Double getDate(String fullDateString, String timeZone) {
        if (fullDateString == null) {
            return null;
        }
        try {
            String[] tokens = fullDateString.split("\\.");
            String dateString = tokens[0];
            String monthString = tokens[1];
            String yearString = tokens[2];
            int date = Integer.parseInt(dateString);
            int month = Integer.parseInt(monthString);
            int year = Integer.parseInt(yearString);
            UtcTimestamp utcTimestamp = new UtcTimestamp();
            utcTimestamp.setDateTime(year, month, date, 0, TimeZone.getTimeZone(timeZone));
            return new Double((double)utcTimestamp.getUtcMillis().longValue() / 1000.0);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Date could not be parsed: [" + fullDateString + "]");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public List<ImportDocument> call() throws Exception {
        String line;
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        ArrayList<ImportDocument> importDocuments = new ArrayList<ImportDocument>();
        String content = this.data.length > 3 && this.data[0] == -17 && this.data[1] == -69 && this.data[2] == -65 ? new String(this.data, 3, this.data.length - 3, "UTF-8") : new String(this.data, "CP1252");
        ArrayList<String> lines = new ArrayList<String>();
        StringReader reader = new StringReader(content);
        BufferedReader bufferedReader = new BufferedReader(reader);
        while ((line = bufferedReader.readLine()) != null) {
            lines.add(line);
        }
        if (lines.size() == 0) {
            importDocuments.add(ImportDocument.constructError((Integer)1, (String)resourceBundle.getString("newDocumentCsvImportNoHeaderError")));
            return importDocuments;
        }
        int documentTypeIndex = -1;
        int numberIndex = -1;
        int partIndex = -1;
        int titleIndex = -1;
        int titleTranslationIndex = -1;
        int scaleIndex = -1;
        int startIndex = -1;
        int endIndex = -1;
        int commentIndex = -1;
        int objectCodeIndex = -1;
        int objectPlannerCodeIndex = -1;
        String headerLine = (String)lines.get(0);
        String[] headerTokens = headerLine.split(SEPARATOR);
        for (int n = 0; n < headerTokens.length; ++n) {
            String headerToken = headerTokens[n].trim();
            if ("$DTYPE".equals(headerToken)) {
                documentTypeIndex = n;
                continue;
            }
            if ("$NUMBER".equals(headerToken)) {
                numberIndex = n;
                continue;
            }
            if ("$PART".equals(headerToken)) {
                partIndex = n;
                continue;
            }
            if ("$TITLE".equals(headerToken)) {
                titleIndex = n;
                continue;
            }
            if ("$TITLE_TRANSLATION".equals(headerToken)) {
                titleTranslationIndex = n;
                continue;
            }
            if ("$SCALE".equals(headerToken)) {
                scaleIndex = n;
                continue;
            }
            if ("$START".equals(headerToken)) {
                startIndex = n;
                continue;
            }
            if ("$END".equals(headerToken)) {
                endIndex = n;
                continue;
            }
            if ("$COMM".equals(headerToken)) {
                commentIndex = n;
                continue;
            }
            if ("$OBJCODE".equals(headerToken)) {
                objectCodeIndex = n;
                continue;
            }
            if (!"$OBJPLANNERCODE".equals(headerToken)) {
                String message = MessageFormat.format(resourceBundle.getString("newDocumentCsvImportIllegalHeaderToken"), headerToken);
                importDocuments.add(ImportDocument.constructError((Integer)1, (String)message));
                return importDocuments;
            }
            objectPlannerCodeIndex = n;
        }
        Long projectId = this.projectDAO.getBySubProject(this.subProjectId).getId();
        String documentTypeCodeFormat = null;
        List<DocumentNumberPart> documentNumberParts = this.documentNumberPartDAO.getDocumentNumberPartsForProject(projectId);
        for (DocumentNumberPart documentNumberPart : documentNumberParts) {
            if (!documentNumberPart.getOgnlRule().contains("documentType.code")) continue;
            documentTypeCodeFormat = documentNumberPart.getFormat();
        }
        List<DocumentType> documentTypes = this.documentTypeDAO.getBySubProject(this.subProjectId);
        log.info("processing codeToDocumentTypes: size= " + documentTypes.size() + " for subProjectId= " + this.subProjectId);
        HashMap<String, DocumentType> codeToDocumentType = new HashMap<String, DocumentType>();
        for (DocumentType documentType : documentTypes) {
            codeToDocumentType.put(documentType.getCode(), documentType);
        }
        List<ObjectPlannerRelease> objectPlannerRelease = this.objectPlannerReleaseDAO.getActiveBySubProject(this.subProjectId);
        Map<Long, Set<Action>> objectPlannerToActions = this.actionDAO.getObjectPlannerActionsForSubProject(this.orgPersonId, this.subProjectId, Action.EDIT_PLAN_DELIVER_CATALOGUE, Action.EDIT_PLAN_DELIVER_CATALOGUE_DATES, Action.EDIT_PLAN_DELIVER_CATALOGUE_START_DATE, Action.EDIT_PLAN_DELIVER_CATALOGUE_END_DATE);
        List<ObjectPlannerWithObject> candidates = this.objectPlannerDAO.getObjectPlannersBySubProject(this.subProjectId);
        HashMap<Long, ObjectPlannerWithObject> objectPlannerIdToJoinDto = new HashMap<Long, ObjectPlannerWithObject>();
        HashMap<String, Long> objectObjectPlannerCodeToOplId = new HashMap<String, Long>();
        for (ObjectPlannerWithObject candidate : candidates) {
            Long candidateId = candidate.getObjectPlannerId();
            if (objectPlannerIdToJoinDto.containsKey(candidateId) || !objectPlannerToActions.containsKey(candidateId) || !objectPlannerToActions.get(candidateId).contains(Action.EDIT_PLAN_DELIVER_CATALOGUE) || candidate.getObjectPlannerInactive() != null && candidate.getObjectPlannerInactive().booleanValue()) continue;
            candidate.setDocumentNull();
            objectPlannerIdToJoinDto.put(candidateId, candidate);
            objectObjectPlannerCodeToOplId.put(candidate.getObjectReleaseCode() + (candidate.getObjectTypeRelCode() != null ? candidate.getObjectTypeRelCode() : "") + "-" + candidate.getObjectPlannerReleaseCode(), candidateId);
        }
        int n = 1;
        while (true) {
            block36: {
                Document document;
                String objectPlannerCode;
                String comment;
                ImportDocument importDocument;
                block38: {
                    String objectCode;
                    String numberCode;
                    block39: {
                        String message;
                        block40: {
                            String end;
                            String start;
                            String scale;
                            String titleTranslation;
                            String title;
                            String partCode;
                            block37: {
                                block34: {
                                    DocumentType documentType;
                                    block35: {
                                        Object code2;
                                        if (n >= lines.size()) {
                                            return importDocuments;
                                        }
                                        importDocument = new ImportDocument();
                                        String line2 = (String)lines.get(n);
                                        String[] lineTokens = line2.split(SEPARATOR);
                                        String documentTypeCode = null;
                                        if (documentTypeIndex != -1 && documentTypeIndex < lineTokens.length) {
                                            documentTypeCode = lineTokens[documentTypeIndex];
                                            if (documentTypeCodeFormat != null && documentTypeCodeFormat.length() > 0) {
                                                documentTypeCode = DocumentNumberCalculator.format(documentTypeCodeFormat, documentTypeCode);
                                            }
                                        }
                                        numberCode = numberIndex != -1 && numberIndex < lineTokens.length ? lineTokens[numberIndex] : null;
                                        partCode = partIndex != -1 && partIndex < lineTokens.length ? lineTokens[partIndex] : null;
                                        title = titleIndex != -1 && titleIndex < lineTokens.length ? lineTokens[titleIndex] : null;
                                        titleTranslation = titleTranslationIndex != -1 && titleTranslationIndex < lineTokens.length ? lineTokens[titleTranslationIndex] : null;
                                        scale = scaleIndex != -1 && scaleIndex < lineTokens.length ? lineTokens[scaleIndex] : null;
                                        start = startIndex != -1 && startIndex < lineTokens.length ? lineTokens[startIndex] : null;
                                        end = endIndex != -1 && endIndex < lineTokens.length ? lineTokens[endIndex] : null;
                                        comment = commentIndex != -1 && commentIndex < lineTokens.length ? lineTokens[commentIndex] : null;
                                        objectCode = objectCodeIndex != -1 && objectCodeIndex < lineTokens.length ? lineTokens[objectCodeIndex] : null;
                                        objectPlannerCode = objectPlannerCodeIndex != -1 && objectPlannerCodeIndex < lineTokens.length ? lineTokens[objectPlannerCodeIndex] : null;
                                        document = new Document();
                                        if (documentTypeCode == null) break block34;
                                        documentType = (DocumentType)codeToDocumentType.get(documentTypeCode);
                                        if (documentType != null) break block35;
                                        ArrayList<String> documentTypeList = new ArrayList<String>();
                                        for (Object code2 : codeToDocumentType.keySet()) {
                                            documentTypeList.add((String)code2);
                                        }
                                        Collections.sort(documentTypeList);
                                        String legalDocumentTypes = "";
                                        code2 = documentTypeList.iterator();
                                        while (code2.hasNext()) {
                                            String legalDocumentType = (String)code2.next();
                                            legalDocumentTypes = legalDocumentTypes + legalDocumentType + " ";
                                        }
                                        message = MessageFormat.format(resourceBundle.getString("newDocumentCsvImportUnknownDocumentType"), "'" + numberCode + "'", "'" + documentTypeCode + "'", "'" + legalDocumentTypes + "'");
                                        importDocuments.add(ImportDocument.constructError((Integer)(n + 1), (String)message));
                                        break block36;
                                    }
                                    document.setDocumentTypeId(documentType.getId());
                                    break block37;
                                }
                                document.setDocumentTypeId(null);
                            }
                            if (numberCode != null) {
                                Integer number = Integer.parseInt(numberCode);
                                document.setNumber(number);
                            } else {
                                document.setNumber(null);
                            }
                            if (partCode != null && partCode.length() > 0) {
                                Integer part = Integer.parseInt(partCode);
                                document.setPart(part);
                            } else {
                                document.setPart(null);
                            }
                            List<String> contentLocales = I18nHelper.getContentLocalesByProject(this.projectDAO, projectId);
                            if (titleTranslation != null && titleTranslation.length() > 0) {
                                String l1 = contentLocales.get(0);
                                String l2 = contentLocales.get(1);
                                String jsContentString = "{\"" + l1 + "\":\"" + title + "\",\"" + l2 + "\":\"" + titleTranslation + "\"}";
                                document.setContent(jsContentString);
                            } else {
                                document.setContent(title);
                            }
                            document.setScale(scale);
                            if (start != null && start.length() > 0) {
                                Double startDate = NewDocumentCsvCallable.getDate(start, TIMEZONE);
                                document.setStartDate(startDate);
                            } else {
                                document.setStartDate(null);
                            }
                            if (end != null && end.length() > 0) {
                                Double endDate = NewDocumentCsvCallable.getDate(end, TIMEZONE);
                                document.setEndDate(endDate);
                            } else {
                                document.setEndDate(null);
                            }
                            document.setObjectPlannerId(null);
                            if (objectPlannerCode == null && objectCode == null) break block38;
                            Long oplIdImpobjectPlanner = null;
                            oplIdImpobjectPlanner = (Long)objectObjectPlannerCodeToOplId.get(objectCode + "-" + objectPlannerCode);
                            if (oplIdImpobjectPlanner == null) break block39;
                            ObjectPlannerWithObject objectPlannerObject = (ObjectPlannerWithObject)objectPlannerIdToJoinDto.get(oplIdImpobjectPlanner);
                            if (objectPlannerObject.getObjectPlannerReleaseReviewCycleInstanceId() == null) break block40;
                            document.setObjectPlannerId(oplIdImpobjectPlanner);
                            break block38;
                        }
                        message = MessageFormat.format(resourceBundle.getString("newDocumentCsvImportUnknownReviewCycle"), "'" + numberCode + "'", "'" + objectCode + "-" + objectPlannerCode + "'");
                        importDocuments.add(ImportDocument.constructError((Integer)(n + 1), (String)message));
                        break block36;
                    }
                    String message = MessageFormat.format(resourceBundle.getString("newDocumentCsvImportUnknownObjectPlanner"), "'" + numberCode + "'", "'" + objectCode + "-" + objectPlannerCode + "'");
                    importDocuments.add(ImportDocument.constructError((Integer)(n + 1), (String)message));
                    break block36;
                }
                document.setComment(comment);
                importDocument.setDocument(document);
                importDocument.setError(Boolean.valueOf(false));
                importDocument.setLineNumber(Integer.valueOf(n));
                importDocument.setMessage(null);
                if (objectPlannerCode == null || document.getObjectPlannerId() != null) {
                    importDocuments.add(importDocument);
                }
            }
            ++n;
        }
    }
}

