/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.certificate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.Key;
import java.security.KeyPair;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.generators.OpenSSLPBEParametersGenerator;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openssl.PEMDecryptor;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMException;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyHelper {
    private static Logger log = LoggerFactory.getLogger(KeyHelper.class);

    public static KeyPair decryptKeyLegacy(Object o, String password) throws IOException {
        LegacyPEMDecryptorProvider decProv = new LegacyPEMDecryptorProvider(password.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        return converter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair((PEMDecryptorProvider)decProv));
    }

    public static KeyPair decryptKey(Object o, String password) throws IOException {
        PEMDecryptorProvider decProv = new JcePEMDecryptorProviderBuilder().build(password.toCharArray());
        JcaPEMKeyConverter converter = new JcaPEMKeyConverter().setProvider("BC");
        return converter.getKeyPair(((PEMEncryptedKeyPair)o).decryptKeyPair(decProv));
    }

    public static KeyPair openKeyPair(byte[] pemString, String password) throws IOException {
        try (PEMParser pr = null;){
            pr = new PEMParser((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(pemString), "US-ASCII"));
            Object o = pr.readObject();
            KeyPair rootCaKeyPair = KeyHelper.decryptKey(o, password);
            if (rootCaKeyPair == null) {
                throw new IOException();
            }
            KeyPair keyPair = rootCaKeyPair;
            return keyPair;
        }
    }

    private static class LegacyPEMDecryptorProvider
    implements PEMDecryptorProvider {
        private final char[] password;

        public LegacyPEMDecryptorProvider(char[] password) {
            this.password = password;
        }

        public PEMDecryptor get(String dekAlgName) throws OperatorCreationException {
            int maxSaltLength;
            int keyLen;
            String alg;
            if (dekAlgName.startsWith("DES-EDE3")) {
                alg = "DESede/CBC/PKCS5Padding";
                keyLen = 24;
                maxSaltLength = Integer.MAX_VALUE;
            } else if (dekAlgName.startsWith("AES-256")) {
                alg = "AES/CBC/PKCS5Padding";
                keyLen = 32;
                maxSaltLength = 8;
            } else {
                throw new OperatorCreationException("unknown encryption [" + dekAlgName + "] with legacy private key");
            }
            return new PEMDecryptor(){

                public byte[] decrypt(byte[] data, byte[] iv) throws PEMException {
                    byte[] salt = iv;
                    if (salt.length > maxSaltLength) {
                        salt = new byte[8];
                        System.arraycopy(iv, 0, salt, 0, maxSaltLength);
                    }
                    OpenSSLPBEParametersGenerator pGen = new OpenSSLPBEParametersGenerator();
                    pGen.init(Strings.toByteArray((char[])password), salt);
                    SecretKeySpec kSpec = new SecretKeySpec(((KeyParameter)pGen.generateDerivedParameters(keyLen * 8)).getKey(), "OpenSSLPBKDF");
                    IvParameterSpec paramSpec = new IvParameterSpec(iv);
                    try {
                        Cipher cipher = Cipher.getInstance(alg, "BC");
                        cipher.init(2, (Key)kSpec, paramSpec);
                        return cipher.doFinal(data);
                    }
                    catch (Exception e) {
                        throw new PEMException("Unable to decrypt symmetrically encrypted PEM content", e);
                    }
                }
            };
        }
    }
}

