/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.BaseTask;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentTask;
import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.impl.dao.GenDocumentTaskDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcDocumentTaskDAO
extends AbstrIdDAO<DocumentTask>
implements GenDocumentTaskDAO {
    public AbstractJdbcDocumentTaskDAO() {
        super(DocumentTask.class, "taskId", "document_task", new String[]{"task_id", "object_planner_id", "project_participation_id", "document_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcDocumentTaskDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "task_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_planner_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participation_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcDocumentTaskDAO.getSelectClauseForDto("document_task", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcDocumentTaskDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".task_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "task_id") + "," + entityLocalName + ".object_planner_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "object_planner_id") + "," + entityLocalName + ".project_participation_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_participation_id") + "," + entityLocalName + ".document_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "document_id") + " ";
    }

    protected DocumentTask fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        DocumentTask documentTask = new DocumentTask();
        documentTask.setTaskId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentTask.setObjectPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentTask.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        documentTask.setDocumentId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return documentTask;
    }

    public static DocumentTask fillDocumentTaskFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        DocumentTask documentTask = new DocumentTask();
        documentTask.setTaskId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentTask.setObjectPlannerId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentTask.setProjectParticipationId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        documentTask.setDocumentId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return documentTask;
    }

    public static DocumentTask fillDocumentTaskFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcDocumentTaskDAO.fillDocumentTaskFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 4;
    }

    public int update(DocumentTask dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<DocumentTask> dtos) {
        Iterator<DocumentTask> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, DocumentTask documentTask) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentTask.getTaskId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)documentTask.getObjectPlannerId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)documentTask.getProjectParticipationId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)4, (Number)documentTask.getDocumentId());
    }

    @Override
    public List<DocumentTask> getByTask(BaseTask baseTask) {
        return this.getByTask(baseTask.getId());
    }

    @Override
    public List<DocumentTask> getByTask(final Long baseTaskId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"task_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, baseTaskId);
            }
        });
    }

    @Override
    public List<DocumentTask> getByObjectPlanner(ObjectPlanner objectPlanner) {
        return this.getByObjectPlanner(objectPlanner.getId());
    }

    @Override
    public List<DocumentTask> getByObjectPlanner(final Long objectPlannerId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_planner_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, objectPlannerId);
            }
        });
    }

    @Override
    public List<DocumentTask> getByProjectParticipation(ProjectParticipation projectParticipation) {
        return this.getByProjectParticipation(projectParticipation.getId());
    }

    @Override
    public List<DocumentTask> getByProjectParticipation(final Long projectParticipationId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participation_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectParticipationId);
            }
        });
    }

    @Override
    public List<DocumentTask> getByDocument(Document document) {
        return this.getByDocument(document.getId());
    }

    @Override
    public List<DocumentTask> getByDocument(final Long documentId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, documentId);
            }
        });
    }

    @Override
    public List<DocumentTask> getByTasks(Collection<Long> baseTaskId) {
        if (baseTaskId.isEmpty()) {
            return new ArrayList<DocumentTask>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[baseTaskId.size()];
        int n = 0;
        Iterator<Long> it = baseTaskId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"task_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentTask> getByObjectPlanners(Collection<Long> objectPlannerId) {
        if (objectPlannerId.isEmpty()) {
            return new ArrayList<DocumentTask>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[objectPlannerId.size()];
        int n = 0;
        Iterator<Long> it = objectPlannerId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"object_planner_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentTask> getByProjectParticipations(Collection<Long> projectParticipationId) {
        if (projectParticipationId.isEmpty()) {
            return new ArrayList<DocumentTask>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectParticipationId.size()];
        int n = 0;
        Iterator<Long> it = projectParticipationId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_participation_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<DocumentTask> getByDocuments(Collection<Long> documentId) {
        if (documentId.isEmpty()) {
            return new ArrayList<DocumentTask>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[documentId.size()];
        int n = 0;
        Iterator<Long> it = documentId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"document_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

