/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Trx;
import at.cdes.impl.dao.GenTrxDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcTrxDAO
extends AbstrIdDAO<Trx>
implements GenTrxDAO {
    public AbstractJdbcTrxDAO() {
        super(Trx.class, "id", "trx", new String[]{"id", "from_ts", "to_ts", "username", "fct", "comment"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcTrxDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "from_ts") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "to_ts") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "username") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "fct") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcTrxDAO.getSelectClauseForDto("trx", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcTrxDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".from_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "from_ts") + "," + entityLocalName + ".to_ts" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "to_ts") + "," + entityLocalName + ".username" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "username") + "," + entityLocalName + ".fct" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "fct") + "," + entityLocalName + ".comment" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + " ";
    }

    protected Trx fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Trx trx = new Trx();
        trx.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        trx.setFromTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        trx.setToTs(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        trx.setUsername(rs.getString(++columnIndex));
        trx.setFct(rs.getString(++columnIndex));
        trx.setComment(rs.getString(++columnIndex));
        return trx;
    }

    public static Trx fillTrxFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Trx trx = new Trx();
        trx.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        trx.setFromTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        trx.setToTs(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        trx.setUsername(rs.getString(columnIndex.incrementAndGet()));
        trx.setFct(rs.getString(columnIndex.incrementAndGet()));
        trx.setComment(rs.getString(columnIndex.incrementAndGet()));
        return trx;
    }

    public static Trx fillTrxFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcTrxDAO.fillTrxFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 6;
    }

    public int update(Trx dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Trx> dtos) {
        Iterator<Trx> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Trx trx) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)trx.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)trx.getFromTs());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)trx.getToTs());
        statement.setString(4, trx.getUsername());
        statement.setString(5, trx.getFct());
        statement.setString(6, trx.getComment());
    }
}

