/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.joinDto.ObjectReleaseJoin;
import at.cdes.api.obj.dto.ObjectSearchModel;
import at.cdes.impl.dao.ObjectReleaseDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcObjectReleaseDAO;
import at.cdes.impl.dao.unionComponent.ObjectReleaseComponent;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcObjectReleaseDAO
extends AbstractJdbcObjectReleaseDAO
implements ObjectReleaseDAO {
    public static String getLastReleaseObjectsSqlClause(String selectClause) {
        String sql = "SELECT " + selectClause + "FROM ((      object_list_release JOIN object_release             ON object_release.object_list_release_id = object_list_release.id) LEFT JOIN object_type           ON object_release.object_type_id = object_type.id) WHERE object_list_release.sub_project_id = ? AND object_list_release.version = (SELECT MAX(local_object_list_release.version) FROM object_list_release local_object_list_release WHERE local_object_list_release.sub_project_id = ?) ";
        return sql;
    }

    @Override
    public List<ObjectRelease> getLastReleasedObjects(final Long subProjectId) {
        String sql = JdbcObjectReleaseDAO.getLastReleaseObjectsSqlClause(JdbcObjectReleaseDAO.getSelectClauseForDto());
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectRelease>>(){

            public List<ObjectRelease> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ObjectRelease> ret = new ArrayList<ObjectRelease>();
                while (rs.next()) {
                    ObjectRelease objectRelease = JdbcObjectReleaseDAO.fillObjectReleaseFromResultSet(rs);
                    ret.add(objectRelease);
                }
                return ret;
            }
        });
    }

    @Override
    public List<ObjectRelease> getActiveByObjectListReleaseId(Long objectListReleaseId) {
        String sql = "SELECT " + JdbcObjectReleaseDAO.getSelectClauseForDto() + "FROM object_release WHERE object_release.object_list_release_id = ? AND object_release.inactive_flag = 0 ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListReleaseId);
        });
    }

    @Override
    public List<ObjectReleaseJoin> getObjectReleaseJoins(final ObjectSearchModel searchModel) {
        final String objectRelease = searchModel.getObj();
        final String objectPlannerReleased = searchModel.getObjectPlanner();
        final String responsible = searchModel.getResponsible();
        String whereClause = "object_release.object_list_release_id = ? AND object_release.inactive_flag = 0 ";
        if (SearchHelper.isStringFilled(objectRelease)) {
            whereClause = whereClause + "AND CONCAT(object_release.code, COALESCE(object_type.code, ''), ' ', object_release.name) LIKE ? ";
        }
        if (SearchHelper.isStringFilled(objectPlannerReleased)) {
            whereClause = whereClause + "AND EXISTS (SELECT 1 FROM object_planner_release local_object_planner_release WHERE local_object_planner_release.object_id = object_release.id AND CONCAT(local_object_planner_release.code, ' ', local_object_planner_release.area) LIKE ?) ";
        }
        if (SearchHelper.isStringFilled(responsible)) {
            whereClause = whereClause + "AND (    EXISTS (SELECT 1 FROM object_planner_release local_object_planner_release JOIN project_participation local_participation ON local_object_planner_release.planner_id = local_participation.id JOIN project_participant local_participant     ON     local_participant.participation_id = local_participation.id AND local_participant.main_participant_flag = 1 AND local_participant.inactive_flag = 0 JOIN organisation_person local_org_person      ON local_participant.organisation_person_id = local_org_person.id JOIN organisation local_organisation           ON local_org_person.organisation_id = local_organisation.id JOIN person local_person                       ON local_org_person.person_id = local_person.id WHERE local_object_planner_release.object_id = object_release.id AND CONCAT(local_organisation.name, ' (', local_person.surName, ' ', local_person.givenName, ')') LIKE ?) OR EXISTS (SELECT 1 FROM object_planner_release local_object_planner_release JOIN object_planner_position_release local_position_release ON local_position_release.object_planner_id = local_object_planner_release.id JOIN project_participation local_participation ON local_position_release.project_participation_id = local_participation.id JOIN project_participant local_participant     ON     local_participant.participation_id = local_participation.id AND local_participant.main_participant_flag = 1 AND local_participant.inactive_flag = 0 JOIN organisation_person local_org_person      ON local_participant.organisation_person_id = local_org_person.id JOIN organisation local_organisation           ON local_org_person.organisation_id = local_organisation.id JOIN person local_person                       ON local_org_person.person_id = local_person.id WHERE local_object_planner_release.object_id = object_release.id AND CONCAT(local_organisation.name, ' (', local_person.surName, ' ', local_person.givenName, ')') LIKE ?)) ";
        }
        String sql = "SELECT " + this.getObjectReleaseUnionSelectClause(ObjectReleaseComponent.BASE, "objectRelease", "object", "objectTypeRel", "objectType", "objectPlannerRelease", "objectPlanner", "reviewCycleInstanceReleased", "projectParticipation", "organisationPerson", "organisation", "person") + "FROM object_release JOIN object                         ON object_release.object_id = object.id LEFT JOIN object_type object_type_rel    ON object_release.object_type_id = object_type_rel.id LEFT JOIN object_type                    ON object.object_type_id = object_type.id LEFT JOIN object_planner_release         ON object_planner_release.object_id = object_release.id LEFT JOIN object_planner                 ON object_planner_release.object_planner_id = object_planner.id LEFT JOIN review_cycle_instance_released ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id LEFT JOIN project_participation          ON object_planner_release.planner_id = project_participation.id LEFT JOIN project_participant main_participant ON    main_participant.participation_id = project_participation.id AND main_participant.main_participant_flag = 1 AND main_participant.inactive_flag = 0 LEFT JOIN organisation_person            ON main_participant.organisation_person_id = organisation_person.id LEFT JOIN organisation                   ON organisation_person.organisation_id = organisation.id LEFT JOIN person                         ON organisation_person.person_id = person.id WHERE " + whereClause + "UNION ALL SELECT " + this.getObjectReleaseUnionSelectClause(ObjectReleaseComponent.CELL_INSTANCE, "objectRelease", "objectPlannerRelease", "reviewCycleCellInstanceReleased") + "FROM object_release JOIN object                         ON object_release.object_id = object.id LEFT JOIN object_type                    ON object.object_type_id = object_type.id LEFT JOIN object_planner_release         ON object_planner_release.object_id = object_release.id LEFT JOIN review_cycle_instance_released ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id LEFT JOIN review_cycle_cell_instance_released ON review_cycle_cell_instance_released.review_cycle_instance_id = review_cycle_instance_released.id WHERE " + whereClause + "UNION ALL SELECT " + this.getObjectReleaseUnionSelectClause(ObjectReleaseComponent.PLANNER_POSITION, "objectRelease", "objectPlannerRelease", "objectPlannerPositionRelease", "objectPlannerPositionDefinition", "projectParticipation", "organisationPerson", "organisation", "person") + "FROM object_release JOIN object                             ON object_release.object_id = object.id LEFT JOIN object_type                        ON object.object_type_id = object_type.id LEFT JOIN object_planner_release             ON object_planner_release.object_id = object_release.id LEFT JOIN object_planner_position_release    ON object_planner_position_release.object_planner_id = object_planner_release.id LEFT JOIN object_planner_position_definition ON object_planner_position_release.definition_id = object_planner_position_definition.id LEFT JOIN project_participation              ON object_planner_position_release.project_participation_id = project_participation.id LEFT JOIN project_participant main_participant ON    main_participant.participation_id = project_participation.id AND main_participant.main_participant_flag = 1 AND main_participant.inactive_flag = 0 LEFT JOIN organisation_person            ON main_participant.organisation_person_id = organisation_person.id LEFT JOIN organisation                   ON organisation_person.organisation_id = organisation.id LEFT JOIN person                         ON organisation_person.person_id = person.id WHERE " + whereClause;
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectReleaseJoin>>(){

            public List<ObjectReleaseJoin> perform(PreparedStatement statement) throws Exception {
                Long objectListReleaseId = searchModel.getObjectListReleaseId();
                int currIndex = 1;
                for (int n = 0; n < 3; ++n) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListReleaseId);
                    if (SearchHelper.isStringFilled(objectRelease)) {
                        statement.setString(currIndex++, SearchHelper.convertForSearch(objectRelease));
                    }
                    if (SearchHelper.isStringFilled(objectPlannerReleased)) {
                        statement.setString(currIndex++, SearchHelper.convertForSearch(objectPlannerReleased));
                    }
                    if (!SearchHelper.isStringFilled(responsible)) continue;
                    statement.setString(currIndex++, SearchHelper.convertForSearch(responsible));
                    statement.setString(currIndex++, SearchHelper.convertForSearch(responsible));
                }
                ArrayList<ObjectReleaseJoin> results = new ArrayList<ObjectReleaseJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    ObjectReleaseJoin joinDto = AbstractJdbcObjectReleaseDAO.fillObjectReleaseJoinFromResultSet(rs);
                    int attributeCount = AbstractJdbcObjectReleaseDAO.getNumberOfObjectReleaseJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)attributeCount++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getObjectReleaseUnionSelectClause(ObjectReleaseComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForObjectReleaseJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }
}

