/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.project;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.SubProject;
import at.cdes.api.project.compositeDto.OrganisationParticipationInfo;
import at.cdes.api.project.compositeDto.ParticipantInfo;
import at.cdes.api.project.compositeDto.ParticipationInfo;
import at.cdes.api.project.searchModel.ParticipationPageSearchModel;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.action.Action;
import at.cdes.impl.dao.ActionDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.export.planning.CompareHelper;
import at.cdes.impl.export.review.ReviewTaskPdfExporter;
import at.cdes.impl.sec.util.SecurityHelper;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.ActionHelper;
import at.cdes.impl.util.PersonHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.text.Collator;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ParticipationPdfExporter {
    private ActionDAO actionDAO;
    private String odfStylePrefix;
    private Long odfTimeout;
    private OrganisationPersonDAO organisationPersonDAO;
    private OOoFileEngine oooFileEngine = null;
    private ProjectDAO projectDAO;
    private PersonVariablesDAO personVariablesDAO;
    private String tempDirName;
    private static final Logger log = LoggerFactory.getLogger(ReviewTaskPdfExporter.class);

    public void setActionDAO(ActionDAO actionDAO) {
        this.actionDAO = actionDAO;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public ScratchFile export(Long organisationPersonId, ParticipationPageSearchModel searchModel, List<OrganisationParticipationInfo> organisationParticipationInfos, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, boolean enableCustomerLogo) throws Exception {
        Long projectId = searchModel.getProjectId();
        SecurityHelper.checkOrganisationPersonIdAgainstPrincipal(this.organisationPersonDAO, organisationPersonId);
        if (!ActionHelper.hasActionsForProject(this.actionDAO, organisationPersonId, projectId, Action.PROJECT_PARTICIPATIONS_OVERVIEW)) {
            throw new SecurityException("OrganisationPersonId [" + organisationPersonId + "] is missing privilege [" + Action.PROJECT_PARTICIPATIONS_OVERVIEW + "] needed to export project participation pdf list of project [" + projectId + "]");
        }
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        ResourceBundle resourceBundle = OdfHelper.getResourceBundleByPrincipal(this.personVariablesDAO);
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, enableCustomerLogo);
        String leftFooterLabelRaw = resourceBundle.getString("projectParticipationPdfLeftFooter");
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabelRaw, null, null, resourceBundle);
        TextHElement textHElement = officeText.newTextHElement(2);
        textHElement.setTextContent(resourceBundle.getString("projectParticipationPdfCaption"));
        officeText.newTextPElement();
        StyleTableCellPropertiesElement headerCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000");
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{headerCellProperties});
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold");
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{headerTextProperties});
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null);
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{dataTextProperties});
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        List<HeaderRow> headerRows = this.constructHeaderRows(resourceBundle, searchModel);
        FancyOdfTable<HeaderRow> headerTable = this.constructHeaderTable(resourceBundle, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle);
        headerTable.setDataRowStyle(dataRowStyle);
        headerTable.setRenderHeaderLine(false);
        headerTable.render((Node)officeText, headerRows, columnSortSpecs);
        officeText.newTextPElement();
        List<RowPos> rowPosList = this.constructRowPosList(organisationParticipationInfos);
        FancyOdfTable<RowPos> odfTable = this.constructTable(resourceBundle, contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, columnToWidth);
        odfTable.setDataRowStyle(dataRowStyle);
        odfTable.render((Node)officeText, rowPosList, columnSortSpecs);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Projektteilnehmer_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private List<HeaderRow> constructHeaderRows(ResourceBundle resourceBundle, ParticipationPageSearchModel searchModel) {
        Long projectId = searchModel.getProjectId();
        Project project = (Project)this.projectDAO.get(projectId);
        String route = project.getRouteName() != null ? project.getRouteName() : "";
        Double kmFromDouble = project.getStretchKmFrom();
        Double kmToDouble = project.getStretchKmTo();
        String kmFrom = null;
        String kmTo = null;
        DecimalFormat kmFormat = (DecimalFormat)NumberFormat.getNumberInstance(Locale.GERMAN);
        kmFormat.applyPattern("###,###.###");
        if (kmFromDouble != null) {
            kmFrom = kmFormat.format(kmFromDouble);
        }
        if (kmToDouble != null) {
            kmTo = kmFormat.format(kmToDouble);
        }
        String km = kmFrom != null ? kmFrom : ("" + (kmFrom != null && kmTo != null ? " - " : "") + kmTo != null ? kmTo : "");
        String comment = project.getComment() != null ? project.getComment() : "";
        ArrayList<HeaderRow> headerRows = new ArrayList<HeaderRow>();
        headerRows.add(new HeaderRow(resourceBundle.getString("projectParticipationPdfHeaderProject"), project.getCode() + " " + project.getName()));
        headerRows.add(new HeaderRow(resourceBundle.getString("projectParticipationPdfHeaderRoute"), route));
        headerRows.add(new HeaderRow(resourceBundle.getString("projectParticipationPdfHeaderKm"), km));
        headerRows.add(new HeaderRow(resourceBundle.getString("projectParticipationPdfHeaderComment"), comment));
        return headerRows;
    }

    private List<RowPos> constructRowPosList(List<OrganisationParticipationInfo> infos) {
        ArrayList<RowPos> rowPosList = new ArrayList<RowPos>();
        for (OrganisationParticipationInfo info : infos) {
            List participationInfos = info.getParticipationInfos();
            for (int n = 0; n < participationInfos.size(); ++n) {
                rowPosList.add(new RowPos(info, n, participationInfos.size()));
            }
        }
        return rowPosList;
    }

    private FancyOdfTable<HeaderRow> constructHeaderTable(ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, final String dataCellStyle, final String dataTextStyle) {
        ArrayList<FancyOdfTableColumn> columns = new ArrayList<FancyOdfTableColumn>();
        columns.add(new FancyOdfTableColumn<HeaderRow>("label", null){

            public void appendCell(TableTableRowElement rowElement, HeaderRow headerRow) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, headerRow.label);
            }

            public int compare(HeaderRow headerRowOne, HeaderRow headerRowTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<HeaderRow>("content", null){

            public void appendCell(TableTableRowElement rowElement, HeaderRow headerRow) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, headerRow.content);
            }

            public int compare(HeaderRow headerRowOne, HeaderRow headerRowTwo, boolean descending) {
                return 0;
            }
        });
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        HashMap<String, Double> relativeColumnWidths = new HashMap<String, Double>();
        relativeColumnWidths.put("label", 0.25);
        relativeColumnWidths.put("content", 0.75);
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private FancyOdfTable<RowPos> constructTable(ResourceBundle resourceBundle, Styles contentAutomaticStyles, String headerCellStyle, String headerTextStyle, final String dataCellStyle, final String dataTextStyle, Map<String, Double> relativeColumnWidths) {
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        ArrayList<FancyOdfTableColumn> columns = new ArrayList<FancyOdfTableColumn>();
        columns.add(new FancyOdfTableColumn<RowPos>("organisation", resourceBundle.getString("projectParticipationPdfOrganisationCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos rowPos) {
                if (rowPos.idx == 0) {
                    Organisation organisation = rowPos.info.getOrganisation();
                    TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                    cellElement.setTableNumberRowsSpannedAttribute(Integer.valueOf(rowPos.count));
                    TextFactory.constructTextNode((Node)cellElement, (String)organisation.getName(), (String)dataTextStyle);
                } else {
                    OdfHelper.appendCoveredTableCell(rowElement);
                }
            }

            public int compare(RowPos rowPosOne, RowPos rowPosTwo, boolean descending) {
                Organisation orgOne = rowPosOne.info.getOrganisation();
                Organisation orgTwo = rowPosTwo.info.getOrganisation();
                if (orgOne.getId().longValue() == orgTwo.getId().longValue()) {
                    return (descending ? -1 : 1) * (rowPosOne.idx - rowPosTwo.idx);
                }
                return CompareHelper.defaultStringCompare(collator, orgOne.getName(), orgTwo.getName(), descending);
            }
        });
        columns.add(new FancyOdfTableColumn<RowPos>("roles", resourceBundle.getString("projectParticipationPdfRolesCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos rowPos) {
                ParticipationInfo participationInfo = (ParticipationInfo)rowPos.info.getParticipationInfos().get(rowPos.idx);
                String name = participationInfo.getCdesRole().getName();
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, name);
            }

            public int compare(RowPos rowPosOne, RowPos rowPosTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<RowPos>("mainParticipant", resourceBundle.getString("projectParticipationPdfMainParticipantCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos rowPos) {
                ParticipationInfo participationInfo = (ParticipationInfo)rowPos.info.getParticipationInfos().get(rowPos.idx);
                String name = participationInfo.getMainParticipantInfo() != null ? PersonHelper.getInverseCommonName(participationInfo.getMainParticipantInfo().getPerson()) : "";
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, name);
            }

            public int compare(RowPos rowPosOne, RowPos rowPosTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<RowPos>("deputies", resourceBundle.getString("projectParticipationPdfDeputiesCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos rowPos) {
                ParticipationInfo participationInfo = (ParticipationInfo)rowPos.info.getParticipationInfos().get(rowPos.idx);
                List deputyInfos = participationInfo.getDeputyInfos();
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                for (ParticipantInfo deputyInfo : deputyInfos) {
                    Person person = deputyInfo.getPerson();
                    String name = PersonHelper.getInverseCommonName(person);
                    TextFactory.constructTextNode((Node)cellElement, (String)name, (String)dataTextStyle);
                }
            }

            public int compare(RowPos rowPosOne, RowPos rowPosTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<RowPos>("allowedSubProjects", resourceBundle.getString("projectParticipationPdfAllowedSubProjectsCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos rowPos) {
                ParticipationInfo participationInfo = (ParticipationInfo)rowPos.info.getParticipationInfos().get(rowPos.idx);
                List allowedSubProjects = participationInfo.getAllowedSubProjects();
                TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)dataCellStyle, (String)dataTextStyle, (TableTableRowElement)rowElement);
                for (SubProject allowedSubProject : allowedSubProjects) {
                    String name = allowedSubProject.getCode() + (allowedSubProject.getNumber() != null ? allowedSubProject.getNumber() + " " : " ") + allowedSubProject.getName();
                    TextFactory.constructTextNode((Node)cellElement, (String)name, (String)dataTextStyle);
                }
            }

            public int compare(RowPos rowPosOne, RowPos rowPosTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<RowPos>("comment", resourceBundle.getString("projectParticipationPdfCommentCaption")){

            public void appendCell(TableTableRowElement rowElement, RowPos rowPos) {
                ParticipationInfo participationInfo = (ParticipationInfo)rowPos.info.getParticipationInfos().get(rowPos.idx);
                String comment = participationInfo.getProjectParticipation().getComment();
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, comment != null ? comment : "");
            }

            public int compare(RowPos rowPosOne, RowPos rowPosTwo, boolean descending) {
                return 0;
            }
        });
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnWidths, columns);
        table.setDataRowStyle(rowStyle);
        return table;
    }

    private static class HeaderRow {
        String label;
        String content;

        HeaderRow(String label, String content) {
            this.label = label;
            this.content = content;
        }
    }

    private static class RowPos {
        OrganisationParticipationInfo info;
        int idx;
        int count;

        RowPos(OrganisationParticipationInfo info, int idx, int count) {
            this.info = info;
            this.idx = idx;
            this.count = count;
        }
    }
}

