/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.msp;

import at.cdes.api.dto.msp.MspFieldValue;
import at.cdes.api.dto.msp.MspItem;
import at.cdes.api.dto.msp.MspItemType;
import at.cdes.api.dto.msp.MspList;
import at.cdes.api.dto.msp.MspListField;
import at.cdes.api.dto.msp.MspResult;
import at.cdes.api.dto.msp.MspTerm;
import at.cdes.api.guiService.DocumentService;
import at.cdes.api.guiService.PlanningNotificationService;
import at.cdes.api.service.MspService;
import at.cdes.api.voc.msp.MspCheckInType;
import at.cdes.impl.export.document.NightlyDocumentCallable;
import at.cdes.impl.export.planning.PlanningNotificationOrderMspExportCallable;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.msp.CookieNTLMSchema;
import at.cdes.impl.msp.CookieReuseStrategy;
import at.cdes.impl.msp.MspPrincipal;
import at.cdes.impl.msp.MspProbe;
import at.cdes.impl.planning.PlanningReportMspExportCallable;
import at.cdes.impl.util.DateHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.text.Collator;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.xml.namespace.NamespaceContext;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.osgi.services.HttpClientBuilderFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.pdfbox.io.IOUtils;
import org.clazzes.util.aop.DAOException;
import org.clazzes.util.aop.IFileDeleter;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.lang.Pair;
import org.clazzes.util.sched.IOneTimeScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MspServiceImpl
implements MspService,
MspProbe {
    private URI baseUrl;
    private int connectTimeout = 60000;
    private DocumentService documentService;
    private IOneTimeScheduler oneTimeScheduler;
    private IFileDeleter fileDeleter;
    private String loginThreadLocalKey;
    private PlanningNotificationService planningNotificationService;
    private String rootFolder;
    private String rootQuery;
    private int socketTimeout = 30000;
    private String tempRepository;
    private static final Logger log = LoggerFactory.getLogger(MspServiceImpl.class);
    private static final String MSP_SOAP_NS_URI = "http://schemas.microsoft.com/sharepoint/soap/";
    private static final String MSP_TAXONOMY_SOAP_NS_URI = "http://schemas.microsoft.com/sharepoint/taxonomy/soap/";
    private static final String SOAP_ENVELOPE_NS_URI = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String W3C_ATOM_NS_URI = "http://www.w3.org/2005/Atom";
    private static final String MS_DATASERVICES_NS_URI = "http://schemas.microsoft.com/ado/2007/08/dataservices";
    private static final String MS_METADATA_NS_URI = "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata";
    private static final String MS_DATASERVICES_SCHEME_URL = "http://schemas.microsoft.com/ado/2007/08/dataservices/scheme";
    private static final XMLOutputFactory XOF = XMLOutputFactory.newFactory();
    private static final XMLInputFactory XIF = XMLInputFactory.newFactory();
    private static final NamespaceContext MSP_SOAP_NAMESPACE_CONTEXT;
    private static final NamespaceContext W3C_ATOM_NAMESPACE_CONTEXT;
    private static final String[] QUERY_ITEM_WRAPS;
    private static final String[] GET_LIST_REST_WRAPS;
    private static final String[] GET_LIST_ITEMS_REST_WRAPS;
    private static final String[] GET_LIST_WRAPS;
    private static final String[] LIST_ITEM_WRAPS;
    private static final String[] LIST_COLLECTION_WRAPS;
    private static final String[] UPDATE_LIST_ITEMS_WRAPS;
    private static final String[] COPY_INTO_ITEMS_WRAPS;
    private static final String[] GET_URL_SEGMENTS_WRAPS;
    private static final String[] GET_LIST_COLLECTION_WRAPS;
    private static final String[] GET_CHILD_TERMS_IN_TERM_SET_WRAPS;
    private static final String[] GET_CHILD_TERMS_IN_TERM_WRAPS;
    private static final String[] GET_TERMS_BY_LABEL_WRAPS;
    private static final String[] TERM_STORE_WRAPS;
    private static final String[] CHECK_IN_WRAPS;
    private static final String[] EMPTY_WRAPS;
    private CloseableHttpClient httpClient;
    private CloseableHttpClient probeHttpClient;

    public void setBaseUrl(URI baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setOneTimeScheduler(IOneTimeScheduler oneTimeScheduler) {
        this.oneTimeScheduler = oneTimeScheduler;
    }

    public void setFileDeleter(IFileDeleter fileDeleter) {
        this.fileDeleter = fileDeleter;
    }

    public void setLoginThreadLocalKey(String loginThreadLocalKey) {
        this.loginThreadLocalKey = loginThreadLocalKey;
    }

    public void setPlanningNotificationService(PlanningNotificationService planningNotificationService) {
        this.planningNotificationService = planningNotificationService;
    }

    public void setRootFolder(String rootFolder) {
        this.rootFolder = rootFolder;
    }

    public void setRootQuery(String rootQuery) {
        this.rootQuery = rootQuery;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setTempRepository(String tempRepository) {
        this.tempRepository = tempRepository;
    }

    private synchronized void setHttpClient(CloseableHttpClient closeableHttpClient, CloseableHttpClient probeHttpClient) {
        this.httpClient = closeableHttpClient;
        this.probeHttpClient = probeHttpClient;
    }

    protected void setHttpClientBuilder(HttpClientBuilder httpClientBuilder) {
        httpClientBuilder.setConnectionTimeToLive(30000L, TimeUnit.MILLISECONDS);
        httpClientBuilder.setMaxConnTotal(8);
        RequestConfig.Builder rqcb = RequestConfig.custom();
        if (this.socketTimeout > 0) {
            rqcb.setSocketTimeout(this.socketTimeout);
        }
        if (this.connectTimeout > 0) {
            rqcb.setConnectTimeout(this.connectTimeout);
        }
        rqcb.setAuthenticationEnabled(true);
        rqcb.setTargetPreferredAuthSchemes(Collections.singleton("NTLM"));
        rqcb.setCookieSpec("default");
        httpClientBuilder.setDefaultRequestConfig(rqcb.build());
        httpClientBuilder.setConnectionReuseStrategy((ConnectionReuseStrategy)new CookieReuseStrategy());
        RegistryBuilder rb = RegistryBuilder.create();
        rb.register("NTLM", (Object)new AuthSchemeProvider(){

            public AuthScheme create(HttpContext context) {
                return new CookieNTLMSchema();
            }
        });
        Registry registry = rb.build();
        httpClientBuilder.setDefaultAuthSchemeRegistry((Lookup)registry);
        CloseableHttpClient closeableHttpClient = httpClientBuilder.build();
        httpClientBuilder.disableRedirectHandling();
        CloseableHttpClient probeHttpClient = httpClientBuilder.build();
        this.setHttpClient(closeableHttpClient, probeHttpClient);
    }

    public void httpClientBuilderFactoryBound(HttpClientBuilderFactory httpClientBuilderFactory) {
        HttpClientBuilder httpClientBuilder = httpClientBuilderFactory.newBuilder();
        this.setHttpClientBuilder(httpClientBuilder);
        log.info("Service [org.apache.http.osgi.services.HttpClientBuilderFactory] became available, MspServiceImpl is now fully operational.");
    }

    public synchronized void httpClientBuilderFactoryUnbound(HttpClientBuilderFactory httpClientBuilderFactory) {
        if (this.httpClient != null) {
            log.info("Service [org.apache.http.osgi.services.HttpClientBuilderFactory] disappeared, MspServiceImpl will now be shut down.");
            try {
                this.httpClient.close();
            }
            catch (IOException e) {
                log.warn("Error closing HTTPClient", (Throwable)e);
            }
            this.httpClient = null;
        }
    }

    protected synchronized CloseableHttpClient getHttpClient() {
        if (this.httpClient == null) {
            throw new IllegalStateException("MspServiceImpl is not initialized, still waiting for OSGi Service [org.apache.http.osgi.services.HttpClientBuilderFactory].");
        }
        return this.httpClient;
    }

    protected synchronized CloseableHttpClient getProbeHttpClient() {
        if (this.probeHttpClient == null) {
            throw new IllegalStateException("MspServiceImpl is not initialized, still waiting for OSGi Service [org.apache.http.osgi.services.HttpClientBuilderFactory].");
        }
        return this.probeHttpClient;
    }

    private HttpClientContext buildClientContext(MspPrincipal mspPrincipal) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)mspPrincipal.getCredentials());
        HttpClientContext clientContext = HttpClientContext.create();
        clientContext.setCredentialsProvider((CredentialsProvider)credsProvider);
        clientContext.setCookieStore((CookieStore)new BasicCookieStore());
        return clientContext;
    }

    protected HttpClientContext getClientContext() {
        MspPrincipal mspPrincipal = (MspPrincipal)ThreadLocalManager.getBoundResource((String)this.loginThreadLocalKey);
        if (mspPrincipal == null) {
            throw new SecurityException("No logged on MSP user in thread local context.");
        }
        return this.buildClientContext(mspPrincipal);
    }

    private URI buildCopyPathURI(String path) {
        return this.buildPathURI("Copy", path);
    }

    private URI buildListsPathURI(String path) {
        return this.buildPathURI("Lists", path);
    }

    private URI buildSiteDataURI(String path) {
        return this.buildPathURI("SiteData", path);
    }

    private URI buildTaxonomyClientServiceURI(String path) {
        return this.buildPathURI("TaxonomyClientService", path);
    }

    private String getRawPath(String path) {
        try {
            return new URI(this.baseUrl.getScheme(), this.baseUrl.getUserInfo(), this.baseUrl.getHost(), this.baseUrl.getPort(), path, null, null).toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private URI buildPathURI(String module, String path) {
        try {
            return new URI(this.baseUrl.getScheme(), this.baseUrl.getUserInfo(), this.baseUrl.getHost(), this.baseUrl.getPort(), path + "/_vti_bin/" + module + ".asmx", null, null);
        }
        catch (URISyntaxException e) {
            throw new DAOException("Error encoding URI for path [" + path + "]", (Throwable)e);
        }
    }

    private URI buildRestURI(String projectPath, String fctPath, String query) {
        try {
            return new URI(this.baseUrl.getScheme(), this.baseUrl.getUserInfo(), this.baseUrl.getHost(), this.baseUrl.getPort(), projectPath + "/_api/" + fctPath, query, null);
        }
        catch (URISyntaxException e) {
            throw new DAOException("Error encoding URI for projectPath [" + projectPath + "] and fctPath [" + fctPath + "]", (Throwable)e);
        }
    }

    private static void checkHttpError(URI uri, CloseableHttpResponse resp) {
        int statusCode = resp.getStatusLine().getStatusCode();
        if (log.isDebugEnabled()) {
            log.debug("Request to [{}] returned HTTP Status [{}].", (Object)uri, (Object)statusCode);
        }
        if (statusCode != 200 && statusCode != 204 && statusCode != 302) {
            if (log.isDebugEnabled()) {
                log.debug("resp.headers=[{}]", (Object)Arrays.toString(resp.getAllHeaders()));
            }
            try (InputStreamReader isr = new InputStreamReader(resp.getEntity().getContent(), "UTF-8");){
                char[] buf = new char[2048];
                int n = isr.read(buf);
                if (n >= 0) {
                    String msg = new String(buf, 0, n);
                    log.error("Request to [" + uri + "] returned message [" + msg + "].");
                }
            }
            catch (Throwable e) {
                log.warn("Error parsing error message from [" + uri + "]", e);
            }
            throw new DAOException("Request to [" + uri + "] returned HTTP Status [" + statusCode + "].");
        }
    }

    private static XMLStreamReader openXmlResponse(URI uri, CloseableHttpResponse resp, String[] wraps) throws UnsupportedOperationException, XMLStreamException, IOException {
        InputStream contentStream = resp.getEntity().getContent();
        if (log.isDebugEnabled()) {
            byte[] data = IOUtils.toByteArray((InputStream)contentStream);
            String dataString = new String(data, "UTF-8");
            log.debug("XML response is: [" + dataString + "]");
            contentStream = new ByteArrayInputStream(data);
        }
        XMLStreamReader xis = XIF.createXMLStreamReader(contentStream);
        return MspServiceImpl.openXmlResponse(uri, xis, wraps);
    }

    private static XMLStreamReader openXmlResponse(String xml, String[] wraps) throws UnsupportedOperationException, XMLStreamException, IOException {
        StringReader stringReader = new StringReader(xml);
        XMLStreamReader xis = XIF.createXMLStreamReader(stringReader);
        return MspServiceImpl.openXmlResponse(null, xis, wraps);
    }

    private static XMLStreamReader openXmlResponse(URI uri, XMLStreamReader xis, String[] wraps) throws UnsupportedOperationException, XMLStreamException, IOException {
        int depth = 0;
        for (int i = 0; i < wraps.length; ++i) {
            boolean hit = false;
            while (!hit && depth >= i) {
                do {
                    xis.next();
                } while (xis.getEventType() != 1 && xis.getEventType() != 2);
                if (xis.getEventType() == 1) {
                    hit = ++depth == i + 1 && wraps[i].equals(xis.getLocalName());
                    continue;
                }
                if (xis.getEventType() != 2) continue;
                --depth;
            }
            if (hit) continue;
            throw new DAOException("Post to [" + uri + "] returned tag [" + xis.getLocalName() + "] instead of [" + wraps[i] + "] at level [" + i + "].");
        }
        xis.nextTag();
        return xis;
    }

    private static void closeXmlResponse(XMLStreamReader xis) {
        try {
            while (xis.hasNext()) {
                xis.next();
            }
            xis.close();
        }
        catch (XMLStreamException e) {
            log.warn("Error closing Xml response", (Throwable)e);
        }
    }

    public List<MspItem> getProjects() {
        List<MspItem> projects = this.rootQuery == null || this.rootQuery.isEmpty() ? this.getProjectsSoap() : this.getProjectsByQuery();
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        Collections.sort(projects, new Comparator<MspItem>(){

            @Override
            public int compare(MspItem itemOne, MspItem itemTwo) {
                String titleOne = itemOne.getTitle();
                String titleTwo = itemTwo.getTitle();
                if (titleOne == null) {
                    titleOne = "";
                }
                if (titleTwo == null) {
                    titleTwo = "";
                }
                return collator.compare(titleOne, titleTwo);
            }
        });
        return projects;
    }

    private MspItem parseRowElement(XMLStreamReader xis) throws XMLStreamException, URISyntaxException {
        MspItem ret = new MspItem();
        while (xis.isStartElement() && "Cells".equals(xis.getLocalName())) {
            xis.nextTag();
            while (xis.isStartElement() && "element".equals(xis.getLocalName())) {
                xis.nextTag();
                String key = null;
                String value = null;
                String valueType = null;
                while (xis.isStartElement()) {
                    if ("Key".equals(xis.getLocalName())) {
                        key = xis.getElementText();
                    } else if ("Value".equals(xis.getLocalName())) {
                        value = xis.getElementText();
                    } else if ("ValueType".equals(xis.getLocalName())) {
                        valueType = xis.getElementText();
                    } else {
                        throw new DAOException("Unexpected tag [" + xis.getLocalName() + "] inside query data cell.");
                    }
                    if (!xis.isEndElement()) continue;
                    xis.nextTag();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Parsed property [{}] with value [{}] and type [{}].", new Object[]{key, value, valueType});
                }
                if ("Path".equals(key)) {
                    if (value != null) {
                        value = value.replace(" ", "%20");
                        URI keyUrl = new URI(value);
                        ret.setPath(keyUrl.getPath());
                    }
                } else if ("Title".equals(key)) {
                    ret.setTitle(value);
                } else if ("PartitionId".equals(key)) {
                    ret.setGuid("{" + value + "}");
                } else if ("DocId".equals(key)) {
                    ret.setId(value);
                }
                if (!xis.isEndElement()) continue;
                xis.nextTag();
            }
            if (!xis.isEndElement()) continue;
            xis.nextTag();
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MspItem> getProjectsByQuery() {
        HttpClientContext context = this.getClientContext();
        CloseableHttpClient client = this.getHttpClient();
        URI uri = this.baseUrl.resolve(this.rootQuery);
        HttpGet req = new HttpGet(uri);
        HttpClientContext httpClientContext = context;
        synchronized (httpClientContext) {
            ArrayList<MspItem> arrayList;
            block19: {
                CloseableHttpResponse resp = client.execute((HttpUriRequest)req, (HttpContext)context);
                try {
                    MspServiceImpl.checkHttpError(uri, resp);
                    ArrayList<MspItem> ret = new ArrayList<MspItem>();
                    XMLStreamReader xis = null;
                    try {
                        xis = MspServiceImpl.openXmlResponse(uri, resp, QUERY_ITEM_WRAPS);
                        while (xis.isStartElement() && "element".equals(xis.getLocalName())) {
                            xis.nextTag();
                            MspItem item = this.parseRowElement(xis);
                            if (item.getPath() != null && !item.getPath().isEmpty() && !item.getPath().endsWith("/msptemplate")) {
                                item.setType(MspItemType.PROJECT);
                                ret.add(item);
                            }
                            if (!xis.isEndElement()) continue;
                            xis.nextTag();
                        }
                    }
                    finally {
                        if (xis != null) {
                            MspServiceImpl.closeXmlResponse(xis);
                        }
                    }
                    arrayList = ret;
                    if (resp == null) break block19;
                }
                catch (Throwable throwable) {
                    try {
                        if (resp != null) {
                            try {
                                resp.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        throw new DAOException((Throwable)e);
                    }
                }
                resp.close();
            }
            return arrayList;
        }
    }

    private List<MspItem> getProjectsSoap() {
        return this.emitSharepointQuery(MSP_SOAP_NS_URI, "GetListItems", LIST_ITEM_WRAPS, new MspQueryProcessor<List<MspItem>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws XMLStreamException {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "listName");
                xsw.writeCharacters(MspServiceImpl.this.rootFolder);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "viewFields");
                xsw.writeStartElement("ViewFields");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "ID");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "GUID");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "Title");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "keyURL");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "Modified");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "Created");
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "rowLimit");
                xsw.writeCharacters("0");
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "queryOptions");
                xsw.writeStartElement("QueryOptions");
                xsw.writeStartElement("IncludeMandatoryColumns");
                xsw.writeCharacters("FALSE");
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.baseUrl.resolve("/_vti_bin/Lists.asmx");
            }

            @Override
            public List<MspItem> process(XMLStreamReader xis) throws Exception {
                ArrayList<MspItem> ret = new ArrayList<MspItem>();
                while (xis.isStartElement() && "row".equals(xis.getLocalName())) {
                    MspItem item = new MspItem();
                    item.setType(MspItemType.PROJECT);
                    item.setId(xis.getAttributeValue(null, "ows_ID"));
                    item.setGuid(xis.getAttributeValue(null, "ows_GUID"));
                    item.setTitle(xis.getAttributeValue(null, "ows_Title"));
                    item.setCreated(xis.getAttributeValue(null, "ows_Created"));
                    item.setModified(xis.getAttributeValue(null, "ows_Modified"));
                    String keyUrl_s = xis.getAttributeValue(null, "ows_keyURL");
                    if (keyUrl_s != null) {
                        keyUrl_s = keyUrl_s.replace(" ", "%20");
                        URI keyUrl = new URI(keyUrl_s);
                        item.setPath(keyUrl.getPath());
                    }
                    ret.add(item);
                    xis.nextTag();
                    if (!xis.isEndElement()) continue;
                    xis.nextTag();
                }
                return ret;
            }
        });
    }

    public List<MspItem> getProjectFolders(final String path) {
        return this.emitSharepointQuery(MSP_SOAP_NS_URI, "GetListCollection", LIST_COLLECTION_WRAPS, new MspQueryProcessor<List<MspItem>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws XMLStreamException {
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildListsPathURI(path);
            }

            @Override
            public List<MspItem> process(XMLStreamReader xis) throws XMLStreamException {
                ArrayList<MspItem> ret = new ArrayList<MspItem>();
                while (xis.isStartElement() && "List".equals(xis.getLocalName())) {
                    String defaultViewUrl;
                    int postfixIndex;
                    MspItem item = new MspItem();
                    item.setType(MspItemType.FOLDER);
                    item.setId(xis.getAttributeValue(null, "ID"));
                    item.setGuid(xis.getAttributeValue(null, "Name"));
                    item.setTitle(xis.getAttributeValue(null, "Title"));
                    item.setCreated(xis.getAttributeValue(null, "Created"));
                    item.setModified(xis.getAttributeValue(null, "Modified"));
                    item.setPath(path);
                    if (log.isTraceEnabled()) {
                        log.trace("ListItemEntityTypeFullName = [" + xis.getAttributeValue(null, "ListItemEntityTypeFullName"));
                    }
                    if ((postfixIndex = (defaultViewUrl = xis.getAttributeValue(null, "DefaultViewUrl")).lastIndexOf("/Forms/AllItems.aspx")) < 0) {
                        postfixIndex = defaultViewUrl.lastIndexOf("/AllItems.aspx");
                    }
                    if (postfixIndex < 0) {
                        log.warn("Couldn't find any marker string for shortening path, copyUrl might be wrong.");
                        postfixIndex = defaultViewUrl.length();
                    }
                    String childPath = defaultViewUrl.substring(0, postfixIndex);
                    item.setUrl(MspServiceImpl.this.getRawPath(childPath));
                    ret.add(item);
                    xis.nextTag();
                    if (!xis.isEndElement()) continue;
                    xis.nextTag();
                }
                return ret;
            }
        });
    }

    private static String stripPfx(XMLStreamReader xis, String localName, String pfx) {
        String v = xis.getAttributeValue(null, localName);
        if (v != null && v.startsWith(pfx)) {
            v = v.substring(pfx.length());
        }
        return v;
    }

    public List<MspItem> getFolderDocuments(final String path, final String guid, final List<String> metaTagKeys) {
        return this.emitSharepointQuery(MSP_SOAP_NS_URI, "GetListItems", LIST_ITEM_WRAPS, new MspQueryProcessor<List<MspItem>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws XMLStreamException {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "listName");
                xsw.writeCharacters(guid);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "viewFields");
                xsw.writeStartElement("ViewFields");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "ID");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "GUID");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "DocIcon");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "Last_x0020_Modified");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "Created_x0020_Date");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "EncodedAbsUrl");
                xsw.writeEmptyElement("FieldRef");
                xsw.writeAttribute("Name", "LinkFilename");
                if (metaTagKeys != null) {
                    for (String metaTagKey : metaTagKeys) {
                        xsw.writeEmptyElement("FieldRef");
                        if (metaTagKey.startsWith("-")) {
                            xsw.writeAttribute("Name", metaTagKey.substring(1));
                            continue;
                        }
                        xsw.writeAttribute("Name", metaTagKey);
                    }
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "rowLimit");
                xsw.writeCharacters("0");
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "queryOptions");
                xsw.writeStartElement("QueryOptions");
                xsw.writeStartElement("IncludeMandatoryColumns");
                xsw.writeCharacters("FALSE");
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildListsPathURI(path);
            }

            @Override
            public List<MspItem> process(XMLStreamReader xis) throws XMLStreamException {
                NumberFormat numberFormat = NumberFormat.getInstance(Locale.GERMAN);
                numberFormat.setGroupingUsed(false);
                numberFormat.setMaximumFractionDigits(3);
                ArrayList<MspItem> ret = new ArrayList<MspItem>();
                while (xis.isStartElement() && "row".equals(xis.getLocalName())) {
                    String icon = xis.getAttributeValue(null, "ows_DocIcon");
                    if (icon != null) {
                        MspItem item = new MspItem();
                        item.setType(MspItemType.DOCUMENT);
                        String id = xis.getAttributeValue(null, "ows_ID");
                        String pfx = id + ";#";
                        item.setId(id);
                        item.setGuid(xis.getAttributeValue(null, "ows_GUID"));
                        item.setTitle(xis.getAttributeValue(null, "ows_LinkFilename"));
                        item.setIcon(icon);
                        item.setCreated(MspServiceImpl.stripPfx(xis, "ows_Created_x0020_Date", pfx));
                        item.setModified(MspServiceImpl.stripPfx(xis, "ows_Last_x0020_Modified", pfx));
                        item.setPath(xis.getAttributeValue(null, "ows_EncodedAbsUrl"));
                        if (log.isTraceEnabled()) {
                            for (int n = 0; n < xis.getAttributeCount(); ++n) {
                                log.trace("Attribute [" + xis.getAttributeName(n) + "] has value [" + xis.getAttributeValue(n) + "]");
                            }
                        }
                        if (metaTagKeys != null) {
                            for (String metaTagKey : metaTagKeys) {
                                String v;
                                if (metaTagKey.startsWith("-")) {
                                    metaTagKey = metaTagKey.substring(1);
                                    v = xis.getAttributeValue(null, "ows_" + metaTagKey);
                                    if (v != null) {
                                        v = v.replaceFirst("^-?[0-9+]+;#", "");
                                        v = v.replaceAll(";#-?[0-9+]*;#", "; ");
                                        v = v.replaceAll("-?[0-9+]*;#", "; ");
                                    }
                                } else {
                                    v = xis.getAttributeValue(null, "ows_" + metaTagKey);
                                }
                                if (v == null) continue;
                                try {
                                    Double d = Double.parseDouble(v);
                                    String doubleAsString = numberFormat.format(d);
                                    int delimiterPos = doubleAsString.lastIndexOf(44);
                                    if (delimiterPos >= 0) {
                                        int cutPosition = delimiterPos - 1;
                                        for (int z = delimiterPos + 1; z < doubleAsString.length(); ++z) {
                                            char c = doubleAsString.charAt(z);
                                            if (c != '1' && c != '2' && c != '3' && c != '4' && c != '5' && c != '6' && c != '7' && c != '8' && c != '9') continue;
                                            cutPosition = z;
                                        }
                                        v = doubleAsString.substring(0, cutPosition + 1);
                                    } else {
                                        v = doubleAsString;
                                    }
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                item.addMetaTag(metaTagKey, v);
                            }
                        }
                        ret.add(item);
                    }
                    xis.nextTag();
                    if (!xis.isEndElement()) continue;
                    xis.nextTag();
                }
                return ret;
            }
        });
    }

    private static Boolean parseBooleanValue(String valueString) {
        if ("TRUE".equals(valueString)) {
            return true;
        }
        if ("FALSE".equals(valueString)) {
            return false;
        }
        return null;
    }

    public List<MspListField> getListFields(final String projectPath, final String listName) {
        return this.emitSharepointQuery(MSP_SOAP_NS_URI, "GetList", GET_LIST_WRAPS, new MspQueryProcessor<List<MspListField>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "listName");
                xsw.writeCharacters(listName);
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildListsPathURI(projectPath);
            }

            @Override
            public List<MspListField> process(XMLStreamReader xis) throws Exception {
                ArrayList<MspListField> fields = new ArrayList<MspListField>();
                while (xis.isStartElement() && "Field".equals(xis.getLocalName())) {
                    MspListField field = new MspListField();
                    field.setId(xis.getAttributeValue(null, "ID"));
                    field.setType(xis.getAttributeValue(null, "Type"));
                    field.setName(xis.getAttributeValue(null, "Name"));
                    field.setList(xis.getAttributeValue(null, "List"));
                    if (log.isTraceEnabled()) {
                        log.trace("Name [" + field.getName() + "], StaticName = [" + xis.getAttributeValue(null, "StaticName") + "], TextField: [" + xis.getAttributeValue(null, "TextField") + "]");
                    }
                    String requiredString = xis.getAttributeValue(null, "Required");
                    field.setRequired(MspServiceImpl.parseBooleanValue(requiredString));
                    this.parseFieldChildren(xis, field);
                    fields.add(field);
                    if (!xis.isEndElement()) continue;
                    xis.nextTag();
                }
                return fields;
            }

            private void parseFieldChildren(XMLStreamReader xis, MspListField field) throws Exception {
                if (log.isTraceEnabled()) {
                    log.trace("parseFieldChildren has started.");
                }
                boolean inCustomization = false;
                boolean inArrayOfProperty = false;
                boolean inProperty = false;
                String name = null;
                String value = null;
                int depth = 0;
                do {
                    int event;
                    if ((event = xis.next()) == 2) {
                        if ("Customization".equals(xis.getLocalName())) {
                            inCustomization = false;
                        } else if (inCustomization && "ArrayOfProperty".equals(xis.getLocalName())) {
                            inArrayOfProperty = false;
                        } else if (inArrayOfProperty && "Property".equals(xis.getLocalName())) {
                            inProperty = false;
                            if (name != null && value != null) {
                                if ("SspId".equals(name)) {
                                    field.setTermStoreId(value);
                                } else if ("TermSetId".equals(name)) {
                                    field.setTermSetId(value);
                                } else if ("AnchorId".equals(name)) {
                                    field.setAnchorId(value);
                                } else if (log.isTraceEnabled()) {
                                    log.trace("Ignored field [" + name + "]");
                                }
                            }
                            name = null;
                            value = null;
                        }
                        --depth;
                        if (!log.isTraceEnabled()) continue;
                        log.trace("Depth [" + depth + "], Processed END_ELEMENT [" + xis.getLocalName() + "]");
                        continue;
                    }
                    if (event != 1) continue;
                    if (log.isTraceEnabled()) {
                        log.trace("Depth [" + depth + "], Processing START_ELEMENT [" + xis.getLocalName() + "]");
                    }
                    if ("Customization".equals(xis.getLocalName())) {
                        inCustomization = true;
                        ++depth;
                        continue;
                    }
                    if (inCustomization && "ArrayOfProperty".equals(xis.getLocalName())) {
                        inArrayOfProperty = true;
                        ++depth;
                        continue;
                    }
                    if (inArrayOfProperty && "Property".equals(xis.getLocalName())) {
                        inProperty = true;
                        ++depth;
                        continue;
                    }
                    if (inProperty && "Name".equals(xis.getLocalName())) {
                        name = MspServiceImpl.getCharacterContent(xis, "Name", false);
                        continue;
                    }
                    if (inProperty && "Value".equals(xis.getLocalName())) {
                        value = MspServiceImpl.getCharacterContent(xis, "Value", false);
                        continue;
                    }
                    ++depth;
                } while (depth >= 0);
                if (log.isTraceEnabled()) {
                    log.trace("parseFieldChildren has completed.");
                }
            }
        });
    }

    public List<Map<String, String>> getListData(String projectPath, String listName, String ... attributes) {
        return this.getListData(projectPath, listName, attributes, (MspQueryWriter)null);
    }

    public List<Map<String, String>> getListDataByStringAttributes(String projectPath, String listName, final Map<String, String> attributeNameToValue, String ... attributes) {
        return this.getListData(projectPath, listName, attributes, new MspQueryWriter(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "query");
                xsw.writeStartElement("Query");
                xsw.writeStartElement("Where");
                int countSoFar = 0;
                for (String attribute : attributeNameToValue.keySet()) {
                    if (countSoFar < attributeNameToValue.size() - 1) {
                        xsw.writeStartElement("And");
                    }
                    String value = (String)attributeNameToValue.get(attribute);
                    xsw.writeStartElement("Eq");
                    xsw.writeStartElement("FieldRef");
                    xsw.writeAttribute("Name", attribute);
                    xsw.writeEndElement();
                    xsw.writeStartElement("Value");
                    xsw.writeAttribute("Type", "Text");
                    xsw.writeCharacters(value);
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    ++countSoFar;
                }
                for (int n = 0; n < attributeNameToValue.size() - 1; ++n) {
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
        });
    }

    public List<Map<String, String>> getListDataByMultipleAttributeValues(String projectPath, String listName, final String attributeName, final List<String> searchedValues, String ... attributes) {
        return this.getListData(projectPath, listName, attributes, new MspQueryWriter(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "query");
                xsw.writeStartElement("Query");
                xsw.writeStartElement("Where");
                int countSoFar = 0;
                for (String searchedValue : searchedValues) {
                    if (countSoFar < searchedValues.size() - 1) {
                        xsw.writeStartElement("Or");
                    }
                    xsw.writeStartElement("Eq");
                    xsw.writeStartElement("FieldRef");
                    xsw.writeAttribute("Name", attributeName);
                    xsw.writeEndElement();
                    xsw.writeStartElement("Value");
                    xsw.writeAttribute("Type", "Text");
                    xsw.writeCharacters(searchedValue);
                    xsw.writeEndElement();
                    xsw.writeEndElement();
                    ++countSoFar;
                }
                for (int n = 0; n < searchedValues.size() - 1; ++n) {
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeEndElement();
            }
        });
    }

    private List<Map<String, String>> getListData(final String projectPath, final String listName, final String[] attributes, final MspQueryWriter queryWriter) {
        return this.emitSharepointQuery(MSP_SOAP_NS_URI, "GetListItems", LIST_ITEM_WRAPS, new MspQueryProcessor<List<Map<String, String>>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "listName");
                xsw.writeCharacters(listName);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "rowLimit");
                xsw.writeCharacters("1000");
                xsw.writeEndElement();
                if (queryWriter != null) {
                    queryWriter.writeQueryXml(xsw);
                }
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "queryOptions");
                xsw.writeStartElement("QueryOptions");
                xsw.writeStartElement("IncludeMandatoryColumns");
                xsw.writeCharacters("FALSE");
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildListsPathURI(projectPath);
            }

            @Override
            public List<Map<String, String>> process(XMLStreamReader xis) throws Exception {
                ArrayList<Map<String, String>> data = new ArrayList<Map<String, String>>();
                while (xis.isStartElement() && "row".equals(xis.getLocalName())) {
                    HashMap<String, String> attributeNameToData = new HashMap<String, String>();
                    for (String attribute : attributes) {
                        attributeNameToData.put(attribute, xis.getAttributeValue(null, attribute));
                    }
                    data.add(attributeNameToData);
                    MspServiceImpl.skipChildTags(xis);
                    if (!xis.isEndElement()) continue;
                    xis.nextTag();
                }
                return data;
            }
        });
    }

    public List<Map<String, String>> getListDataByListAndAttributeRest(final String projectPath, final String listId, final String attributeName, final String attributeValue, final String ... attributes) {
        final HashSet<String> attributeSet = new HashSet<String>();
        for (String attribute : attributes) {
            attributeSet.add(attribute);
        }
        return this.emitRestSharepointGet(GET_LIST_ITEMS_REST_WRAPS, new MspQueryProcessor<List<Map<String, String>>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
            }

            @Override
            public URI buildURI() {
                String selectClause;
                String string = selectClause = attributes != null && attributes.length > 0 ? "$select=" : null;
                if (attributes != null) {
                    boolean first = true;
                    for (String attribute : attributes) {
                        selectClause = selectClause + (first ? "" : ",") + attribute;
                        first = false;
                    }
                }
                String filterClause = attributeName != null && attributeValue != null ? "$filter=" + attributeName + " eq '" + attributeValue + "'" : null;
                String parameterClause = "";
                boolean firstParam = true;
                if (selectClause != null) {
                    parameterClause = parameterClause + (firstParam ? "" : "&") + selectClause;
                    firstParam = false;
                }
                if (filterClause != null) {
                    parameterClause = parameterClause + (firstParam ? "" : "&") + filterClause;
                }
                String query = "web/lists('" + listId + "')/items";
                URI uri = MspServiceImpl.this.buildRestURI(projectPath, query, parameterClause);
                if (log.isDebugEnabled()) {
                    log.debug("Will query uri [" + uri + "]");
                }
                return uri;
            }

            @Override
            public List<Map<String, String>> process(XMLStreamReader xis) throws Exception {
                int level = 0;
                boolean withinFeed = false;
                boolean withinEntry = false;
                boolean withinContent = false;
                boolean withinProperties = false;
                ArrayList<Map<String, String>> retList = new ArrayList<Map<String, String>>();
                HashMap<String, String> currInstance = null;
                while (xis.hasNext()) {
                    String localName;
                    if (xis.isStartElement()) {
                        localName = xis.getLocalName();
                        if (level == 4 && withinProperties && attributeSet.contains(localName)) {
                            String content = MspServiceImpl.getCharacterContent(xis, localName, true);
                            currInstance.put(localName, content);
                            continue;
                        }
                        if (level == 0 && "feed".equals(localName)) {
                            withinFeed = true;
                        } else if (level == 1 && withinFeed && "entry".equals(localName)) {
                            withinEntry = true;
                        } else if (level == 2 && withinEntry && "content".equals(localName)) {
                            withinContent = true;
                        } else if (level == 3 && withinContent && "properties".equals(localName)) {
                            withinProperties = true;
                            currInstance = new HashMap<String, String>();
                        }
                        xis.next();
                        ++level;
                        continue;
                    }
                    if (xis.isEndElement()) {
                        localName = xis.getLocalName();
                        xis.next();
                        if (--level == 0 && "feed".equals(localName)) {
                            withinFeed = false;
                            continue;
                        }
                        if (level == 1 && withinFeed && "entry".equals(localName)) {
                            withinEntry = false;
                            continue;
                        }
                        if (level == 2 && withinEntry && "content".equals(localName)) {
                            withinContent = false;
                            continue;
                        }
                        if (level != 3 || !withinContent || !"properties".equals(localName)) continue;
                        withinProperties = false;
                        retList.add(currInstance);
                        currInstance = null;
                        continue;
                    }
                    xis.next();
                }
                return retList;
            }
        });
    }

    public String getPropertyFromGlobalPropertyBagRest(final String attributeName) {
        return this.emitRestSharepointGet(EMPTY_WRAPS, new MspQueryProcessor<String>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildRestURI("", "web/allProperties", null);
            }

            @Override
            public String process(XMLStreamReader xis) throws Exception {
                int level = 0;
                boolean withinEntry = false;
                boolean withinContent = false;
                boolean withinProperties = false;
                String retValue = null;
                while (xis.hasNext()) {
                    String localName;
                    if (xis.isStartElement()) {
                        localName = xis.getLocalName();
                        if (level == 3 && withinProperties && attributeName.equals(localName)) {
                            retValue = MspServiceImpl.getCharacterContent(xis, localName, true);
                            continue;
                        }
                        if (level == 0 && "entry".equals(localName)) {
                            withinEntry = true;
                        } else if (level == 1 && withinEntry && "content".equals(localName)) {
                            withinContent = true;
                        } else if (level == 2 && withinContent && "properties".equals(localName)) {
                            withinProperties = true;
                        }
                        xis.next();
                        ++level;
                        continue;
                    }
                    if (xis.isEndElement()) {
                        localName = xis.getLocalName();
                        xis.next();
                        if (--level == 0 && "entry".equals(localName)) {
                            withinEntry = false;
                            continue;
                        }
                        if (level == 1 && withinEntry && "content".equals(localName)) {
                            withinContent = false;
                            continue;
                        }
                        if (level != 2 || !withinContent || !"properties".equals(localName)) continue;
                        withinProperties = false;
                        continue;
                    }
                    xis.next();
                }
                return retValue;
            }
        });
    }

    private static void skipChildTags(XMLStreamReader xis) throws XMLStreamException {
        int depth = 0;
        while (depth >= 0 && xis.hasNext()) {
            xis.next();
            if (xis.getEventType() == 1) {
                ++depth;
                continue;
            }
            if (xis.getEventType() != 2) continue;
            --depth;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream readDocumentContent(String path) {
        FilterInputStream filterInputStream;
        block8: {
            CloseableHttpResponse resp;
            HttpClientContext context = this.getClientContext();
            CloseableHttpClient client = this.getHttpClient();
            final URI uri = new URI(path);
            if (!(this.baseUrl.getScheme().equals(uri.getScheme()) && this.baseUrl.getHost().equals(uri.getHost()) && uri.getPath() != null && uri.getPath().startsWith(this.baseUrl.getPath()))) {
                throw new DAOException("Given URI [" + uri + "] is not relative to MSP base URI [" + this.baseUrl + "]");
            }
            HttpGet get = new HttpGet(uri);
            CloseableHttpResponse closeable = resp = client.execute((HttpUriRequest)get, (HttpContext)context);
            try {
                MspServiceImpl.checkHttpError(uri, resp);
                FilterInputStream is = new FilterInputStream(resp.getEntity().getContent()){

                    @Override
                    public void close() throws IOException {
                        try {
                            super.close();
                        }
                        catch (IOException e) {
                            log.warn("Error closing input stream for [" + uri + "]", (Throwable)e);
                        }
                        try {
                            resp.close();
                        }
                        catch (IOException e) {
                            log.warn("Error response for [" + uri + "]", (Throwable)e);
                        }
                    }
                };
                closeable = null;
                filterInputStream = is;
                if (closeable == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (closeable != null) {
                        closeable.close();
                    }
                    throw throwable;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DAOException("Caught Exception fetching data from [" + path + "]", (Throwable)e);
                }
            }
            closeable.close();
        }
        return filterInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkCredentials(MspPrincipal principal) {
        HttpClientContext context = this.buildClientContext(principal);
        HttpGet get = new HttpGet(this.baseUrl);
        CloseableHttpClient client = this.getProbeHttpClient();
        HttpClientContext httpClientContext = context;
        synchronized (httpClientContext) {
            boolean bl;
            block23: {
                CloseableHttpResponse resp = client.execute((HttpUriRequest)get, (HttpContext)context);
                try {
                    MspServiceImpl.checkHttpError(this.baseUrl, resp);
                    try (InputStreamReader isr = new InputStreamReader(resp.getEntity().getContent(), "UTF-8");){
                        char[] buf = new char[2048];
                        int n = isr.read(buf);
                        if (n >= 0) {
                            String msg = new String(buf, 0, n);
                            if (log.isDebugEnabled()) {
                                log.debug("GET from [" + this.baseUrl + "] returned message [" + msg + "].");
                            }
                        }
                    }
                    catch (Throwable e) {
                        log.warn("Error parsing error message from [" + this.baseUrl + "]", e);
                    }
                    bl = true;
                    if (resp == null) break block23;
                }
                catch (Throwable throwable) {
                    try {
                        if (resp != null) {
                            try {
                                resp.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug("GET from [" + this.baseUrl + "] catched", (Throwable)e);
                        }
                        return false;
                    }
                }
                resp.close();
            }
            return bl;
        }
    }

    public MspList getListInfo(final String projectPath, final String listId) {
        return this.emitRestSharepointGet(GET_LIST_REST_WRAPS, new MspQueryProcessor<MspList>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildRestURI(projectPath, "web/lists/getbyid('" + listId + "')", null);
            }

            @Override
            public MspList process(XMLStreamReader xis) throws Exception {
                String id = null;
                String title = null;
                String listItemEntityTypeFullName = null;
                while (xis.hasNext()) {
                    if (xis.isStartElement()) {
                        String localName = xis.getLocalName();
                        if ("Id".equals(localName)) {
                            id = MspServiceImpl.getCharacterContent(xis, "Id");
                            continue;
                        }
                        if ("Title".equals(localName)) {
                            title = MspServiceImpl.getCharacterContent(xis, "Title");
                            continue;
                        }
                        if ("ListItemEntityTypeFullName".equals(localName)) {
                            listItemEntityTypeFullName = MspServiceImpl.getCharacterContent(xis, "ListItemEntityTypeFullName");
                            continue;
                        }
                        xis.next();
                        continue;
                    }
                    xis.next();
                }
                MspList mspList = new MspList();
                mspList.setUuid(id);
                mspList.setTitle(title);
                mspList.setListItemEntityTypeFullName(listItemEntityTypeFullName);
                return mspList;
            }
        });
    }

    public List<MspResult> addListItems(String projectPath, String listName, List<Map<String, String>> items) {
        return this.callUpdateListItems(projectPath, listName, items, null, null);
    }

    public List<MspResult> updateListItems(String projectPath, String listName, List<Map<String, String>> items) {
        return this.callUpdateListItems(projectPath, listName, null, items, null);
    }

    public List<MspResult> callUpdateListItems(final String projectPath, final String listName, final List<Map<String, String>> newItems, final List<Map<String, String>> updateItems, final List<Map<String, String>> deleteItems) {
        return this.emitSharepointQuery(MSP_SOAP_NS_URI, "UpdateListItems", UPDATE_LIST_ITEMS_WRAPS, new MspQueryProcessor<List<MspResult>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "listName");
                xsw.writeCharacters(listName);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "updates");
                xsw.writeStartElement("Batch");
                xsw.writeAttribute("OnError", "Return");
                Integer currId = 1;
                if (newItems != null) {
                    currId = this.writeMethodSection(xsw, listName, newItems, "New", currId);
                }
                if (updateItems != null) {
                    currId = this.writeMethodSection(xsw, listName, updateItems, "Update", currId);
                }
                if (deleteItems != null) {
                    currId = this.writeMethodSection(xsw, listName, deleteItems, "Delete", currId);
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
            }

            private Integer writeMethodSection(XMLStreamWriter xsw, String listId, List<Map<String, String>> items, String cmd, Integer currId) throws Exception {
                for (Map<String, String> item : items) {
                    xsw.writeStartElement("Method");
                    xsw.writeAttribute("ID", currId.toString());
                    xsw.writeAttribute("Cmd", cmd);
                    for (String fieldName : item.keySet()) {
                        String value = item.get(fieldName);
                        if (value == null) continue;
                        xsw.writeStartElement("Field");
                        xsw.writeAttribute("Name", fieldName);
                        xsw.writeCharacters(item.get(fieldName));
                        xsw.writeEndElement();
                    }
                    xsw.writeEndElement();
                    Integer n = currId;
                    currId = currId + 1;
                }
                return currId;
            }

            private void writeSetList(XMLStreamWriter xsw, String listId) throws Exception {
                xsw.writeStartElement("SetList");
                xsw.writeAttribute("Scope", "Request");
                xsw.writeCharacters(listId);
                xsw.writeEndElement();
            }

            private void writeSetVar(XMLStreamWriter xsw, String name, String value) throws Exception {
                xsw.writeStartElement("SetVar");
                xsw.writeAttribute("Name", name);
                xsw.writeCharacters(value);
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildListsPathURI(projectPath);
            }

            @Override
            public List<MspResult> process(XMLStreamReader xis) throws Exception {
                Integer key;
                HashMap<Integer, MspResult> idToResult = new HashMap<Integer, MspResult>();
                MspResult currResult = null;
                Integer currId = null;
                boolean insideResult = false;
                while (xis.hasNext()) {
                    String localName;
                    if (xis.isStartElement()) {
                        localName = xis.getLocalName();
                        if (!insideResult && "Result".equals(localName)) {
                            insideResult = true;
                            currResult = new MspResult();
                            String idString = xis.getAttributeValue(null, "ID");
                            String[] idStringTokens = idString.split(",");
                            String id = idStringTokens.length > 0 ? idStringTokens[0] : null;
                            currId = id != null ? Integer.valueOf(id) : null;
                            String command = idStringTokens.length > 1 ? idStringTokens[1] : null;
                            xis.next();
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Result for: Id = [" + id + "], cmd = [" + command + "]");
                            continue;
                        }
                        if (insideResult && "ErrorCode".equals(localName)) {
                            String errorCode = MspServiceImpl.getCharacterContent(xis, "ErrorCode");
                            currResult.setNumericCode(errorCode);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Setting numeric code: " + errorCode);
                            continue;
                        }
                        if (insideResult && "ErrorText".equals(localName)) {
                            String errorText = MspServiceImpl.getCharacterContent(xis, "ErrorText");
                            currResult.setErrorMessage(errorText);
                            if (!log.isDebugEnabled()) continue;
                            log.debug("Setting errorMessage: " + errorText);
                            continue;
                        }
                        xis.next();
                        continue;
                    }
                    if (xis.isEndElement()) {
                        localName = xis.getLocalName();
                        if ("Result".equals(localName)) {
                            currResult.setSuccess(Boolean.valueOf(currResult.getNumericCode() != null && "0x00000000".equals(currResult.getNumericCode())));
                            if (currId != null) {
                                idToResult.put(currId, currResult);
                            } else {
                                log.warn("No id for currResult, please inspect response manually");
                            }
                            insideResult = false;
                            if (log.isDebugEnabled()) {
                                log.debug("Finished Result");
                            }
                            xis.next();
                            continue;
                        }
                        xis.next();
                        continue;
                    }
                    xis.next();
                }
                ArrayList<MspResult> results = new ArrayList<MspResult>();
                if (newItems != null) {
                    for (int n = 0; n < newItems.size(); ++n) {
                        if (idToResult.containsKey(n + 1)) {
                            results.add((MspResult)idToResult.get(n + 1));
                            continue;
                        }
                        results.add(new MspResult());
                    }
                }
                if (updateItems != null) {
                    for (int n = 0; n < updateItems.size(); ++n) {
                        key = (newItems != null ? newItems.size() : 0) + 1 + n;
                        if (idToResult.containsKey(key)) {
                            results.add((MspResult)idToResult.get(key));
                            continue;
                        }
                        results.add(new MspResult());
                    }
                }
                if (deleteItems != null) {
                    for (int n = 0; n < deleteItems.size(); ++n) {
                        key = (newItems != null ? newItems.size() : 0) + 1 + (updateItems != null ? updateItems.size() : 0) + n;
                        if (idToResult.containsKey(key)) {
                            results.add((MspResult)idToResult.get(key));
                            continue;
                        }
                        results.add(new MspResult());
                    }
                }
                return results;
            }
        });
    }

    public void processBatchData(final String projectPath, final String listName, final List<Map<String, String>> newItems, final List<Map<String, String>> updateItems, final List<Map<String, String>> deleteItems) {
        this.emitSharepointQuery(MSP_SOAP_NS_URI, "ProcessBatchData", UPDATE_LIST_ITEMS_WRAPS, new MspQueryProcessor<Void>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "strBatchData");
                xsw.writeStartElement("Batch");
                xsw.writeAttribute("OnError", "Return");
                Integer currId = 1;
                if (newItems != null) {
                    currId = this.writeMethodSection(xsw, listName, newItems, "New", currId);
                }
                if (updateItems != null) {
                    currId = this.writeMethodSection(xsw, listName, updateItems, "Update", currId);
                }
                if (deleteItems != null) {
                    currId = this.writeMethodSection(xsw, listName, deleteItems, "Delete", currId);
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
            }

            private Integer writeMethodSection(XMLStreamWriter xsw, String listName2, List<Map<String, String>> items, String cmd, Integer currId) throws Exception {
                for (Map<String, String> item : items) {
                    xsw.writeStartElement("Method");
                    xsw.writeStartElement("SetList");
                    xsw.writeCharacters(listName2);
                    xsw.writeEndElement();
                    this.writeSetVar(xsw, "Cmd", cmd);
                    for (String fieldName : item.keySet()) {
                        String value = item.get(fieldName);
                        this.writeSetVar(xsw, fieldName, value);
                    }
                    xsw.writeEndElement();
                    Integer n = currId;
                    currId = currId + 1;
                }
                return currId;
            }

            private void writeSetVar(XMLStreamWriter xsw, String name, String value) throws Exception {
                xsw.writeStartElement("SetVar");
                xsw.writeAttribute("Name", name);
                xsw.writeCharacters(value);
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildListsPathURI(projectPath);
            }

            @Override
            public Void process(XMLStreamReader xis) throws Exception {
                return null;
            }
        });
    }

    public MspResult copyIntoItems(final String sourceUrl, final String destPath, final InputStream dataStream, final List<MspFieldValue> fieldValues) {
        return this.emitTmpFileSharepointQuery(MSP_SOAP_NS_URI, "CopyIntoItems", COPY_INTO_ITEMS_WRAPS, new MspQueryProcessor<MspResult>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "SourceUrl");
                xsw.writeCharacters(sourceUrl);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "DestinationUrls");
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "string");
                xsw.writeCharacters(destPath);
                xsw.writeEndElement();
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "Fields");
                for (MspFieldValue fieldValue : fieldValues) {
                    String displayName = fieldValue.getDisplayName();
                    String type = fieldValue.getType().getName();
                    String value = fieldValue.getValue();
                    xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "FieldInformation");
                    xsw.writeAttribute("Type", type);
                    xsw.writeAttribute("Value", value);
                    xsw.writeAttribute("DisplayName", displayName);
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
                try (Base64InputStream base64InputStream = new Base64InputStream(dataStream, true);){
                    int numberOfBytesRead;
                    byte[] buffer = new byte[16384];
                    xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "Stream");
                    while ((numberOfBytesRead = base64InputStream.read(buffer)) >= 0) {
                        String dataString = new String(buffer, 0, numberOfBytesRead, Charset.forName("UTF-8"));
                        xsw.writeCharacters(dataString);
                        if (numberOfBytesRead != -1) continue;
                    }
                    xsw.writeEndElement();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Finished writing Stream data");
                }
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildCopyPathURI("");
            }

            @Override
            public MspResult process(XMLStreamReader xis) throws Exception {
                String resultCodeString = null;
                String errorCode = null;
                String errorMessage = null;
                String destinationUrl = null;
                MspResult result = new MspResult();
                while (xis.isStartElement()) {
                    if ("CopyIntoItemsResult".equals(xis.getLocalName())) {
                        resultCodeString = MspServiceImpl.getCharacterContent(xis, "CopyIntoItemsResult", true);
                        result.setNumericCode(resultCodeString);
                    } else if ("Results".equals(xis.getLocalName())) {
                        xis.nextTag();
                        if ("CopyResult".equals(xis.getLocalName())) {
                            errorCode = xis.getAttributeValue(null, "ErrorCode");
                            errorMessage = xis.getAttributeValue(null, "ErrorMessage");
                            destinationUrl = xis.getAttributeValue(null, "DestinationUrl");
                            result.setErrorCode(errorCode);
                            result.setErrorMessage(errorMessage);
                            result.setUrl(destinationUrl);
                            MspServiceImpl.skipChildTags(xis);
                            xis.nextTag();
                        }
                    }
                    if (!xis.isEndElement()) continue;
                    xis.nextTag();
                }
                boolean success = "0".equals(resultCodeString) && "Success".equals(errorCode);
                result.setSuccess(Boolean.valueOf(success));
                return result;
            }
        });
    }

    public String getProjectPathForListUrl(String listUrl) {
        int secondSlashIndex;
        String baseUrl = this.baseUrl.toString();
        if (!listUrl.startsWith(baseUrl)) {
            throw new IllegalArgumentException("list url [" + listUrl + "] does not start with baseUrl [" + baseUrl + "]");
        }
        String projectPath = listUrl.substring(baseUrl.length());
        if (!projectPath.startsWith("/")) {
            projectPath = "/" + projectPath;
        }
        if ((secondSlashIndex = projectPath.indexOf(47, 1)) == -1) {
            throw new IllegalArgumentException("Path [" + projectPath + "] does not contain a second slash.");
        }
        int thirdSlashIndex = projectPath.indexOf(47, secondSlashIndex + 1);
        if (thirdSlashIndex == -1) {
            throw new IllegalArgumentException("Path [" + projectPath + "] does not contain a third slash.");
        }
        projectPath = projectPath.substring(0, thirdSlashIndex);
        return projectPath;
    }

    public Pair<String, String> getIdsForList(String listUrl) {
        String itemUrl = listUrl + (listUrl.endsWith("/") ? "" : "/") + "Forms/AllItems.aspx";
        return this.getIdsForListItem(itemUrl);
    }

    public Pair<String, String> getIdsForListItem(final String listUrl) {
        return this.emitSharepointQuery(MSP_SOAP_NS_URI, "GetURLSegments", GET_URL_SEGMENTS_WRAPS, new MspQueryProcessor<Pair<String, String>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "strURL");
                xsw.writeCharacters(listUrl);
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                try {
                    URI uri = new URI(listUrl);
                    String path = uri.getPath();
                    log.info("Path is [" + path + "]");
                    if (path.startsWith("/")) {
                        path = path.substring(1);
                    }
                    int firstSlashIndex = path.indexOf(47);
                    int secondSlashIndex = path.indexOf(47, firstSlashIndex + 1);
                    String projectPath = "/" + path.substring(0, secondSlashIndex);
                    URI retURI = MspServiceImpl.this.buildSiteDataURI(projectPath);
                    log.info("returned uri is [" + retURI + "]");
                    return retURI;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public Pair<String, String> process(XMLStreamReader xis) throws Exception {
                boolean result = false;
                String listGuid = null;
                String itemId = null;
                while (xis.isStartElement()) {
                    String urlSegmentsResultString = MspServiceImpl.getCharacterContent(xis, "GetURLSegmentsResult", true);
                    if (urlSegmentsResultString != null && "true".equals(urlSegmentsResultString)) {
                        result = true;
                        continue;
                    }
                    String listIdString = MspServiceImpl.getCharacterContent(xis, "strListID", true);
                    if (listIdString != null) {
                        listGuid = listIdString;
                        continue;
                    }
                    String itemIdString = MspServiceImpl.getCharacterContent(xis, "strItemID", true);
                    if (itemIdString == null) continue;
                    itemId = itemIdString;
                }
                return result ? new Pair(listGuid, itemId) : null;
            }
        });
    }

    public Boolean checkInFile(final String projectPath, final String fileUrl, final String comment, final MspCheckInType checkInType) {
        return this.emitSharepointQuery(MSP_SOAP_NS_URI, "CheckInFile", CHECK_IN_WRAPS, new MspQueryProcessor<Boolean>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "pageUrl");
                xsw.writeCharacters(fileUrl);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "comment");
                xsw.writeCharacters(comment != null ? comment : "");
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_SOAP_NS_URI, "CheckInType");
                xsw.writeCharacters(String.valueOf(checkInType.getValue()));
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildListsPathURI(projectPath);
            }

            @Override
            public Boolean process(XMLStreamReader xis) throws Exception {
                return false;
            }
        });
    }

    public List<MspTerm> getTermsById(final String projectPath, final Integer languageId, final Integer resultCollectionSize, final String termIds) {
        return this.emitSharepointQuery(MSP_TAXONOMY_SOAP_NS_URI, "GetTermsByLabel", GET_TERMS_BY_LABEL_WRAPS, new MspQueryProcessor<List<MspTerm>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "lcid");
                xsw.writeCharacters(languageId.toString());
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "matchOption");
                xsw.writeCharacters("ExactMatch");
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "resultCollectionSize");
                xsw.writeCharacters(resultCollectionSize.toString());
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "termIds");
                xsw.writeCharacters(termIds);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "addIfNotFound");
                xsw.writeCharacters("false");
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildTaxonomyClientServiceURI(projectPath);
            }

            @Override
            public List<MspTerm> process(XMLStreamReader xis) throws Exception {
                String content = MspServiceImpl.getCharacterContent(xis, "GetChildTermsInTermSetResult", true);
                if (log.isTraceEnabled()) {
                    log.trace("Received [" + content + "]");
                }
                return MspServiceImpl.this.parseTerms(content);
            }
        });
    }

    public List<MspTerm> getTermsByLabel(final String projectPath, final Integer languageId, final Integer resultCollectionSize, final String label) {
        return this.emitSharepointQuery(MSP_TAXONOMY_SOAP_NS_URI, "GetTermsByLabel", GET_TERMS_BY_LABEL_WRAPS, new MspQueryProcessor<List<MspTerm>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "label");
                xsw.writeCharacters(label);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "lcid");
                xsw.writeCharacters(languageId.toString());
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "matchOption");
                xsw.writeCharacters("ExactMatch");
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "resultCollectionSize");
                xsw.writeCharacters(resultCollectionSize.toString());
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "termIds");
                xsw.writeCharacters("b6778609-3551-4a32-b317-b1c05954ef05");
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "addIfNotFound");
                xsw.writeCharacters("false");
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildTaxonomyClientServiceURI(projectPath);
            }

            @Override
            public List<MspTerm> process(XMLStreamReader xis) throws Exception {
                String content = MspServiceImpl.getCharacterContent(xis, "GetTermsByLabelResult", true);
                if (log.isTraceEnabled()) {
                    log.trace("Received [" + content + "]");
                }
                return MspServiceImpl.this.parseTerms(content);
            }
        });
    }

    public List<MspTerm> getChildTermsInTermSet(final String projectPath, final String termStoreId, final String termSetId, final Integer languageId) {
        return this.emitSharepointQuery(MSP_TAXONOMY_SOAP_NS_URI, "GetChildTermsInTermSet", GET_CHILD_TERMS_IN_TERM_SET_WRAPS, new MspQueryProcessor<List<MspTerm>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "sspId");
                xsw.writeCharacters(termStoreId);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "lcid");
                xsw.writeCharacters(languageId.toString());
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "termSetId");
                xsw.writeCharacters(termSetId);
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildTaxonomyClientServiceURI(projectPath);
            }

            @Override
            public List<MspTerm> process(XMLStreamReader xis) throws Exception {
                String content = MspServiceImpl.getCharacterContent(xis, "GetChildTermsInTermSetResult", true);
                if (log.isTraceEnabled()) {
                    log.trace("Received [" + content + "]");
                }
                return MspServiceImpl.this.parseTerms(content);
            }
        });
    }

    public List<MspTerm> getChildTermsInTerm(final String projectPath, final String termStoreId, final String termSetId, final String termId, final Integer languageId) {
        return this.emitSharepointQuery(MSP_TAXONOMY_SOAP_NS_URI, "GetChildTermsInTerm", GET_CHILD_TERMS_IN_TERM_WRAPS, new MspQueryProcessor<List<MspTerm>>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "sspId");
                xsw.writeCharacters(termStoreId);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "lcid");
                xsw.writeCharacters(languageId.toString());
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "termId");
                xsw.writeCharacters(termId);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.MSP_TAXONOMY_SOAP_NS_URI, "termSetId");
                xsw.writeCharacters(termSetId);
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildTaxonomyClientServiceURI(projectPath);
            }

            @Override
            public List<MspTerm> process(XMLStreamReader xis) throws Exception {
                String content = MspServiceImpl.getCharacterContent(xis, "GetChildTermsInTermResult", true);
                if (log.isTraceEnabled()) {
                    log.trace("Received [" + content + "]");
                }
                return MspServiceImpl.this.parseTerms(content);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<MspTerm> parseTerms(String content) throws Exception {
        XMLStreamReader innerReader = null;
        try {
            innerReader = MspServiceImpl.openXmlResponse(content, TERM_STORE_WRAPS);
            List<MspTerm> list = this.processTermStoreResponse(innerReader);
            return list;
        }
        finally {
            if (innerReader != null) {
                MspServiceImpl.closeXmlResponse(innerReader);
            }
        }
    }

    private List<MspTerm> processTermStoreResponse(XMLStreamReader xis) throws Exception {
        ArrayList<MspTerm> terms = new ArrayList<MspTerm>();
        while (xis.isStartElement() && "T".equals(xis.getLocalName())) {
            String uuid = xis.getAttributeValue(null, "a9");
            String deprecatedString = xis.getAttributeValue(null, "a21");
            String id = xis.getAttributeValue(null, "a1000");
            if (!"false".equals(deprecatedString)) break;
            MspTerm term = new MspTerm();
            term.setUuid(uuid);
            term.setId(id);
            boolean inLS = false;
            boolean inTMS = false;
            ArrayList<String> allLabels = new ArrayList<String>();
            int depth = 0;
            do {
                int event;
                if ((event = xis.next()) == 2) {
                    if ("LS".equals(xis.getLocalName())) {
                        inLS = false;
                    } else if ("TMS".equals(xis.getLocalName())) {
                        inTMS = false;
                    }
                    --depth;
                    continue;
                }
                if (event != 1) continue;
                if ("LS".equals(xis.getLocalName())) {
                    inLS = true;
                    ++depth;
                    continue;
                }
                if (inLS && "TL".equals(xis.getLocalName())) {
                    String label = xis.getAttributeValue(null, "a32");
                    String defaultString = xis.getAttributeValue(null, "a31");
                    if ("true".equals(defaultString)) {
                        term.setDefaultLabel(label);
                    }
                    allLabels.add(label);
                    ++depth;
                    continue;
                }
                if ("TMS".equals(xis.getLocalName())) {
                    inTMS = true;
                    ++depth;
                    continue;
                }
                if (inTMS && "TM".equals(xis.getLocalName())) {
                    String mayHaveChildrenString = xis.getAttributeValue(null, "a69");
                    if (mayHaveChildrenString != null) {
                        boolean mayHaveChildren = Boolean.parseBoolean(mayHaveChildrenString);
                        term.setMayHaveChildren(mayHaveChildren);
                    } else {
                        term.setMayHaveChildren(false);
                    }
                    ++depth;
                    continue;
                }
                ++depth;
            } while (depth >= 0);
            term.setAllLabels(allLabels);
            terms.add(term);
            log.info("Received term with uuid = [" + term.getUuid() + "], id = [" + term.getId() + "] and allLabels = [" + allLabels + "]");
            xis.nextTag();
        }
        return terms;
    }

    public Map<String, MspTerm> getLabelToTerm(String projectPath, MspListField listField, Integer languageId) {
        String termStoreId = listField.getTermStoreId();
        String termSetId = listField.getTermSetId();
        String anchorId = listField.getAnchorId();
        HashMap<String, MspTerm> idToTerm = new HashMap<String, MspTerm>();
        List<MspTerm> terms = this.getChildTermsInTermSet(projectPath, termStoreId, termSetId, languageId);
        HashSet<String> termIdsLeft = new HashSet<String>();
        this.populateTermContainers(terms, termIdsLeft, idToTerm);
        while (termIdsLeft.size() > 0) {
            terms.clear();
            for (String string : termIdsLeft) {
                if (log.isDebugEnabled()) {
                    log.debug("Querying children of term id [" + string + "]");
                }
                List<MspTerm> currTerms = this.getChildTermsInTerm(projectPath, termStoreId, termSetId, string, languageId);
                MspTerm parentTerm = (MspTerm)idToTerm.get(string);
                parentTerm.setChildren(currTerms);
                terms.addAll(currTerms);
            }
            termIdsLeft.clear();
            this.populateTermContainers(terms, termIdsLeft, idToTerm);
        }
        HashMap<String, MspTerm> labelToTerm = new HashMap<String, MspTerm>();
        if (anchorId == null || "00000000-0000-0000-0000-000000000000".equals(anchorId)) {
            for (MspTerm mspTerm2 : idToTerm.values()) {
                List labels = mspTerm2.getAllLabels();
                for (String label : labels) {
                    labelToTerm.put(label, mspTerm2);
                }
            }
        } else {
            MspTerm mspTerm;
            if (log.isDebugEnabled()) {
                log.debug("Case anchorId set, anchorId = [" + anchorId + "]");
                for (MspTerm mspTerm2 : idToTerm.values()) {
                    log.debug("idToTerm contains term: uuid = [" + mspTerm2.getUuid() + "]; labels = [" + mspTerm2.getAllLabels() + "]");
                }
            }
            if ((mspTerm = (MspTerm)idToTerm.get(anchorId)) != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Found anchorTerm [" + mspTerm.getUuid() + "] with labels [" + mspTerm.getAllLabels() + "]");
                }
                this.addChildTerms(mspTerm, labelToTerm);
            } else {
                log.warn("Found no anchorTerm for termStoreId [" + termStoreId + "], termSetId [" + termSetId + "] and anchorId [" + anchorId + "]");
            }
        }
        if (log.isDebugEnabled()) {
            for (String label : labelToTerm.keySet()) {
                log.debug("Found term [" + label + "] with id [" + ((MspTerm)labelToTerm.get(label)).getId() + "]");
            }
        }
        return labelToTerm;
    }

    private void populateTermContainers(List<MspTerm> terms, Set<String> termIdsLeft, Map<String, MspTerm> idToTerm) {
        for (MspTerm term : terms) {
            if (term.isMayHaveChildren()) {
                termIdsLeft.add(term.getUuid());
            }
            idToTerm.put(term.getUuid(), term);
        }
    }

    private void addChildTerms(MspTerm term, Map<String, MspTerm> labelToTerm) {
        List allLabels = term.getAllLabels();
        for (String label : allLabels) {
            labelToTerm.put(label, term);
        }
        List childTerms = term.getChildren();
        if (childTerms != null) {
            for (MspTerm childTerm : childTerms) {
                this.addChildTerms(childTerm, labelToTerm);
            }
        }
    }

    public String getTaxonomyMultiString(String projectPath, MspListField mspListField, Set<String> labels) {
        String termStoreId = mspListField.getTermStoreId();
        String termSetId = mspListField.getTermSetId();
        Integer languageId = 3079;
        List<MspTerm> terms = this.getChildTermsInTermSet(projectPath, termStoreId, termSetId, languageId);
        HashMap<String, MspTerm> labelToTerm = new HashMap<String, MspTerm>();
        for (MspTerm term : terms) {
            for (String label : term.getAllLabels()) {
                labelToTerm.put(label, term);
            }
        }
        return this.getTaxonomyMultiStringGivenTerms(projectPath, labelToTerm, labels);
    }

    public String getTaxonomyMultiStringGivenTerms(String projectPath, Map<String, MspTerm> labelToTerm, Set<String> labels) {
        ArrayList<String> labelsList = new ArrayList<String>();
        for (String label : labels) {
            labelsList.add(label);
        }
        Collections.sort(labelsList);
        String resultString = "";
        boolean first = true;
        for (String label : labelsList) {
            MspTerm term = labelToTerm.get(label);
            if (term == null) {
                log.warn("Term [" + label + "] not found, will ignore it.");
                continue;
            }
            resultString = resultString + (first ? "" : ";#") + "-1;#" + term.getDefaultLabel() + "|" + term.getUuid();
            first = false;
        }
        return resultString;
    }

    private static String getCharacterContent(XMLStreamReader xis, String tagName) throws XMLStreamException {
        return MspServiceImpl.getCharacterContent(xis, tagName, true);
    }

    private static String getCharacterContent(XMLStreamReader xis, String tagName, boolean skipEndTag) throws XMLStreamException {
        String localName = xis.getLocalName();
        String result = null;
        if (tagName.equals(localName)) {
            while (xis.hasNext()) {
                xis.next();
                if (xis.getEventType() == 2) {
                    if (!skipEndTag || !xis.hasNext()) break;
                    xis.nextTag();
                    break;
                }
                if (xis.getEventType() == 4) {
                    result = result == null ? xis.getText() : result + xis.getText();
                    continue;
                }
                throw new IllegalArgumentException("getCharacterContent may only be called, if a node with character content (and nothing else) is expected.");
            }
        }
        return result;
    }

    public void getListCollection() {
        this.emitSharepointQuery(MSP_SOAP_NS_URI, "GetListCollection", GET_LIST_COLLECTION_WRAPS, new MspQueryProcessor<Void>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildListsPathURI("");
            }

            @Override
            public Void process(XMLStreamReader xis) throws Exception {
                return null;
            }
        });
    }

    private XMLStreamWriter openStreamWriterAndStartEnvelope(OutputStream outputStream, String namespaceUri, String method) throws XMLStreamException {
        XMLStreamWriter xsw = XOF.createXMLStreamWriter(outputStream);
        xsw.setNamespaceContext(MSP_SOAP_NAMESPACE_CONTEXT);
        xsw.writeStartDocument();
        xsw.writeStartElement(SOAP_ENVELOPE_NS_URI, "Envelope");
        xsw.writeNamespace("soap", SOAP_ENVELOPE_NS_URI);
        xsw.writeNamespace("msp", MSP_SOAP_NS_URI);
        xsw.writeStartElement(SOAP_ENVELOPE_NS_URI, "Body");
        xsw.writeStartElement(namespaceUri, method);
        return xsw;
    }

    private void finishEnvelopeAndCloseWriter(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndElement();
        xsw.writeEndDocument();
        xsw.close();
    }

    private XMLStreamWriter openStreamWriterForRestXmlPayload(ByteArrayOutputStream byteArrayOutputStream) throws XMLStreamException {
        XMLStreamWriter xsw = XOF.createXMLStreamWriter(byteArrayOutputStream);
        xsw.setNamespaceContext(W3C_ATOM_NAMESPACE_CONTEXT);
        xsw.writeStartDocument();
        xsw.writeStartElement(W3C_ATOM_NS_URI, "entry");
        xsw.writeNamespace("d", MS_DATASERVICES_NS_URI);
        xsw.writeNamespace("m", MS_METADATA_NS_URI);
        return xsw;
    }

    private void finishStreamWriterForRestXml(XMLStreamWriter xsw) throws XMLStreamException {
        xsw.writeEndElement();
        xsw.writeEndDocument();
        xsw.close();
    }

    private void printPayloadToDebug(byte[] payload) {
        if (log.isDebugEnabled()) {
            try {
                log.debug("payload = [{}]", (Object)new String(payload, "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                log.error("UTF-8 not found", (Throwable)e);
            }
        }
    }

    /*
     * Exception decompiling
     */
    private <T> T emitTmpFileSharepointQuery(String namespaceUri, String fct, String[] wraps, MspQueryProcessor<T> queryProcessor) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T emitSharepointQuery(String namespaceUri, String fct, String[] wraps, MspQueryProcessor<T> queryProcessor) {
        HttpClientContext context = this.getClientContext();
        CloseableHttpClient client = this.getHttpClient();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            XMLStreamWriter xsw = this.openStreamWriterAndStartEnvelope(bos, namespaceUri, fct);
            queryProcessor.writeQueryXml(xsw);
            this.finishEnvelopeAndCloseWriter(xsw);
        }
        catch (Exception e) {
            throw new DAOException((Throwable)e);
        }
        byte[] payload = bos.toByteArray();
        this.printPayloadToDebug(payload);
        URI uri = queryProcessor.buildURI();
        if (log.isDebugEnabled()) {
            log.debug("Querying URI [" + uri + "]");
        }
        HttpPost post = new HttpPost(uri);
        ByteArrayEntity entity = new ByteArrayEntity(payload, ContentType.TEXT_XML.withCharset("UTF-8"));
        post.setEntity((HttpEntity)entity);
        HttpClientContext httpClientContext = context;
        synchronized (httpClientContext) {
            try {
                T ret;
                CloseableHttpResponse resp = client.execute((HttpUriRequest)post, (HttpContext)context);
                MspServiceImpl.checkHttpError(uri, resp);
                if (wraps != null) {
                    XMLStreamReader xis = null;
                    try {
                        xis = MspServiceImpl.openXmlResponse(uri, resp, wraps);
                        ret = queryProcessor.process(xis);
                    }
                    finally {
                        if (xis != null) {
                            MspServiceImpl.closeXmlResponse(xis);
                        }
                    }
                } else {
                    ret = null;
                }
                T t = ret;
                return t;
                finally {
                    if (resp != null) {
                        resp.close();
                    }
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DAOException((Throwable)e);
            }
        }
    }

    public void updateListItemRest(final String projectPath, final String listItemEntityTypeFullName, final String listId, final String itemId, final Map<String, String> attributeToValue) {
        this.emitRestSharepointPost(new MspQueryProcessor<Void>(){

            @Override
            public void writeQueryXml(XMLStreamWriter xsw) throws Exception {
                xsw.writeAttribute(MspServiceImpl.MS_METADATA_NS_URI, "type", listItemEntityTypeFullName);
                xsw.writeStartElement(MspServiceImpl.W3C_ATOM_NS_URI, "category");
                xsw.writeAttribute("term", listItemEntityTypeFullName);
                xsw.writeAttribute("scheme", MspServiceImpl.MS_DATASERVICES_SCHEME_URL);
                xsw.writeEndElement();
                xsw.writeStartElement(MspServiceImpl.W3C_ATOM_NS_URI, "content");
                xsw.writeAttribute("type", "application/xml");
                xsw.writeStartElement(MspServiceImpl.MS_METADATA_NS_URI, "properties");
                for (String attribute : attributeToValue.keySet()) {
                    xsw.writeStartElement(MspServiceImpl.MS_DATASERVICES_NS_URI, attribute);
                    xsw.writeCharacters((String)attributeToValue.get(attribute));
                    xsw.writeEndElement();
                }
                xsw.writeEndElement();
                xsw.writeEndElement();
            }

            @Override
            public URI buildURI() {
                return MspServiceImpl.this.buildRestURI(projectPath, "web/lists/getbyid('" + listId + "')/items(" + itemId + ")", null);
            }

            @Override
            public Void process(XMLStreamReader xis) throws Exception {
                return null;
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T emitRestSharepointGet(String[] wraps, MspQueryProcessor<T> queryProcessor) {
        HttpClientContext context = this.getClientContext();
        CloseableHttpClient client = this.getHttpClient();
        URI uri = queryProcessor.buildURI();
        if (log.isDebugEnabled()) {
            log.debug("Querying URI [" + uri + "]");
        }
        HttpGet get = new HttpGet(uri);
        HttpClientContext httpClientContext = context;
        synchronized (httpClientContext) {
            try {
                CloseableHttpResponse response = client.execute((HttpUriRequest)get, (HttpContext)context);
                T t = MspServiceImpl.processXmlResponse(uri, wraps, response, queryProcessor);
                return t;
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T emitRestSharepointPost(MspQueryProcessor<T> queryProcessor) {
        HttpClientContext context = this.getClientContext();
        CloseableHttpClient client = this.getHttpClient();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            XMLStreamWriter xsw = this.openStreamWriterForRestXmlPayload(byteArrayOutputStream);
            queryProcessor.writeQueryXml(xsw);
            this.finishStreamWriterForRestXml(xsw);
        }
        catch (Exception e) {
            throw new DAOException((Throwable)e);
        }
        byte[] payload = byteArrayOutputStream.toByteArray();
        this.printPayloadToDebug(payload);
        URI uri = queryProcessor.buildURI();
        if (log.isDebugEnabled()) {
            log.debug("Querying URI [" + uri + "]");
        }
        HttpPost post = new HttpPost(uri);
        ContentType contentType = ContentType.parse((String)"application/atom+xml;odata=verbose;charset=utf-8");
        ByteArrayEntity entity = new ByteArrayEntity(payload, contentType);
        post.setHeader("X-HTTP-Method", "MERGE");
        post.setHeader("IF-MATCH", "*");
        post.setEntity((HttpEntity)entity);
        HttpClientContext httpClientContext = context;
        synchronized (httpClientContext) {
            try {
                CloseableHttpResponse response = client.execute((HttpUriRequest)post, (HttpContext)context);
                T t = MspServiceImpl.processXmlResponse(uri, null, response, queryProcessor);
                return t;
                finally {
                    if (response != null) {
                        response.close();
                    }
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T> T processXmlResponse(URI uri, String[] wraps, CloseableHttpResponse response, MspQueryProcessor<T> queryProcessor) {
        try {
            MspServiceImpl.checkHttpError(uri, response);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 204) {
                return null;
            }
            if (wraps == null) return null;
            XMLStreamReader xis = null;
            try {
                xis = MspServiceImpl.openXmlResponse(uri, response, new String[0]);
                T t = queryProcessor.process(xis);
                return t;
            }
            finally {
                if (xis != null) {
                    MspServiceImpl.closeXmlResponse(xis);
                }
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DAOException((Throwable)e);
        }
    }

    public String triggerExportPlanningNotificationOrdersToMsp(Long organisationPersonId, Long networkId, String mspProjectPath, List<Long> workflowEntityIds) {
        PlanningNotificationOrderMspExportCallable job = new PlanningNotificationOrderMspExportCallable(this.planningNotificationService, organisationPersonId, networkId, mspProjectPath, workflowEntityIds);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public String triggerExportPlanningNotificationReportToMsp(Long organisationPersonId, String jobId, String mspDestUrl) {
        PlanningReportMspExportCallable job = new PlanningReportMspExportCallable(this.planningNotificationService, organisationPersonId, jobId, mspDestUrl);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public String triggerExportDocumentsToMspNow() {
        NightlyDocumentCallable job = new NightlyDocumentCallable(this.documentService);
        UUID uuid = this.oneTimeScheduler.scheduleJob((Callable)((Object)job));
        return uuid.toString();
    }

    public static String formatMspUtcMillis(Long utcMillis) {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
        String dateString = utcMillis != null ? DateHelper.formatUtcMillis(utcMillis, "Europe/Vienna", dateFormatPattern) : null;
        return dateString;
    }

    public static String formatMspUtcSecondsMillis(Double utcSeconds) {
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle();
        String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
        String dateString = utcSeconds != null ? DateHelper.formatUtcSeconds(utcSeconds, "Europe/Vienna", dateFormatPattern) : null;
        return dateString;
    }

    public String getRelativeMspUrl(String absoluteMspUrl) {
        String baseUrlString = this.baseUrl.toString();
        if (absoluteMspUrl.startsWith(baseUrlString)) {
            String postfix = absoluteMspUrl.substring(baseUrlString.length());
            if (!postfix.startsWith("/")) {
                postfix = "/" + postfix;
            }
            return postfix;
        }
        log.warn("Did not find msp base url [" + baseUrlString + "] as prefix of absolute url [" + absoluteMspUrl + "]; will leave it unchanged.");
        return absoluteMspUrl;
    }

    public String getAbsoluteMspUrl(String relativeMspUrl) {
        if (relativeMspUrl.startsWith("http")) {
            log.warn("getAbsoluteMspUrl was feeded with absolute url [" + relativeMspUrl + "]; will do nothing about it.");
            return relativeMspUrl;
        }
        String result = this.baseUrl.toString();
        if (!result.endsWith("/")) {
            result = result + "/";
        }
        result = result + (relativeMspUrl.startsWith("/") ? relativeMspUrl.substring(1) : relativeMspUrl);
        return result;
    }

    static {
        QUERY_ITEM_WRAPS = new String[]{"query", "PrimaryQueryResult", "RelevantResults", "Table", "Rows"};
        GET_LIST_REST_WRAPS = new String[]{"entry", "content", "properties"};
        GET_LIST_ITEMS_REST_WRAPS = new String[]{"feed"};
        GET_LIST_WRAPS = new String[]{"Envelope", "Body", "GetListResponse", "GetListResult", "List", "Fields"};
        LIST_ITEM_WRAPS = new String[]{"Envelope", "Body", "GetListItemsResponse", "GetListItemsResult", "listitems", "data"};
        LIST_COLLECTION_WRAPS = new String[]{"Envelope", "Body", "GetListCollectionResponse", "GetListCollectionResult", "Lists"};
        UPDATE_LIST_ITEMS_WRAPS = new String[]{"Envelope", "Body", "UpdateListItemsResponse", "UpdateListItemsResult", "Results"};
        COPY_INTO_ITEMS_WRAPS = new String[]{"Envelope", "Body", "CopyIntoItemsResponse"};
        GET_URL_SEGMENTS_WRAPS = new String[]{"Envelope", "Body", "GetURLSegmentsResponse"};
        GET_LIST_COLLECTION_WRAPS = new String[0];
        GET_CHILD_TERMS_IN_TERM_SET_WRAPS = new String[]{"Envelope", "Body", "GetChildTermsInTermSetResponse"};
        GET_CHILD_TERMS_IN_TERM_WRAPS = new String[]{"Envelope", "Body", "GetChildTermsInTermResponse"};
        GET_TERMS_BY_LABEL_WRAPS = new String[]{"Envelope", "Body", "GetTermsByLabelResponse"};
        TERM_STORE_WRAPS = new String[]{"TermStore"};
        CHECK_IN_WRAPS = new String[]{"Envelope", "Body", "CheckInFileResponse"};
        EMPTY_WRAPS = new String[0];
        XOF.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.TRUE);
        MSP_SOAP_NAMESPACE_CONTEXT = new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return Collections.singleton(this.getPrefix(namespaceURI)).iterator();
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if ("http://www.w3.org/2001/XMLSchema".equals(namespaceURI)) {
                    return "s";
                }
                if (MspServiceImpl.SOAP_ENVELOPE_NS_URI.equals(namespaceURI)) {
                    return "soap";
                }
                if (MspServiceImpl.MSP_SOAP_NS_URI.equals(namespaceURI)) {
                    return "msp";
                }
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if ("s".equals(prefix)) {
                    return "http://www.w3.org/2001/XMLSchema";
                }
                if ("soap".equals(prefix)) {
                    return MspServiceImpl.SOAP_ENVELOPE_NS_URI;
                }
                if ("msp".equals(prefix)) {
                    return MspServiceImpl.MSP_SOAP_NS_URI;
                }
                return null;
            }
        };
        W3C_ATOM_NAMESPACE_CONTEXT = new NamespaceContext(){

            public Iterator getPrefixes(String namespaceURI) {
                return Collections.singleton(this.getPrefix(namespaceURI)).iterator();
            }

            @Override
            public String getPrefix(String namespaceURI) {
                if (MspServiceImpl.MS_DATASERVICES_NS_URI.equals(namespaceURI)) {
                    return "d";
                }
                if (MspServiceImpl.MS_METADATA_NS_URI.equals(namespaceURI)) {
                    return "m";
                }
                return null;
            }

            @Override
            public String getNamespaceURI(String prefix) {
                if ("d".equals(prefix)) {
                    return MspServiceImpl.MS_DATASERVICES_NS_URI;
                }
                if ("m".equals(prefix)) {
                    return MspServiceImpl.MS_METADATA_NS_URI;
                }
                return null;
            }
        };
    }

    private static interface MspQueryProcessor<T> {
        public void writeQueryXml(XMLStreamWriter var1) throws Exception;

        public URI buildURI();

        public T process(XMLStreamReader var1) throws Exception;
    }

    private static interface MspQueryWriter {
        public void writeQueryXml(XMLStreamWriter var1) throws Exception;
    }
}

