/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.service;

import at.cdes.api.service.ApplicationUrlResolver;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseProxyApplicationUrlResolver
implements ApplicationUrlResolver {
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyApplicationUrlResolver.class);
    private String externalUserUrl;
    private String reverseProxyIp;
    private String internalUserUrl;

    public void setExternalUserUrl(String externalUserUrl) {
        this.externalUserUrl = externalUserUrl;
    }

    public void setReverseProxyIp(String reverseProxyIp) {
        this.reverseProxyIp = reverseProxyIp;
    }

    public void setInternalUserUrl(String internalUserUrl) {
        this.internalUserUrl = internalUserUrl;
    }

    public String resolveApplicationUrl(HttpServletRequest req) {
        if (log.isTraceEnabled()) {
            Enumeration headerNames = req.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                log.trace("resolveApplicationUrl received header [" + headerName + "] with value [" + req.getHeader(headerName));
            }
        }
        if (this.reverseProxyIp == null || this.reverseProxyIp.length() == 0) {
            return this.internalUserUrl;
        }
        if (this.reverseProxyIp.equals(req.getRemoteAddr())) {
            return this.externalUserUrl;
        }
        return this.internalUserUrl;
    }
}

