/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Country;
import at.cdes.api.dto.Localisation;
import at.cdes.impl.dao.GenLocalisationDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcLocalisationDAO
extends AbstrIdDAO<Localisation>
implements GenLocalisationDAO {
    public AbstractJdbcLocalisationDAO() {
        super(Localisation.class, "id", "localisation", new String[]{"id", "name", "country_id", "language_code", "description"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcLocalisationDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "country_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "language_code") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcLocalisationDAO.getSelectClauseForDto("localisation", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcLocalisationDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".country_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "country_id") + "," + entityLocalName + ".language_code" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "language_code") + "," + entityLocalName + ".description" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "description") + " ";
    }

    protected Localisation fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Localisation localisation = new Localisation();
        localisation.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        localisation.setName(rs.getString(++columnIndex));
        localisation.setCountryId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        localisation.setLanguageCode(rs.getString(++columnIndex));
        localisation.setDescription(rs.getString(++columnIndex));
        return localisation;
    }

    public static Localisation fillLocalisationFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Localisation localisation = new Localisation();
        localisation.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        localisation.setName(rs.getString(columnIndex.incrementAndGet()));
        localisation.setCountryId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        localisation.setLanguageCode(rs.getString(columnIndex.incrementAndGet()));
        localisation.setDescription(rs.getString(columnIndex.incrementAndGet()));
        return localisation;
    }

    public static Localisation fillLocalisationFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcLocalisationDAO.fillLocalisationFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 5;
    }

    public int update(Localisation dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Localisation> dtos) {
        Iterator<Localisation> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Localisation localisation) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)localisation.getId());
        statement.setString(2, localisation.getName());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)localisation.getCountryId());
        statement.setString(4, localisation.getLanguageCode());
        statement.setString(5, localisation.getDescription());
    }

    @Override
    public List<Localisation> getByCountry(Country country) {
        return this.getByCountry(country.getId());
    }

    @Override
    public List<Localisation> getByCountry(final Long countryId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"country_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, countryId);
            }
        });
    }

    @Override
    public List<Localisation> getByCountrys(Collection<Long> countryId) {
        if (countryId.isEmpty()) {
            return new ArrayList<Localisation>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[countryId.size()];
        int n = 0;
        Iterator<Long> it = countryId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"country_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

