/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.joinDto.DocumentReleaseContextJoin;
import at.cdes.impl.dao.DocumentReleaseDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcDocumentReleaseDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcDocumentReleaseDAO
extends AbstractJdbcDocumentReleaseDAO
implements DocumentReleaseDAO {
    @Override
    public List<DocumentRelease> getReleasedDocuments(final List<Long> documentIds, final Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentReleaseDAO.getSelectClauseForDto() + "FROM document_release, document_list_release WHERE document_list_release.version = (SELECT MAX(document_list_release_local.version) FROM document_list_release document_list_release_local WHERE document_list_release_local.sub_project_id = ?) AND document_release.document_list_id = document_list_release.id AND document_release.document_id IN (";
        for (int n = 0; n < documentIds.size(); ++n) {
            sql = sql + "?";
            if (n >= documentIds.size() - 1) continue;
            sql = sql + ", ";
        }
        sql = sql + ")";
        List releasedDocuments = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentRelease>>(){

            public List<DocumentRelease> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                for (Long documentId : documentIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentRelease> ret = new ArrayList<DocumentRelease>();
                while (rs.next()) {
                    ret.add(JdbcDocumentReleaseDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
        return releasedDocuments;
    }

    @Override
    public List<DocumentRelease> getReleasedDocuments(final Long documentListId, final Integer version) {
        String sql = "SELECT " + JdbcDocumentReleaseDAO.getSelectClauseForDto() + "FROM document_release document_release WHERE document_release.document_list_id IN (SELECT id FROM document_list_release WHERE document_list_id = ? AND version = ?)";
        List releasedDocuments = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentRelease>>(){

            public List<DocumentRelease> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentListId);
                JDBCHelper.setInt((PreparedStatement)statement, (int)2, (Number)version);
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentRelease> ret = new ArrayList<DocumentRelease>();
                while (rs.next()) {
                    ret.add(JdbcDocumentReleaseDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
        return releasedDocuments;
    }

    @Override
    public DocumentRelease getReleasedDocument(Long documentId) {
        String sql = "SELECT " + JdbcDocumentReleaseDAO.getSelectClauseForDto() + "\n     FROM document\n     JOIN document_list         ON document_list.id = document.id\nLEFT JOIN document_list_release ON document_list_release.document_list_id = document_list.id\n                               AND document_list_release.version = (document_list.version - 1)\nLEFT JOIN document_release      ON document_release.document_id = document.id\n                               AND document_release.document_list_id = document_list_release.id\nWHERE document.id = ?\n";
        return (DocumentRelease)this.performWithPreparedStatement(sql, statement -> {
            JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentId);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                return this.fillDtoFromResultSet(rs);
            }
            return null;
        });
    }

    @Override
    public List<DocumentReleaseContextJoin> getDocumentReleaseContextJoinsBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentReleaseDAO.getDocumentReleaseContextJoinSelectClause() + "FROM sub_project JOIN project                    ON sub_project.project_id = project.id JOIN network                    ON project.network_id = network.id JOIN document_list              ON document_list.sub_project_id = sub_project.id JOIN document_list_release      ON document_list_release.document_list_id = document_list.id AND document_list_release.version = document_list.version - 1 JOIN document_release           ON document_release.document_list_id = document_list_release.id JOIN document                   ON document_release.document_id = document.id JOIN object_planner             ON document.object_planner_id = object_planner.id JOIN object                     ON object_planner.object_id = object.id JOIN object_list                ON object.object_list_id = object_list.id AND object_list.sub_project_id = sub_project.id JOIN object_list_release        ON object_list_release.object_list_id = object_list.id AND object_list_release.version = object_list.version - 1 LEFT JOIN object_release             ON object_release.object_id = object.id AND object_release.object_list_release_id = object_list_release.id LEFT JOIN object_planner_release     ON object_planner_release.object_planner_id = object_planner.id AND object_planner_release.object_id = object_release.id WHERE sub_project.id = ? AND document.invalidated = 0 ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcDocumentReleaseDAO::fillDocumentReleaseContextJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }

    @Override
    public Map<Long, DocumentRelease> getDocumentVersionIdToDocumentRelease(Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentReleaseDAO.getSelectClauseForDto() + ", document_version.id FROM document_list JOIN document              ON document.document_list_id = document_list.id JOIN document_version      ON document_version.document_id = document.id JOIN document_list_release ON      document_list_release.sub_project_id = document_list.sub_project_id AND document_list_release.version = document_list.version - 1 JOIN document_release      ON      document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id WHERE document_list.sub_project_id = ? ";
        return (Map)this.performWithPreparedStatement(sql, statement -> {
            JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId);
            ResultSet rs = statement.executeQuery();
            HashMap<Long, DocumentRelease> documentVersionIdToDocumentRelease = new HashMap<Long, DocumentRelease>();
            while (rs.next()) {
                DocumentRelease documentRelease = this.fillDtoFromResultSet(rs);
                int numberOfAttributes = JdbcDocumentReleaseDAO.getNumberOfDtoAttributes();
                Long documentVersionId = JDBCHelper.getLong((ResultSet)rs, (int)(numberOfAttributes + 1));
                documentVersionIdToDocumentRelease.put(documentVersionId, documentRelease);
            }
            return documentVersionIdToDocumentRelease;
        });
    }

    @Override
    public List<DocumentRelease> getActiveBySubProject(final Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentReleaseDAO.getSelectClauseForDto() + "FROM document_list JOIN document              ON document.document_list_id = document_list.id JOIN document_list_release ON      document_list_release.sub_project_id = document_list.sub_project_id AND document_list_release.version = document_list.version - 1 JOIN document_release      ON      document_release.document_id = document.id AND document_release.document_list_id = document_list_release.id WHERE document_list.sub_project_id = ? ";
        List releasedDocuments = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentRelease>>(){

            public List<DocumentRelease> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<DocumentRelease> ret = new ArrayList<DocumentRelease>();
                while (rs.next()) {
                    ret.add(JdbcDocumentReleaseDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
        return releasedDocuments;
    }
}

