/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Organisation;
import at.cdes.api.joinDto.OrganisationDeleteJoin;
import at.cdes.api.joinDto.OrganisationJoin;
import at.cdes.api.organisation.searchModel.OrganisationSearchModel;
import at.cdes.impl.dao.OrganisationDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcOrganisationDAO;
import at.cdes.impl.dao.unionComponent.OrganisationDeleteUnionComponent;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcOrganisationDAO
extends AbstractJdbcOrganisationDAO
implements OrganisationDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcOrganisationDAO.class);

    @Override
    public List<Organisation> getNetworkOrganisationNames(final Long networkId, final Boolean consortiumFlag) {
        String sql = "SELECT DISTINCT id, name, consortium_flag FROM organisation LEFT JOIN network_organisation             ON network_organisation.organisation_id = organisation.id WHERE 1=1 ";
        if (networkId != null) {
            sql = sql + "AND network_organisation.network_id = ? ";
        }
        if (consortiumFlag != null) {
            sql = sql + "AND organisation.consortium_flag = ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Organisation>>(){

            public List<Organisation> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (networkId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                }
                if (consortiumFlag != null) {
                    JDBCHelper.setBoolean((PreparedStatement)statement, (int)currIndex++, (Boolean)consortiumFlag);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<Organisation> ret = new ArrayList<Organisation>();
                while (rs.next()) {
                    Organisation organisation = new Organisation(true);
                    organisation.setId(JDBCHelper.getLong((ResultSet)rs, (int)1));
                    organisation.setName(rs.getString(2));
                    organisation.setConsortiumFlag(Boolean.valueOf(rs.getBoolean(3)));
                    ret.add(organisation);
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationJoin> getNetworkOrganisationJoins(final List<Long> networkIds, final Boolean consortiumFlag) {
        String sql = "SELECT " + JdbcOrganisationDAO.getOrganisationJoinSelectClause() + "FROM ((        organisation LEFT JOIN countries country     ON organisation.country_id = country.id) LEFT JOIN network_organisation             ON network_organisation.organisation_id = organisation.id) WHERE 1=1 ";
        if (networkIds != null && networkIds.size() > 0) {
            sql = sql + "AND network_organisation.network_id IN (" + QueryHelper.getPlaceHolderSequence(networkIds.size()) + ") ";
        }
        if (consortiumFlag != null) {
            sql = sql + "AND organisation.consortium_flag = ? ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationJoin>>(){

            public List<OrganisationJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                if (networkIds != null) {
                    for (Long networkId : networkIds) {
                        JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
                    }
                }
                if (consortiumFlag != null) {
                    JDBCHelper.setBoolean((PreparedStatement)statement, (int)currIndex++, (Boolean)consortiumFlag);
                }
                ResultSet rs = statement.executeQuery();
                HashMap<Long, OrganisationJoin> idToOrganisationJoin = new HashMap<Long, OrganisationJoin>();
                while (rs.next()) {
                    OrganisationJoin organisationJoin = JdbcOrganisationDAO.fillOrganisationJoinFromResultSet(rs);
                    Long organisationId = organisationJoin.getOrganisationId();
                    idToOrganisationJoin.put(organisationId, organisationJoin);
                }
                ArrayList<OrganisationJoin> organisationJoins = new ArrayList<OrganisationJoin>();
                organisationJoins.addAll(idToOrganisationJoin.values());
                return organisationJoins;
            }
        });
    }

    @Override
    public List<Organisation> getProjectOrganisations(final Long projectId) {
        String sql = "SELECT DISTINCT " + JdbcOrganisationDAO.getSelectClauseForDto() + "FROM (((   project_participation JOIN project_participant      ON project_participant.participation_id = project_participation.id) JOIN organisation_person      ON project_participant.organisation_person_id = organisation_person.id) JOIN organisation             ON organisation_person.organisation_id = organisation.id) WHERE       project_participation.project_id = ? AND project_participation.invalidated = 0 AND project_participant.inactive_flag = 0 AND organisation_person.retired_flag = 0 ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Organisation>>(){

            public List<Organisation> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<Organisation> ret = new ArrayList<Organisation>();
                while (rs.next()) {
                    Organisation organisation = JdbcOrganisationDAO.fillOrganisationFromResultSet(rs);
                    ret.add(organisation);
                }
                return ret;
            }
        });
    }

    @Override
    public List<Organisation> getByConsortiumFlag(Boolean consortiumFlag) {
        String sql = "SELECT " + JdbcOrganisationDAO.getSelectClauseForDto() + "FROM organisation WHERE 1=1 ";
        if (consortiumFlag != null) {
            sql = consortiumFlag != false ? sql + "AND consortium_flag = 1" : sql + "AND consortium_flag = 0";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<Organisation>>(){

            public List<Organisation> perform(PreparedStatement statement) throws Exception {
                ResultSet rs = statement.executeQuery();
                ArrayList<Organisation> ret = new ArrayList<Organisation>();
                while (rs.next()) {
                    Organisation organisation = JdbcOrganisationDAO.fillOrganisationFromResultSet(rs);
                    ret.add(organisation);
                }
                return ret;
            }
        });
    }

    @Override
    public OrganisationJoin getOrganisationJoinById(final Long organisationId) {
        String sql = "SELECT " + JdbcOrganisationDAO.getOrganisationJoinSelectClause() + "FROM (          organisation LEFT JOIN countries country     ON organisation.country_id = country.id) WHERE organisation.id = ?";
        return (OrganisationJoin)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<OrganisationJoin>(){

            public OrganisationJoin perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                ResultSet rs = statement.executeQuery();
                if (rs.next()) {
                    OrganisationJoin organisationJoin = JdbcOrganisationDAO.fillOrganisationJoinFromResultSet(rs);
                    return organisationJoin;
                }
                return null;
            }
        });
    }

    @Override
    public List<OrganisationJoin> getOrganisationJoins(final OrganisationSearchModel searchModel, Boolean consortiumFlag) {
        String sql = "SELECT " + JdbcOrganisationDAO.getOrganisationJoinSelectClause() + "FROM (          organisation LEFT JOIN countries country     ON organisation.country_id = country.id) WHERE 1=1 ";
        sql = sql + "AND (    EXISTS (SELECT 1 FROM network_person where network_person.organisation_person_id = ? ) OR EXISTS (SELECT 1 FROM (((  organisation_person JOIN organisation op_organisation ON organisation_person.organisation_id = op_organisation.id) JOIN network_organisation op_network_organisation ON op_network_organisation.organisation_id = op_organisation.id) JOIN network_organisation org_network_organisation ON org_network_organisation.network_id = op_network_organisation.network_id) WHERE org_network_organisation.organisation_id = organisation.id AND organisation_person.id = ?)) ";
        if (consortiumFlag != null) {
            sql = consortiumFlag != false ? sql + "AND organisation.consortium_flag = 1 " : sql + "AND organisation.consortium_flag = 0 ";
        }
        if (searchModel.getId() != null) {
            sql = sql + "AND organisation.id = ? ";
        } else if (SearchHelper.isStringFilled(searchModel.getName())) {
            sql = sql + "AND organisation.name LIKE ? ";
        }
        if (searchModel.getNetworkId() != null) {
            sql = sql + "AND EXISTS (SELECT 1 FROM (      network_organisation JOIN network              ON network_organisation.network_id = network.id) WHERE network_organisation.organisation_id = organisation.id AND network.id = ?) ";
        } else if (SearchHelper.isStringFilled(searchModel.getNetworkName())) {
            sql = sql + "AND EXISTS (SELECT 1 FROM (      network_organisation JOIN network              ON network_organisation.network_id = network.id) WHERE network_organisation.organisation_id = organisation.id AND network.name LIKE ?) ";
        }
        if (searchModel.getOrganisationId() != null) {
            sql = sql + "AND EXISTS (SELECT 1 FROM (          consortium_member JOIN organisation local_organisation ON consortium_member.organisation_id = local_organisation.id) WHERE consortium_member.consortium_id = organisation.id AND local_organisation.id = ?) ";
        } else if (SearchHelper.isStringFilled(searchModel.getOrganisationName())) {
            sql = sql + "AND EXISTS (SELECT 1 FROM (          consortium_member JOIN organisation local_organisation ON consortium_member.organisation_id = local_organisation.id) WHERE consortium_member.consortium_id = organisation.id AND local_organisation.name LIKE ?) ";
        }
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationJoin>>(){

            public List<OrganisationJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getOrganisationPersonId());
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getOrganisationPersonId());
                if (searchModel.getId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getId());
                } else if (SearchHelper.isStringFilled(searchModel.getName())) {
                    String name = SearchHelper.convertForSearch(searchModel.getName());
                    statement.setString(currIndex++, name);
                }
                if (searchModel.getNetworkId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getNetworkId());
                } else if (SearchHelper.isStringFilled(searchModel.getNetworkName())) {
                    String networkName = SearchHelper.convertForSearch(searchModel.getNetworkName());
                    statement.setString(currIndex++, networkName);
                }
                if (searchModel.getOrganisationId() != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)searchModel.getOrganisationId());
                } else if (SearchHelper.isStringFilled(searchModel.getOrganisationName())) {
                    String organisationName = SearchHelper.convertForSearch(searchModel.getOrganisationName());
                    statement.setString(currIndex++, organisationName);
                }
                ResultSet rs = statement.executeQuery();
                ArrayList<OrganisationJoin> ret = new ArrayList<OrganisationJoin>();
                while (rs.next()) {
                    OrganisationJoin organisationJoin = JdbcOrganisationDAO.fillOrganisationJoinFromResultSet(rs);
                    ret.add(organisationJoin);
                }
                return ret;
            }
        });
    }

    @Override
    public List<OrganisationJoin> getMemberJoinsByConsortiumId(Long consortiumId) {
        ArrayList<Long> consortiumIds = new ArrayList<Long>();
        consortiumIds.add(consortiumId);
        Map<Long, List<OrganisationJoin>> consortiumIdToMembers = this.getMemberJoinsByConsortiums(consortiumIds);
        ArrayList members = consortiumIdToMembers.get(consortiumId);
        return members != null ? members : new ArrayList();
    }

    @Override
    public Map<Long, List<OrganisationJoin>> getMemberJoinsByConsortiums(final List<Long> consortiumIds) {
        String sql = "SELECT " + JdbcOrganisationDAO.getOrganisationJoinSelectClause() + ", consortium_member.consortium_id FROM ((         consortium_member JOIN organisation         ON consortium_member.organisation_id = organisation.id) LEFT JOIN countries country    ON organisation.country_id = country.id) WHERE consortium_member.consortium_id IN (" + QueryHelper.getPlaceHolderSequence(consortiumIds.size()) + ")";
        return (Map)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Map<Long, List<OrganisationJoin>>>(){

            public Map<Long, List<OrganisationJoin>> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                for (Long consortiumId : consortiumIds) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)consortiumId);
                }
                ResultSet rs = statement.executeQuery();
                HashMap<Long, List<OrganisationJoin>> consortiumIdToMembers = new HashMap<Long, List<OrganisationJoin>>();
                while (rs.next()) {
                    Long consortiumId;
                    OrganisationJoin organisationJoin = JdbcOrganisationDAO.fillOrganisationJoinFromResultSet(rs);
                    currIndex = JdbcOrganisationDAO.getNumberOfOrganisationJoinAttributes() + 1;
                    if (!consortiumIdToMembers.containsKey(consortiumId = JDBCHelper.getLong((ResultSet)rs, (int)currIndex++))) {
                        consortiumIdToMembers.put(consortiumId, new ArrayList());
                    }
                    ((List)consortiumIdToMembers.get(consortiumId)).add(organisationJoin);
                }
                return consortiumIdToMembers;
            }
        });
    }

    @Override
    public List<OrganisationDeleteJoin> getOrganisationDeleteJoins(final Long organisationId) {
        final String sql = "SELECT " + this.getOrganisationDeleteUnionSelectClause(OrganisationDeleteUnionComponent.LABEL, "organisation", "label") + "FROM (organisation JOIN label                ON label.organisation_id = organisation.id) WHERE organisation.id = ? UNION ALL SELECT " + this.getOrganisationDeleteUnionSelectClause(OrganisationDeleteUnionComponent.NETWORK, "organisation", "network") + "FROM (organisation JOIN network              ON network.maintainer_id = organisation.id) WHERE organisation.id = ? UNION ALL SELECT " + this.getOrganisationDeleteUnionSelectClause(OrganisationDeleteUnionComponent.ORGANISATION_ORDER_STEP, "organisation", "plottOrderTemplate", "plottOrder") + "FROM (((((organisation JOIN organisation_order_step          ON organisation_order_step.organisation_id = organisation.id) JOIN order_step                       ON organisation_order_step.order_step_id = order_step.id) JOIN plott_order_item                 ON order_step.order_item_id = plott_order_item.id) JOIN plott_order                      ON plott_order_item.order_contract_id = plott_order.id) JOIN plott_order_template             ON plott_order.template_id = plott_order_template.id) WHERE organisation.id = ? UNION ALL SELECT " + this.getOrganisationDeleteUnionSelectClause(OrganisationDeleteUnionComponent.ORGANISATION_PERSON, "organisation", "person") + "FROM ((organisation JOIN organisation_person             ON organisation_person.organisation_id = organisation.id) JOIN person                          ON organisation_person.person_id = person.id) WHERE organisation.id = ? UNION ALL SELECT " + this.getOrganisationDeleteUnionSelectClause(OrganisationDeleteUnionComponent.PLOT_ORDER, "organisation", "plottOrderTemplate", "plottOrder") + "FROM ((organisation JOIN plott_order                      ON plott_order.plotter_id = organisation.id) JOIN plott_order_template             ON plott_order.template_id = plott_order_template.id) WHERE organisation.id = ? UNION ALL SELECT " + this.getOrganisationDeleteUnionSelectClause(OrganisationDeleteUnionComponent.PROJECT_PARTICIPATION, "organisation", "project", "network", "person") + "FROM ((((((organisation JOIN project_participation            ON project_participation.organisation_id = organisation.id) JOIN project                          ON project_participation.project_id = project.id) JOIN network                          ON project.network_id = network.id) LEFT JOIN project_participant              ON project_participant.participation_id = project_participation.id) LEFT JOIN organisation_person              ON project_participant.organisation_person_id = organisation_person.id) LEFT JOIN person                           ON organisation_person.person_id = person.id) WHERE organisation.id = ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<OrganisationDeleteJoin>>(){

            public List<OrganisationDeleteJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationId);
                QueryHelper.checkNumberOfWildcards(sql, currIndex);
                if (log.isDebugEnabled()) {
                    log.debug("Will query sql for organisation_id [" + organisationId + "]: " + sql);
                }
                ArrayList<OrganisationDeleteJoin> results = new ArrayList<OrganisationDeleteJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    OrganisationDeleteJoin joinDto = AbstractJdbcOrganisationDAO.fillOrganisationDeleteJoinFromResultSet(rs);
                    currIndex = AbstractJdbcOrganisationDAO.getNumberOfOrganisationDeleteJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getOrganisationDeleteUnionSelectClause(OrganisationDeleteUnionComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForOrganisationDeleteJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : "") + component.getValue() + " ";
    }

    @Override
    public List<Organisation> getBySubProjectIdViaOrderRequest(Long subProjectId) {
        String sql = "SELECT " + JdbcOrganisationDAO.getSelectClauseForDto() + "FROM       original_document_order JOIN order_step               ON original_document_order.request_id = order_step.id JOIN organisation_order_step  ON original_document_order.request_id = organisation_order_step.order_step_id JOIN organisation             ON organisation_order_step.organisation_id = organisation.id WHERE original_document_order.sub_project_id = ? ";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(subProjectId));
    }

    @Override
    public List<Organisation> getBySubProjectIdViaOriginalReceiver(Long subProjectId) {
        String sql = "SELECT " + JdbcOrganisationDAO.getSelectClauseForDto() + "FROM       original_document_order JOIN original_document_order_item ON original_document_order_item.order_contract_id = original_document_order.id JOIN organisation                 ON original_document_order_item.receiver_id = organisation.id WHERE original_document_order.sub_project_id = ? ";
        return QueryHelper.getListWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(subProjectId));
    }

    @Override
    public List<Organisation> getAllMaintainerOrganisations() {
        String sql = "SELECT DISTINCT " + JdbcOrganisationDAO.getSelectClauseForDto() + "FROM network JOIN organisation ON network.maintainer_id = organisation.id ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {});
    }
}

