/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.msp;

import at.cdes.api.dto.msp.MspFieldType;
import at.cdes.api.dto.msp.MspFieldValue;
import at.cdes.api.dto.msp.MspListField;
import at.cdes.api.dto.msp.MspTerm;
import at.cdes.api.service.MspService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MspHelper {
    private static final Logger log = LoggerFactory.getLogger(MspHelper.class);

    public static Map<String, MspListField> getListFieldMap(MspService mspService, String projectPath, String listName) {
        HashMap<String, MspListField> nameToField = new HashMap<String, MspListField>();
        List listFields = mspService.getListFields(projectPath, listName);
        for (MspListField listField : listFields) {
            String fieldName = listField.getName();
            nameToField.put(fieldName, listField);
            if (!log.isDebugEnabled()) continue;
            log.debug("getListFieldMap found fieldName [" + fieldName + "]");
            log.debug("... mapped to: { id = [" + listField.getId() + "]; name = [" + listField.getName() + "]; type = [" + listField.getType() + "]; list = [" + listField.getList() + "]; termStoreId = [" + listField.getTermStoreId() + "]; termSetId = [" + listField.getTermSetId() + "]; required = [" + listField.getRequired() + "]");
        }
        return nameToField;
    }

    public static Map<String, String> getFirstListDataByOneStringAttribute(MspService mspService, String projectPath, String listName, String queryAttribute, String queryValue, String ... attributes) {
        Map retValue;
        HashMap<String, String> queryAttributeToValue = new HashMap<String, String>();
        queryAttributeToValue.put(queryAttribute, queryValue);
        List results = mspService.getListDataByStringAttributes(projectPath, listName, queryAttributeToValue, attributes);
        Map map = retValue = results.size() > 0 ? (Map)results.get(0) : null;
        if (log.isTraceEnabled()) {
            List allListData = mspService.getListData(projectPath, listName, attributes);
            log.trace("All list data of list [" + listName + "] in project [" + projectPath + "] is:");
            for (Map instance : allListData) {
                log.trace("... Instance:");
                for (String key : instance.keySet()) {
                    log.trace("...... Member [" + key + "] has value [" + (String)instance.get(key) + "]");
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("getFirstListDataByOneStringAttribute, called for queryAttribute [" + queryAttribute + "] and queryValue [" + queryValue + "] returns retValue [" + retValue + "]");
        }
        return retValue;
    }

    public static String getTermGuidFromUniqueId(String uniqueId) {
        int termGuidStartIndex = uniqueId.indexOf(";#{") + ";#{".length();
        int termGuidEndIndex = uniqueId.lastIndexOf(125);
        if (termGuidStartIndex == -1) {
            throw new IllegalArgumentException("Separator ;#{ not found in unique id");
        }
        if (termGuidEndIndex == -1) {
            throw new IllegalArgumentException("Final } not found in unique id");
        }
        return uniqueId.substring(termGuidStartIndex, termGuidEndIndex);
    }

    public static String getLookupFieldMultiString(MspService mspService, String projectPath, MspListField mspListField, Set<String> titles) {
        String streckenListId = mspListField.getList();
        List allStrecken = mspService.getListData(projectPath, streckenListId, new String[]{"ows_ID", "ows_Title"});
        String streckenString = "";
        boolean first = true;
        for (Map strecke : allStrecken) {
            String id = (String)strecke.get("ows_ID");
            String title = (String)strecke.get("ows_Title");
            if (!titles.contains(title)) continue;
            streckenString = streckenString + (first ? "" : ";#") + id + ";#" + title;
            first = false;
        }
        return streckenString;
    }

    public static void registerLookupFieldReferencesToItem(List<MspFieldValue> fieldValues, String foreignKeyName, Map<String, String> item) {
        String id = item.get("ows_ID");
        String title = item.get("ows_Title");
        String uniqueId = item.get("ows_UniqueId");
        String termGuid = MspHelper.getTermGuidFromUniqueId(uniqueId);
        String taxonomyFieldValue = id + ";#" + title;
        String taxonomyHiddenFieldValue = title + "|" + termGuid;
        fieldValues.add(new MspFieldValue(foreignKeyName + "_0", MspFieldType.NOTE, taxonomyHiddenFieldValue));
    }

    public static void registerLookupFieldReferencesToTermItem(List<MspFieldValue> fieldValues, String foreignKeyName, Map<String, String> item) {
        String id = item.get("Id");
        String title = item.get("Title");
        String termGuid = item.get("IdForTerm");
        String taxonomyFieldValue = id + ";#" + title;
        String taxonomyHiddenFieldValue = title + "|" + termGuid;
        fieldValues.add(new MspFieldValue(foreignKeyName, MspFieldType.LOOKUP, taxonomyFieldValue));
        fieldValues.add(new MspFieldValue(foreignKeyName + "_0", MspFieldType.NOTE, taxonomyHiddenFieldValue));
    }

    public static void registerLookupFieldReferencesToTermItem(List<MspFieldValue> fieldValues, String foreignKeyName, MspTerm termItem) {
        String id = termItem.getId();
        String title = termItem.getDefaultLabel();
        String termGuid = termItem.getUuid();
        String taxonomyFieldValue = id + ";#" + title;
        String taxonomyHiddenFieldValue = title + "|" + termGuid;
        fieldValues.add(new MspFieldValue(foreignKeyName, MspFieldType.LOOKUP, taxonomyFieldValue));
        fieldValues.add(new MspFieldValue(foreignKeyName + "_0", MspFieldType.NOTE, taxonomyHiddenFieldValue));
    }

    public static String stripId(String idWithCurlyBraces) {
        if (idWithCurlyBraces == null) {
            return null;
        }
        if (idWithCurlyBraces.startsWith("{")) {
            idWithCurlyBraces = idWithCurlyBraces.substring(1);
        }
        if (idWithCurlyBraces.endsWith("}")) {
            idWithCurlyBraces = idWithCurlyBraces.substring(0, idWithCurlyBraces.length() - 1);
        }
        idWithCurlyBraces = idWithCurlyBraces.replaceAll("-", "");
        return idWithCurlyBraces;
    }
}

