/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.project;

import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.ObjectPlannerPosition;
import at.cdes.api.dto.ObjectPlannerPositionRelease;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.PersonVariables;
import at.cdes.api.dto.PlottOrderItem;
import at.cdes.api.dto.PlottOrderItemTemplate;
import at.cdes.api.dto.PlottOrderTemplate;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipantHistoryPart;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ProjectParticipationSubProjectRestrictions;
import at.cdes.api.dto.ReviewCycleNodeInstancePlottOrderListener;
import at.cdes.api.dto.ReviewCycleNodePositionReleased;
import at.cdes.api.dto.RoleType;
import at.cdes.api.dto.SubProject;
import at.cdes.api.dto.WorkflowEntity;
import at.cdes.api.dto.WorkflowNodePosition;
import at.cdes.api.dto.WorkflowNodeTemplate;
import at.cdes.api.dto.WorkflowToken;
import at.cdes.api.joinDto.ParticipationDeleteJoin;
import at.cdes.api.joinDto.ParticipationSelectionJoin;
import at.cdes.api.joinDto.WorkflowJoin;
import at.cdes.api.obj.voc.ObjectPlannerChanged;
import at.cdes.api.planning.compositeDto.WorkflowInfo;
import at.cdes.api.planning.compositeDto.WorkflowNodeInfo;
import at.cdes.api.planning.compositeDto.WorkflowNodePositionInfo;
import at.cdes.api.project.compositeDto.ParticipationDeleteInfo;
import at.cdes.api.voc.ProjectStatus;
import at.cdes.api.voc.RoleTypeEnum;
import at.cdes.api.voc.action.Action;
import at.cdes.api.voc.project.ProjectParticipationStatus;
import at.cdes.impl.dao.AttachedReviewTaskDAO;
import at.cdes.impl.dao.CdesRoleDAO;
import at.cdes.impl.dao.FutureEmailDAO;
import at.cdes.impl.dao.ObjectPlannerDAO;
import at.cdes.impl.dao.ObjectPlannerPositionDAO;
import at.cdes.impl.dao.ObjectPlannerPositionReleaseDAO;
import at.cdes.impl.dao.ObjectPlannerReleaseDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.PlottOrderItemDAO;
import at.cdes.impl.dao.PlottOrderItemTemplateDAO;
import at.cdes.impl.dao.PlottOrderTemplateDAO;
import at.cdes.impl.dao.ProjectConfigDAO;
import at.cdes.impl.dao.ProjectDAO;
import at.cdes.impl.dao.ProjectHolidayDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipantHistoryPartDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.ProjectParticipationSubProjectRestrictionsDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstancePlottOrderListenerDAO;
import at.cdes.impl.dao.ReviewCycleNodePositionDAO;
import at.cdes.impl.dao.ReviewCycleNodePositionReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodeProjectParticipationsNotificationDAO;
import at.cdes.impl.dao.RoleTypeDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.dao.TaskDAO;
import at.cdes.impl.dao.WorkflowActivityPositionResultDAO;
import at.cdes.impl.dao.WorkflowDAO;
import at.cdes.impl.dao.WorkflowEntityDAO;
import at.cdes.impl.dao.WorkflowNodePositionDAO;
import at.cdes.impl.dao.WorkflowTokenDAO;
import at.cdes.impl.dao.unionComponent.ParticipationDeleteComponent;
import at.cdes.impl.email.EmailUtils;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.planning.PlanningNotificationQueryHelper;
import at.cdes.impl.task.TaskUtils;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.objects.ObjectHelper;
import at.cdes.impl.util.plot.PlotHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectUtils {
    private static final Logger log = LoggerFactory.getLogger(ProjectUtils.class);
    private AttachedReviewTaskDAO attachedReviewTaskDAO;
    private CdesRoleDAO cdesRoleDAO;
    private EmailUtils mailUtils;
    private FutureEmailDAO futureEmailDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private ObjectPlannerPositionDAO objectPlannerPositionDAO;
    private ObjectPlannerPositionReleaseDAO objectPlannerPositionReleaseDAO;
    private ObjectPlannerReleaseDAO objectPlannerReleaseDAO;
    private PersonVariablesDAO personVariablesDAO;
    private PlottOrderItemDAO plotOrderItemDAO;
    private PlottOrderTemplateDAO plotOrderTemplateDAO;
    private PlottOrderItemTemplateDAO plotOrderItemTemplateDAO;
    private ProjectDAO projectDAO;
    private ProjectConfigDAO projectConfigDAO;
    private ProjectHolidayDAO projectHolidayDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private ProjectParticipantHistoryPartDAO projectParticipantHistoryPartDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private ProjectParticipationSubProjectRestrictionsDAO projectParticipationSubProjectRestrictionDAO;
    private ReviewCycleNodeInstancePlottOrderListenerDAO reviewCycleNodeInstancePlotOrderListenerDAO;
    private ReviewCycleNodePositionDAO reviewCycleNodePositionDAO;
    private ReviewCycleNodePositionReleasedDAO reviewCycleNodePositionReleasedDAO;
    private ReviewCycleNodeProjectParticipationsNotificationDAO reviewCycleNodeProjectParticipationsNotificationDAO;
    private RoleTypeDAO roleTypeDAO;
    private SubProjectDAO subProjectDAO;
    private TaskDAO taskDAO;
    private TaskUtils taskUtils;
    private WorkflowDAO workflowDAO;
    private WorkflowActivityPositionResultDAO workflowActivityPositionResultDAO;
    private WorkflowEntityDAO workflowEntityDAO;
    private WorkflowNodePositionDAO workflowNodePositionDAO;
    private WorkflowTokenDAO workflowTokenDAO;

    public void setAttachedReviewTaskDAO(AttachedReviewTaskDAO attachedReviewTaskDAO) {
        this.attachedReviewTaskDAO = attachedReviewTaskDAO;
    }

    public void setCdesRoleDAO(CdesRoleDAO cdesRoleDAO) {
        this.cdesRoleDAO = cdesRoleDAO;
    }

    public void setMailUtils(EmailUtils mailUtils) {
        this.mailUtils = mailUtils;
    }

    public void setFutureEmailDAO(FutureEmailDAO futureEmailDAO) {
        this.futureEmailDAO = futureEmailDAO;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setObjectPlannerPositionDAO(ObjectPlannerPositionDAO objectPlannerPositionDAO) {
        this.objectPlannerPositionDAO = objectPlannerPositionDAO;
    }

    public void setObjectPlannerPositionReleaseDAO(ObjectPlannerPositionReleaseDAO objectPlannerPositionReleaseDAO) {
        this.objectPlannerPositionReleaseDAO = objectPlannerPositionReleaseDAO;
    }

    public void setObjectPlannerReleaseDAO(ObjectPlannerReleaseDAO objectPlannerReleaseDAO) {
        this.objectPlannerReleaseDAO = objectPlannerReleaseDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setPlotOrderItemDAO(PlottOrderItemDAO plotOrderItemDAO) {
        this.plotOrderItemDAO = plotOrderItemDAO;
    }

    public void setPlotOrderTemplateDAO(PlottOrderTemplateDAO plotOrderTemplateDAO) {
        this.plotOrderTemplateDAO = plotOrderTemplateDAO;
    }

    public void setPlotOrderItemTemplateDAO(PlottOrderItemTemplateDAO plotOrderItemTemplateDAO) {
        this.plotOrderItemTemplateDAO = plotOrderItemTemplateDAO;
    }

    public void setProjectDAO(ProjectDAO projectDAO) {
        this.projectDAO = projectDAO;
    }

    public void setProjectConfigDAO(ProjectConfigDAO projectConfigDAO) {
        this.projectConfigDAO = projectConfigDAO;
    }

    public void setProjectHolidayDAO(ProjectHolidayDAO projectHolidayDAO) {
        this.projectHolidayDAO = projectHolidayDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setProjectParticipantHistoryPartDAO(ProjectParticipantHistoryPartDAO projectParticipantHistoryPartDAO) {
        this.projectParticipantHistoryPartDAO = projectParticipantHistoryPartDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setProjectParticipationSubProjectRestrictionDAO(ProjectParticipationSubProjectRestrictionsDAO projectParticipationSubProjectRestrictionDAO) {
        this.projectParticipationSubProjectRestrictionDAO = projectParticipationSubProjectRestrictionDAO;
    }

    public void setParticipationInvalid(Long participationId) {
        ProjectParticipation participation = (ProjectParticipation)this.projectParticipationDAO.get(participationId);
        participation.setInvalidated(Integer.valueOf(ProjectParticipationStatus.INVALID.getValue()));
        this.projectParticipationDAO.update(participation);
    }

    public void setReviewCycleNodeInstancePlotOrderListenerDAO(ReviewCycleNodeInstancePlottOrderListenerDAO reviewCycleNodeInstancePlotOrderListenerDAO) {
        this.reviewCycleNodeInstancePlotOrderListenerDAO = reviewCycleNodeInstancePlotOrderListenerDAO;
    }

    public void setReviewCycleNodePositionDAO(ReviewCycleNodePositionDAO reviewCycleNodePositionDAO) {
        this.reviewCycleNodePositionDAO = reviewCycleNodePositionDAO;
    }

    public void setReviewCycleNodePositionReleasedDAO(ReviewCycleNodePositionReleasedDAO reviewCycleNodePositionReleasedDAO) {
        this.reviewCycleNodePositionReleasedDAO = reviewCycleNodePositionReleasedDAO;
    }

    public void setReviewCycleNodeProjectParticipationsNotificationDAO(ReviewCycleNodeProjectParticipationsNotificationDAO reviewCycleNodeProjectParticipationsNotificationDAO) {
        this.reviewCycleNodeProjectParticipationsNotificationDAO = reviewCycleNodeProjectParticipationsNotificationDAO;
    }

    public void setRoleTypeDAO(RoleTypeDAO roleTypeDAO) {
        this.roleTypeDAO = roleTypeDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void setTaskDAO(TaskDAO taskDAO) {
        this.taskDAO = taskDAO;
    }

    public void setTaskUtils(TaskUtils taskUtils) {
        this.taskUtils = taskUtils;
    }

    public void setWorkflowDAO(WorkflowDAO workflowDAO) {
        this.workflowDAO = workflowDAO;
    }

    public void setWorkflowActivityPositionResultDAO(WorkflowActivityPositionResultDAO workflowActivityPositionResultDAO) {
        this.workflowActivityPositionResultDAO = workflowActivityPositionResultDAO;
    }

    public void setWorkflowEntityDAO(WorkflowEntityDAO workflowEntityDAO) {
        this.workflowEntityDAO = workflowEntityDAO;
    }

    public void setWorkflowNodePositionDAO(WorkflowNodePositionDAO workflowNodePositionDAO) {
        this.workflowNodePositionDAO = workflowNodePositionDAO;
    }

    public void setWorkflowTokenDAO(WorkflowTokenDAO workflowTokenDAO) {
        this.workflowTokenDAO = workflowTokenDAO;
    }

    public void removeAndReplaceMainParticipant(Long organisationPersonId, Long cdesRoleId, List<ProjectParticipant> participantsForMainParticipantParticipation, ProjectParticipant newMainParticipantProxy) {
        ProjectParticipant oldMainParticipant = null;
        for (ProjectParticipant participant : participantsForMainParticipantParticipation) {
            boolean mainParticipantFlag = participant.getMainParticipantFlag() != null && participant.getMainParticipantFlag() != false;
            if (!mainParticipantFlag) continue;
            oldMainParticipant = participant;
            break;
        }
        if (oldMainParticipant == null) {
            throw new IllegalArgumentException("Did not find any mainParticipant in the given participants list");
        }
        if (newMainParticipantProxy == null || newMainParticipantProxy.isMainParticipantFlag().booleanValue()) {
            throw new IllegalArgumentException("NewMainParticipantProxy was not given or is mainParticipant");
        }
        boolean newMainParticipantWasProxyParticipant = false;
        Long lateTaskEmailOrganisationPersonId = null;
        Long newMainParticipantOrganisationPersonId = newMainParticipantProxy.getOrganisationPersonId();
        boolean isSurveillantRole = this.cdesRoleDAO.hasTypeAndAction(cdesRoleId, RoleTypeEnum.PROJECT_SURVEILLANT, Action.MONITOR_LATE_REVIEWS);
        if (isSurveillantRole) {
            for (ProjectParticipant oldParticipant : participantsForMainParticipantParticipation) {
                if (!oldParticipant.getOrganisationPersonId().equals(newMainParticipantProxy.getOrganisationPersonId())) continue;
                newMainParticipantWasProxyParticipant = true;
                break;
            }
            if (!newMainParticipantWasProxyParticipant) {
                lateTaskEmailOrganisationPersonId = newMainParticipantOrganisationPersonId;
            }
        }
        this.removeParticipant(organisationPersonId, newMainParticipantProxy);
        ProjectParticipant newMainParticipant = new ProjectParticipant();
        newMainParticipant.setOrganisationPersonId(newMainParticipantOrganisationPersonId);
        newMainParticipant.setParticipationId(newMainParticipantProxy.getParticipationId());
        newMainParticipant.setMainParticipantFlag(Boolean.valueOf(true));
        newMainParticipant.setInactiveFlag(Boolean.valueOf(false));
        this.insertParticipant(organisationPersonId, newMainParticipant);
        this.removeParticipant(organisationPersonId, oldMainParticipant);
        if (lateTaskEmailOrganisationPersonId != null) {
            this.mailUtils.createLateTaskEmail(lateTaskEmailOrganisationPersonId, newMainParticipant.getId());
        }
    }

    public void removeParticipant(Long organisationPersonId, ProjectParticipant participant) {
        boolean isMainParticipant;
        PersonVariables personVariables = this.personVariablesDAO.getByOrganisationPerson(organisationPersonId);
        String locale = personVariables.getUserLocale();
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(locale);
        boolean isInactive = participant.getInactiveFlag() != null && participant.getInactiveFlag() != false;
        boolean bl = isMainParticipant = participant.isMainParticipantFlag() != null && participant.isMainParticipantFlag() != false;
        if (!isInactive) {
            participant.setInactiveFlag(Boolean.valueOf(true));
            if (isMainParticipant) {
                participant.setMainParticipantFlag(Boolean.valueOf(false));
                participant.setInactiveComment(resourceBundle.getString("projectParticipantMainParticipantInactiveComment"));
            } else {
                participant.setInactiveComment(resourceBundle.getString("projectParticipantOrdinaryParticipantInactiveComment"));
            }
            ProjectParticipantHistoryPart newestHistoryPart = this.projectParticipantHistoryPartDAO.getNewestByParticipant(participant.getId());
            if (newestHistoryPart == null) {
                newestHistoryPart = new ProjectParticipantHistoryPart();
                newestHistoryPart.setProjectParticipantId(participant.getId());
                newestHistoryPart = (ProjectParticipantHistoryPart)this.projectParticipantHistoryPartDAO.save(newestHistoryPart);
            }
            Double currentUtcSeconds = DateHelper.getCurrentUtcSeconds();
            newestHistoryPart.setEditDate(currentUtcSeconds);
            newestHistoryPart.setEndDate(currentUtcSeconds);
            newestHistoryPart.setOrganisationPersonId(organisationPersonId);
            this.projectParticipantHistoryPartDAO.update(newestHistoryPart);
            this.projectParticipantDAO.update(participant);
        }
    }

    public void insertParticipant(Long organisationPersonId, ProjectParticipant participant) {
        participant = (ProjectParticipant)this.projectParticipantDAO.save(participant);
        ProjectParticipantHistoryPart newestHistoryPart = new ProjectParticipantHistoryPart();
        newestHistoryPart.setProjectParticipantId(participant.getId());
        newestHistoryPart = (ProjectParticipantHistoryPart)this.projectParticipantHistoryPartDAO.save(newestHistoryPart);
        Double currentUtcSeconds = DateHelper.getCurrentUtcSeconds();
        newestHistoryPart.setEditDate(currentUtcSeconds);
        newestHistoryPart.setStartDate(currentUtcSeconds);
        newestHistoryPart.setOrganisationPersonId(organisationPersonId);
        this.projectParticipantHistoryPartDAO.update(newestHistoryPart);
    }

    public void deleteTasksForSubProjectDelete(Long subProjectId) {
        Collection<Long> reviewCycleEntryTaskIds = this.taskDAO.getReviewCycleEntryTaskIdsBySubProject(subProjectId);
        Collection<Long> originalDocumentTaskIds = this.taskDAO.getOriginalDocumentTaskIdsBySubProject(subProjectId);
        Collection<Long> plotOrderAcceptanceTaskIds = this.taskDAO.getInvalidatePlotOrderAcceptanceTaskIdsBySubProject(subProjectId);
        Collection<Long> reviewCyclePlotTaskIds = this.taskDAO.getReviewCyclePlotTaskIdsBySubProject(subProjectId);
        Collection<Long> reviewTaskIds = this.taskDAO.getReviewTaskIdsBySubProject(subProjectId);
        Collection<Long> attachedReviewTaskIds = this.taskDAO.getAttachedReviewTaskIdsBySubProject(subProjectId);
        Collection<Long> selectCellConnectionTaskIds = this.taskDAO.getSelectCellConnectionTaskIdsBySubProject(subProjectId);
        this.taskUtils.deleteReviewCycleEntryTasks(reviewCycleEntryTaskIds);
        this.taskUtils.deleteOriginalDocumentTasks(originalDocumentTaskIds);
        this.taskUtils.deletePlotOrderAcceptanceTasks(plotOrderAcceptanceTaskIds);
        this.taskUtils.deleteReviewCyclePlotTasks(reviewCyclePlotTaskIds);
        this.taskUtils.deleteReviewTasks(reviewTaskIds);
        this.taskUtils.deleteAttachedReviewTasks(attachedReviewTaskIds);
        this.taskUtils.deleteSelectCellConnectionTasks(selectCellConnectionTaskIds);
    }

    public void deleteParticipationsByProjectId(Long projectId) {
        List<ProjectParticipantHistoryPart> historyParts = this.projectParticipantHistoryPartDAO.getByProject(projectId);
        List<ProjectParticipant> participants = this.projectParticipantDAO.getByProject(projectId);
        List<ProjectParticipation> participations = this.projectParticipationDAO.getByProject(projectId);
        List<Long> historyPartIds = QueryHelper.getPersistentIds(historyParts);
        List<Long> participantIds = QueryHelper.getPersistentIds(participants);
        List<Long> participationIds = QueryHelper.getPersistentIds(participations);
        if (historyPartIds.size() > 0) {
            this.projectParticipantHistoryPartDAO.deleteBatch(historyPartIds);
        }
        if (participantIds.size() > 0) {
            this.projectParticipantDAO.deleteBatch(participantIds);
        }
        if (participationIds.size() > 0) {
            this.projectParticipationDAO.deleteBatch(participationIds);
        }
    }

    public void deleteParticipationById(Long participationId) {
        List<ProjectParticipantHistoryPart> historyParts = this.projectParticipantHistoryPartDAO.getByParticipation(participationId);
        List<ProjectParticipant> participants = this.projectParticipantDAO.getByParticipation(participationId);
        List<Long> historyPartIds = QueryHelper.getPersistentIds(historyParts);
        List<Long> participantIds = QueryHelper.getPersistentIds(participants);
        if (historyPartIds.size() > 0) {
            this.projectParticipantHistoryPartDAO.deleteBatch(historyPartIds);
        }
        if (participantIds.size() > 0) {
            this.projectParticipantDAO.deleteBatch(participantIds);
        }
        this.projectParticipationDAO.delete(participationId);
    }

    public void deleteProjectHolidaysByProjectId(Long projectId) {
        List<ProjectHoliday> projectHolidays = this.projectHolidayDAO.getByProject(projectId);
        List<Long> projectHolidayIds = QueryHelper.getPersistentIds(projectHolidays);
        if (projectHolidayIds.size() > 0) {
            this.projectHolidayDAO.deleteBatch(projectHolidayIds);
        }
    }

    public void deleteProjectConfigByProjectId(Long projectId) {
        Project project = (Project)this.projectDAO.get(projectId);
        Long projectConfigId = project.getProjectConfigId();
        if (projectConfigId != null) {
            this.projectConfigDAO.delete(projectConfigId);
        }
    }

    public void deleteProjectConfigById(Long projectConfigId) {
        if (projectConfigId != null) {
            this.projectConfigDAO.delete(projectConfigId);
        }
    }

    public ParticipationDeleteInfo getInfoByParticipationDeleteJoins(List<ParticipationDeleteJoin> deleteJoins, Long projectId, Long participationId) {
        ParticipationDeleteInfo deleteInfo = new ParticipationDeleteInfo();
        Project project = null;
        if (projectId != null) {
            project = (Project)this.projectDAO.get(projectId);
        } else if (participationId != null) {
            project = this.projectDAO.getByParticipation(participationId);
        }
        boolean buek = project.getStatus().intValue() == ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue();
        deleteInfo.setBuek(buek);
        ArrayList<ParticipationDeleteJoin> deleteJoinsForClient = new ArrayList<ParticipationDeleteJoin>();
        HashMap<Long, SubProject> affectedSubProjectIdToSubProject = new HashMap<Long, SubProject>();
        for (ParticipationDeleteJoin deleteJoin : deleteJoins) {
            ParticipationDeleteComponent component = ParticipationDeleteComponent.getByValue(deleteJoin.getUnionClause());
            if (component == ParticipationDeleteComponent.REVIEW_CYCLE_NODE_POSITION || component == ParticipationDeleteComponent.REVIEW_CYCLE_NODE_INSTANCE_NOTIFICATION || component == ParticipationDeleteComponent.REVIEW_CYCLE_NODE_INSTANCE_PLOTT_ORDER_LISTENER || component == ParticipationDeleteComponent.OBJECT_PLANNER || component == ParticipationDeleteComponent.OBJECT_PLANNER_POSITION || component == ParticipationDeleteComponent.PLOT_ORDER_TEMPLATE || component == ParticipationDeleteComponent.PLOT_ORDER_ITEM_TEMPLATE || component == ParticipationDeleteComponent.ATTACHED_REVIEW_TASK) {
                deleteJoinsForClient.add(deleteJoin);
            }
            if (component == ParticipationDeleteComponent.ATTACHED_REVIEW_TASK) {
                deleteInfo.setHasAttachedReviewTasks(true);
            }
            if (component == ParticipationDeleteComponent.REVIEW_CYCLE_NODE_POSITION_RELEASED || component == ParticipationDeleteComponent.OBJECT_PLANNER_POSITION_RELEASE || component == ParticipationDeleteComponent.OBJECT_PLANNER_RELEASE) {
                deleteInfo.setHasReleasedObjectListAssignments(true);
            }
            if (component == ParticipationDeleteComponent.REVIEW_CYCLE_NODE_POSITION || component == ParticipationDeleteComponent.OBJECT_PLANNER_POSITION || component == ParticipationDeleteComponent.OBJECT_PLANNER) {
                deleteInfo.setHasUnreleasedObjectListAssignments(true);
            }
            if (component == ParticipationDeleteComponent.REVIEW_CYCLE_NODE_INSTANCE_NOTIFICATION) {
                deleteInfo.setHasNotificationListenerAssignments(true);
            }
            if (component == ParticipationDeleteComponent.REVIEW_CYCLE_NODE_INSTANCE_PLOTT_ORDER_LISTENER || component == ParticipationDeleteComponent.PLOT_ORDER_TEMPLATE || component == ParticipationDeleteComponent.PLOT_ORDER_ITEM_TEMPLATE) {
                deleteInfo.setHasPlottOrderListenerAssignments(true);
            }
            if (component == ParticipationDeleteComponent.REMAINING_ADMIN_NON_BUEK) {
                deleteInfo.setLastAdminNonBuek(true);
            }
            if (component == ParticipationDeleteComponent.REMAINING_ADMIN_BUEK) {
                deleteInfo.setLastAdminBuek(true);
            }
            if (component == ParticipationDeleteComponent.PLOT_TASKS || component == ParticipationDeleteComponent.ORDER_STEP) {
                deleteInfo.setHasOpenTasks(true);
            }
            if (component != ParticipationDeleteComponent.REVIEW_CYCLE_NODE_POSITION && component != ParticipationDeleteComponent.REVIEW_CYCLE_NODE_INSTANCE_NOTIFICATION && component != ParticipationDeleteComponent.REVIEW_CYCLE_NODE_INSTANCE_PLOTT_ORDER_LISTENER && component != ParticipationDeleteComponent.OBJECT_PLANNER && component != ParticipationDeleteComponent.OBJECT_PLANNER_POSITION && component != ParticipationDeleteComponent.REVIEW_CYCLE_NODE_POSITION_RELEASED && component != ParticipationDeleteComponent.OBJECT_PLANNER_POSITION_RELEASE && component != ParticipationDeleteComponent.OBJECT_PLANNER_RELEASE) continue;
            affectedSubProjectIdToSubProject.put(deleteJoin.getSubProjectId(), deleteJoin.getSubProject());
        }
        ArrayList affectedSubProjects = new ArrayList();
        affectedSubProjects.addAll(affectedSubProjectIdToSubProject.values());
        deleteInfo.setAffectedSubProjects(affectedSubProjects);
        deleteInfo.setDeleteJoins(deleteJoinsForClient);
        return deleteInfo;
    }

    public void doDeleteParticipationWithRelationsById(Long participationId) {
        Project project = this.projectDAO.getByParticipation(participationId);
        boolean setMarkedForDeletion = false;
        if (project.getStatus().intValue() != ProjectStatus.PLANNING_NOTIFICATION_PROJECT.getValue()) {
            this.reviewCycleNodePositionDAO.deleteByParticipation(participationId);
            this.reviewCycleNodeProjectParticipationsNotificationDAO.deleteByParticipation(participationId);
            this.removePlotOrderListenerReferencesByParticipation(participationId);
            List<ReviewCycleNodePositionReleased> reviewCycleNodePositionReleaseds = this.reviewCycleNodePositionReleasedDAO.getActiveByParticipationId(participationId);
            setMarkedForDeletion |= reviewCycleNodePositionReleaseds.size() > 0;
            this.treatUnreleasedObjectPlannersOnParticipationDelete(participationId);
            List<ObjectPlannerPositionRelease> objectPlannerPositionReleases = this.objectPlannerPositionReleaseDAO.getActiveByParticipationId(participationId);
            List<ObjectPlannerRelease> objectPlannerReleases = this.objectPlannerReleaseDAO.getActiveByParticipationId(participationId);
            setMarkedForDeletion |= objectPlannerPositionReleases.size() > 0;
            boolean bl = objectPlannerReleases.size() > 0;
            this.treatPlotOrderTemplatesOnParticipationDelete(participationId);
            this.treatAttachedReviewTasksOnParticipationDelete(participationId);
            ProjectParticipation participation = (ProjectParticipation)this.projectParticipationDAO.get(participationId);
            if (!(setMarkedForDeletion |= bl)) {
                participation.setInvalidated(Integer.valueOf(ProjectParticipationStatus.INVALID.getValue()));
            } else {
                participation.setInvalidated(Integer.valueOf(ProjectParticipationStatus.MARKED_FOR_DELETION.getValue()));
            }
            this.projectParticipationDAO.update(participation);
        } else {
            this.treatWorkflowNodePositionsOnParticipationDelete(participationId);
        }
    }

    private void removePlotOrderListenerReferencesByParticipation(Long participationId) {
        List<PlottOrderItemTemplate> plotOrderItemTemplates = this.plotOrderItemTemplateDAO.getByDeliveryAddress(participationId);
        Set<Long> plotOrderTemplateIds = PlotHelper.getPlotOrderTemplateIdsByItemTemplates(plotOrderItemTemplates);
        List<PlottOrderItemTemplate> candidateItemTemplates = this.plotOrderItemTemplateDAO.getByOrderContracts(plotOrderTemplateIds);
        Map<Long, List<PlottOrderItemTemplate>> participationTemplateIdToItems = PlotHelper.groupByOrderContractId(plotOrderItemTemplates);
        Map<Long, List<PlottOrderItemTemplate>> allTemplateIdToItems = PlotHelper.groupByOrderContractId(candidateItemTemplates);
        ArrayList<Long> templateIdsToBeRemoved = new ArrayList<Long>();
        for (Long templateId : participationTemplateIdToItems.keySet()) {
            int allCount;
            int participationCount = participationTemplateIdToItems.get(templateId).size();
            if (participationCount != (allCount = allTemplateIdToItems.get(templateId).size())) continue;
            templateIdsToBeRemoved.add(templateId);
        }
        List<ReviewCycleNodeInstancePlottOrderListener> listeners = this.reviewCycleNodeInstancePlotOrderListenerDAO.getByReferences(templateIdsToBeRemoved);
        if (listeners.size() > 0) {
            for (ReviewCycleNodeInstancePlottOrderListener listener : listeners) {
                listener.setReferenceId(null);
            }
            this.reviewCycleNodeInstancePlotOrderListenerDAO.updateBatch(listeners);
        }
    }

    private void treatUnreleasedObjectPlannersOnParticipationDelete(Long participationId) {
        List<ObjectPlannerPosition> objectPlannerPositions = this.objectPlannerPositionDAO.getByProjectParticipation(participationId);
        List<Long> objectPlannerPositionIds = QueryHelper.getPersistentIds(objectPlannerPositions);
        Set<Long> positionObjectPlannerIds = ObjectHelper.getObjectPlannerIdsFromPositions(objectPlannerPositions);
        if (objectPlannerPositionIds.size() > 0) {
            this.objectPlannerPositionDAO.deleteBatch(objectPlannerPositionIds);
        }
        List<ObjectPlanner> refObjectPlanners = this.objectPlannerDAO.getByPlanner(participationId);
        List<Long> refObjectPlannerIds = QueryHelper.getPersistentIds(refObjectPlanners);
        HashSet<Long> refObjectPlannerIdsSet = new HashSet<Long>();
        refObjectPlannerIdsSet.addAll(refObjectPlannerIds);
        HashSet<Long> allObjectPlannerIds = new HashSet<Long>();
        allObjectPlannerIds.addAll(positionObjectPlannerIds);
        allObjectPlannerIds.addAll(refObjectPlannerIds);
        List allObjectPlanners = allObjectPlannerIds.size() > 0 ? this.objectPlannerDAO.getBatch(allObjectPlannerIds) : new ArrayList();
        for (ObjectPlanner objectPlanner : allObjectPlanners) {
            Long objectPlannerId = objectPlanner.getId();
            if (refObjectPlannerIdsSet.contains(objectPlannerId)) {
                objectPlanner.setPlannerId(null);
            }
            if (objectPlanner.getChanged() == null || objectPlanner.getChanged().intValue() != ObjectPlannerChanged.UNCHANGED.getValue()) continue;
            objectPlanner.setChanged(Integer.valueOf(ObjectPlannerChanged.CHANGED.getValue()));
        }
        if (allObjectPlanners.size() > 0) {
            this.objectPlannerDAO.updateBatch(allObjectPlanners);
        }
    }

    private void treatPlotOrderTemplatesOnParticipationDelete(Long particiationId) {
        List<PlottOrderTemplate> templates = this.plotOrderTemplateDAO.getByPlotter(particiationId);
        for (PlottOrderTemplate template : templates) {
            template.setPlotterId(null);
        }
        if (templates.size() > 0) {
            this.plotOrderTemplateDAO.updateBatch(templates);
        }
        List<PlottOrderItemTemplate> itemTemplates = this.plotOrderItemTemplateDAO.getByDeliveryAddress(particiationId);
        Set<Long> itemTemplateIds = QueryHelper.getPersistentIdsSet(itemTemplates);
        List<PlottOrderItem> items = this.plotOrderItemDAO.getByTemplates(itemTemplateIds);
        for (PlottOrderItem plottOrderItem : items) {
            itemTemplateIds.remove(plottOrderItem.getTemplateId());
        }
        HashSet<Long> templateIds = new HashSet<Long>();
        for (PlottOrderItemTemplate itemTemplate : itemTemplates) {
            templateIds.add(itemTemplate.getOrderContractId());
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        ArrayList<PlottOrderItemTemplate> itemTemplatesToUpdate = new ArrayList<PlottOrderItemTemplate>();
        for (PlottOrderItemTemplate itemTemplate : itemTemplates) {
            if (itemTemplateIds.contains(itemTemplate.getId())) {
                arrayList.add(itemTemplate.getId());
                continue;
            }
            itemTemplate.setInvalidated(Boolean.valueOf(true));
            itemTemplatesToUpdate.add(itemTemplate);
        }
        if (arrayList.size() > 0) {
            this.plotOrderItemTemplateDAO.deleteBatch(arrayList);
        } else {
            this.plotOrderItemTemplateDAO.updateBatch(itemTemplatesToUpdate);
        }
        List allTemplates = this.plotOrderTemplateDAO.getBatch(templateIds);
        List<PlottOrderItemTemplate> allItemTemplates = this.plotOrderItemTemplateDAO.getByOrderContracts(templateIds);
        HashMap templateIdToItems = new HashMap();
        for (PlottOrderItemTemplate itemTemplate : allItemTemplates) {
            Long templateId = itemTemplate.getOrderContractId();
            if (!templateIdToItems.containsKey(templateId)) {
                templateIdToItems.put(templateId, new ArrayList());
            }
            ((List)templateIdToItems.get(templateId)).add(itemTemplate);
        }
        ArrayList<Long> templateIdsToDelete = new ArrayList<Long>();
        ArrayList<PlottOrderTemplate> templatesToUpdate = new ArrayList<PlottOrderTemplate>();
        for (PlottOrderTemplate template : allTemplates) {
            Long templateId = template.getId();
            if (!templateIdToItems.containsKey(templateId)) {
                templateIdsToDelete.add(templateId);
                continue;
            }
            boolean onlyInvalid = true;
            for (PlottOrderItemTemplate itemTemplate : (List)templateIdToItems.get(templateId)) {
                onlyInvalid &= itemTemplate.getInvalidated() != null && itemTemplate.getInvalidated() != false;
            }
            if (!onlyInvalid) continue;
            template.setInvalidated(Boolean.valueOf(true));
            templatesToUpdate.add(template);
        }
        if (templatesToUpdate.size() > 0) {
            this.plotOrderTemplateDAO.updateBatch(templatesToUpdate);
        }
        if (templateIdsToDelete.size() > 0) {
            this.plotOrderTemplateDAO.deleteBatch(templateIdsToDelete);
        }
    }

    private void treatAttachedReviewTasksOnParticipationDelete(Long participationId) {
        this.taskUtils.deleteAttachedReviewTasksByParticipation(participationId);
    }

    private void treatWorkflowNodePositionsOnParticipationDelete(Long participationId) {
        boolean setMarkedForDeletion = false;
        boolean noPositions = true;
        List<WorkflowJoin> workflowJoins = this.workflowDAO.getWorkflowJoinsParticipationId(participationId);
        List<WorkflowInfo> infos = PlanningNotificationQueryHelper.getWorkflowInfos(workflowJoins);
        block2: for (WorkflowInfo info : infos) {
            if (setMarkedForDeletion) break;
            List nodeInfos = info.getNodeInfos();
            block3: for (WorkflowNodeInfo nodeInfo : nodeInfos) {
                if (setMarkedForDeletion) continue block2;
                List nodePositionInfos = nodeInfo.getPositionInfos();
                WorkflowNodeTemplate nodeTemplate = nodeInfo.getTemplate();
                boolean isStartNode = nodeTemplate.getIsStartNode() != null && nodeTemplate.getIsStartNode() != false;
                for (WorkflowNodePositionInfo nodePositionInfo : nodePositionInfos) {
                    if (setMarkedForDeletion) continue block3;
                    WorkflowNodePosition workflowNodePosition = nodePositionInfo.getWorkflowNodePosition();
                    List results = nodePositionInfo.getWorkflowActivityPositionResults();
                    Long currParticipationId = workflowNodePosition.getProjectParticipationId();
                    if (currParticipationId == null || currParticipationId.longValue() != participationId.longValue()) continue;
                    if (isStartNode || results.size() > 0) {
                        setMarkedForDeletion = true;
                        continue;
                    }
                    try {
                        noPositions &= this.deleteWorkflowNodePositionForParticipationDelete(info, nodeInfo, nodePositionInfo);
                    }
                    catch (Exception e) {
                        setMarkedForDeletion = true;
                    }
                }
            }
        }
        if (!setMarkedForDeletion && noPositions) {
            RoleType roleType = this.roleTypeDAO.getByParticipationId(participationId);
            if (roleType != null && roleType.getType() != null && roleType.getType().intValue() == RoleTypeEnum.PROJECT_SURVEILLANT.getValue()) {
                this.futureEmailDAO.deleteByParticipation(participationId);
            }
            this.deleteParticipationById(participationId);
        }
    }

    private boolean deleteWorkflowNodePositionForParticipationDelete(WorkflowInfo info, WorkflowNodeInfo nodeInfo, WorkflowNodePositionInfo positionInfo) {
        Long workflowNodePositionId = positionInfo.getWorkflowNodePosition().getId();
        if (this.isWorkflowInitialized(info)) {
            WorkflowToken initiatorToken;
            List initiatorTokens = positionInfo.getInitiatorTokens();
            WorkflowToken workflowToken = initiatorToken = initiatorTokens.size() > 0 ? (WorkflowToken)initiatorTokens.get(0) : null;
            if (initiatorToken != null && initiatorToken.getOwnerPositionId() != null && initiatorToken.getOwnerPositionId().longValue() == workflowNodePositionId.longValue()) {
                this.workflowTokenDAO.delete(initiatorToken.getId());
                this.workflowNodePositionDAO.delete(workflowNodePositionId);
                positionInfo.setInitiatorTokens(new ArrayList());
                if (!this.checkWorkflowHasTokens(info)) {
                    List entities = info.getWorkflowEntities();
                    for (WorkflowEntity entity : entities) {
                        entity.setWorkflowEntityStatusId(null);
                    }
                    this.workflowEntityDAO.updateBatch(entities);
                }
                return true;
            }
            return false;
        }
        this.workflowNodePositionDAO.delete(workflowNodePositionId);
        return true;
    }

    private boolean isWorkflowInitialized(WorkflowInfo workflowInfo) {
        List nodeInfos = workflowInfo.getNodeInfos();
        for (WorkflowNodeInfo nodeInfo : nodeInfos) {
            List positionInfos = nodeInfo.getPositionInfos();
            for (WorkflowNodePositionInfo positionInfo : positionInfos) {
                if (positionInfo.getOwnerTokens().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkWorkflowHasTokens(WorkflowInfo workflowInfo) {
        List nodeInfos = workflowInfo.getNodeInfos();
        for (WorkflowNodeInfo nodeInfo : nodeInfos) {
            WorkflowNodeTemplate template = nodeInfo.getTemplate();
            if (template.getIsStartNode() == null || !template.getIsStartNode().booleanValue()) continue;
            List positionInfos = nodeInfo.getPositionInfos();
            for (WorkflowNodePositionInfo positionInfo : positionInfos) {
                if (positionInfo.getInitiatorTokens().size() <= 0 && positionInfo.getOwnerTokens().size() <= 0) continue;
                return true;
            }
        }
        return false;
    }

    public List<ParticipationSelectionJoin> getParticipationSelectionJoinsBySubProject(Long subProjectId) {
        SubProject subProject = (SubProject)this.subProjectDAO.get(subProjectId);
        Long projectId = subProject.getProjectId();
        Project project = (Project)this.projectDAO.get(projectId);
        boolean withSubProjectRestriction = project.getWithParticipantsSubProjectRestriction() != null && project.getWithParticipantsSubProjectRestriction() != false;
        List<ParticipationSelectionJoin> rawJoins = this.projectParticipationDAO.getSelectionJoinsBySubProjectAndRoleTypeId(subProjectId, null);
        HashSet<Long> restrictedParticipationIds = new HashSet<Long>();
        if (withSubProjectRestriction) {
            List<ProjectParticipationSubProjectRestrictions> restrictions = this.projectParticipationSubProjectRestrictionDAO.getBySubProject(subProjectId);
            for (ProjectParticipationSubProjectRestrictions restriction : restrictions) {
                restrictedParticipationIds.add(restriction.getProjectParticipationId());
            }
        }
        ArrayList<ParticipationSelectionJoin> joins = new ArrayList<ParticipationSelectionJoin>();
        for (ParticipationSelectionJoin rawJoin : rawJoins) {
            Long participationId = rawJoin.getProjectParticipationId();
            if (restrictedParticipationIds.contains(participationId)) continue;
            joins.add(rawJoin);
        }
        return joins;
    }
}

