/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ReviewCycleInstance;
import at.cdes.api.joinDto.InstanceEditJoin;
import at.cdes.api.joinDto.InstanceJoin;
import at.cdes.api.obj.dto.InstanceSearchModel;
import at.cdes.impl.dao.ReviewCycleInstanceDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcReviewCycleInstanceDAO;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.SearchHelper;
import java.sql.PreparedStatement;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcReviewCycleInstanceDAO
extends AbstractJdbcReviewCycleInstanceDAO
implements ReviewCycleInstanceDAO {
    @Override
    public ReviewCycleInstance getByReviewCycleCellInstance(Long reviewCycleCellInstanceId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM review_cycle_cell_instance\nJOIN review_cycle_instance ON review_cycle_instance.id = review_cycle_cell_instance.review_cycle_instance_id\nWHERE review_cycle_cell_instance.id = ?\n";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)reviewCycleCellInstanceId));
    }

    @Override
    public List<ReviewCycleInstance> getBySubProjectWithLabelIfNecessary(Long subProjectId) {
        String sql = "SELECT " + JdbcReviewCycleInstanceDAO.getSelectClauseForDto() + "FROM review_cycle_instance JOIN review_cycle           ON review_cycle_instance.review_cycle_id = review_cycle.id WHERE review_cycle_instance.sub_project_id = ? AND (    review_cycle.is_label_mandatory = 0 OR review_cycle.is_label_mandatory IS NULL OR review_cycle_instance.label_id IS NOT NULL) ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId));
    }

    @Override
    public List<InstanceJoin> getInstanceJoinsBySubProject(Long subProjectId, InstanceSearchModel searchModel) {
        String name = searchModel.getName();
        String sql = "SELECT " + JdbcReviewCycleInstanceDAO.getInstanceJoinSelectClause() + "FROM review_cycle_instance JOIN review_cycle            ON review_cycle_instance.review_cycle_id = review_cycle.id LEFT JOIN label                   ON review_cycle_instance.label_id = label.id WHERE review_cycle_instance.sub_project_id = ? ";
        if (SearchHelper.isStringFilled(name)) {
            sql = sql + "AND review_cycle_instance.name LIKE ? ";
        }
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcReviewCycleInstanceDAO::fillInstanceJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
            if (SearchHelper.isStringFilled(name)) {
                statement.setString(currIndex++, SearchHelper.convertForSearch(name));
            }
        });
    }

    @Override
    public List<InstanceEditJoin> getInstanceEditJoinsByInstance(Long instanceId) {
        String sql = "SELECT " + JdbcReviewCycleInstanceDAO.getInstanceEditJoinSelectClause() + "FROM review_cycle_instance LEFT JOIN review_cycle               ON review_cycle_instance.review_cycle_id = review_cycle.id LEFT JOIN label                      ON review_cycle_instance.label_id = label.id LEFT JOIN review_cycle_cell_instance ON review_cycle_cell_instance.review_cycle_instance_id = review_cycle_instance.id LEFT JOIN review_cycle_cell cell     ON review_cycle_cell_instance.review_cycle_cell_id = cell.id LEFT JOIN review_cycle_node_instance ON review_cycle_node_instance.review_cycle_cell_instance_id = review_cycle_cell_instance.id LEFT JOIN review_cycle_node node     ON review_cycle_node_instance.review_cycle_node_id = node.id LEFT JOIN review_cycle_node_position ON review_cycle_node_position.review_cycle_node_instance_id = review_cycle_node_instance.id LEFT JOIN realm                      ON review_cycle_node_position.realm_id = realm.id LEFT JOIN project_participation      ON review_cycle_node_position.project_participation_id = project_participation.id LEFT JOIN cdes_role                  ON project_participation.role_id = cdes_role.id LEFT JOIN role_type                  ON cdes_role.type_id = role_type.id LEFT JOIN organisation               ON project_participation.organisation_id = organisation.id LEFT JOIN project_participant        ON     project_participant.participation_id = project_participation.id AND project_participant.inactive_flag = 0 AND project_participant.main_participant_flag = 1 LEFT JOIN organisation_person        ON project_participant.organisation_person_id = organisation_person.id LEFT JOIN person                     ON organisation_person.person_id = person.id WHERE review_cycle_instance.id = ? ORDER BY cell.position ASC";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcReviewCycleInstanceDAO::fillInstanceEditJoinFromResultSet, statement -> JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)instanceId));
    }

    @Override
    public List<ReviewCycleInstance> getByNetwork(Long networkId) {
        String sql = "SELECT " + JdbcReviewCycleInstanceDAO.getSelectClauseForDto() + "FROM review_cycle_instance JOIN sub_project            ON review_cycle_instance.sub_project_id = sub_project.id JOIN project                ON sub_project.project_id = project.id JOIN network                ON project.network_id = network.id WHERE network.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
        });
    }
}

