/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.WorkflowActivity;
import at.cdes.api.dto.WorkflowActivityNotificationSnippet;
import at.cdes.impl.dao.WorkflowActivityNotificationSnippetDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcWorkflowActivityNotificationSnippetDAO
extends AbstrIdDAO<WorkflowActivityNotificationSnippet>
implements WorkflowActivityNotificationSnippetDAO {
    public JdbcWorkflowActivityNotificationSnippetDAO() {
        super(WorkflowActivityNotificationSnippet.class, "id", "workflow_activity_notification_snippet", new String[]{"id", "workflow_activity_id", "organisation_person_id", "send_time"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcWorkflowActivityNotificationSnippetDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "workflow_activity_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_person_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "send_time") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcWorkflowActivityNotificationSnippetDAO.getSelectClauseForDto("workflow_activity_notification_snippet", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcWorkflowActivityNotificationSnippetDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".workflow_activity_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "workflow_activity_id") + "," + entityLocalName + ".organisation_person_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "organisation_person_id") + "," + entityLocalName + ".send_time" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "send_time") + " ";
    }

    protected WorkflowActivityNotificationSnippet fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        WorkflowActivityNotificationSnippet workflowActivityNotificationSnippet = new WorkflowActivityNotificationSnippet();
        workflowActivityNotificationSnippet.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowActivityNotificationSnippet.setWorkflowActivityId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowActivityNotificationSnippet.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        workflowActivityNotificationSnippet.setSendTime(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)(++columnIndex)));
        return workflowActivityNotificationSnippet;
    }

    public static WorkflowActivityNotificationSnippet fillWorkflowActivityNotificationSnippetFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        WorkflowActivityNotificationSnippet workflowActivityNotificationSnippet = new WorkflowActivityNotificationSnippet();
        workflowActivityNotificationSnippet.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowActivityNotificationSnippet.setWorkflowActivityId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowActivityNotificationSnippet.setOrganisationPersonId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        workflowActivityNotificationSnippet.setSendTime(JDBCHelper.getUtcSeconds((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return workflowActivityNotificationSnippet;
    }

    public static WorkflowActivityNotificationSnippet fillWorkflowActivityNotificationSnippetFromResultSet(ResultSet rs) throws SQLException {
        return JdbcWorkflowActivityNotificationSnippetDAO.fillWorkflowActivityNotificationSnippetFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 4;
    }

    @Override
    public void deleteByWorkflowActivity(final Long workflowActivityId) {
        String sql = "DELETE FROM workflow_activity_notification_snippet WHERE workflow_activity_id = ? ";
        this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<Void>(){

            public Void perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                statement.setLong(currIndex++, workflowActivityId);
                statement.execute();
                return null;
            }
        });
    }

    public int update(WorkflowActivityNotificationSnippet dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<WorkflowActivityNotificationSnippet> dtos) {
        Iterator<WorkflowActivityNotificationSnippet> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, WorkflowActivityNotificationSnippet workflowActivityNotificationSnippet) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)workflowActivityNotificationSnippet.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)workflowActivityNotificationSnippet.getWorkflowActivityId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)workflowActivityNotificationSnippet.getOrganisationPersonId());
        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)4, (Double)workflowActivityNotificationSnippet.getSendTime());
    }

    @Override
    public List<WorkflowActivityNotificationSnippet> getByWorkflowActivity(WorkflowActivity workflowActivity) {
        return this.getByWorkflowActivity(workflowActivity.getId());
    }

    @Override
    public List<WorkflowActivityNotificationSnippet> getByWorkflowActivity(final Long workflowActivityId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"workflow_activity_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, workflowActivityId);
            }
        });
    }

    @Override
    public List<WorkflowActivityNotificationSnippet> getByOrganisationPerson(OrganisationPerson organisationPerson) {
        return this.getByOrganisationPerson(organisationPerson.getId());
    }

    @Override
    public List<WorkflowActivityNotificationSnippet> getByOrganisationPerson(final Long organisationPersonId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_person_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, organisationPersonId);
            }
        });
    }

    @Override
    public List<WorkflowActivityNotificationSnippet> getByWorkflowActivitys(Collection<Long> workflowActivityId) {
        if (workflowActivityId.isEmpty()) {
            return new ArrayList<WorkflowActivityNotificationSnippet>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[workflowActivityId.size()];
        int n = 0;
        Iterator<Long> it = workflowActivityId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"workflow_activity_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<WorkflowActivityNotificationSnippet> getByOrganisationPersons(Collection<Long> organisationPersonId) {
        if (organisationPersonId.isEmpty()) {
            return new ArrayList<WorkflowActivityNotificationSnippet>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[organisationPersonId.size()];
        int n = 0;
        Iterator<Long> it = organisationPersonId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"organisation_person_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

