/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.planning;

import java.text.Collator;
import java.util.List;

public class CompareHelper {
    public static boolean areStringsEqual(String s1, String s2) {
        if (s1 != null != (s2 != null)) {
            return false;
        }
        return s1 == null || s1.equals(s2);
    }

    public static boolean areDoublesEqual(Double d1, Double d2) {
        if (d1 != null != (d2 != null)) {
            return false;
        }
        return d1 == null || d1.equals(d2);
    }

    public static boolean areLongsEqual(Long l1, Long l2) {
        if (l1 != null != (l2 != null)) {
            return false;
        }
        return l1 == null || l1.equals(l2);
    }

    public static boolean areIntsEqual(Integer i1, Integer i2) {
        if (i1 != null != (i2 != null)) {
            return false;
        }
        return i1 == null || i1.equals(i2);
    }

    public static int defaultIntCompare(Integer i1, Integer i2, boolean descending) {
        if (descending) {
            return -CompareHelper.defaultIntCompare(i1, i2, descending);
        }
        int v1 = i1 != null ? i1 : 0;
        int v2 = i2 != null ? i2 : 0;
        return v1 - v2;
    }

    public static int defaultDoubleCompare(Double d1, Double d2, boolean descending) {
        return CompareHelper.doubleCompare(d1, d2, 0.0, 1.0E-10, descending);
    }

    public static int doubleCompare(Double d1, Double d2, double defaultValue, double epsilon, boolean descending) {
        if (descending) {
            return -CompareHelper.doubleCompare(d1, d2, defaultValue, epsilon, descending);
        }
        if (d1 == null) {
            d1 = defaultValue;
        }
        if (d2 == null) {
            d2 = defaultValue;
        }
        double diff = Math.abs(d1 - d2);
        if (d1 < d2 && diff > epsilon) {
            return -1;
        }
        if (d1 > d2 && diff > epsilon) {
            return 1;
        }
        return 0;
    }

    public static int defaultStringCompare(Collator collator, String s1, String s2, boolean descending) {
        if (descending) {
            return -CompareHelper.defaultStringCompare(collator, s1, s2, false);
        }
        if (s1 == null) {
            s1 = "";
        }
        if (s2 == null) {
            s2 = "";
        }
        return collator.compare(s1, s2);
    }

    public static int defaultStringCompare(Collator collator, String[] listOne, String[] listTwo, boolean descending) {
        String s1 = "";
        String s2 = "";
        for (String l1 : listOne) {
            s1 = s1 + l1 + ";";
        }
        for (String l2 : listTwo) {
            s2 = s2 + l2 + ";";
        }
        return CompareHelper.defaultStringCompare(collator, s1, s2, descending);
    }

    public static int defaultStringCompare(Collator collator, List<String> listOne, List<String> listTwo, boolean descending) {
        String s1 = "";
        String s2 = "";
        for (String l1 : listOne) {
            s1 = s1 + l1 + ";";
        }
        for (String l2 : listTwo) {
            s2 = s2 + l2 + ";";
        }
        return CompareHelper.defaultStringCompare(collator, s1, s2, descending);
    }
}

