/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util;

import at.cdes.api.compositeDto.MasterDataInfo;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.dto.DocumentNumberVersionPart;
import at.cdes.api.dto.DocumentType;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.IReviewCycleCellConnectionOrEntry;
import at.cdes.api.dto.Object;
import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.ObjectType;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.ReviewCycleCellConnection;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.dto.SubProject;
import at.cdes.api.dto.SubProjectType;
import at.cdes.api.joinDto.DocumentNumberGenJoin;
import at.cdes.api.joinDto.ObjectPlannerWithObject;
import at.cdes.api.joinDto.PlanDeliverNewJoin;
import at.cdes.api.joinDto.PlanDeliverSaveJoin;
import at.cdes.api.voc.DocumentNumberComponent;
import at.cdes.api.voc.DocumentNumberUniqueness;
import at.cdes.api.voc.DocumentVersionStatus;
import java.util.HashMap;
import java.util.IllegalFormatConversionException;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.util.lang.Triple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodeHelper {
    private static final Logger log = LoggerFactory.getLogger(CodeHelper.class);

    public static String getDocumentNumber(Map<Long, MasterDataInfo> idToMasterDataInfo, Document document, PlanDeliverNewJoin planDeliverNewJoin, boolean includeLastSeparator) {
        return CodeHelper.getDocumentNumber(idToMasterDataInfo, document, planDeliverNewJoin.getObjectPlanner(), planDeliverNewJoin.getObject(), planDeliverNewJoin.getSubProject(), planDeliverNewJoin.getProject(), planDeliverNewJoin.getProjectParticipation(), planDeliverNewJoin.getObjectPlannerRelease(), planDeliverNewJoin.getObjectRelease(), includeLastSeparator);
    }

    public static String getDocumentNumber(Map<Long, MasterDataInfo> idToMasterDataInfo, Document document, PlanDeliverSaveJoin planDeliverSaveJoin, boolean includeLastSeparator) {
        return CodeHelper.getDocumentNumber(idToMasterDataInfo, document, planDeliverSaveJoin.getObjectPlanner(), planDeliverSaveJoin.getObject(), planDeliverSaveJoin.getSubProject(), planDeliverSaveJoin.getProject(), planDeliverSaveJoin.getProjectParticipation(), planDeliverSaveJoin.getObjectPlannerRelease(), planDeliverSaveJoin.getObjectRelease(), includeLastSeparator);
    }

    public static String getDocumentNumber(Map<Long, MasterDataInfo> idToMasterDataInfo, Document document, DocumentNumberGenJoin documentNumberGenJoin, boolean includeLastSeparator) {
        return CodeHelper.getDocumentNumber(idToMasterDataInfo, document, documentNumberGenJoin.getObjectPlanner(), documentNumberGenJoin.getObject(), documentNumberGenJoin.getSubProject(), documentNumberGenJoin.getProject(), documentNumberGenJoin.getProjectParticipation(), documentNumberGenJoin.getObjectPlannerRelease(), documentNumberGenJoin.getObjectRelease(), includeLastSeparator);
    }

    public static String getDocumentNumber(Map<Long, MasterDataInfo> idToMasterDataInfo, Document document, ObjectPlanner objectPlanner, Object object, SubProject subProject, Project project, ProjectParticipation projectParticipation, ObjectPlannerRelease objectPlannerRelease, ObjectRelease objectRelease, boolean includeLastSeparator) {
        Long numberPartGroupId = project.getDocumentNumberPartGroupId();
        MasterDataInfo masterDataInfo = CodeHelper.getMasterDataInfoByNumberPartGroupId(idToMasterDataInfo, numberPartGroupId);
        if (masterDataInfo == null) {
            throw new IllegalArgumentException("Could not find any masterDataInfo for project [" + project.getId() + "] and its numberPartGroupId [" + numberPartGroupId + "]");
        }
        String result = "";
        String lastResultWithoutSeperator = "";
        List numberParts = (List)masterDataInfo.getGroupIdToDocumentNumberParts().get(numberPartGroupId);
        for (int n = 0; n < numberParts.size(); ++n) {
            DocumentNumberPart numberPart = (DocumentNumberPart)numberParts.get(n);
            DocumentNumberComponent component = CodeHelper.getDocumentNumberComponentByOgnlPath(numberPart.getOgnlRule());
            String format = numberPart.getFormat();
            String formattedCode = CodeHelper.getCodeByComponent(component, masterDataInfo, format, document, objectPlanner, object, subProject, project, projectParticipation, objectPlannerRelease, objectRelease);
            result = result + formattedCode;
            if (n < numberParts.size() - 1 || includeLastSeparator) {
                lastResultWithoutSeperator = result;
                result = result + numberPart.getSeperator();
                continue;
            }
            if (n != numberParts.size() - 1 || formattedCode.length() != 0 || includeLastSeparator) continue;
            result = lastResultWithoutSeperator;
        }
        return result;
    }

    public static List<DocumentNumberPart> getDocumentNumberPartsByGroupId(Map<Long, MasterDataInfo> idToMasterDataInfo, Long numberPartGroupId) {
        MasterDataInfo masterDataInfo = CodeHelper.getMasterDataInfoByNumberPartGroupId(idToMasterDataInfo, numberPartGroupId);
        return (List)masterDataInfo.getGroupIdToDocumentNumberParts().get(numberPartGroupId);
    }

    private static MasterDataInfo getMasterDataInfoByNumberPartGroupId(Map<Long, MasterDataInfo> idToMasterDataInfo, Long numberPartGroupId) {
        for (MasterDataInfo masterDataInfo : idToMasterDataInfo.values()) {
            Map groupIdToDocumentNumberGroup = masterDataInfo.getGroupIdToDocumentNumberGroup();
            if (!groupIdToDocumentNumberGroup.containsKey(numberPartGroupId)) continue;
            return masterDataInfo;
        }
        return null;
    }

    public static DocumentNumberUniqueness getDocumentNumberUniqueness(List<DocumentNumberPart> numberParts) {
        for (DocumentNumberPart numberPart : numberParts) {
            if (numberPart.getOgnlRule() != null && numberPart.getOgnlRule().contains(".objectPlanner.") && numberPart.isUniqueKey().booleanValue()) {
                return DocumentNumberUniqueness.OBJECT_PLANNER;
            }
            if (numberPart.getOgnlRule() == null || !numberPart.getOgnlRule().contains(".object.") || !numberPart.isUniqueKey().booleanValue()) continue;
            return DocumentNumberUniqueness.OBJECT;
        }
        return null;
    }

    private static DocumentNumberComponent getDocumentNumberComponentByOgnlPath(String path) {
        if ("document.documentType.code".equals(path)) {
            return DocumentNumberComponent.DOCUMENT_TYPE_CODE;
        }
        if ("document.documentType.documentTypeGroup.code".equals(path)) {
            return DocumentNumberComponent.DOCUMENT_TYPE_GROUP_CODE;
        }
        if ("document.number".equals(path)) {
            return DocumentNumberComponent.DOCUMENT_NUMBER;
        }
        if ("document.part".equals(path)) {
            return DocumentNumberComponent.DOCUMENT_PART;
        }
        if ("document.objectPlanner.code".equals(path)) {
            return DocumentNumberComponent.OBJECTPLANNER_CODE;
        }
        if ("document.objectPlanner.object.code".equals(path)) {
            return DocumentNumberComponent.OBJECT_CODE_FULL;
        }
        if ("document.objectPlanner.object.codeWithoutType".equals(path)) {
            return DocumentNumberComponent.OBJECT_CODE;
        }
        if ("document.objectPlanner.object.objectType.code".equals(path)) {
            return DocumentNumberComponent.OBJECT_TYPE_CODE;
        }
        if ("document.objectPlanner.planner.customerId".equals(path)) {
            return DocumentNumberComponent.PROJECT_PARTICIPATION_CUSTOMER_ID;
        }
        if ("document.documentList.subProject.code".equals(path)) {
            return DocumentNumberComponent.SUBPROJECT_CODE;
        }
        if ("document.documentList.subProject.codeWithoutNumber".equals(path)) {
            return DocumentNumberComponent.SUBPROJECT_CODE_WITHOUTNUMBER;
        }
        if ("document.documentList.subProject.number".equals(path)) {
            return DocumentNumberComponent.SUBPROJECT_NUMBER;
        }
        if ("document.documentList.subProject.subProjectType.code".equals(path)) {
            return DocumentNumberComponent.SUBPROJECT_TYPE_CODE;
        }
        if ("document.documentList.subProject.project.code".equals(path)) {
            return DocumentNumberComponent.PROJECT_CODE;
        }
        if ("relObjectPlanner.code".equals(path)) {
            return DocumentNumberComponent.OBJECTPLANNER_RELEASE_CODE;
        }
        if ("relObjectPlanner.object.code".equals(path)) {
            return DocumentNumberComponent.OBJECT_RELEASE_CODE_FULL;
        }
        if ("relObjectPlanner.object.codeWithoutType".equals(path)) {
            return DocumentNumberComponent.OBJECT_RELEASE_CODE;
        }
        if ("relObjectPlanner.object.objectType.code".equals(path)) {
            return DocumentNumberComponent.OBJECT_RELEASE_TYPE_CODE;
        }
        if ("relObjectPlanner.planner.customerId".equals(path)) {
            return DocumentNumberComponent.PROJECT_PARTICIPATION_CUSTOMER_ID;
        }
        if ("relObjectPlanner.objectPlanner.planner.customerId".equals(path)) {
            return DocumentNumberComponent.PROJECT_PARTICIPATION_CUSTOMER_ID;
        }
        throw new IllegalArgumentException("Unsupported ognl path: " + path);
    }

    private static String getCodeByComponent(DocumentNumberComponent component, MasterDataInfo masterDataInfo, String format, Document document, ObjectPlanner objectPlanner, Object object, SubProject subProject, Project project, ProjectParticipation projectParticipation, ObjectPlannerRelease objectPlannerRelease, ObjectRelease objectRelease) {
        if (component == DocumentNumberComponent.DOCUMENT_TYPE_CODE) {
            Long documentTypeId = document.getDocumentTypeId();
            DocumentType documentType = masterDataInfo.getDocumentType(documentTypeId);
            return CodeHelper.formatCode(format, documentType != null ? documentType.getCode() : "---");
        }
        if (component == DocumentNumberComponent.DOCUMENT_TYPE_GROUP_CODE) {
            Long documentTypeId = document.getDocumentTypeId();
            DocumentType documentType = masterDataInfo.getDocumentType(documentTypeId);
            if (documentType.getDocumentTypeGroupId() != null) {
                DocumentType group = masterDataInfo.getDocumentType(documentType.getDocumentTypeGroupId());
                return CodeHelper.formatCode(format, group != null ? group.getCode() : "---");
            }
            return CodeHelper.formatCode(format, (String)null);
        }
        if (component == DocumentNumberComponent.DOCUMENT_NUMBER) {
            return CodeHelper.formatCode(format, document.getNumber());
        }
        if (component == DocumentNumberComponent.DOCUMENT_PART) {
            return CodeHelper.formatCode(format, document.getPart());
        }
        if (component == DocumentNumberComponent.OBJECTPLANNER_CODE) {
            return CodeHelper.formatCode(format, objectPlanner.getCode());
        }
        if (component == DocumentNumberComponent.OBJECTPLANNER_RELEASE_CODE) {
            return CodeHelper.formatCode(format, objectPlannerRelease.getCode());
        }
        if (component == DocumentNumberComponent.OBJECT_CODE) {
            return CodeHelper.formatCode(format, object.getCode());
        }
        if (component == DocumentNumberComponent.OBJECT_RELEASE_CODE) {
            return CodeHelper.formatCode(format, objectRelease.getCode());
        }
        if (component == DocumentNumberComponent.OBJECT_CODE_FULL) {
            Long objectTypeId = object.getObjectTypeId();
            ObjectType objectType = masterDataInfo.getObjectType(objectTypeId);
            if (objectType == null) {
                return CodeHelper.formatCode(format, object.getCode());
            }
            return CodeHelper.formatCode(format, object.getCode() + objectType.getCode());
        }
        if (component == DocumentNumberComponent.OBJECT_RELEASE_CODE_FULL) {
            Long objectTypeId = objectRelease.getObjectTypeId();
            ObjectType objectType = masterDataInfo.getObjectType(objectTypeId);
            if (objectType == null) {
                return CodeHelper.formatCode(format, objectRelease.getCode());
            }
            return CodeHelper.formatCode(format, objectRelease.getCode() + objectType.getCode());
        }
        if (component == DocumentNumberComponent.OBJECT_TYPE_CODE) {
            Long objectTypeId = object.getObjectTypeId();
            ObjectType objectType = masterDataInfo.getObjectType(objectTypeId);
            if (objectType == null) {
                return "---";
            }
            return CodeHelper.formatCode(format, objectType.getCode());
        }
        if (component == DocumentNumberComponent.OBJECT_RELEASE_TYPE_CODE) {
            Long objectTypeId = objectRelease.getObjectTypeId();
            ObjectType objectType = masterDataInfo.getObjectType(objectTypeId);
            if (objectType == null) {
                return "---";
            }
            return CodeHelper.formatCode(format, objectType.getCode());
        }
        if (component == DocumentNumberComponent.SUBPROJECT_CODE) {
            return CodeHelper.formatCode(format, subProject.getCode() + (subProject.getNumber() != null ? subProject.getNumber() : ""));
        }
        if (component == DocumentNumberComponent.SUBPROJECT_CODE_WITHOUTNUMBER) {
            return CodeHelper.formatCode(format, subProject.getCode());
        }
        if (component == DocumentNumberComponent.SUBPROJECT_NUMBER) {
            return CodeHelper.formatCode(format, subProject.getNumber());
        }
        if (component == DocumentNumberComponent.SUBPROJECT_TYPE_CODE) {
            Long subProjectTypeId = subProject.getSubProjectTypeId();
            SubProjectType subProjectType = (SubProjectType)masterDataInfo.getIdToSubProjectType().get(subProjectTypeId);
            return subProjectType != null ? subProjectType.getCode() : "---";
        }
        if (component == DocumentNumberComponent.PROJECT_CODE) {
            return CodeHelper.formatCode(format, project.getCode());
        }
        if (component == DocumentNumberComponent.PROJECT_PARTICIPATION_CUSTOMER_ID) {
            return CodeHelper.formatCode(format, projectParticipation.getCustomerId());
        }
        throw new IllegalArgumentException("Unsupported component " + component + " passed to getCodeByComponent");
    }

    private static String formatCode(String format, String code) {
        if (code == null) {
            return "";
        }
        if (format == null || format.length() == 0) {
            return code;
        }
        try {
            if (format.contains("d")) {
                return String.format(format, Integer.valueOf(code));
            }
            return String.format(format, code);
        }
        catch (IllegalFormatConversionException e) {
            throw new IllegalArgumentException("Illegal format: " + format, e);
        }
    }

    private static String formatCode(String format, Integer code) {
        if (code == null) {
            return "";
        }
        if (format == null || format.length() == 0) {
            return String.valueOf(code);
        }
        try {
            if (format.length() == 4 && format.charAt(0) == '%' && format.charAt(1) == '.' && format.charAt(3) == 'd') {
                int prec = Integer.parseInt(String.valueOf(format.charAt(2)));
                String codeStr = code.toString();
                String part1 = codeStr.substring(0, codeStr.length() - prec);
                String part2 = codeStr.substring(codeStr.length() - prec, codeStr.length());
                return part1 + "." + part2;
            }
            return String.format(format, code);
        }
        catch (IllegalFormatConversionException e) {
            throw new IllegalArgumentException("Illegal format: " + format, e);
        }
    }

    public static Map<Long, String> getUniqueKeysForDocuments(List<ObjectPlannerWithObject> documentInfos, List<DocumentNumberPart> numberParts, Map<Long, DocumentType> idToDocumentType) {
        HashMap<Long, String> documentIdToUniqueKey = new HashMap<Long, String>();
        for (ObjectPlannerWithObject documentInfo : documentInfos) {
            Document document = documentInfo.getDocument();
            ProjectParticipation projectParticipation = documentInfo.getProjectParticipation();
            Long documentId = document.getId();
            String uniqueKey = CodeHelper.getUniqueKeyForDocument(document, numberParts, idToDocumentType, projectParticipation);
            documentIdToUniqueKey.put(documentId, uniqueKey);
        }
        return documentIdToUniqueKey;
    }

    public static String getUniqueKeyForDocument(Document document, List<DocumentNumberPart> numberParts, Map<Long, DocumentType> idToDocumentType, ProjectParticipation projectParticipation) {
        String key = "";
        for (DocumentNumberPart numberPart : numberParts) {
            DocumentType documentType;
            if (!numberPart.isUniqueKey().booleanValue()) continue;
            String ognlRule = numberPart.getOgnlRule();
            if ("document.documentType.documentTypeGroup.code".equals(ognlRule)) {
                if (document.getDocumentTypeId() != null) {
                    documentType = idToDocumentType.get(document.getDocumentTypeId());
                    if (documentType != null && documentType.getDocumentTypeGroupId() != null) {
                        DocumentType documentTypeGroup = idToDocumentType.get(documentType.getDocumentTypeGroupId());
                        if (documentTypeGroup != null && documentTypeGroup.getCode() != null) {
                            key = CodeHelper.appendToUniqueKey(key, documentTypeGroup.getCode());
                            continue;
                        }
                        key = CodeHelper.appendToUniqueKey(key, "---");
                        continue;
                    }
                    key = CodeHelper.appendToUniqueKey(key, "---");
                    continue;
                }
                key = CodeHelper.appendToUniqueKey(key, "---");
                continue;
            }
            if ("document.documentType.code".equals(ognlRule)) {
                if (document.getDocumentTypeId() != null) {
                    documentType = idToDocumentType.get(document.getDocumentTypeId());
                    if (documentType != null && documentType.getCode() != null) {
                        key = CodeHelper.appendToUniqueKey(key, documentType.getCode());
                        continue;
                    }
                    key = CodeHelper.appendToUniqueKey(key, "---");
                    continue;
                }
                key = CodeHelper.appendToUniqueKey(key, "---");
                continue;
            }
            if ("relObjectPlanner.planner.customerId".equals(ognlRule)) {
                if (projectParticipation.getCustomerId() != null) {
                    key = CodeHelper.appendToUniqueKey(key, projectParticipation.getCustomerId());
                    continue;
                }
                key = CodeHelper.appendToUniqueKey(key, "---");
                continue;
            }
            if ("document.number".equals(ognlRule)) {
                key = CodeHelper.appendToUniqueKey(key, String.valueOf(document.getNumber()));
                continue;
            }
            if (!"document.part".equals(ognlRule) || document.getPart() == null) continue;
            key = CodeHelper.appendToUniqueKey(key, String.valueOf(document.getPart()));
        }
        return key;
    }

    private static String appendToUniqueKey(String uniqueKey, String suffix) {
        if (uniqueKey.length() == 0) {
            return uniqueKey + suffix;
        }
        return uniqueKey + "___" + suffix;
    }

    public static String getI18nDueDateRemark(ResourceBundle resourceBundle, String dueDateRemark) {
        if (dueDateRemark == null) {
            return null;
        }
        if (dueDateRemark.equals("noEntries")) {
            return resourceBundle.getString("dueDateRemarkNoEntries");
        }
        if (dueDateRemark.equals("beforeConstruction")) {
            return resourceBundle.getString("dueDateRemarkBeforeConstruction");
        }
        if (dueDateRemark.equals("whileConstruction")) {
            return resourceBundle.getString("dueDateRemarkWhileConstruction");
        }
        if (dueDateRemark.equals("duringConstruction")) {
            return resourceBundle.getString("dueDateRemarkDuringConstruction");
        }
        if (dueDateRemark.equals("beforeStarting")) {
            return resourceBundle.getString("dueDateRemarkBeforeStarting");
        }
        if (dueDateRemark.equals("afterConstruction")) {
            return resourceBundle.getString("dueDateRemarkAfterConstruction");
        }
        if (dueDateRemark.equals("inOperation")) {
            return resourceBundle.getString("dueDateRemarkInOperation");
        }
        if (dueDateRemark.equals("tillOperationApproval")) {
            return resourceBundle.getString("dueDateRemarkTillOperationApproval");
        }
        return dueDateRemark;
    }

    public static String getI18nDocumentVersionStatus(ResourceBundle resourceBundle, DocumentVersionStatus documentVersionStatus) {
        Integer statusInt = documentVersionStatus != null ? Integer.valueOf(documentVersionStatus.getValue()) : null;
        return CodeHelper.getI18nDocumentVersionStatus(resourceBundle, statusInt);
    }

    public static String getI18nDocumentVersionStatus(ResourceBundle resourceBundle, Integer statusInt) {
        if (statusInt == null) {
            return resourceBundle.getString("documentVersionStatusNoStatus");
        }
        int status = statusInt;
        if (status == DocumentVersionStatus.INREVIEW.getValue()) {
            return resourceBundle.getString("documentVersionStatusInReview");
        }
        if (status == DocumentVersionStatus.RELEASEDPOSITIV.getValue()) {
            return resourceBundle.getString("documentVersionStatusReleasedPositiv");
        }
        if (status == DocumentVersionStatus.NOTINREVIEW.getValue()) {
            return resourceBundle.getString("documentVersionStatusNotInReview");
        }
        if (status == DocumentVersionStatus.RELEASEDNEGATIV.getValue()) {
            return resourceBundle.getString("documentVersionStatusReleasedNegativ");
        }
        if (status == DocumentVersionStatus.INVALIDATEDVERSION.getValue()) {
            return resourceBundle.getString("documentVersionStatusInvalidatedVersion");
        }
        if (status == DocumentVersionStatus.INVALIDATEDALL.getValue()) {
            return resourceBundle.getString("documentVersionStatusInvalidatedAll");
        }
        if (status == DocumentVersionStatus.DELETED.getValue()) {
            return resourceBundle.getString("documentVersionStatusDeleted");
        }
        if (status == DocumentVersionStatus.PREREVIEWED.getValue()) {
            return resourceBundle.getString("documentVersionStatusPrereviewied");
        }
        if (status == DocumentVersionStatus.ACTIVE.getValue()) {
            return resourceBundle.getString("documentVersionStatusActive");
        }
        if (status == DocumentVersionStatus.ASBUILT.getValue()) {
            return resourceBundle.getString("documentVersionStatusAsBuilt");
        }
        if (status == DocumentVersionStatus.NOTUPLOADED.getValue()) {
            return resourceBundle.getString("documentVersionStatusNotUploaded");
        }
        if (status == DocumentVersionStatus.REPLACED.getValue()) {
            return resourceBundle.getString("documentVersionStatusReplaced");
        }
        if (status == DocumentVersionStatus.ABORTED.getValue()) {
            return resourceBundle.getString("documentVersionStatusAborted");
        }
        return resourceBundle.getString("documentVersionStatusNoStatus");
    }

    public static boolean isDocumentVersionStatusInAction(DocumentVersionStatus documentVersionStatus) {
        return documentVersionStatus == DocumentVersionStatus.INREVIEW || documentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION || documentVersionStatus == DocumentVersionStatus.RELEASEDNEGATIV || documentVersionStatus == DocumentVersionStatus.DELETED;
    }

    public static String getDocumentVersionName(ReviewCycleCellConnection connection, ReviewCycleCellResult oldResult, DocumentVersion oldResultDocumentVersion, List<DocumentNumberPart> documentNumberParts, DocumentNumberVersionPart sourceCellCycleDocumentNumberVersionPart, Document document) {
        return CodeHelper.getDocumentVersionName((IReviewCycleCellConnectionOrEntry)connection, oldResult, oldResultDocumentVersion, documentNumberParts, sourceCellCycleDocumentNumberVersionPart, document, null);
    }

    public static Triple<String, String, String> getDocumentVersionNameParts(IReviewCycleCellConnectionOrEntry connection, List<DocumentNumberPart> documentNumberParts, Document document) {
        Triple documentVersionNameParts = new Triple();
        documentVersionNameParts.setFirst((java.lang.Object)CodeHelper.getDocumentVersionName(connection, null, null, documentNumberParts, null, document, null));
        Triple<String, String, String> versionParts = CodeHelper.getVersionParts(connection, null, null, null, null);
        documentVersionNameParts.setSecond((java.lang.Object)((String)versionParts.getFirst()));
        documentVersionNameParts.setThird((java.lang.Object)((String)versionParts.getThird()));
        return documentVersionNameParts;
    }

    public static String getDocumentVersionName(IReviewCycleCellConnectionOrEntry connection, ReviewCycleCellResult oldResult, DocumentVersion oldResultDocumentVersion, List<DocumentNumberPart> documentNumberParts, DocumentNumberVersionPart sourceCellCycleDocumentNumberVersionPart, Document document, DocumentVersion documentVersion) {
        String number = document.getName() + CodeHelper.getLastSeparator(document, documentNumberParts);
        Triple<String, String, String> versionParts = CodeHelper.getVersionParts(connection, oldResult, oldResultDocumentVersion, sourceCellCycleDocumentNumberVersionPart, documentVersion);
        return number + (String)versionParts.getFirst() + (String)versionParts.getSecond() + (String)versionParts.getThird();
    }

    private static Triple<String, String, String> getVersionParts(IReviewCycleCellConnectionOrEntry connection, ReviewCycleCellResult oldResult, DocumentVersion oldResultDocumentVersion, DocumentNumberVersionPart sourceCellCycleDocumentNumberVersionPart, DocumentVersion documentVersion) {
        String separator;
        Triple versionParts = new Triple();
        String versionPartA = null;
        String versionPartB = null;
        versionPartA = documentVersion != null && documentVersion.getVersionParta() != null ? (connection.getPartaFormat() != null && connection.getPartaFormat().contains("d") ? CodeHelper.format(connection.getPartaFormat(), Integer.valueOf(documentVersion.getVersionParta())) : CodeHelper.format(connection.getPartaFormat(), documentVersion.getVersionParta())) : CodeHelper.getPart(connection, oldResult, oldResultDocumentVersion, "A");
        String string = separator = sourceCellCycleDocumentNumberVersionPart != null ? sourceCellCycleDocumentNumberVersionPart.getSeperator() : "";
        versionPartB = documentVersion != null && documentVersion.getVersionPartb() != null ? (connection.getPartbFormat() != null && connection.getPartbFormat().contains("d") ? CodeHelper.format(connection.getPartbFormat(), Integer.valueOf(documentVersion.getVersionPartb())) : CodeHelper.format(connection.getPartbFormat(), documentVersion.getVersionPartb())) : CodeHelper.getPart(connection, oldResult, oldResultDocumentVersion, "B");
        if (documentVersion != null) {
            documentVersion.setVersionParta(versionPartA);
            documentVersion.setVersionPartb(versionPartB);
            documentVersion.setVersionPartSeperator(separator);
        }
        versionParts.setFirst((java.lang.Object)versionPartA);
        versionParts.setSecond((java.lang.Object)separator);
        versionParts.setThird((java.lang.Object)versionPartB);
        return versionParts;
    }

    private static String getLastSeparator(Document document, List<DocumentNumberPart> documentNumberParts) {
        DocumentNumberPart lastDocumentNumberPart = null;
        for (DocumentNumberPart documentNumberPart : documentNumberParts) {
            if (lastDocumentNumberPart != null && documentNumberPart.getPosition() <= lastDocumentNumberPart.getPosition()) continue;
            lastDocumentNumberPart = documentNumberPart;
        }
        String separator = lastDocumentNumberPart.getSeperator();
        return separator;
    }

    private static String format(String format, java.lang.Object value) {
        if (value == null) {
            return "";
        }
        if (format == null || format.length() == 0) {
            return String.valueOf(value);
        }
        try {
            if (format.contains("d")) {
                return String.format(format, Integer.valueOf((String)value));
            }
            return String.format(format, value);
        }
        catch (IllegalFormatConversionException e) {
            log.error("IllegalFormatConversion error ", (Throwable)e);
            return String.valueOf(value);
        }
    }

    private static String getPart(IReviewCycleCellConnectionOrEntry connection, ReviewCycleCellResult oldResult, DocumentVersion oldResultDocumentVersion, String part) {
        String rule = null;
        if ("A".equals(part)) {
            rule = connection.getPartaRule();
        } else if ("B".equals(part)) {
            rule = connection.getPartbRule();
        }
        java.lang.Object result = null;
        if (rule == null || rule.trim().length() == 0) {
            result = "A".equals(part) ? oldResultDocumentVersion.getVersionParta() : oldResultDocumentVersion.getVersionPartb();
        } else if (rule.startsWith("calculator.add")) {
            int openBracketPos = rule.indexOf(40);
            int commaPos = rule.indexOf(44);
            int closeBracketPos = rule.indexOf(41);
            String firstOperand = rule.substring(openBracketPos + 1, commaPos);
            String secondOperand = rule.substring(commaPos + 1, closeBracketPos);
            String firstValue = null;
            if ("oldPartA".equals(firstOperand)) {
                firstValue = oldResultDocumentVersion.getVersionParta();
            } else if ("oldPartB".equals(firstOperand)) {
                firstValue = oldResultDocumentVersion.getVersionPartb();
            } else {
                throw new IllegalArgumentException("firstOperand [" + firstOperand + "] is not supported.");
            }
            result = CodeHelper.add(firstValue, secondOperand);
        } else {
            result = rule.startsWith("asBuiltReference!=null?asBuiltReference.versionPartB:") ? rule.replace("asBuiltReference!=null?asBuiltReference.versionPartB:", "") : (rule.startsWith("'") ? rule.substring(1, rule.length() - 1) : rule);
        }
        if ("A".equals(part)) {
            if (connection.getPartaFormat() != null && connection.getPartaFormat().contains("d")) {
                return CodeHelper.format(connection.getPartaFormat(), Integer.valueOf(String.valueOf(result)));
            }
            return CodeHelper.format(connection.getPartaFormat(), result);
        }
        if (connection.getPartbFormat() != null && connection.getPartbFormat().contains("d")) {
            return CodeHelper.format(connection.getPartbFormat(), Integer.valueOf(String.valueOf(result)));
        }
        return CodeHelper.format(connection.getPartbFormat(), result);
    }

    private static int add(String as, String bs) {
        int a = 0;
        int b = 0;
        try {
            if (as != null) {
                a = Integer.parseInt(as);
            }
            if (bs != null) {
                b = Integer.parseInt(bs);
            }
        }
        catch (NumberFormatException e) {
            return 0;
        }
        return a + b;
    }
}

