/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ObjectList;
import at.cdes.api.dto.SubProject;
import at.cdes.impl.dao.ObjectListDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcObjectListDAO
extends AbstrIdDAO<ObjectList>
implements ObjectListDAO {
    public JdbcObjectListDAO() {
        super(ObjectList.class, "id", "object_list", new String[]{"id", "version", "sub_project_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcObjectListDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "version") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "sub_project_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcObjectListDAO.getSelectClauseForDto("object_list", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcObjectListDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".version" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "version") + "," + entityLocalName + ".sub_project_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "sub_project_id") + " ";
    }

    protected ObjectList fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectList objectList = new ObjectList();
        objectList.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectList.setVersion(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        objectList.setSubProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return objectList;
    }

    public static ObjectList fillObjectListFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ObjectList objectList = new ObjectList();
        objectList.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectList.setVersion(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectList.setSubProjectId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return objectList;
    }

    public static ObjectList fillObjectListFromResultSet(ResultSet rs) throws SQLException {
        return JdbcObjectListDAO.fillObjectListFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 3;
    }

    public int update(ObjectList dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ObjectList> dtos) {
        Iterator<ObjectList> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ObjectList objectList) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)objectList.getId());
        JDBCHelper.setInt((PreparedStatement)statement, (int)2, (Number)objectList.getVersion());
        JDBCHelper.setLong((PreparedStatement)statement, (int)3, (Number)objectList.getSubProjectId());
    }

    @Override
    public List<ObjectList> getBySubProject(SubProject subProject) {
        return this.getBySubProject(subProject.getId());
    }

    @Override
    public List<ObjectList> getBySubProject(final Long subProjectId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"sub_project_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, subProjectId);
            }
        });
    }

    @Override
    public List<ObjectList> getBySubProjects(Collection<Long> subProjectId) {
        if (subProjectId.isEmpty()) {
            return new ArrayList<ObjectList>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[subProjectId.size()];
        int n = 0;
        Iterator<Long> it = subProjectId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"sub_project_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

