/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.joinDto.ObjectPlannerPositionReleaseChainJoin;
import at.cdes.api.joinDto.ObjectPlannerReleaseObjectJoin;
import at.cdes.impl.dao.ObjectPlannerReleaseDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcObjectPlannerReleaseDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcObjectPlannerReleaseDAO
extends AbstractJdbcObjectPlannerReleaseDAO
implements ObjectPlannerReleaseDAO {
    public static final String OBJECT_TO_OBJECT_RELEASE_JOINS = "     JOIN object                 ON object.id = object_planner.object_id\n     JOIN object_list            ON object_list.id = object.object_list_id\n     JOIN object_list_release    ON object_list_release.object_list_id = object_list.id\n                                AND object_list_release.version = (object_list.version - 1)\n     JOIN object_release         ON object_release.object_list_release_id = object_list_release.id\n                                AND object_release.object_id = object.id\n     JOIN object_planner_release ON object_planner_release.object_id = object_release.id\n                                AND object_planner_release.object_planner_id = object_planner.id\n";

    @Override
    public List<ObjectPlannerPositionReleaseChainJoin> getObjectPlannerPositionReleaseChainJoinsByPersonViaObjectPlannerPositionRelease(final Long personId) {
        String sql = "SELECT " + JdbcObjectPlannerReleaseDAO.getObjectPlannerPositionReleaseChainJoinSelectClause() + "FROM ((((((((((((( organisation_person JOIN project_participant    ON project_participant.organisation_person_id = organisation_person.id) JOIN project_participation  ON project_participant.participation_id = project_participation.id) JOIN project                ON project_participation.project_id = project.id) JOIN network                ON project.network_id = network.id) LEFT JOIN object_planner_position_release ON object_planner_position_release.project_participation_id = project_participation.id) LEFT JOIN object_planner_position_definition ON object_planner_position_release.definition_id = object_planner_position_definition.id) LEFT JOIN object_planner_definition ON object_planner_position_definition.definition_id = object_planner_definition.id) LEFT JOIN object_planner_release ON object_planner_position_release.object_planner_id = object_planner_release.id) LEFT JOIN object_release         ON object_planner_release.object_id = object_release.id) LEFT JOIN object_list_release    ON object_release.object_list_release_id = object_list_release.id) LEFT JOIN object_list            ON object_list_release.object_list_id = object_list.id) LEFT JOIN sub_project            ON object_list_release.sub_project_id = sub_project.id) LEFT JOIN review_cycle_instance_released ON object_planner_release.review_cycle_instance_id = review_cycle_instance_released.id) WHERE (project_participant.inactive_flag IS NULL OR project_participant.inactive_flag = 0) AND (object_list_release.id IS NULL OR object_list_release.version = object_list.version - 1) AND organisation_person.person_id = ? ";
        List joins = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ObjectPlannerPositionReleaseChainJoin>>(){

            public List<ObjectPlannerPositionReleaseChainJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ObjectPlannerPositionReleaseChainJoin> ret = new ArrayList<ObjectPlannerPositionReleaseChainJoin>();
                while (rs.next()) {
                    ret.add(AbstractJdbcObjectPlannerReleaseDAO.fillObjectPlannerPositionReleaseChainJoinFromResultSet(rs));
                }
                return ret;
            }
        });
        return joins;
    }

    @Override
    public ObjectPlannerRelease getReleasedObjectPlannerForObjectPlanner(Long objectPlannerId) {
        String sql = "SELECT " + JdbcObjectPlannerReleaseDAO.getSelectClauseForDto() + "\n     FROM object_planner\n" + OBJECT_TO_OBJECT_RELEASE_JOINS + "WHERE object_planner.id = ?\n";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(objectPlannerId));
    }

    @Override
    public ObjectPlannerRelease getReleasedObjectPlannerForDocument(Long documentId) {
        String sql = "SELECT " + JdbcObjectPlannerReleaseDAO.getSelectClauseForDto() + "\n     FROM document\n     JOIN object_planner         ON object_planner.id = document.object_planner_id\n" + OBJECT_TO_OBJECT_RELEASE_JOINS + "WHERE document.id = ?\n";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(documentId));
    }

    @Override
    public ObjectPlannerRelease getByListAndDocument(Long objectListReleaseId, Long documentId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM document\nJOIN object_planner         ON object_planner.id = document.object_planner_id\nJOIN object_planner_release ON object_planner_release.object_planner_id = object_planner.id\nJOIN object_release         ON object_release.id = object_planner_release.object_id\n                           AND object_release.object_list_release_id = ?\nWHERE document.id = ?\n";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(objectListReleaseId).addLong(documentId));
    }

    @Override
    public ObjectPlannerReleaseObjectJoin getReleasedObjectPlannerObjectJoinForDocument(Long documentId) {
        String sql = "SELECT " + JdbcObjectPlannerReleaseDAO.getObjectPlannerReleaseObjectJoinSelectClause() + "\n     FROM document\n     JOIN object_planner         ON object_planner.id = document.object_planner_id\n     JOIN object                 ON object.id = object_planner.object_id\n     JOIN object_list            ON object_list.id = object.object_list_id\n     JOIN object_list_release    ON object_list_release.object_list_id = object_list.id\n                                AND object_list_release.version = (object_list.version - 1)\n     JOIN object_release         ON object_release.object_list_release_id = object_list_release.id\n                                AND object_release.object_id = object.id\n     JOIN object_planner_release ON object_planner_release.object_id = object_release.id\n                                AND object_planner_release.object_planner_id = object_planner.id\nWHERE document.id = ?\n";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, AbstractJdbcObjectPlannerReleaseDAO::fillObjectPlannerReleaseObjectJoinFromResultSet, filler -> filler.addLong(documentId));
    }

    @Override
    public List<ObjectPlannerRelease> getActiveByParticipationId(Long participationId) {
        String sql = "SELECT " + JdbcObjectPlannerReleaseDAO.getSelectClauseForDto() + "FROM object_planner_release JOIN object_release                  ON object_planner_release.object_id = object_release.id JOIN object_list_release             ON object_release.object_list_release_id = object_list_release.id JOIN object_list                     ON object_list_release.object_list_id = object_list.id WHERE object_planner_release.planner_id = ? AND object_list_release.version = object_list.version - 1 ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participationId);
        });
    }

    @Override
    public List<ObjectPlannerRelease> getActiveByObjectListReleaseId(Long objectListReleaseId) {
        String sql = "SELECT " + JdbcObjectPlannerReleaseDAO.getSelectClauseForDto() + "FROM object_release JOIN object_planner_release ON object_planner_release.object_id = object_release.id WHERE object_release.object_list_release_id = ? AND object_release.inactive_flag = 0 ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListReleaseId);
        });
    }

    @Override
    public List<ObjectPlannerRelease> getActiveBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcObjectPlannerReleaseDAO.getSelectClauseForDto() + "FROM object_list JOIN object_list_release    ON     object_list_release.sub_project_id = object_list.sub_project_id AND object_list_release.version = object_list.version - 1 JOIN object_release         ON     object_release.object_list_release_id = object_list_release.id JOIN object_planner_release ON     object_planner_release.object_id = object_release.id WHERE object_list.sub_project_id = ? AND object_release.inactive_flag = 0 ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }

    @Override
    public List<ObjectPlannerRelease> getByObjectListRelease(Long objectListReleaseId) {
        String sql = "SELECT " + JdbcObjectPlannerReleaseDAO.getSelectClauseForDto() + "FROM object_release JOIN object_planner_release ON object_planner_release.object_id = object_release.id WHERE object_release.object_list_release_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListReleaseId);
        });
    }
}

