/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DigestCalculator;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ProjectStatusChange;
import at.cdes.api.dto.Signature;
import at.cdes.impl.dao.ProjectStatusChangeDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcProjectStatusChangeDAO
extends AbstrIdDAO<ProjectStatusChange>
implements ProjectStatusChangeDAO {
    public JdbcProjectStatusChangeDAO() {
        super(ProjectStatusChange.class, "id", "project_status_change", new String[]{"id", "project_id", "old_status", "new_status", "digest", "digest_calculator_id", "signature_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcProjectStatusChangeDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "old_status") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "new_status") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcProjectStatusChangeDAO.getSelectClauseForDto("project_status_change", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcProjectStatusChangeDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".project_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project_id") + "," + entityLocalName + ".old_status" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "old_status") + "," + entityLocalName + ".new_status" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "new_status") + "," + entityLocalName + ".digest" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest") + "," + entityLocalName + ".digest_calculator_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "digest_calculator_id") + "," + entityLocalName + ".signature_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "signature_id") + " ";
    }

    protected ProjectStatusChange fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ProjectStatusChange projectStatusChange = new ProjectStatusChange();
        projectStatusChange.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        projectStatusChange.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        projectStatusChange.setOldStatus(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        projectStatusChange.setNewStatus(JDBCHelper.getInt((ResultSet)rs, (int)(++columnIndex)));
        projectStatusChange.setDigest(rs.getString(++columnIndex));
        projectStatusChange.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        projectStatusChange.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return projectStatusChange;
    }

    public static ProjectStatusChange fillProjectStatusChangeFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ProjectStatusChange projectStatusChange = new ProjectStatusChange();
        projectStatusChange.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        projectStatusChange.setProjectId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        projectStatusChange.setOldStatus(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        projectStatusChange.setNewStatus(JDBCHelper.getInt((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        projectStatusChange.setDigest(rs.getString(columnIndex.incrementAndGet()));
        projectStatusChange.setDigestCalculatorId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        projectStatusChange.setSignatureId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return projectStatusChange;
    }

    public static ProjectStatusChange fillProjectStatusChangeFromResultSet(ResultSet rs) throws SQLException {
        return JdbcProjectStatusChangeDAO.fillProjectStatusChangeFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 7;
    }

    public int update(ProjectStatusChange dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ProjectStatusChange> dtos) {
        Iterator<ProjectStatusChange> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ProjectStatusChange projectStatusChange) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)projectStatusChange.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)projectStatusChange.getProjectId());
        JDBCHelper.setInt((PreparedStatement)statement, (int)3, (Number)projectStatusChange.getOldStatus());
        JDBCHelper.setInt((PreparedStatement)statement, (int)4, (Number)projectStatusChange.getNewStatus());
        statement.setString(5, projectStatusChange.getDigest());
        JDBCHelper.setLong((PreparedStatement)statement, (int)6, (Number)projectStatusChange.getDigestCalculatorId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)projectStatusChange.getSignatureId());
    }

    @Override
    public List<ProjectStatusChange> getByProject(Project project) {
        return this.getByProject(project.getId());
    }

    @Override
    public List<ProjectStatusChange> getByProject(final Long projectId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectId);
            }
        });
    }

    @Override
    public List<ProjectStatusChange> getByDigestCalculator(DigestCalculator digestCalculator) {
        return this.getByDigestCalculator(digestCalculator.getId());
    }

    @Override
    public List<ProjectStatusChange> getByDigestCalculator(final Long digestCalculatorId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, digestCalculatorId);
            }
        });
    }

    @Override
    public List<ProjectStatusChange> getBySignature(Signature signature) {
        return this.getBySignature(signature.getId());
    }

    @Override
    public List<ProjectStatusChange> getBySignature(final Long signatureId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, signatureId);
            }
        });
    }

    @Override
    public List<ProjectStatusChange> getByProjects(Collection<Long> projectId) {
        if (projectId.isEmpty()) {
            return new ArrayList<ProjectStatusChange>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectId.size()];
        int n = 0;
        Iterator<Long> it = projectId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ProjectStatusChange> getByDigestCalculators(Collection<Long> digestCalculatorId) {
        if (digestCalculatorId.isEmpty()) {
            return new ArrayList<ProjectStatusChange>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[digestCalculatorId.size()];
        int n = 0;
        Iterator<Long> it = digestCalculatorId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"digest_calculator_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<ProjectStatusChange> getBySignatures(Collection<Long> signatureId) {
        if (signatureId.isEmpty()) {
            return new ArrayList<ProjectStatusChange>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[signatureId.size()];
        int n = 0;
        Iterator<Long> it = signatureId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"signature_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

