/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.plot;

import at.cdes.api.dto.Country;
import at.cdes.api.dto.ExportResult;
import at.cdes.api.dto.Network;
import at.cdes.api.dto.OrderAddress;
import at.cdes.api.dto.OrderStep;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.PlottOrder;
import at.cdes.api.dto.PlottProperties;
import at.cdes.api.dto.Project;
import at.cdes.api.plot.compositeDto.PlotTaskInfo;
import at.cdes.api.plot.compositeDto.PlotTaskItemInfo;
import at.cdes.api.plot.voc.PlotMargin;
import at.cdes.api.plot.voc.PlotPaperQuality;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.api.voc.plot.AcceptedMode;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.plot.LengthCalculator;
import at.cdes.impl.plot.LengthUnit;
import at.cdes.impl.service.ChallengeLoginServiceImpl;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.odf.OdfHelper;
import at.cdes.impl.util.plot.PlotHelper;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.datetime.UtcTimestamp;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfTextDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.office.OfficeTextElement;
import org.odftoolkit.odfdom.dom.element.style.StyleParagraphPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextHElement;
import org.w3c.dom.Node;

public class PlotTaskPdfExporter {
    private Boolean enableCustomerLogo;
    private String costumerLabel;
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private PersonVariablesDAO personVariablesDAO;
    private String tempDirName;

    public void setEnableCustomerLogo(Boolean enableCustomerLogo) {
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public void setCostumerLabel(String costumerLabel) {
        this.costumerLabel = costumerLabel;
    }

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public ScratchFile export(Long organisationPersonId, boolean plotOrderAcceptance, PlotTaskInfo plotTaskInfo) throws Exception {
        OdfTextDocument document = DocumentFactory.constructTextDocument((String)"export/emptyLandscapeTemplate.odt", ChallengeLoginServiceImpl.class, (Locale)ThreadLocalManager.getLoginLocale());
        ResourceBundle resourceBundle = OdfHelper.getResourceBundleByPrincipal(this.personVariablesDAO);
        OfficeTextElement officeText = document.getContentRoot();
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        StyleTextPropertiesElement normalTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", "");
        String normalTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{normalTextProperties});
        StyleTextPropertiesElement boldTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "12pt", "bold");
        String boldTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{boldTextProperties});
        OdfHelper.constructHeader(context, document, standardParagraphStyle, null, this.enableCustomerLogo);
        String leftFooterLabelRaw = resourceBundle.getString("plotTaskCaption");
        OdfHelper.constructFooter(context, document, standardParagraphStyle, leftFooterLabelRaw, null, null, resourceBundle);
        TextFactory.constructTextNode((Node)officeText, (String)"", null);
        TextFactory.constructTextNode((Node)officeText, (String)"", null);
        TextHElement textHElement = officeText.newTextHElement(2);
        textHElement.setTextContent(resourceBundle.getString("plotTaskCaption"));
        officeText.newTextPElement();
        this.appendBillingAddress(officeText, plotTaskInfo, boldTextStyle);
        this.appendPlotterAddress(officeText, plotTaskInfo, boldTextStyle);
        this.appendNetworkProject(officeText, resourceBundle, plotTaskInfo, boldTextStyle);
        this.appendDateAndNumbers(officeText, resourceBundle, plotTaskInfo, normalTextStyle, boldTextStyle);
        this.appendItemTable(officeText, context, resourceBundle, plotTaskInfo);
        this.appendSumSection(officeText, context, resourceBundle, plotTaskInfo, normalTextStyle);
        this.appendAdditionalSection(officeText, context, resourceBundle, plotTaskInfo, normalTextStyle);
        this.appendAcceptanceSection(officeText, context, resourceBundle, plotTaskInfo, normalTextStyle, standardParagraphStyle);
        this.appendCompletedSection(officeText, context, resourceBundle, plotTaskInfo, normalTextStyle, plotOrderAcceptance);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Plotauftrag_", (OdfTextDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.PDF, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        return new ScratchFile(new File(tmpFileName), "application/pdf", "attachment; filename*=UTF-8''" + encodedFileName);
    }

    private String constructPageBreakStyle(OdfContext context, String parentParagraphStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphPropertiesElement = stylesOfficeStyles.constructParagraphPropertiesWithBreakBefore("page");
        paragraphPropertiesElement.setFoMarginTopAttribute("0cm");
        return stylesOfficeStyles.getParagraphStyleWithParent(parentParagraphStyle, new OdfStylePropertiesBase[]{paragraphPropertiesElement});
    }

    private String constructLeftStyle(OdfContext context, String parentParagraphStyle) {
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        StyleParagraphPropertiesElement paragraphPropertiesElement = stylesOfficeStyles.constructParagraphPropertiesWithBreakBefore("page");
        paragraphPropertiesElement.setFoMarginLeftAttribute("0cm");
        return stylesOfficeStyles.getParagraphStyleWithParent(parentParagraphStyle, new OdfStylePropertiesBase[]{paragraphPropertiesElement});
    }

    private void appendBillingAddress(OfficeTextElement officeText, PlotTaskInfo plotTaskInfo, String boldTextStyle) {
        OrderAddress billingAddress = plotTaskInfo.getBillingAddress();
        String locality = billingAddress.getPostalCode() + " " + billingAddress.getLocalityName();
        String country = plotTaskInfo.getBillingCountry().getDescDe();
        TextFactory.constructTextNode((Node)officeText, (String)billingAddress.getOrganisationName(), (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)billingAddress.getPostalAddress(), (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)locality, (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)country, (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)boldTextStyle);
    }

    private void appendPlotterAddress(OfficeTextElement officeText, PlotTaskInfo plotTaskInfo, String boldTextStyle) {
        Organisation plotterOrganisation = plotTaskInfo.getPlotterOrganisation();
        String locality = plotterOrganisation.getPostalCode() + " " + plotterOrganisation.getLocalityName();
        String country = plotTaskInfo.getPlotterCountry().getDescDe();
        TextFactory.constructTextNode((Node)officeText, (String)plotterOrganisation.getName(), (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)plotterOrganisation.getPostalAddress(), (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)locality, (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)country, (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)boldTextStyle);
    }

    private void appendNetworkProject(OfficeTextElement officeText, ResourceBundle resourceBundle, PlotTaskInfo plotTaskInfo, String boldTextStyle) {
        Network network = plotTaskInfo.getNetwork();
        Project project = plotTaskInfo.getProject();
        String networkString = resourceBundle.getString("network") + ": " + network.getName();
        String projectString = resourceBundle.getString("project") + ": " + project.getCode() + " " + project.getName();
        TextFactory.constructTextNode((Node)officeText, (String)networkString, (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)projectString, (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)boldTextStyle);
    }

    private void appendDateAndNumbers(OfficeTextElement officeText, ResourceBundle resourceBundle, PlotTaskInfo plotTaskInfo, String normalTextStyle, String boldTextStyle) {
        OrderStep requestStep = plotTaskInfo.getRequestStep();
        OrderAddress billingAddress = plotTaskInfo.getBillingAddress();
        PlottOrder plotOrder = plotTaskInfo.getPlotOrder();
        String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
        String createdString = resourceBundle.getString("plotTaskDate") + " " + (requestStep.getCreated() != null ? DateHelper.formatUtcSeconds(requestStep.getCreated(), "Europe/Vienna", dateFormatPattern) : "");
        String clientCodeString = resourceBundle.getString("plotTaskClientCode") + " " + (billingAddress.getClientCode() != null ? billingAddress.getClientCode() : "");
        String jobNumberString = resourceBundle.getString("plotTaskJobNumber") + " " + (plotOrder.getJobNumber() != null ? plotOrder.getJobNumber().toString() : "");
        TextFactory.constructTextNode((Node)officeText, (String)createdString, (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)clientCodeString, (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)jobNumberString, (String)boldTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)normalTextStyle);
    }

    private void appendItemTable(OfficeTextElement officeText, OdfContext context, ResourceBundle resourceBundle, PlotTaskInfo plotTaskInfo) {
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        StyleTableCellPropertiesElement headerCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000");
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{headerCellProperties});
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold");
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{headerTextProperties});
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null);
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{dataTextProperties});
        String rowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentAutomaticStyles.constructTableRowPropertiesWithBackgroundColor("#ffffff", "always")});
        String pageBreakStyle = this.constructPageBreakStyle(context, standardParagraphStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)pageBreakStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", null);
        TextFactory.constructTextNode((Node)officeText, (String)"", null);
        TextHElement textHElement = officeText.newTextHElement(4);
        textHElement.setTextContent(resourceBundle.getString("plotTaskPositionCaption"));
        officeText.newTextPElement();
        HashMap<String, Double> relativeColumnToWidth = new HashMap<String, Double>();
        relativeColumnToWidth.put("document", 1.0);
        relativeColumnToWidth.put("paperQuality", 0.75);
        relativeColumnToWidth.put("color", 0.5);
        relativeColumnToWidth.put("margin", 0.5);
        relativeColumnToWidth.put("mirror", 0.5);
        relativeColumnToWidth.put("scale", 0.5);
        relativeColumnToWidth.put("count", 0.5);
        relativeColumnToWidth.put("area", 0.5);
        relativeColumnToWidth.put("pages", 0.5);
        relativeColumnToWidth.put("deliveryAddress", 1.0);
        relativeColumnToWidth.put("received", 1.0);
        ArrayList columnSortSpecs = new ArrayList();
        List<FancyOdfTableColumn<PlotTaskItemInfo>> itemColumns = this.constructItemColumns(resourceBundle, dataCellStyle, dataTextStyle);
        FancyOdfTable table = new FancyOdfTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, Double.valueOf(23.9), relativeColumnToWidth, itemColumns);
        table.setDataRowStyle(rowStyle);
        List itemInfos = plotTaskInfo.getItemInfos();
        table.render((Node)officeText, itemInfos, columnSortSpecs);
    }

    private List<FancyOdfTableColumn<PlotTaskItemInfo>> constructItemColumns(final ResourceBundle resourceBundle, final String dataCellStyle, final String dataTextStyle) {
        ArrayList<FancyOdfTableColumn<PlotTaskItemInfo>> columns = new ArrayList<FancyOdfTableColumn<PlotTaskItemInfo>>();
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("document", resourceBundle.getString("plotTaskDocumentVersionName")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                ArrayList<String> lines = new ArrayList<String>();
                lines.add(itemInfo.getDocumentVersion().getName());
                String content = itemInfo.getDocumentRelease().getId() != null ? itemInfo.getDocumentRelease().getContent() : itemInfo.getDocument().getContent();
                lines.add(content);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, lines);
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("paperQuality", resourceBundle.getString("plotTaskPaperQuality")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, itemInfo.getPlotProperties().getPaperQuality());
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("color", resourceBundle.getString("plotTaskColor")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                Integer color = itemInfo.getPlotProperties().getIsInColor();
                String colorString = PlotHelper.getColorLabel(resourceBundle, color);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, colorString);
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("margin", resourceBundle.getString("plotTaskMargin")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, itemInfo.getPlotProperties().getMargin());
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("mirror", resourceBundle.getString("plotTaskMirror")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                Boolean mirror = itemInfo.getPlotProperties().getMirror();
                String mirrorString = PlotHelper.getMirrorLabel(resourceBundle, mirror);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, mirrorString);
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("scale", resourceBundle.getString("plotTaskScale")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, itemInfo.getPlotProperties().getScale());
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("count", resourceBundle.getString("plotTaskCountCaption")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                Integer count = itemInfo.getPlotProperties().getCount();
                if (count != null) {
                    String countString = MessageFormat.format(resourceBundle.getString("plotTaskCount"), count);
                    CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, countString);
                }
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("area", resourceBundle.getString("plotTaskArea")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                PlottProperties plotProperties = itemInfo.getPlotProperties();
                Double area = PlotHelper.getPlotPropertiesArea(plotProperties);
                String areaString = PlotHelper.getPlotAreaString(area);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, areaString);
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("pages", resourceBundle.getString("plotTaskPages")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                Integer numberOfPages = itemInfo.getDocumentVersion().getNumberOfPages();
                String numberOfPagesString = numberOfPages != null ? numberOfPages.toString() : "";
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, numberOfPagesString);
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("deliveryAddress", resourceBundle.getString("plotTaskDeliveryAddress")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                OrderAddress orderAddress = itemInfo.getDeliveryAddress();
                Country country = itemInfo.getDeliveryCountry();
                String organisationName = orderAddress.getOrganisationName() != null ? orderAddress.getOrganisationName() : "";
                String givenName = orderAddress.getGivenName() != null ? orderAddress.getGivenName() : "";
                String surName = orderAddress.getSurName() != null ? orderAddress.getSurName() : "";
                String postalAddress = orderAddress.getPostalAddress() != null ? orderAddress.getPostalAddress() : "";
                String postalCode = orderAddress.getPostalCode() != null ? orderAddress.getPostalCode() : "";
                String localityName = orderAddress.getLocalityName() != null ? orderAddress.getLocalityName() : "";
                String countryDescDe = country.getDescDe() != null ? country.getDescDe() : "";
                ArrayList<String> lines = new ArrayList<String>();
                lines.add(organisationName);
                lines.add(MessageFormat.format(resourceBundle.getString("deliverDirectly"), givenName + " " + surName));
                lines.add(postalAddress);
                lines.add(postalCode + " " + localityName);
                lines.add(countryDescDe);
                CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, lines);
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        columns.add(new FancyOdfTableColumn<PlotTaskItemInfo>("received", resourceBundle.getString("plotTaskReceived")){

            public void appendCell(TableTableRowElement rowElement, PlotTaskItemInfo itemInfo) {
                OrderStep receivedStep = itemInfo.getReceivedStep();
                Person receivedPerson = itemInfo.getReceivedPerson();
                if (receivedStep != null && receivedStep.getId() != null && receivedPerson != null && receivedPerson.getId() != null) {
                    String pattern = resourceBundle.getString("yearToSecondFormat");
                    String formattedFinishedDate = null;
                    Double time = receivedStep.getFinished();
                    if (time != null) {
                        UtcTimestamp utcTimeStamp = new UtcTimestamp(TimeZone.getTimeZone("Europe/Vienna"), new Double(time * 1000.0).longValue());
                        Calendar calendar = utcTimeStamp.toCalendar();
                        Locale locale = ThreadLocalManager.getLoginLocale();
                        FastDateFormat format = FastDateFormat.getInstance((String)pattern, (Locale)locale);
                        formattedFinishedDate = format.format(calendar);
                    }
                    AcceptedMode acceptedMode = AcceptedMode.getByValue((Integer)receivedStep.getAcceptedMode());
                    String acceptedModeString = null;
                    if (acceptedMode == AcceptedMode.ACCEPTED) {
                        acceptedModeString = resourceBundle.getString("plotOrderListOkState");
                    } else if (acceptedMode == AcceptedMode.DECLINED) {
                        acceptedModeString = resourceBundle.getString("plotOrderListNotOkState");
                    }
                    String comment = receivedStep.getComment();
                    ArrayList<String> lines = new ArrayList<String>();
                    if (formattedFinishedDate != null) {
                        lines.add(formattedFinishedDate);
                    }
                    lines.add(receivedPerson.getGivenName() + " " + receivedPerson.getSurName());
                    if (acceptedModeString != null) {
                        lines.add(acceptedModeString);
                    }
                    if (comment != null) {
                        lines.add(comment);
                    }
                    CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, lines);
                } else {
                    CdesExportHelper.appendCellWithLineBreaks(dataCellStyle, dataTextStyle, rowElement, "");
                }
            }

            public int compare(PlotTaskItemInfo itemInfoOne, PlotTaskItemInfo itemInfoTwo, boolean descending) {
                return 0;
            }
        });
        return columns;
    }

    private void appendSumSection(OfficeTextElement officeText, OdfContext context, ResourceBundle resourceBundle, PlotTaskInfo plotTaskInfo, String normalTextStyle) {
        TextHElement textHElement = officeText.newTextHElement(4);
        textHElement.setTextContent(resourceBundle.getString("plotTaskAreaSectionCaption") + ":");
        double monochromeAreaSum = PlotHelper.getSumForColorValue(plotTaskInfo, 0);
        double colorAreaSum = PlotHelper.getSumForColorValue(plotTaskInfo, 1);
        double likeTemplateAreaSum = PlotHelper.getSumForColorValue(plotTaskInfo, 2);
        double totalAreaSum = monochromeAreaSum + colorAreaSum + likeTemplateAreaSum;
        double[] paperQualitySum = PlotHelper.getSumForPaperQuality(plotTaskInfo);
        double[] plotMarginSum = PlotHelper.getSumForPlotMargin(plotTaskInfo);
        String monochromeLabel = "";
        if (monochromeAreaSum > 0.0) {
            monochromeLabel = resourceBundle.getString("plotTaskMonochromeSum") + " " + PlotHelper.getPlotAreaString(monochromeAreaSum) + " ";
        }
        String colorLabel = "";
        if (colorAreaSum > 0.0) {
            colorLabel = resourceBundle.getString("plotTaskColorSum") + " " + PlotHelper.getPlotAreaString(colorAreaSum) + " ";
        }
        String likeTemplateLabel = "";
        if (likeTemplateAreaSum > 0.0) {
            likeTemplateLabel = resourceBundle.getString("plotTaskLikeTemplateSum") + " " + PlotHelper.getPlotAreaString(likeTemplateAreaSum) + " ";
        }
        String plotPaperQualityLabel = "";
        for (int i = 0; i < PlotPaperQuality.values().length; ++i) {
            if (paperQualitySum[i] == 0.0) continue;
            plotPaperQualityLabel = plotPaperQualityLabel + "\n" + PlotPaperQuality.values()[i].getValue() + " " + String.format(Locale.US, "%.2f", paperQualitySum[i]) + " " + LengthCalculator.getSquareUnitLabel(LengthUnit.METER);
        }
        String plotMarginLabel = "";
        for (int i = 0; i < PlotMargin.values().length; ++i) {
            if (plotMarginSum[i] == 0.0) continue;
            plotMarginLabel = plotMarginLabel + "\n" + PlotMargin.values()[i].getValue() + " " + String.format(Locale.US, "%.2f", plotMarginSum[i]) + " " + LengthCalculator.getSquareUnitLabel(LengthUnit.METER);
        }
        String totalLabel = "";
        if (totalAreaSum > 0.0) {
            totalLabel = resourceBundle.getString("plotTaskTotalSum") + " " + PlotHelper.getPlotAreaString(totalAreaSum);
        }
        TextFactory.constructTextNode((Node)officeText, (String)(monochromeLabel + colorLabel + likeTemplateLabel), (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)plotPaperQualityLabel, (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)plotMarginLabel, (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)totalLabel, (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)normalTextStyle);
    }

    private void appendAdditionalSection(OfficeTextElement officeText, OdfContext context, ResourceBundle resourceBundle, PlotTaskInfo plotTaskInfo, String normalTextStyle) {
        TextFactory.constructTextNode((Node)officeText, (String)resourceBundle.getString("plotTaskBillingAddressLabel"), (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)resourceBundle.getString("plotTaskDeliveryDateLabel"), (String)normalTextStyle);
        String kindOfDelivery = plotTaskInfo.getPlotOrder().getKindOfDelivery();
        String kindOfDeliveryString = resourceBundle.getString("plotTaskKindOfDeliveryLabel") + (kindOfDelivery != null ? " " + kindOfDelivery : "");
        TextFactory.constructTextNode((Node)officeText, (String)kindOfDeliveryString, (String)normalTextStyle);
        String comment = plotTaskInfo.getPlotOrder().getComment();
        String commentString = MessageFormat.format(resourceBundle.getString("additionalInfoLabel"), comment != null ? comment : "");
        TextFactory.constructTextNode((Node)officeText, (String)commentString, (String)normalTextStyle);
    }

    private void appendAcceptanceSection(OfficeTextElement officeText, OdfContext context, ResourceBundle resourceBundle, PlotTaskInfo plotTaskInfo, String normalTextStyle, String standardParagraphStyle) {
        OrderStep orderStep = plotTaskInfo.getAcceptanceStep();
        if (orderStep.getSignatureId() == null) {
            return;
        }
        String pageBreakStyle = this.constructPageBreakStyle(context, standardParagraphStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)pageBreakStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", null);
        TextFactory.constructTextNode((Node)officeText, (String)"", null);
        TextHElement textHElement = officeText.newTextHElement(4);
        textHElement.setTextContent(resourceBundle.getString("plotTaskStepCaption"));
        officeText.newTextPElement();
        Person person = plotTaskInfo.getAcceptancePerson();
        Double timestamp = orderStep != null ? orderStep.getFinished() : null;
        String personGivenName = person != null ? person.getGivenName() : null;
        String personSurName = person != null ? person.getSurName() : null;
        String comment = orderStep != null ? orderStep.getComment() : null;
        Integer acceptedModeInt = orderStep != null ? orderStep.getAcceptedMode() : null;
        AcceptedMode acceptedMode = AcceptedMode.getByValue((Integer)acceptedModeInt);
        String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
        String receivedLabel = resourceBundle.getString("plotTaskReceivedCaption");
        String dateString = timestamp != null ? DateHelper.formatUtcSeconds(timestamp, "Europe/Vienna", dateFormatPattern) : "---";
        String dateLine = MessageFormat.format(resourceBundle.getString("plotTaskDateLabel"), dateString, personGivenName != null ? personGivenName : "---", personSurName != null ? personSurName : "---");
        String okString = acceptedMode == AcceptedMode.ACCEPTED ? resourceBundle.getString("plotOrderListReceivedState") : (acceptedMode == AcceptedMode.DECLINED ? resourceBundle.getString("plotOrderListDeclinedState") : "");
        String okLine = resourceBundle.getString("plotTaskDecisionLabel") + " " + okString;
        String commentLine = resourceBundle.getString("plotTaskCommentLabel") + (comment != null ? " " + comment : "");
        TextFactory.constructTextNode((Node)officeText, (String)receivedLabel, (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)dateLine, (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)okLine, (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)commentLine, (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)normalTextStyle);
        TextFactory.constructTextNode((Node)officeText, (String)"", (String)normalTextStyle);
    }

    private void appendCompletedSection(OfficeTextElement officeText, OdfContext context, ResourceBundle resourceBundle, PlotTaskInfo plotTaskInfo, String normalTextStyle, boolean plotOrderAcceptance) {
        OrderStep orderStep = plotTaskInfo.getCompletedStep();
        if (orderStep == null || orderStep.getSignatureId() == null) {
            return;
        }
        Person person = plotTaskInfo.getCompletedPerson();
        Double timestamp = orderStep != null ? orderStep.getFinished() : null;
        String personGivenName = person != null ? person.getGivenName() : null;
        String personSurName = person != null ? person.getSurName() : null;
        String comment = orderStep != null ? orderStep.getComment() : null;
        Integer acceptedModeInt = orderStep != null ? orderStep.getAcceptedMode() : null;
        AcceptedMode acceptedMode = AcceptedMode.getByValue((Integer)acceptedModeInt);
        String dateFormatPattern = resourceBundle.getString("yearToSecondFormat");
        String receivedLabel = resourceBundle.getString("plotTaskAcceptanceCaption");
        String dateString = timestamp != null ? DateHelper.formatUtcSeconds(timestamp, "Europe/Vienna", dateFormatPattern) : "---";
        String dateLine = MessageFormat.format(resourceBundle.getString("plotTaskDateLabel"), dateString, personGivenName != null ? personGivenName : "---", personSurName != null ? personSurName : "---");
        String okString = acceptedMode == AcceptedMode.ACCEPTED ? resourceBundle.getString("plotOrderListOkState") : resourceBundle.getString("plotOrderListNotOkState");
        String okLine = resourceBundle.getString("plotTaskDecisionLabel") + " " + okString;
        String commentLine = resourceBundle.getString("plotTaskCommentLabel") + (comment != null ? " " + comment : "");
        TextFactory.constructTextNode((Node)officeText, (String)receivedLabel, (String)normalTextStyle);
        if (plotOrderAcceptance) {
            TextFactory.constructTextNode((Node)officeText, (String)dateLine, (String)normalTextStyle);
            TextFactory.constructTextNode((Node)officeText, (String)okLine, (String)normalTextStyle);
            TextFactory.constructTextNode((Node)officeText, (String)commentLine, (String)normalTextStyle);
        }
    }
}

