/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.review;

import at.cdes.api.dto.ExportResult;
import at.cdes.api.joinDto.OrganisationPersonJoin;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.api.task.dto.Task;
import at.cdes.api.task.searchModel.TaskSearchModel;
import at.cdes.api.task.voc.TaskSearchMode;
import at.cdes.api.voc.OdfExportSlot;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.export.planning.PlanningReportXlsExporter;
import at.cdes.impl.export.review.ReviewTaskExportHelper;
import at.cdes.impl.export.review.ReviewTaskPdfExporter;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.util.odf.OdfHelper;
import java.io.File;
import java.text.Collator;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.factory.DocumentFactory;
import org.clazzes.odf.util.file.OdfFileHelper;
import org.clazzes.odf.util.style.Styles;
import org.clazzes.odf.util.table.ColumnSortSpec;
import org.clazzes.odf.util.table.FancyOdfTable;
import org.clazzes.odf.util.table.FancyOdfTableColumn;
import org.clazzes.odf.util.table.TableFactory;
import org.clazzes.odf.util.text.TextFactory;
import org.clazzes.ooo.engine.OOoFileConversionTicket;
import org.clazzes.ooo.engine.OOoFileEngine;
import org.clazzes.util.aop.ThreadLocalManager;
import org.clazzes.util.sched.cache.ScratchFile;
import org.odftoolkit.odfdom.doc.OdfDocument;
import org.odftoolkit.odfdom.doc.OdfSpreadsheetDocument;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.element.style.StyleTableCellPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTableRowPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableCellElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableElement;
import org.odftoolkit.odfdom.dom.element.table.TableTableRowElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class ReviewTaskXlsExporter {
    private String odfStylePrefix;
    private Long odfTimeout;
    private OOoFileEngine oooFileEngine = null;
    private OrganisationPersonDAO organisationPersonDAO;
    private PersonVariablesDAO personVariablesDAO;
    private String tempDirName;
    private static final Logger log = LoggerFactory.getLogger(ReviewTaskPdfExporter.class);

    public void setOdfStylePrefix(String odfStylePrefix) {
        this.odfStylePrefix = odfStylePrefix;
    }

    public void setOdfTimeout(Long odfTimeout) {
        this.odfTimeout = odfTimeout;
    }

    public void setOooFileEngine(OOoFileEngine oooFileEngine) {
        this.oooFileEngine = oooFileEngine;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setTempDir(String tempDirName) {
        this.tempDirName = tempDirName;
    }

    public ScratchFile export(Long loginOrganisationPersonId, TaskSearchModel searchModel, List<Task> tasks, Map<String, Double> columnToWidth, List<ColumnSortSpec> columnSortSpecs, boolean enableCustomerLogo) throws Exception {
        OdfSpreadsheetDocument document = DocumentFactory.constructSpreadsheetDocument((String)"export/emptyOdsTemplate.ods", PlanningReportXlsExporter.class, (Locale)ThreadLocalManager.getLoginLocale());
        OdfContext context = new OdfContext((OdfDocument)document, this.odfStylePrefix);
        String personVariablesUserLocale = OdfHelper.getPersonVariablesUserLocaleByPrincipal(this.personVariablesDAO);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(personVariablesUserLocale);
        this.fillDocument(searchModel, loginOrganisationPersonId, context, resourceBundle, document, columnToWidth, tasks, personVariablesUserLocale);
        String pdfFileName = OdfFileHelper.saveAndConvert((String)this.tempDirName, (String)"cdes_Aufgaben_", (OdfSpreadsheetDocument)document, (OOoFileConversionTicket.TargetFileType)OOoFileConversionTicket.TargetFileType.MSEXCEL_2007_XML, (OOoFileEngine)this.oooFileEngine, (Long)this.odfTimeout, (Integer)OdfExportSlot.DEFAULT.getValue(), null);
        ExportResult exportResult = OdfHelper.constructExportResult(pdfFileName);
        String tmpFileName = exportResult.getTmpFileName();
        String encodedFileName = "Test";
        ScratchFile scratchFile = new ScratchFile(new File(tmpFileName), "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", "attachment; filename*=UTF-8''" + encodedFileName);
        return scratchFile;
    }

    private void fillDocument(TaskSearchModel searchModel, Long loginOrganisationPersonId, OdfContext context, ResourceBundle resourceBundle, OdfSpreadsheetDocument document, Map<String, Double> columnToWidth, List<Task> tasks, String personVariablesUserLocale) throws Exception {
        ArrayList sortSpecs = new ArrayList();
        List tableElements = document.getTables();
        TableTableElement tableElement = (TableTableElement)tableElements.get(0);
        TableFactory.cleanTableElementBeforeUsage((TableTableElement)tableElement);
        Styles contentAutomaticStyles = context.getContentAutomaticStyles();
        Styles contentOfficeStyles = context.getStylesOfficeStyles();
        Styles stylesOfficeStyles = context.getStylesOfficeStyles();
        String standardParagraphStyle = OdfHelper.constructStandardParagraphStyle(stylesOfficeStyles);
        StyleTableCellPropertiesElement headerCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#f0f0f0", "0.097cm", "0.05pt solid #000000");
        String headerCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{headerCellProperties});
        StyleTextPropertiesElement headerTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "8pt", "bold");
        String headerTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{headerTextProperties});
        StyleTableCellPropertiesElement dataCellProperties = contentAutomaticStyles.constructTableCellPropertiesWithColorPaddingAndBorders("#ffffff", "0.097cm", "0.05pt solid #000000");
        dataCellProperties.setFoWrapOptionAttribute("wrap");
        String dataCellStyle = contentAutomaticStyles.getTableCellStyle(new OdfStylePropertiesBase[]{dataCellProperties});
        StyleTextPropertiesElement dataTextProperties = contentAutomaticStyles.constructTextPropertiesWithColorFontAndHyphenation("#000000", "Arial", "9pt", null);
        String dataTextStyle = contentAutomaticStyles.getParagraphStyleWithParent(standardParagraphStyle, new OdfStylePropertiesBase[]{dataTextProperties});
        StyleTableRowPropertiesElement properties = contentAutomaticStyles.constructTableRowProperties();
        properties.setFoKeepTogetherAttribute("auto");
        String dataRowStyle = contentAutomaticStyles.getTableRowStyle(new OdfStylePropertiesBase[]{properties});
        List columns = this.constructColumns(searchModel, loginOrganisationPersonId, resourceBundle, dataCellStyle, dataTextStyle, personVariablesUserLocale);
        columnToWidth.put("name", 4.0);
        columnToWidth.put("document", 6.0);
        columnToWidth.put("responsible", 6.0);
        columnToWidth.put("object", 3.0);
        columnToWidth.put("project", 3.0);
        columnToWidth.put("uploaded", 2.0);
        columnToWidth.put("reviewStatus", 3.0);
        columnToWidth.put("reviewDeadline", 3.0);
        columnToWidth.put("taskStatus", 3.0);
        columnToWidth.put("taskDeadline", 3.0);
        FancyOdfTable table = ReviewTaskXlsExporter.constructFancyTable(contentAutomaticStyles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, dataRowStyle, null, columns, columnToWidth);
        table.setDataRowStyle(contentOfficeStyles.getTableRowStyle(new OdfStylePropertiesBase[]{contentOfficeStyles.constructTableRowPropertiesWithOptimalRowHeight()}));
        table.renderIntoTableElement(tableElement, tasks, sortSpecs, true);
    }

    private TextPElement constructLabelCell(TableTableRowElement rowElement, String cellStyle, String textStyle, String label) {
        TableTableCellElement cellElement = TableFactory.appendEmptyCell((String)cellStyle, null, (TableTableRowElement)rowElement);
        return TextFactory.constructTextNode((Node)cellElement, (String)label, (String)textStyle);
    }

    private List<FancyOdfTableColumn<Task>> constructColumns(TaskSearchModel searchModel, Long loginOrganisationPersonId, ResourceBundle resourceBundle, String dataCellStyle, String dataTextStyle, String personVariablesUserLocale) {
        Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        TaskSearchMode searchMode = searchModel.getSearchMode();
        CdesPrincipal loginPrincipal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long loginPersonId = loginPrincipal.getPersonId();
        OrganisationPersonJoin organisationPersonJoin = this.organisationPersonDAO.getOrganisationPersonJoinById(loginOrganisationPersonId);
        ArrayList<FancyOdfTableColumn<Task>> columns = new ArrayList<FancyOdfTableColumn<Task>>();
        columns.add(ReviewTaskExportHelper.constructNameColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, personVariablesUserLocale));
        columns.add(ReviewTaskExportHelper.constructDocumentColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(ReviewTaskExportHelper.constructResponsibleColumn(resourceBundle, collator, loginPersonId, organisationPersonJoin, searchMode, dataCellStyle, dataTextStyle));
        columns.add(ReviewTaskExportHelper.constructObjectColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(ReviewTaskExportHelper.constructProjectColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        columns.add(ReviewTaskExportHelper.constructNetworkColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
        FancyOdfTableColumn<Task> taskStatusStatusColumn = ReviewTaskExportHelper.constructTaskStatusColumn(resourceBundle, collator, searchMode, "taskStatus", resourceBundle.getString("reviewTaskStatusCaption"), true, false, dataCellStyle, dataTextStyle);
        FancyOdfTableColumn<Task> taskStatusDeadlineColumn = ReviewTaskExportHelper.constructTaskStatusColumn(resourceBundle, collator, searchMode, "taskDeadline", resourceBundle.getString("reviewTaskDeadlineCaption"), false, true, dataCellStyle, dataTextStyle);
        FancyOdfTableColumn<Task> uploadedColumn = ReviewTaskExportHelper.constructUploadedColumn(resourceBundle, collator, dataCellStyle, dataTextStyle);
        if (searchMode == TaskSearchMode.OWN) {
            columns.add(uploadedColumn);
            columns.add(taskStatusStatusColumn);
            columns.add(taskStatusDeadlineColumn);
        } else if (searchMode == TaskSearchMode.DONE) {
            columns.add(ReviewTaskExportHelper.constructDoneDateColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
            columns.add(ReviewTaskExportHelper.constructDoneResultColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, personVariablesUserLocale));
        } else if (searchMode == TaskSearchMode.LATE) {
            columns.add(uploadedColumn);
            columns.add(taskStatusStatusColumn);
            columns.add(taskStatusDeadlineColumn);
            columns.add(ReviewTaskExportHelper.constructReviewStatusColumn(resourceBundle, collator, "reviewStatus", resourceBundle.getString("reviewTaskStatusCaption"), true, false, dataCellStyle, dataTextStyle));
            columns.add(ReviewTaskExportHelper.constructReviewStatusColumn(resourceBundle, collator, "reviewDeadline", resourceBundle.getString("reviewTaskDeadlineCaption"), false, true, dataCellStyle, dataTextStyle));
        } else if (searchMode == TaskSearchMode.BATCH) {
            columns.add(ReviewTaskExportHelper.constructReviewDateColumn(resourceBundle, collator, dataCellStyle, dataTextStyle));
            columns.add(ReviewTaskExportHelper.constructReviewResultColumn(resourceBundle, collator, dataCellStyle, dataTextStyle, personVariablesUserLocale));
        }
        return columns;
    }

    private static <T> FancyOdfTable<T> constructFancyTable(Styles styles, String headerCellStyle, String headerTextStyle, String dataCellStyle, String dataTextStyle, String dataRowStyle, Double width, List<FancyOdfTableColumn<T>> columns, Map<String, Double> absoluteColumnWidths) {
        FancyOdfTable table = new FancyOdfTable(styles, headerCellStyle, headerTextStyle, dataCellStyle, dataTextStyle, width, null, columns);
        table.setDataRowStyle(dataRowStyle);
        table.setAbsoluteColumnWidths(absoluteColumnWidths);
        return table;
    }
}

