/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.objects;

import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.Object;
import at.cdes.api.dto.ObjectListRelease;
import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.ObjectPlannerPositionRelease;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.ProjectHoliday;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellConnection;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodePositionReleased;
import at.cdes.api.obj.voc.ObjectChanged;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.impl.dao.ObjectDAO;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.reviewCycle.DurationCalcContext;
import at.cdes.impl.util.ContainerHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectReleaseContext
implements DurationCalcContext {
    private static final Logger log = LoggerFactory.getLogger(ObjectReleaseContext.class);
    private Long projectId;
    private Long networkId;
    private Long subProjectId;
    private boolean usePdcStartDateForTasks;
    private Long localisationId;
    private Long organisationPersonId;
    private ProjectParticipant signer;
    private Certificate certificate;
    private String password;
    private Map<Long, Object> idToObject = new HashMap<Long, Object>();
    private Map<Long, ObjectPlanner> idToObjectPlanner = new HashMap<Long, ObjectPlanner>();
    private Long prevObjectListReleaseId;
    private Long newObjectListReleaseId;
    private Map<Long, ObjectListRelease> idToObjectListRelease = new HashMap<Long, ObjectListRelease>();
    private Map<Long, List<ObjectRelease>> objectListReleaseIdToObjectReleases = new HashMap<Long, List<ObjectRelease>>();
    private Map<Long, ObjectRelease> idToObjectRelease = new HashMap<Long, ObjectRelease>();
    private Map<Long, ObjectPlannerRelease> idToObjectPlannerRelease = new HashMap<Long, ObjectPlannerRelease>();
    private Map<Long, List<ObjectPlannerRelease>> objectReleaseIdToPlannerReleases = new HashMap<Long, List<ObjectPlannerRelease>>();
    private Map<Long, ObjectPlannerPositionRelease> idToPositionRelease = new HashMap<Long, ObjectPlannerPositionRelease>();
    private Map<Long, List<ObjectPlannerPositionRelease>> objectPlannerReleaseIdToPositionReleases = new HashMap<Long, List<ObjectPlannerPositionRelease>>();
    private Map<Long, List<ReviewCycleInstanceReleased>> objectListReleaseIdToInstanceReleaseds = new HashMap<Long, List<ReviewCycleInstanceReleased>>();
    private Map<Long, ReviewCycleInstanceReleased> idToInstanceReleased = new HashMap<Long, ReviewCycleInstanceReleased>();
    private Map<Long, List<ReviewCycleCellInstanceReleased>> instanceReleasedIdToCellInstanceReleaseds = new HashMap<Long, List<ReviewCycleCellInstanceReleased>>();
    private Map<Long, List<ReviewCycleNodeInstanceReleased>> cellInstanceReleasedIdToNodeInstanceReleaseds = new HashMap<Long, List<ReviewCycleNodeInstanceReleased>>();
    private Map<Long, ReviewCycleCellInstanceReleased> idToCellInstanceReleased = new HashMap<Long, ReviewCycleCellInstanceReleased>();
    private Map<Long, List<ReviewCycleNodePositionReleased>> nodeInstanceReleasedIdToPositionReleaseds = new HashMap<Long, List<ReviewCycleNodePositionReleased>>();
    private Map<Long, DocumentRelease> documentVersionIdToDocumentRelease;
    private Set<Long> projectRoleParticipationIds;
    private List<ProjectHoliday> projectHolidays;
    private Map<Long, Realm> idToRealm;
    private ReviewCycleInfo reviewCycleInfo;
    private Map<Long, List<DocumentVersion>> nodeInstanceIdToDocumentVersions = new HashMap<Long, List<DocumentVersion>>();
    private List<Work> works = new ArrayList<Work>();
    private DebugContext debugContext = new DebugContext();

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public Long getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(Long networkId) {
        this.networkId = networkId;
    }

    public Long getSubProjectId() {
        return this.subProjectId;
    }

    public void setSubProjectId(Long subProjectId) {
        this.subProjectId = subProjectId;
    }

    public boolean isUsePdcStartDateForTasks() {
        return this.usePdcStartDateForTasks;
    }

    public void setUsePdcStartDateForTasks(boolean usePdcStartDateForTasks) {
        this.usePdcStartDateForTasks = usePdcStartDateForTasks;
    }

    public Long getLocalisationId() {
        return this.localisationId;
    }

    public void setLocalisationId(Long localisationId) {
        this.localisationId = localisationId;
    }

    public Long getOrganisationPersonId() {
        return this.organisationPersonId;
    }

    public void setOrganisationPersonId(Long organisationPersonId) {
        this.organisationPersonId = organisationPersonId;
    }

    public ProjectParticipant getSigner() {
        return this.signer;
    }

    public void setSigner(ProjectParticipant signer) {
        this.signer = signer;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Certificate getCertificate() {
        return this.certificate;
    }

    public void setCertificate(Certificate certificate) {
        this.certificate = certificate;
    }

    public void registerObject(Object object) {
        this.idToObject.put(object.getId(), object);
    }

    public void registerObjectPlanner(ObjectPlanner objectPlanner) {
        this.idToObjectPlanner.put(objectPlanner.getId(), objectPlanner);
    }

    public ObjectPlanner getObjectPlannerById(Long objectPlannerId) {
        return this.idToObjectPlanner.get(objectPlannerId);
    }

    public Long getPrevObjectListReleaseId() {
        return this.prevObjectListReleaseId;
    }

    public void setPrevObjectListReleaseId(Long prevObjectListReleaseId) {
        this.prevObjectListReleaseId = prevObjectListReleaseId;
    }

    public Long getNewObjectListReleaseId() {
        return this.newObjectListReleaseId;
    }

    public void setNewObjectListReleaseId(Long newObjectListReleaseId) {
        this.newObjectListReleaseId = newObjectListReleaseId;
    }

    public void registerObjectListRelease(ObjectListRelease objectListRelease) {
        Long objectListReleaseId = objectListRelease.getId();
        this.idToObjectListRelease.put(objectListReleaseId, objectListRelease);
    }

    public ObjectListRelease getObjectListRelease(Long objectListReleaseId) {
        return this.idToObjectListRelease.get(objectListReleaseId);
    }

    public void registerObjectRelease(ObjectRelease objectRelease) {
        if (objectRelease != null) {
            this.idToObjectRelease.put(objectRelease.getId(), objectRelease);
            Long objectListReleaseId = objectRelease.getObjectListReleaseId();
            if (!this.objectListReleaseIdToObjectReleases.containsKey(objectListReleaseId)) {
                this.objectListReleaseIdToObjectReleases.put(objectListReleaseId, new ArrayList());
            }
            this.objectListReleaseIdToObjectReleases.get(objectListReleaseId).add(objectRelease);
        }
    }

    public void registerObjectPlannerRelease(ObjectPlannerRelease objectPlannerRelease) {
        if (objectPlannerRelease == null) {
            return;
        }
        Long objectPlannerReleaseId = objectPlannerRelease.getId();
        if (!this.idToObjectPlannerRelease.containsKey(objectPlannerReleaseId)) {
            this.idToObjectPlannerRelease.put(objectPlannerReleaseId, objectPlannerRelease);
            Long objectReleaseId = objectPlannerRelease.getObjectId();
            if (!this.objectReleaseIdToPlannerReleases.containsKey(objectReleaseId)) {
                this.objectReleaseIdToPlannerReleases.put(objectReleaseId, new ArrayList());
            }
            this.objectReleaseIdToPlannerReleases.get(objectReleaseId).add(objectPlannerRelease);
        }
    }

    public void registerPositionRelease(ObjectPlannerPositionRelease positionRelease) {
        if (positionRelease == null) {
            return;
        }
        Long positionReleaseId = positionRelease.getId();
        if (!this.idToPositionRelease.containsKey(positionReleaseId)) {
            this.idToPositionRelease.put(positionReleaseId, positionRelease);
            Long objectPlannerReleaseId = positionRelease.getObjectPlannerId();
            if (!this.objectPlannerReleaseIdToPositionReleases.containsKey(objectPlannerReleaseId)) {
                this.objectPlannerReleaseIdToPositionReleases.put(objectPlannerReleaseId, new ArrayList());
            }
            this.objectPlannerReleaseIdToPositionReleases.get(objectPlannerReleaseId).add(positionRelease);
        }
    }

    public void registerInstanceReleaseds(Long objectListReleaseId, List<ReviewCycleInstanceReleased> instanceReleaseds) {
        this.objectListReleaseIdToInstanceReleaseds.put(objectListReleaseId, instanceReleaseds);
        for (ReviewCycleInstanceReleased instanceReleased : instanceReleaseds) {
            Long instanceReleasedId = instanceReleased.getId();
            this.idToInstanceReleased.put(instanceReleasedId, instanceReleased);
        }
    }

    @Override
    public ReviewCycleInstanceReleased getInstanceReleasedById(Long instanceReleasedId) {
        return this.idToInstanceReleased.get(instanceReleasedId);
    }

    public List<ReviewCycleInstanceReleased> getNewInstanceReleaseds() {
        return this.objectListReleaseIdToInstanceReleaseds.get(this.newObjectListReleaseId);
    }

    public List<ReviewCycleInstanceReleased> getPrevInstanceReleaseds() {
        return this.objectListReleaseIdToInstanceReleaseds.containsKey(this.prevObjectListReleaseId) ? this.objectListReleaseIdToInstanceReleaseds.get(this.prevObjectListReleaseId) : new ArrayList<ReviewCycleInstanceReleased>();
    }

    public Map<Long, ReviewCycleInstanceReleased> getInstanceIdToReleasedMap(List<ReviewCycleInstanceReleased> instanceReleaseds) {
        HashMap<Long, ReviewCycleInstanceReleased> instanceIdToReleased = new HashMap<Long, ReviewCycleInstanceReleased>();
        for (ReviewCycleInstanceReleased instanceReleased : instanceReleaseds) {
            Long instanceId = instanceReleased.getReviewCycleInstanceId();
            instanceIdToReleased.put(instanceId, instanceReleased);
        }
        return instanceIdToReleased;
    }

    public void registerCellInstanceReleaseds(List<ReviewCycleCellInstanceReleased> cellInstanceReleaseds) {
        for (ReviewCycleCellInstanceReleased cellInstanceReleased : cellInstanceReleaseds) {
            Long id = cellInstanceReleased.getId();
            this.idToCellInstanceReleased.put(id, cellInstanceReleased);
            Long instanceReleasedId = cellInstanceReleased.getReviewCycleInstanceId();
            if (!this.instanceReleasedIdToCellInstanceReleaseds.containsKey(instanceReleasedId)) {
                this.instanceReleasedIdToCellInstanceReleaseds.put(instanceReleasedId, new ArrayList());
            }
            this.instanceReleasedIdToCellInstanceReleaseds.get(instanceReleasedId).add(cellInstanceReleased);
        }
    }

    @Override
    public ReviewCycleCellInstanceReleased getCellInstanceReleasedById(Long cellInstanceReleasedId) {
        return this.idToCellInstanceReleased.get(cellInstanceReleasedId);
    }

    @Override
    public Collection<ReviewCycleCellInstanceReleased> getAllCellInstancesReleased() {
        return this.idToCellInstanceReleased.values();
    }

    public Map<Long, ReviewCycleCellInstanceReleased> getCellIdToCellInstanceReleased(Long instanceReleasedId) {
        List<ReviewCycleCellInstanceReleased> cellInstanceReleaseds = this.instanceReleasedIdToCellInstanceReleaseds.get(instanceReleasedId);
        HashMap<Long, ReviewCycleCellInstanceReleased> cellIdToCellInstanceReleased = new HashMap<Long, ReviewCycleCellInstanceReleased>();
        if (cellInstanceReleaseds != null) {
            for (ReviewCycleCellInstanceReleased cellInstanceReleased : cellInstanceReleaseds) {
                Long cellId = cellInstanceReleased.getReviewCycleCellId();
                cellIdToCellInstanceReleased.put(cellId, cellInstanceReleased);
            }
        }
        return cellIdToCellInstanceReleased;
    }

    public List<ReviewCycleCellInstanceReleased> getCellInstanceReleasedsByInstanceReleasedId(Long instanceReleasedId) {
        if (this.instanceReleasedIdToCellInstanceReleaseds.containsKey(instanceReleasedId)) {
            return this.instanceReleasedIdToCellInstanceReleaseds.get(instanceReleasedId);
        }
        return new ArrayList<ReviewCycleCellInstanceReleased>();
    }

    public void registerNodeInstanceReleaseds(List<ReviewCycleNodeInstanceReleased> nodeInstanceReleaseds) {
        for (ReviewCycleNodeInstanceReleased nodeInstanceReleased : nodeInstanceReleaseds) {
            Long cellInstanceReleasedId = nodeInstanceReleased.getReviewCycleCellInstanceId();
            if (!this.cellInstanceReleasedIdToNodeInstanceReleaseds.containsKey(cellInstanceReleasedId)) {
                this.cellInstanceReleasedIdToNodeInstanceReleaseds.put(cellInstanceReleasedId, new ArrayList());
            }
            this.cellInstanceReleasedIdToNodeInstanceReleaseds.get(cellInstanceReleasedId).add(nodeInstanceReleased);
        }
    }

    public SortedMap<Integer, ReviewCycleNodeInstanceReleased> getPositionToNodeInstanceReleased(Long cellInstanceReleasedId) {
        TreeMap<Integer, ReviewCycleNodeInstanceReleased> positionToNodeInstanceReleased = new TreeMap<Integer, ReviewCycleNodeInstanceReleased>();
        List<ReviewCycleNodeInstanceReleased> nodeInstanceReleaseds = this.getNodeInstanceReleasedsByCellInstanceReleasedId(cellInstanceReleasedId);
        if (nodeInstanceReleaseds != null) {
            for (ReviewCycleNodeInstanceReleased nodeInstanceReleased : nodeInstanceReleaseds) {
                Long nodeId = nodeInstanceReleased.getReviewCycleNodeId();
                ReviewCycleNode node = this.reviewCycleInfo.getNodeById(nodeId);
                Integer position = node.getPosition();
                positionToNodeInstanceReleased.put(position, nodeInstanceReleased);
            }
        }
        return positionToNodeInstanceReleased;
    }

    @Override
    public List<ReviewCycleNodeInstanceReleased> getNodeInstanceReleasedsByCellInstanceReleasedId(Long cellInstanceReleasedId) {
        if (this.cellInstanceReleasedIdToNodeInstanceReleaseds.containsKey(cellInstanceReleasedId)) {
            return this.cellInstanceReleasedIdToNodeInstanceReleaseds.get(cellInstanceReleasedId);
        }
        return new ArrayList<ReviewCycleNodeInstanceReleased>();
    }

    public ReviewCycleNodeInstanceReleased getNodeInstanceReleasedByNodeInstanceAndInstanceReleased(Long instanceReleasedId, Long nodeInstanceId) {
        if (nodeInstanceId == null) {
            return null;
        }
        List<ReviewCycleCellInstanceReleased> cellInstanceReleaseds = this.getCellInstanceReleasedsByInstanceReleasedId(instanceReleasedId);
        for (ReviewCycleCellInstanceReleased cellInstanceReleased : cellInstanceReleaseds) {
            Long cellInstanceReleasedId = cellInstanceReleased.getId();
            List<ReviewCycleNodeInstanceReleased> nodeInstanceReleaseds = this.getNodeInstanceReleasedsByCellInstanceReleasedId(cellInstanceReleasedId);
            for (ReviewCycleNodeInstanceReleased nodeInstanceReleased : nodeInstanceReleaseds) {
                if (nodeInstanceReleased.getReviewCycleNodeInstanceId().longValue() != nodeInstanceId.longValue()) continue;
                return nodeInstanceReleased;
            }
        }
        return null;
    }

    public void registerNodePositionReleaseds(List<ReviewCycleNodePositionReleased> nodePositionReleaseds) {
        for (ReviewCycleNodePositionReleased nodePositionReleased : nodePositionReleaseds) {
            Long nodeInstanceReleasedId = nodePositionReleased.getReviewCycleNodeInstanceId();
            if (!this.nodeInstanceReleasedIdToPositionReleaseds.containsKey(nodeInstanceReleasedId)) {
                this.nodeInstanceReleasedIdToPositionReleaseds.put(nodeInstanceReleasedId, new ArrayList());
            }
            this.nodeInstanceReleasedIdToPositionReleaseds.get(nodeInstanceReleasedId).add(nodePositionReleased);
        }
    }

    @Override
    public boolean hasNodePositionReleased(Long nodeInstanceReleasedId) {
        return this.getNodePositionReleasedsByNodeInstanceReleasedId(nodeInstanceReleasedId).size() > 0;
    }

    public List<ReviewCycleNodePositionReleased> getNodePositionReleasedsByNodeInstanceReleasedId(Long nodeInstanceReleasedId) {
        if (this.nodeInstanceReleasedIdToPositionReleaseds.containsKey(nodeInstanceReleasedId)) {
            return this.nodeInstanceReleasedIdToPositionReleaseds.get(nodeInstanceReleasedId);
        }
        return new ArrayList<ReviewCycleNodePositionReleased>();
    }

    public Map<Long, List<ReviewCycleNodePositionReleased>> getParticipationIdToNodePositionReleaseds(Long nodeInstanceReleasedId) {
        HashMap<Long, List<ReviewCycleNodePositionReleased>> participationIdToNodePositionReleaseds = new HashMap<Long, List<ReviewCycleNodePositionReleased>>();
        List<ReviewCycleNodePositionReleased> nodePositionReleaseds = this.getNodePositionReleasedsByNodeInstanceReleasedId(nodeInstanceReleasedId);
        for (ReviewCycleNodePositionReleased nodePositionReleased : nodePositionReleaseds) {
            Long participationId = nodePositionReleased.getProjectParticipationId();
            if (!participationIdToNodePositionReleaseds.containsKey(participationId)) {
                participationIdToNodePositionReleaseds.put(participationId, new ArrayList());
            }
            ((List)participationIdToNodePositionReleaseds.get(participationId)).add(nodePositionReleased);
        }
        return participationIdToNodePositionReleaseds;
    }

    public Object getObjectById(Long objectId) {
        return this.idToObject.get(objectId);
    }

    public Collection<ObjectPlanner> getAllObjectPlanners() {
        return this.idToObjectPlanner.values();
    }

    public List<ObjectRelease> getObjectReleasesByObjectListReleaseId(Long objectListReleaseId) {
        if (this.objectListReleaseIdToObjectReleases.containsKey(objectListReleaseId)) {
            return this.objectListReleaseIdToObjectReleases.get(objectListReleaseId);
        }
        return new ArrayList<ObjectRelease>();
    }

    public List<ObjectPlannerRelease> getObjectPlannerReleasesByObjectReleaseId(Long objectReleaseId) {
        if (this.objectReleaseIdToPlannerReleases.containsKey(objectReleaseId)) {
            return this.objectReleaseIdToPlannerReleases.get(objectReleaseId);
        }
        return new ArrayList<ObjectPlannerRelease>();
    }

    public List<ObjectPlannerRelease> getObjectPlannerReleasesByObjectListReleaseId(Long objectListReleaseId) {
        List<ObjectRelease> objectReleases = this.getObjectReleasesByObjectListReleaseId(objectListReleaseId);
        ArrayList<ObjectPlannerRelease> objectPlannerReleases = new ArrayList<ObjectPlannerRelease>();
        for (ObjectRelease objectRelease : objectReleases) {
            Long objectReleaseId = objectRelease.getId();
            List<ObjectPlannerRelease> currObjectPlannerReleases = this.getObjectPlannerReleasesByObjectReleaseId(objectReleaseId);
            objectPlannerReleases.addAll(currObjectPlannerReleases);
        }
        return objectPlannerReleases;
    }

    public List<ObjectPlannerPositionRelease> getPositionReleasesByObjectPlannerReleasedId(Long objectPlannerReleasedId) {
        if (this.objectPlannerReleaseIdToPositionReleases.containsKey(objectPlannerReleasedId)) {
            return this.objectPlannerReleaseIdToPositionReleases.get(objectPlannerReleasedId);
        }
        return new ArrayList<ObjectPlannerPositionRelease>();
    }

    public Map<Long, ObjectRelease> getObjectIdToObjectReleaseByListReleaseId(Long objectListReleaseId) {
        List<ObjectRelease> objectReleases = this.getObjectReleasesByObjectListReleaseId(objectListReleaseId);
        HashMap<Long, ObjectRelease> objectIdToObjectRelease = new HashMap<Long, ObjectRelease>();
        for (ObjectRelease objectRelease : objectReleases) {
            Long objectId = objectRelease.getObjectId();
            objectIdToObjectRelease.put(objectId, objectRelease);
        }
        return objectIdToObjectRelease;
    }

    public void resetObjectChanged(ObjectReleaseContext context, ObjectDAO objectDAO) {
        context.openDebugNode("resetObjectChanged");
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Object object : this.idToObject.values()) {
            object.setHasChanged(Integer.valueOf(ObjectChanged.UNCHANGED.getValue()));
            objects.add(object);
            context.getDebug().addUpdateMessage(object.getId(), "Object", "changed [" + object.getHasChanged() + "]");
        }
        objectDAO.updateBatch(objects);
        context.registerWork("resetObjectChanged");
        context.closeDebugNode();
    }

    public void setReviewCycleInfo(ReviewCycleInfo reviewCycleInfo) {
        this.reviewCycleInfo = reviewCycleInfo;
    }

    public ReviewCycleInfo getCycleInfo() {
        return this.reviewCycleInfo;
    }

    @Override
    public boolean isEndNode(Long nodeId) {
        return this.reviewCycleInfo.isEndNode(nodeId);
    }

    @Override
    public ReviewCycleNode getNodeById(Long nodeId) {
        return this.reviewCycleInfo.getNodeById(nodeId);
    }

    @Override
    public ReviewCycleCell getCellById(Long cellId) {
        return this.reviewCycleInfo.getCellById(cellId);
    }

    @Override
    public List<ReviewCycleCellConnection> getLeavingConnectionsForCell(Long cellId) {
        return this.reviewCycleInfo.getLeavingConnectionsForCell(cellId);
    }

    public void registerDocumentVersion(DocumentVersion documentVersion) {
        Long nodeInstanceId = documentVersion.getActiveNodeInstanceId();
        if (!this.nodeInstanceIdToDocumentVersions.containsKey(nodeInstanceId)) {
            this.nodeInstanceIdToDocumentVersions.put(nodeInstanceId, new ArrayList());
        }
        this.nodeInstanceIdToDocumentVersions.get(nodeInstanceId).add(documentVersion);
    }

    public List<DocumentVersion> getDocumentVersionsByActiveNodeInstanceId(Long nodeInstanceId) {
        if (this.nodeInstanceIdToDocumentVersions.containsKey(nodeInstanceId)) {
            return this.nodeInstanceIdToDocumentVersions.get(nodeInstanceId);
        }
        return new ArrayList<DocumentVersion>();
    }

    public List<ProjectHoliday> getProjectHolidays() {
        return this.projectHolidays;
    }

    public void setProjectHolidays(List<ProjectHoliday> projectHolidays) {
        this.projectHolidays = projectHolidays;
    }

    public Map<Long, DocumentRelease> getDocumentVersionIdToDocumentRelease() {
        return this.documentVersionIdToDocumentRelease;
    }

    public void setDocumentVersionIdToDocumentRelease(Map<Long, DocumentRelease> documentVersionIdToDocumentRelease) {
        this.documentVersionIdToDocumentRelease = documentVersionIdToDocumentRelease;
    }

    public Double getDocumentReleaseStartDateByDocumentVersionId(Long documentVersionId) {
        if (this.documentVersionIdToDocumentRelease.containsKey(documentVersionId)) {
            return this.documentVersionIdToDocumentRelease.get(documentVersionId).getStartDate();
        }
        return null;
    }

    public Double getDocumentReleaseEndDateByDocumentVersionId(Long documentVersionId) {
        if (this.documentVersionIdToDocumentRelease.containsKey(documentVersionId)) {
            return this.documentVersionIdToDocumentRelease.get(documentVersionId).getEndDate();
        }
        return null;
    }

    public void setProjectRoleParticipationIds(Set<Long> projectRoleParticipationIds) {
        this.projectRoleParticipationIds = projectRoleParticipationIds;
    }

    public Set<Long> getProjectRoleParticipationIds() {
        return this.projectRoleParticipationIds;
    }

    public void setRealms(List<Realm> realms) {
        this.idToRealm = ContainerHelper.groupById(realms);
    }

    public Realm getRealmById(Long realmId) {
        return this.idToRealm.get(realmId);
    }

    public void registerWork(String topic) {
        Work prevWork = this.works.size() > 0 ? this.works.get(this.works.size() - 1) : null;
        long endMillis = System.currentTimeMillis();
        Long duration = prevWork != null ? Long.valueOf(endMillis - prevWork.endMillis) : null;
        Work newWork = new Work(topic, endMillis, duration);
        this.works.add(newWork);
        if (log.isDebugEnabled()) {
            String durationString = duration != null ? duration.doubleValue() / 1000.0 + "" : "---";
            log.debug("[Work Done][" + durationString + "s]: " + topic);
        }
    }

    public void outputWorks() {
        if (log.isDebugEnabled()) {
            log.debug("=====================================");
            log.debug("Work summary:");
            for (Work work : this.works) {
                String durationString = work.duration != null ? work.duration.doubleValue() / 1000.0 + "" : "---";
                log.debug("[" + durationString + "s]: " + work.topic);
            }
            log.debug("=====================================");
            if (this.works.size() > 0) {
                long totalMillis = this.works.get((int)(this.works.size() - 1)).endMillis - this.works.get((int)0).endMillis;
                String totalMillisString = (double)totalMillis / 1000.0 + "s";
                log.debug("Total time: [" + totalMillisString + "]");
            }
            log.debug("=====================================");
        }
    }

    public DebugContext getDebug() {
        return this.debugContext;
    }

    public void openDebugNode(String message) {
        this.debugContext.openDebugNode(message);
    }

    public void closeDebugNode() {
        this.debugContext.closeDebugNode();
    }

    public void closeDebugNode(String message) {
        this.debugContext.closeDebugNode(message);
    }

    private static class Work {
        String topic;
        Long duration;
        long endMillis;

        Work(String topic, long endMillis, Long duration) {
            this.endMillis = endMillis;
            this.topic = topic;
            this.duration = duration;
        }
    }
}

