/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util.objects;

import at.cdes.api.dto.ObjectListRelease;
import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.ObjectPlannerPosition;
import at.cdes.api.dto.ObjectPlannerPositionRelease;
import at.cdes.api.dto.ObjectPlannerRelease;
import at.cdes.api.dto.ObjectRelease;
import at.cdes.api.dto.ReviewCycleCellInstance;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ObjectJoin;
import at.cdes.api.joinDto.ObjectReleaseJoin;
import at.cdes.api.joinDto.ObjectShowInstanceJoin;
import at.cdes.api.joinDto.ObjectShowJoin;
import at.cdes.api.obj.dto.ObjectInfo;
import at.cdes.api.obj.dto.ObjectPlannerInfo;
import at.cdes.api.obj.dto.ObjectPlannerPositionInfo;
import at.cdes.api.obj.voc.ObjectChanged;
import at.cdes.api.obj.voc.ObjectListChangedState;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.clazzes.util.aop.ThreadLocalManager;

public class ObjectHelper {
    public static Set<Long> getObjectIdsFromContextJoins(List<ContextJoin> contextJoins) {
        HashSet<Long> objectIds = new HashSet<Long>();
        for (ContextJoin contextJoin : contextJoins) {
            if (contextJoin.getObjectId() == null) continue;
            objectIds.add(contextJoin.getObjectId());
        }
        return objectIds;
    }

    public static Set<Long> getObjectPlannerIdsFromContextJoins(List<ContextJoin> contextJoins) {
        HashSet<Long> objectPlannerIds = new HashSet<Long>();
        for (ContextJoin contextJoin : contextJoins) {
            if (contextJoin.getObjectPlannerId() == null) continue;
            objectPlannerIds.add(contextJoin.getObjectPlannerId());
        }
        return objectPlannerIds;
    }

    public static Set<Long> getObjectPlannerIdsFromPositions(List<ObjectPlannerPosition> objectPlannerPositions) {
        HashSet<Long> objectPlannerIds = new HashSet<Long>();
        for (ObjectPlannerPosition objectPlannerPosition : objectPlannerPositions) {
            objectPlannerIds.add(objectPlannerPosition.getObjectPlannerId());
        }
        return objectPlannerIds;
    }

    public static Map<Long, List<ObjectShowJoin>> groupObjectShowJoinsByObjectPlannerReleaseId(List<ObjectShowJoin> objectShowJoins) {
        HashMap<Long, List<ObjectShowJoin>> objectPlannerReleaseIdToJoins = new HashMap<Long, List<ObjectShowJoin>>();
        for (ObjectShowJoin objectShowJoin : objectShowJoins) {
            Long objectPlannerReleaseId = objectShowJoin.getObjectPlannerReleaseId();
            if (!objectPlannerReleaseIdToJoins.containsKey(objectPlannerReleaseId)) {
                objectPlannerReleaseIdToJoins.put(objectPlannerReleaseId, new ArrayList());
            }
            ((List)objectPlannerReleaseIdToJoins.get(objectPlannerReleaseId)).add(objectShowJoin);
        }
        return objectPlannerReleaseIdToJoins;
    }

    public static Map<Long, List<ObjectShowInstanceJoin>> groupObjectShowInstanceJoinsByObjectPlannerReleaseId(List<ObjectShowInstanceJoin> objectShowInstanceJoins) {
        HashMap<Long, List<ObjectShowInstanceJoin>> objectPlannerReleaseIdToJoins = new HashMap<Long, List<ObjectShowInstanceJoin>>();
        for (ObjectShowInstanceJoin objectShowInstanceJoin : objectShowInstanceJoins) {
            Long objectPlannerReleaseId = objectShowInstanceJoin.getObjectPlannerReleaseId();
            if (!objectPlannerReleaseIdToJoins.containsKey(objectPlannerReleaseId)) {
                objectPlannerReleaseIdToJoins.put(objectPlannerReleaseId, new ArrayList());
            }
            ((List)objectPlannerReleaseIdToJoins.get(objectPlannerReleaseId)).add(objectShowInstanceJoin);
        }
        return objectPlannerReleaseIdToJoins;
    }

    public static Map<Long, List<ObjectShowInstanceJoin>> groupObjectShowInstanceJoinsByCellInstanceReleasedId(List<ObjectShowInstanceJoin> objectShowInstanceJoins) {
        HashMap<Long, List<ObjectShowInstanceJoin>> cellInstanceReleasedIdToJoins = new HashMap<Long, List<ObjectShowInstanceJoin>>();
        if (objectShowInstanceJoins == null) {
            return cellInstanceReleasedIdToJoins;
        }
        for (ObjectShowInstanceJoin objectShowInstanceJoin : objectShowInstanceJoins) {
            Long cellInstanceReleasedId = objectShowInstanceJoin.getReviewCycleCellInstanceReleasedId();
            if (!cellInstanceReleasedIdToJoins.containsKey(cellInstanceReleasedId)) {
                cellInstanceReleasedIdToJoins.put(cellInstanceReleasedId, new ArrayList());
            }
            ((List)cellInstanceReleasedIdToJoins.get(cellInstanceReleasedId)).add(objectShowInstanceJoin);
        }
        return cellInstanceReleasedIdToJoins;
    }

    public static Map<Long, List<ObjectShowInstanceJoin>> groupObjectShowInstanceJoinsByNodeInstanceReleasedId(List<ObjectShowInstanceJoin> objectShowInstanceJoins) {
        HashMap<Long, List<ObjectShowInstanceJoin>> nodeInstanceReleasedIdToJoins = new HashMap<Long, List<ObjectShowInstanceJoin>>();
        for (ObjectShowInstanceJoin objectShowInstanceJoin : objectShowInstanceJoins) {
            Long nodeInstanceReleasedId = objectShowInstanceJoin.getReviewCycleNodeInstanceReleasedId();
            if (!nodeInstanceReleasedIdToJoins.containsKey(nodeInstanceReleasedId)) {
                nodeInstanceReleasedIdToJoins.put(nodeInstanceReleasedId, new ArrayList());
            }
            ((List)nodeInstanceReleasedIdToJoins.get(nodeInstanceReleasedId)).add(objectShowInstanceJoin);
        }
        return nodeInstanceReleasedIdToJoins;
    }

    public static Map<Long, List<ObjectReleaseJoin>> groupObjectReleaseJoinsByObjectReleaseId(List<ObjectReleaseJoin> objectReleaseJoins) {
        HashMap<Long, List<ObjectReleaseJoin>> objectReleaseIdToJoins = new HashMap<Long, List<ObjectReleaseJoin>>();
        for (ObjectReleaseJoin objectReleaseJoin : objectReleaseJoins) {
            Long objectReleaseId = objectReleaseJoin.getObjectReleaseId();
            if (!objectReleaseIdToJoins.containsKey(objectReleaseId)) {
                objectReleaseIdToJoins.put(objectReleaseId, new ArrayList());
            }
            ((List)objectReleaseIdToJoins.get(objectReleaseId)).add(objectReleaseJoin);
        }
        return objectReleaseIdToJoins;
    }

    public static Map<Long, List<ObjectJoin>> groupObjectJoinsByObjectId(List<ObjectJoin> objectJoins) {
        HashMap<Long, List<ObjectJoin>> objectIdToJoins = new HashMap<Long, List<ObjectJoin>>();
        for (ObjectJoin objectJoin : objectJoins) {
            Long objectId = objectJoin.getObjectId();
            if (!objectIdToJoins.containsKey(objectId)) {
                objectIdToJoins.put(objectId, new ArrayList());
            }
            ((List)objectIdToJoins.get(objectId)).add(objectJoin);
        }
        return objectIdToJoins;
    }

    public static Map<Long, List<ObjectReleaseJoin>> groupObjectReleaseJoinsByObjectPlannerReleaseId(List<ObjectReleaseJoin> objectReleaseJoins) {
        HashMap<Long, List<ObjectReleaseJoin>> objectReleaseIdToJoins = new HashMap<Long, List<ObjectReleaseJoin>>();
        for (ObjectReleaseJoin objectReleaseJoin : objectReleaseJoins) {
            Long objectPlannerReleaseId = objectReleaseJoin.getObjectPlannerReleaseId();
            if (objectPlannerReleaseId == null) continue;
            if (!objectReleaseIdToJoins.containsKey(objectPlannerReleaseId)) {
                objectReleaseIdToJoins.put(objectPlannerReleaseId, new ArrayList());
            }
            ((List)objectReleaseIdToJoins.get(objectPlannerReleaseId)).add(objectReleaseJoin);
        }
        return objectReleaseIdToJoins;
    }

    public static Map<Long, List<ObjectJoin>> groupObjectJoinsByObjectPlannerId(List<ObjectJoin> objectJoins) {
        HashMap<Long, List<ObjectJoin>> objectIdToJoins = new HashMap<Long, List<ObjectJoin>>();
        for (ObjectJoin objectJoin : objectJoins) {
            Long objectPlannerId = objectJoin.getObjectPlannerId();
            if (objectPlannerId == null) continue;
            if (!objectIdToJoins.containsKey(objectPlannerId)) {
                objectIdToJoins.put(objectPlannerId, new ArrayList());
            }
            ((List)objectIdToJoins.get(objectPlannerId)).add(objectJoin);
        }
        return objectIdToJoins;
    }

    public static ObjectInfo getObjectInfoByObjectReleaseJoins(ObjectListRelease objectListRelease, List<ObjectReleaseJoin> baseJoins, Map<Long, List<ReviewCycleCellInstanceReleased>> objectPlannerReleasedIdToCellInstanceReleaseds, Map<Long, List<ObjectReleaseJoin>> objectPlannerReleasedIdToPositionJoins) {
        ObjectInfo objectInfo = new ObjectInfo();
        ObjectReleaseJoin someJoin = baseJoins.get(0);
        objectInfo.setId(someJoin.getObjectReleaseId());
        objectInfo.setCode(someJoin.getObjectReleaseCode());
        objectInfo.setComment(someJoin.getObjectReleaseComment());
        objectInfo.setObjectTypeId(someJoin.getObjectTypeId());
        objectInfo.setObjectTypeCode(someJoin.getObjectTypeCode());
        objectInfo.setName(someJoin.getObjectReleaseName());
        objectInfo.setStretchKmFrom(someJoin.getObjectReleaseStretchKmFrom());
        objectInfo.setStretchKmTo(someJoin.getObjectReleaseStretchKmTo());
        objectInfo.setInactive(someJoin.getObjectReleaseInactiveFlag());
        objectInfo.setReadOnly(someJoin.getObjectReadOnly());
        objectInfo.setChanged(someJoin.getObjectReleaseChanged());
        objectInfo.setAsBuiltReferenceId(someJoin.getObjectAsBuiltReference());
        objectInfo.setObjectId(someJoin.getObjectId());
        objectInfo.setVersion(objectListRelease.getVersion());
        Map<Long, List<ObjectReleaseJoin>> objectPlannerReleaseIdToJoins = ObjectHelper.groupObjectReleaseJoinsByObjectPlannerReleaseId(baseJoins);
        ArrayList<ObjectPlannerInfo> objectPlannerInfos = new ArrayList<ObjectPlannerInfo>();
        for (Long objectPlannerReleaseId : objectPlannerReleaseIdToJoins.keySet()) {
            List<ObjectReleaseJoin> currObjectReleaseJoins = objectPlannerReleaseIdToJoins.get(objectPlannerReleaseId);
            ObjectReleaseJoin someObjectPlannerReleaseJoin = currObjectReleaseJoins.get(0);
            ObjectPlannerInfo objectPlannerInfo = new ObjectPlannerInfo();
            objectPlannerInfo.setId(someObjectPlannerReleaseJoin.getObjectPlannerReleaseId());
            objectPlannerInfo.setCode(someObjectPlannerReleaseJoin.getObjectPlannerReleaseCode());
            objectPlannerInfo.setArea(someObjectPlannerReleaseJoin.getObjectPlannerReleaseArea());
            objectPlannerInfo.setInactive(someObjectPlannerReleaseJoin.getObjectPlannerInactive());
            objectPlannerInfo.setChanged(someObjectPlannerReleaseJoin.getObjectPlannerReleaseChanged());
            objectPlannerInfo.setReviewCycleInstanceId(someObjectPlannerReleaseJoin.getReviewCycleInstanceReleasedId());
            objectPlannerInfo.setReviewCycleInstanceChanged(someObjectPlannerReleaseJoin.getReviewCycleInstanceReleasedChanged());
            objectPlannerInfo.setReviewCycleInstanceName(someObjectPlannerReleaseJoin.getReviewCycleInstanceReleasedName());
            objectPlannerInfo.setPlannerParticipationId(someObjectPlannerReleaseJoin.getProjectParticipationId());
            objectPlannerInfo.setPlannerParticipationComment(someObjectPlannerReleaseJoin.getProjectParticipationComment());
            objectPlannerInfo.setPlannerOrgPersonId(someObjectPlannerReleaseJoin.getOrganisationPersonId());
            objectPlannerInfo.setPlannerOrganisationId(someObjectPlannerReleaseJoin.getOrganisationId());
            objectPlannerInfo.setPlannerOrganisationName(someObjectPlannerReleaseJoin.getOrganisationName());
            objectPlannerInfo.setPlannerPersonId(someObjectPlannerReleaseJoin.getPersonId());
            objectPlannerInfo.setPlannerPersonGivenName(someObjectPlannerReleaseJoin.getPersonGivenName());
            objectPlannerInfo.setPlannerPersonSurName(someObjectPlannerReleaseJoin.getPersonSurName());
            objectPlannerInfo.setAsBuiltReferenceId(someObjectPlannerReleaseJoin.getObjectPlannerAsBuiltReference());
            ObjectListChangedState changedState = ObjectHelper.getObjectPlannerChangedState(objectInfo, objectPlannerInfo, objectPlannerReleasedIdToCellInstanceReleaseds);
            objectPlannerInfo.setChangedState(changedState);
            List<ObjectReleaseJoin> positionJoins = objectPlannerReleasedIdToPositionJoins.get(objectPlannerReleaseId);
            List<ObjectPlannerPositionInfo> positionInfos = ObjectHelper.getPositionInfosByPositionReleasedJoins(positionJoins);
            objectPlannerInfo.setPositionInfos(positionInfos);
            objectPlannerInfos.add(objectPlannerInfo);
        }
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        Collections.sort(objectPlannerInfos, new Comparator<ObjectPlannerInfo>(){

            @Override
            public int compare(ObjectPlannerInfo infoOne, ObjectPlannerInfo infoTwo) {
                String codeOne = infoOne.getCode() != null ? infoOne.getCode() : "";
                String codeTwo = infoTwo.getCode() != null ? infoTwo.getCode() : "";
                String areaOne = infoOne.getArea() != null ? infoOne.getArea() : "";
                String areaTwo = infoTwo.getArea() != null ? infoTwo.getArea() : "";
                String keyOne = codeOne + areaOne;
                String keyTwo = codeTwo + areaTwo;
                return collator.compare(keyOne, keyTwo);
            }
        });
        objectInfo.setObjectPlannerInfos(objectPlannerInfos);
        ObjectListChangedState changedState = ObjectHelper.getObjectChangedState(objectInfo, objectPlannerReleasedIdToCellInstanceReleaseds);
        objectInfo.setChangedState(changedState);
        return objectInfo;
    }

    public static ObjectInfo getObjectInfoByObjectJoins(List<ObjectJoin> baseJoins, Map<Long, List<ReviewCycleCellInstance>> objectPlannerIdToCellInstances, Map<Long, List<ObjectJoin>> objectPlannerIdToPositionJoins) {
        ObjectInfo objectInfo = new ObjectInfo();
        ObjectJoin someJoin = baseJoins.get(0);
        objectInfo.setId(someJoin.getObjectId());
        objectInfo.setCode(someJoin.getObjectCode());
        objectInfo.setComment(someJoin.getObjectComment());
        objectInfo.setObjectTypeId(someJoin.getObjectTypeId());
        objectInfo.setObjectTypeCode(someJoin.getObjectTypeCode());
        objectInfo.setName(someJoin.getObjectName());
        objectInfo.setStretchKmFrom(someJoin.getObjectStretchKmFrom());
        objectInfo.setStretchKmTo(someJoin.getObjectStretchKmTo());
        objectInfo.setInactive(someJoin.getObjectInactiveFlag());
        objectInfo.setReadOnly(someJoin.getObjectReadOnly());
        objectInfo.setChanged(someJoin.getObjectHasChanged());
        objectInfo.setAsBuiltReferenceId(someJoin.getObjectAsBuiltReference());
        objectInfo.setObjectId(someJoin.getObjectId());
        objectInfo.setVersion(someJoin.getObjectListVersion());
        Map<Long, List<ObjectJoin>> objectPlannerIdToJoins = ObjectHelper.groupObjectJoinsByObjectPlannerId(baseJoins);
        ArrayList<ObjectPlannerInfo> objectPlannerInfos = new ArrayList<ObjectPlannerInfo>();
        for (Long objectPlannerId : objectPlannerIdToJoins.keySet()) {
            List<ObjectJoin> currObjectJoins = objectPlannerIdToJoins.get(objectPlannerId);
            ObjectJoin someObjectPlannerJoin = currObjectJoins.get(0);
            ObjectPlannerInfo objectPlannerInfo = new ObjectPlannerInfo();
            objectPlannerInfo.setId(someObjectPlannerJoin.getObjectPlannerId());
            objectPlannerInfo.setCode(someObjectPlannerJoin.getObjectPlannerCode());
            objectPlannerInfo.setArea(someObjectPlannerJoin.getObjectPlannerArea());
            objectPlannerInfo.setInactive(someObjectPlannerJoin.getObjectPlannerInactive());
            objectPlannerInfo.setChanged(someObjectPlannerJoin.getObjectPlannerChanged());
            objectPlannerInfo.setPlannerId(someObjectPlannerJoin.getObjectPlannerPlannerId());
            objectPlannerInfo.setDefinitionId(someObjectPlannerJoin.getObjectPlannerDefinitionId());
            objectPlannerInfo.setReviewCycleInstanceId(someObjectPlannerJoin.getReviewCycleInstanceId());
            objectPlannerInfo.setReviewCycleInstanceChanged(someObjectPlannerJoin.getReviewCycleInstanceChanged());
            objectPlannerInfo.setReviewCycleInstanceName(someObjectPlannerJoin.getReviewCycleInstanceName());
            objectPlannerInfo.setPlannerParticipationId(someObjectPlannerJoin.getProjectParticipationId());
            objectPlannerInfo.setPlannerOrgPersonId(someObjectPlannerJoin.getOrganisationPersonId());
            objectPlannerInfo.setPlannerOrganisationId(someObjectPlannerJoin.getOrganisationId());
            objectPlannerInfo.setPlannerOrganisationName(someObjectPlannerJoin.getOrganisationName());
            objectPlannerInfo.setPlannerPersonId(someObjectPlannerJoin.getPersonId());
            objectPlannerInfo.setPlannerPersonGivenName(someObjectPlannerJoin.getPersonGivenName());
            objectPlannerInfo.setPlannerPersonSurName(someObjectPlannerJoin.getPersonSurName());
            objectPlannerInfo.setAsBuiltReferenceId(someObjectPlannerJoin.getObjectPlannerAsBuiltReference());
            ObjectListChangedState changedState = ObjectHelper.getObjectPlannerChangedStateByNonReleased(objectInfo, objectPlannerInfo, objectPlannerIdToCellInstances);
            objectPlannerInfo.setChangedState(changedState);
            boolean hasObjectPlannerRelease = someObjectPlannerJoin.getObjectPlannerReleaseId() != null;
            boolean hasVersion = someObjectPlannerJoin.getPlannerHasVersionsId() != null;
            objectPlannerInfo.setDeletable(!hasObjectPlannerRelease);
            objectPlannerInfo.setReviewCycleChangeable(!hasObjectPlannerRelease || !hasVersion);
            List<ObjectJoin> positionJoins = objectPlannerIdToPositionJoins.get(objectPlannerId);
            List<ObjectPlannerPositionInfo> positionInfos = ObjectHelper.getPositionInfosByPositionJoins(positionJoins);
            objectPlannerInfo.setPositionInfos(positionInfos);
            objectPlannerInfos.add(objectPlannerInfo);
        }
        final Collator collator = Collator.getInstance(ThreadLocalManager.getLoginLocale());
        Collections.sort(objectPlannerInfos, new Comparator<ObjectPlannerInfo>(){

            @Override
            public int compare(ObjectPlannerInfo infoOne, ObjectPlannerInfo infoTwo) {
                String codeOne = infoOne.getCode() != null ? infoOne.getCode() : "";
                String codeTwo = infoTwo.getCode() != null ? infoTwo.getCode() : "";
                String areaOne = infoOne.getArea() != null ? infoOne.getArea() : "";
                String areaTwo = infoTwo.getArea() != null ? infoTwo.getArea() : "";
                String keyOne = codeOne + areaOne;
                String keyTwo = codeTwo + areaTwo;
                return collator.compare(keyOne, keyTwo);
            }
        });
        objectInfo.setObjectPlannerInfos(objectPlannerInfos);
        ObjectListChangedState changedState = ObjectHelper.getObjectChangedStateByNonReleased(objectInfo, objectPlannerIdToCellInstances);
        objectInfo.setChangedState(changedState);
        return objectInfo;
    }

    private static ObjectListChangedState getObjectChangedState(ObjectInfo objectInfo, Map<Long, List<ReviewCycleCellInstanceReleased>> objectPlannerReleasedIdToCellInstanceReleaseds) {
        ObjectChanged objectChanged = ObjectChanged.getByValue((Integer)objectInfo.getChanged());
        if (objectChanged == ObjectChanged.NEW) {
            return ObjectListChangedState.NEW;
        }
        for (ObjectPlannerInfo objectPlannerInfo : objectInfo.getObjectPlannerInfos()) {
            if (objectPlannerInfo.getReviewCycleInstanceId() == null) continue;
            ObjectChanged reviewCycleInstanceChanged = ObjectChanged.getByValue((Integer)objectPlannerInfo.getReviewCycleInstanceChanged());
            if (reviewCycleInstanceChanged == ObjectChanged.CHANGED || reviewCycleInstanceChanged == ObjectChanged.NEW) {
                return ObjectListChangedState.REVIEW_CYCLE_INSTANCE_CHANGE;
            }
            Long objectPlannerReleasedId = objectPlannerInfo.getId();
            List<ReviewCycleCellInstanceReleased> cellInstanceReleaseds = objectPlannerReleasedIdToCellInstanceReleaseds.get(objectPlannerReleasedId);
            if (cellInstanceReleaseds == null) continue;
            for (ReviewCycleCellInstanceReleased cellInstanceReleased : cellInstanceReleaseds) {
                ObjectChanged cellChanged = ObjectChanged.getByValue((Integer)cellInstanceReleased.getChanged());
                if (cellChanged != ObjectChanged.CHANGED && cellChanged != ObjectChanged.NEW) continue;
                return ObjectListChangedState.REVIEW_CYCLE_INSTANCE_CHANGE;
            }
        }
        for (ObjectPlannerInfo objectPlannerInfo : objectInfo.getObjectPlannerInfos()) {
            ObjectChanged objectPlannerChanged = ObjectChanged.getByValue((Integer)objectPlannerInfo.getChanged());
            if (objectPlannerChanged != ObjectChanged.CHANGED) continue;
            return ObjectListChangedState.MODIFIED;
        }
        if (objectChanged == ObjectChanged.CHANGED) {
            return ObjectListChangedState.MODIFIED;
        }
        return ObjectListChangedState.NOCHANGE;
    }

    private static ObjectListChangedState getObjectChangedStateByNonReleased(ObjectInfo objectInfo, Map<Long, List<ReviewCycleCellInstance>> objectPlannerIdToCellInstances) {
        ObjectChanged objectChanged = ObjectChanged.getByValue((Integer)objectInfo.getChanged());
        if (objectChanged == ObjectChanged.NEW) {
            return ObjectListChangedState.NEW;
        }
        for (ObjectPlannerInfo objectPlannerInfo : objectInfo.getObjectPlannerInfos()) {
            if (objectPlannerInfo.getReviewCycleInstanceId() == null) continue;
            ObjectChanged reviewCycleInstanceChanged = ObjectChanged.getByValue((Integer)objectPlannerInfo.getReviewCycleInstanceChanged());
            if (reviewCycleInstanceChanged == ObjectChanged.CHANGED || reviewCycleInstanceChanged == ObjectChanged.NEW) {
                return ObjectListChangedState.REVIEW_CYCLE_INSTANCE_CHANGE;
            }
            Long objectPlannerId = objectPlannerInfo.getId();
            List<ReviewCycleCellInstance> cellInstances = objectPlannerIdToCellInstances.get(objectPlannerId);
            for (ReviewCycleCellInstance cellInstance : cellInstances) {
                ObjectChanged cellChanged = ObjectChanged.getByValue((Integer)cellInstance.getChanged());
                if (cellChanged != ObjectChanged.CHANGED && cellChanged != ObjectChanged.NEW) continue;
                return ObjectListChangedState.REVIEW_CYCLE_INSTANCE_CHANGE;
            }
        }
        for (ObjectPlannerInfo objectPlannerInfo : objectInfo.getObjectPlannerInfos()) {
            ObjectChanged objectPlannerChanged = ObjectChanged.getByValue((Integer)objectPlannerInfo.getChanged());
            if (objectPlannerChanged != ObjectChanged.CHANGED) continue;
            return ObjectListChangedState.MODIFIED;
        }
        if (objectChanged == ObjectChanged.CHANGED) {
            return ObjectListChangedState.MODIFIED;
        }
        return ObjectListChangedState.NOCHANGE;
    }

    private static ObjectListChangedState getObjectPlannerChangedState(ObjectInfo objectInfo, ObjectPlannerInfo objectPlannerInfo, Map<Long, List<ReviewCycleCellInstanceReleased>> objectPlannerReleasedIdToCellInstanceReleaseds) {
        ObjectChanged objectChanged = ObjectChanged.getByValue((Integer)objectInfo.getChanged());
        ObjectChanged objectPlannerChanged = ObjectChanged.getByValue((Integer)objectPlannerInfo.getChanged());
        if (objectChanged == ObjectChanged.NEW || objectPlannerChanged == ObjectChanged.NEW) {
            return ObjectListChangedState.NEW;
        }
        if (objectPlannerInfo.getReviewCycleInstanceId() != null) {
            ObjectChanged reviewCycleInstanceChanged = ObjectChanged.getByValue((Integer)objectPlannerInfo.getReviewCycleInstanceChanged());
            if (reviewCycleInstanceChanged == ObjectChanged.CHANGED || reviewCycleInstanceChanged == ObjectChanged.NEW) {
                return ObjectListChangedState.REVIEW_CYCLE_INSTANCE_CHANGE;
            }
            Long objectPlannerReleasedId = objectPlannerInfo.getId();
            List<ReviewCycleCellInstanceReleased> cellInstanceReleaseds = objectPlannerReleasedIdToCellInstanceReleaseds.get(objectPlannerReleasedId);
            if (cellInstanceReleaseds != null) {
                for (ReviewCycleCellInstanceReleased cellInstanceReleased : cellInstanceReleaseds) {
                    ObjectChanged cellChanged = ObjectChanged.getByValue((Integer)cellInstanceReleased.getChanged());
                    if (cellChanged != ObjectChanged.CHANGED && cellChanged != ObjectChanged.NEW) continue;
                    return ObjectListChangedState.REVIEW_CYCLE_INSTANCE_CHANGE;
                }
            }
        }
        if (objectPlannerChanged == ObjectChanged.CHANGED) {
            return ObjectListChangedState.MODIFIED;
        }
        return ObjectListChangedState.NOCHANGE;
    }

    private static ObjectListChangedState getObjectPlannerChangedStateByNonReleased(ObjectInfo objectInfo, ObjectPlannerInfo objectPlannerInfo, Map<Long, List<ReviewCycleCellInstance>> objectPlannerIdToCellInstances) {
        ObjectChanged objectChanged = ObjectChanged.getByValue((Integer)objectInfo.getChanged());
        ObjectChanged objectPlannerChanged = ObjectChanged.getByValue((Integer)objectPlannerInfo.getChanged());
        if (objectChanged == ObjectChanged.NEW || objectPlannerChanged == ObjectChanged.NEW) {
            return ObjectListChangedState.NEW;
        }
        if (objectPlannerInfo.getReviewCycleInstanceId() != null) {
            ObjectChanged reviewCycleInstanceChanged = ObjectChanged.getByValue((Integer)objectPlannerInfo.getReviewCycleInstanceChanged());
            if (reviewCycleInstanceChanged == ObjectChanged.CHANGED || reviewCycleInstanceChanged == ObjectChanged.NEW) {
                return ObjectListChangedState.REVIEW_CYCLE_INSTANCE_CHANGE;
            }
            Long objectPlannerId = objectPlannerInfo.getId();
            List<ReviewCycleCellInstance> cellInstances = objectPlannerIdToCellInstances.get(objectPlannerId);
            for (ReviewCycleCellInstance cellInstance : cellInstances) {
                ObjectChanged cellChanged = ObjectChanged.getByValue((Integer)cellInstance.getChanged());
                if (cellChanged != ObjectChanged.CHANGED && cellChanged != ObjectChanged.NEW) continue;
                return ObjectListChangedState.REVIEW_CYCLE_INSTANCE_CHANGE;
            }
        }
        if (objectPlannerChanged == ObjectChanged.CHANGED) {
            return ObjectListChangedState.MODIFIED;
        }
        return ObjectListChangedState.NOCHANGE;
    }

    private static List<ObjectPlannerPositionInfo> getPositionInfosByPositionReleasedJoins(List<ObjectReleaseJoin> positionReleasedJoins) {
        ArrayList<ObjectPlannerPositionInfo> positionInfos = new ArrayList<ObjectPlannerPositionInfo>();
        if (positionReleasedJoins != null) {
            for (ObjectReleaseJoin join : positionReleasedJoins) {
                ObjectPlannerPositionInfo positionInfo = new ObjectPlannerPositionInfo();
                positionInfo.setId(join.getObjectPlannerPositionReleaseId());
                positionInfo.setProjectParticipationId(join.getProjectParticipationId());
                positionInfo.setProjectParticipationComment(join.getProjectParticipationComment());
                positionInfo.setRoleId(join.getObjectPlannerPositionReleaseRoleId());
                positionInfo.setPositionDefinitionId(join.getObjectPlannerPositionDefinitionId());
                positionInfo.setPositionDefinitionName(join.getObjectPlannerPositionDefinitionName());
                positionInfo.setMainParticipantId(join.getProjectParticipationId());
                positionInfo.setMainOrganisationId(join.getOrganisationId());
                positionInfo.setMainOrganisationName(join.getOrganisationName());
                positionInfo.setMainPersonId(join.getPersonId());
                positionInfo.setMainPersonGivenName(join.getPersonGivenName());
                positionInfo.setMainPersonSurName(join.getPersonSurName());
                positionInfos.add(positionInfo);
            }
        }
        return positionInfos;
    }

    private static List<ObjectPlannerPositionInfo> getPositionInfosByPositionJoins(List<ObjectJoin> positionJoins) {
        ArrayList<ObjectPlannerPositionInfo> positionInfos = new ArrayList<ObjectPlannerPositionInfo>();
        if (positionJoins != null) {
            for (ObjectJoin join : positionJoins) {
                ObjectPlannerPositionInfo positionInfo = new ObjectPlannerPositionInfo();
                positionInfo.setId(join.getObjectPlannerPositionId());
                positionInfo.setProjectParticipationId(join.getProjectParticipationId());
                positionInfo.setRoleId(join.getObjectPlannerPositionRoleId());
                positionInfo.setPositionDefinitionId(join.getObjectPlannerPositionDefinitionId());
                positionInfo.setPositionDefinitionName(join.getObjectPlannerPositionDefinitionName());
                positionInfo.setPositionDefinitionRoleTypeId(join.getObjectPlannerPositionDefinitionRoleTypeId());
                positionInfo.setMainParticipantId(join.getProjectParticipationId());
                positionInfo.setMainOrganisationId(join.getOrganisationId());
                positionInfo.setMainOrganisationName(join.getOrganisationName());
                positionInfo.setMainPersonId(join.getPersonId());
                positionInfo.setMainPersonGivenName(join.getPersonGivenName());
                positionInfo.setMainPersonSurName(join.getPersonSurName());
                positionInfos.add(positionInfo);
            }
        }
        return positionInfos;
    }

    public static Map<Long, ObjectRelease> getObjectIdToRelease(List<ObjectRelease> objectReleases) {
        HashMap<Long, ObjectRelease> objectIdToRelease = new HashMap<Long, ObjectRelease>();
        for (ObjectRelease objectRelease : objectReleases) {
            Long objectId = objectRelease.getObjectId();
            objectIdToRelease.put(objectId, objectRelease);
        }
        return objectIdToRelease;
    }

    public static Map<Long, List<ObjectPlanner>> getObjectIdToPlanners(List<ObjectPlanner> objectPlanners) {
        HashMap<Long, List<ObjectPlanner>> objectIdToPlanners = new HashMap<Long, List<ObjectPlanner>>();
        for (ObjectPlanner objectPlanner : objectPlanners) {
            Long objectId = objectPlanner.getObjectId();
            if (!objectIdToPlanners.containsKey(objectId)) {
                objectIdToPlanners.put(objectId, new ArrayList());
            }
            ((List)objectIdToPlanners.get(objectId)).add(objectPlanner);
        }
        return objectIdToPlanners;
    }

    public static Map<Long, ObjectPlannerRelease> getObjectPlannerIdToRelease(List<ObjectPlannerRelease> objectPlannerReleases) {
        HashMap<Long, ObjectPlannerRelease> objectPlannerIdToRelease = new HashMap<Long, ObjectPlannerRelease>();
        for (ObjectPlannerRelease objectPlannerRelease : objectPlannerReleases) {
            Long objectPlannerId = objectPlannerRelease.getObjectPlannerId();
            objectPlannerIdToRelease.put(objectPlannerId, objectPlannerRelease);
        }
        return objectPlannerIdToRelease;
    }

    public static Map<Long, List<ObjectPlannerPosition>> getPlannerIdToPositions(List<ObjectPlannerPosition> positions) {
        HashMap<Long, List<ObjectPlannerPosition>> plannerIdToPositions = new HashMap<Long, List<ObjectPlannerPosition>>();
        for (ObjectPlannerPosition position : positions) {
            Long objectPlannerId = position.getObjectPlannerId();
            if (!plannerIdToPositions.containsKey(objectPlannerId)) {
                plannerIdToPositions.put(objectPlannerId, new ArrayList());
            }
            ((List)plannerIdToPositions.get(objectPlannerId)).add(position);
        }
        return plannerIdToPositions;
    }

    public static Map<Long, List<ObjectPlannerPositionRelease>> getPlannerReleaseIdToPositions(List<ObjectPlannerPositionRelease> positionReleases) {
        HashMap<Long, List<ObjectPlannerPositionRelease>> plannerReleaseIdToPositions = new HashMap<Long, List<ObjectPlannerPositionRelease>>();
        for (ObjectPlannerPositionRelease position : positionReleases) {
            Long objectPlannerId = position.getObjectPlannerId();
            if (!plannerReleaseIdToPositions.containsKey(objectPlannerId)) {
                plannerReleaseIdToPositions.put(objectPlannerId, new ArrayList());
            }
            ((List)plannerReleaseIdToPositions.get(objectPlannerId)).add(position);
        }
        return plannerReleaseIdToPositions;
    }
}

