/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ReviewCycleEntryTask;
import at.cdes.api.joinDto.EntryTaskJoin;
import at.cdes.api.joinDto.ReviewCycleEntryTaskJoin;
import at.cdes.api.joinDto.TaskWithEmailJoin;
import at.cdes.impl.dao.ReviewCycleEntryTaskDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcReviewCycleEntryTaskDAO;
import at.cdes.impl.dao.jdbc.JdbcTaskDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcReviewCycleEntryTaskDAO
extends AbstractJdbcReviewCycleEntryTaskDAO
implements ReviewCycleEntryTaskDAO {
    @Override
    public List<TaskWithEmailJoin> getReviewCycleEntryTasksWithMail(final Long documentId) {
        String sql = "SELECT " + JdbcTaskDAO.getTaskWithEmailJoinSelectClause() + "FROM ((((( task JOIN document_task            ON document_task.task_id = task.id) JOIN review_cycle_entry_task  ON review_cycle_entry_task.task_id = document_task.task_id) LEFT JOIN task_email_snippet       ON task_email_snippet.task_id = task.id) LEFT JOIN email_snippet            ON task_email_snippet.email_snippet_id = email_snippet.id) LEFT JOIN future_email             ON future_email.task_id = task.id) WHERE document_task.document_id = ?";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<TaskWithEmailJoin>>(){

            public List<TaskWithEmailJoin> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentId);
                ResultSet rs = statement.executeQuery();
                ArrayList<TaskWithEmailJoin> ret = new ArrayList<TaskWithEmailJoin>();
                while (rs.next()) {
                    ret.add(JdbcTaskDAO.fillTaskWithEmailJoinFromResultSet(rs));
                }
                return ret;
            }
        });
    }

    @Override
    public ReviewCycleEntryTask getByDocument(Long documentId) {
        String sql = "SELECT " + this.getSelectClauseForDto() + "\nFROM document\nJOIN document_task           ON document_task.document_id = document.id\n JOIN review_cycle_entry_task ON review_cycle_entry_task.task_id = document_task.task_id\nWHERE document.id = ?\n";
        return QueryHelper.getUniqueWithSqlFiller((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, filler -> filler.addLong(documentId));
    }

    @Override
    public List<EntryTaskJoin> getEntryTaskJoinsByDocument(Long documentId) {
        String sql = "SELECT " + JdbcReviewCycleEntryTaskDAO.getEntryTaskJoinSelectClause() + "FROM document_task  JOIN task                                ON document_task.task_id = task.id) JOIN review_cycle_entry_task             ON review_cycle_entry_task.task_id = document_task.task_id) LEFT JOIN future_email                        ON future_email.task_id = document_task.task_id) LEFT JOIN task_email_snippet                  ON task_email_snippet.task_id = document_task.task_id) LEFT JOIN email_snippet                       ON task_email_snippet.email_snippet_id = email_snippet.id) WHERE document_task.document_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcReviewCycleEntryTaskDAO::fillEntryTaskJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentId);
        });
    }

    @Override
    public List<ReviewCycleEntryTaskJoin> getEntryTaskJoinsBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcReviewCycleEntryTaskDAO.getReviewCycleEntryTaskJoinSelectClause() + "FROM task JOIN document_task                       ON document_task.task_id = task.id JOIN review_cycle_entry_task             ON review_cycle_entry_task.task_id = task.id JOIN object_planner                      ON document_task.object_planner_id = object_planner.id JOIN object                              ON object_planner.object_id = object.id JOIN object_list                         ON object.object_list_id = object_list.id JOIN document                            ON document_task.document_id = document.id JOIN document_list                       ON document.document_list_id = document_list.id LEFT JOIN document_list_release               ON     document_list_release.document_list_id = document_list.id AND document_list_release.version = document_list.version - 1 LEFT JOIN document_release                    ON     document_release.document_list_id = document_list_release.id AND document_release.document_id = document.id WHERE object_list.sub_project_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcReviewCycleEntryTaskDAO::fillReviewCycleEntryTaskJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }
}

