/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.export.obj;

import at.cdes.api.guiService.ObjectService;
import at.cdes.api.obj.dto.ObjectSearchModel;
import at.cdes.api.voc.misc.SortOrder;
import at.cdes.impl.export.obj.ObjectListPdfExporter;
import java.util.List;
import org.clazzes.util.sched.cache.ScratchFile;
import org.clazzes.util.sched.impl.HasLoggingCallable;

public class ObjectListPdfCallable
extends HasLoggingCallable<ScratchFile> {
    private ObjectListPdfExporter exporter;
    private Long organisationPersonId;
    private ObjectService objectService;
    private ObjectSearchModel searchModel;
    private SortOrder sortOrder;
    private boolean enableCustomerLogo;

    public ObjectListPdfCallable(ObjectListPdfExporter exporter, ObjectService objectService, Long organisationPersonId, ObjectSearchModel searchModel, SortOrder sortOrder, boolean enableCustomerLogo) {
        this.exporter = exporter;
        this.objectService = objectService;
        this.organisationPersonId = organisationPersonId;
        this.searchModel = searchModel;
        this.sortOrder = sortOrder;
        this.enableCustomerLogo = enableCustomerLogo;
    }

    public ScratchFile call() throws Exception {
        boolean released = this.searchModel.isReleased();
        List objectInfos = released ? this.objectService.getObjectReleaseInfos(this.organisationPersonId, this.searchModel) : this.objectService.getObjectInfos(this.organisationPersonId, this.searchModel);
        ScratchFile scratchFile = this.exporter.export(this.organisationPersonId, this.searchModel, this.sortOrder, objectInfos, this.enableCustomerLogo);
        return scratchFile;
    }
}

