/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.imp;

import at.cdes.api.dao.TemporaryDocumentDAO;
import at.cdes.api.document.PreviewRenderer;
import at.cdes.api.document.compositeDto.TemporaryDocumentVersion;
import at.cdes.api.sec.CdesPrincipal;
import at.cdes.impl.imp.Parameters;
import at.cdes.impl.mime.MimeStreamUtils;
import at.cdes.preview.api.IMimeInputStream;
import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.clazzes.util.aop.ThreadLocalManager;

public class TemporaryDocumentPngPreviewServlet
extends HttpServlet {
    private PreviewRenderer previewRenderer;
    private TemporaryDocumentDAO temporaryDocumentDAO;
    private static final Gson gson = new Gson();

    public void setPreviewRenderer(PreviewRenderer previewRenderer) {
        this.previewRenderer = previewRenderer;
    }

    public void setTemporaryDocumentDAO(TemporaryDocumentDAO temporaryDocumentDAO) {
        this.temporaryDocumentDAO = temporaryDocumentDAO;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Parameters parameters = (Parameters)gson.fromJson(req.getParameter("q"), Parameters.class);
        TemporaryDocumentVersion documentVersion = (TemporaryDocumentVersion)this.temporaryDocumentDAO.get(parameters.versionId);
        CdesPrincipal principal = (CdesPrincipal)ThreadLocalManager.getLoginPrincipal();
        Long personId = principal.getPersonId();
        String userName = principal.getUserName();
        IMimeInputStream inputStream = this.previewRenderer.renderPngPreview(documentVersion, personId, userName, documentVersion.getSeekResult(), parameters.destinationId, parameters.pixelSize, parameters.angle);
        try (InputStream input = MimeStreamUtils.toInputStream(inputStream);
             ServletOutputStream output = resp.getOutputStream();){
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
    }
}

