/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.mime;

import at.cdes.preview.api.IMimeInputStream;
import at.cdes.preview.api.IOError;
import java.io.IOException;
import java.io.InputStream;

public class MimeStreamUtils {
    public static InputStream toInputStream(final IMimeInputStream inputStream) throws IOException {
        try {
            return new InputStream(){
                private long remaining;
                {
                    this.remaining = inputStream.getStreamSize();
                }

                @Override
                public int read() throws IOException {
                    try {
                        if (this.remaining <= 0L) {
                            return -1;
                        }
                        byte[] block = inputStream.readBlock(1);
                        --this.remaining;
                        return block[0];
                    }
                    catch (IOError e) {
                        throw new IOException(e);
                    }
                }

                @Override
                public int read(byte[] b) throws IOException {
                    try {
                        if (this.remaining <= 0L) {
                            return -1;
                        }
                        byte[] block = inputStream.readBlock((int)Math.min((long)b.length, this.remaining));
                        this.remaining -= (long)block.length;
                        for (int i = 0; i < block.length; ++i) {
                            b[i] = block[i];
                        }
                        return block.length;
                    }
                    catch (IOError e) {
                        throw new IOException(e);
                    }
                }

                @Override
                public int read(byte[] b, int off, int len) throws IOException {
                    try {
                        if (this.remaining <= 0L) {
                            return -1;
                        }
                        byte[] block = inputStream.readBlock((int)Math.min((long)len, this.remaining));
                        this.remaining -= (long)block.length;
                        for (int i = 0; i < block.length; ++i) {
                            b[off + i] = block[i];
                        }
                        return block.length;
                    }
                    catch (IOError e) {
                        throw new IOException(e);
                    }
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    try {
                        inputStream.close();
                    }
                    catch (IOError e) {
                        throw new IOException(e);
                    }
                }
            };
        }
        catch (IOError e) {
            throw new IOException(e);
        }
    }
}

