/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.objects;

import at.cdes.api.dto.Object;
import at.cdes.api.dto.ObjectList;
import at.cdes.api.dto.ObjectPlanner;
import at.cdes.api.dto.ObjectPlannerDefinition;
import at.cdes.api.dto.ObjectPlannerPosition;
import at.cdes.api.dto.ObjectPlannerPositionDefinition;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.impl.dao.ObjectDAO;
import at.cdes.impl.dao.ObjectListDAO;
import at.cdes.impl.dao.ObjectPlannerDAO;
import at.cdes.impl.dao.ObjectPlannerDefinitionDAO;
import at.cdes.impl.dao.ObjectPlannerPositionDAO;
import at.cdes.impl.dao.ObjectPlannerPositionDefinitionDAO;
import at.cdes.impl.dao.SubProjectDAO;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.objects.ObjectHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ObjectUtils {
    private ObjectDAO objectDAO;
    private ObjectListDAO objectListDAO;
    private ObjectPlannerDAO objectPlannerDAO;
    private ObjectPlannerDefinitionDAO objectPlannerDefinitionDAO;
    private ObjectPlannerPositionDefinitionDAO objectPlannerPositionDefinitionDAO;
    private ObjectPlannerPositionDAO objectPlannerPositionDAO;
    private SubProjectDAO subProjectDAO;

    public void setObjectDAO(ObjectDAO objectDAO) {
        this.objectDAO = objectDAO;
    }

    public void setObjectListDAO(ObjectListDAO objectListDAO) {
        this.objectListDAO = objectListDAO;
    }

    public void setObjectPlannerDAO(ObjectPlannerDAO objectPlannerDAO) {
        this.objectPlannerDAO = objectPlannerDAO;
    }

    public void setObjectPlannerDefinitionDAO(ObjectPlannerDefinitionDAO objectPlannerDefinitionDAO) {
        this.objectPlannerDefinitionDAO = objectPlannerDefinitionDAO;
    }

    public void setObjectPlannerPositionDefinitionDAO(ObjectPlannerPositionDefinitionDAO objectPlannerPositionDefinitionDAO) {
        this.objectPlannerPositionDefinitionDAO = objectPlannerPositionDefinitionDAO;
    }

    public void setObjectPlannerPositionDAO(ObjectPlannerPositionDAO objectPlannerPositionDAO) {
        this.objectPlannerPositionDAO = objectPlannerPositionDAO;
    }

    public void setSubProjectDAO(SubProjectDAO subProjectDAO) {
        this.subProjectDAO = subProjectDAO;
    }

    public void invalidateObjectListBySubProject(Long subProjectId) {
        List<ContextJoin> contextJoins = this.subProjectDAO.getSubProjectToObjectPlannerContextJoins(subProjectId);
        Set<Long> objectIds = ObjectHelper.getObjectIdsFromContextJoins(contextJoins);
        Set<Long> objectPlannerIds = ObjectHelper.getObjectPlannerIdsFromContextJoins(contextJoins);
        List objects = objectIds.size() > 0 ? this.objectDAO.getBatch(objectIds) : new ArrayList();
        List objectPlanners = objectPlannerIds.size() > 0 ? this.objectPlannerDAO.getBatch(objectPlannerIds) : new ArrayList();
        for (Object object : objects) {
            object.setInactiveFlag(Boolean.valueOf(true));
        }
        for (ObjectPlanner objectPlanner : objectPlanners) {
            objectPlanner.setInactive(Boolean.valueOf(true));
        }
        this.objectDAO.updateBatch(objects);
        this.objectPlannerDAO.updateBatch(objectPlanners);
    }

    public void deleteNeverReleasedObjectListBySubProject(Long subProjectId) {
        List<ObjectList> objectLists = this.objectListDAO.getBySubProject(subProjectId);
        List<Object> objects = this.objectDAO.getBySubProject(subProjectId);
        List<ObjectPlanner> objectPlanners = this.objectPlannerDAO.getBySubProject(subProjectId);
        List<ObjectPlannerPosition> objectPlannerPositions = this.objectPlannerPositionDAO.getBySubProject(subProjectId);
        List<Long> objectListIds = QueryHelper.getPersistentIds(objectLists);
        List<Long> objectIds = QueryHelper.getPersistentIds(objects);
        List<Long> objectPlannerIds = QueryHelper.getPersistentIds(objectPlanners);
        List<Long> objectPlannerPositionIds = QueryHelper.getPersistentIds(objectPlannerPositions);
        if (objectPlannerPositionIds.size() > 0) {
            this.objectPlannerPositionDAO.deleteBatch(objectPlannerPositionIds);
        }
        if (objectPlannerIds.size() > 0) {
            this.objectPlannerDAO.deleteBatch(objectPlannerIds);
        }
        if (objectIds.size() > 0) {
            this.objectDAO.deleteBatch(objectIds);
        }
        if (objectListIds.size() > 0) {
            this.objectListDAO.deleteBatch(objectListIds);
        }
    }

    public void deleteObjectPlannerDefinitionByProjectId(Long projectId) {
        List<ObjectPlannerDefinition> objectPlannerDefinitions = this.objectPlannerDefinitionDAO.getByProject(projectId);
        List<ObjectPlannerPositionDefinition> objectPlannerPositionDefinitions = this.objectPlannerPositionDefinitionDAO.getByProjectId(projectId);
        List<Long> definitionIds = QueryHelper.getPersistentIds(objectPlannerDefinitions);
        List<Long> positionDefinitionIds = QueryHelper.getPersistentIds(objectPlannerPositionDefinitions);
        if (positionDefinitionIds.size() > 0) {
            this.objectPlannerPositionDefinitionDAO.deleteBatch(positionDefinitionIds);
        }
        if (definitionIds.size() > 0) {
            this.objectPlannerDefinitionDAO.deleteBatch(definitionIds);
        }
    }
}

