/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.util.odf;

import at.cdes.api.dto.Country;
import at.cdes.api.dto.Organisation;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Person;
import at.cdes.impl.export.CdesExportHelper;
import at.cdes.impl.util.PersonHelper;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.clazzes.odf.util.core.OdfContext;
import org.clazzes.odf.util.text.TextFactory;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.w3c.dom.Node;

public class OdfAddressHelper {
    public static void generateAddressBlock(OdfElement parentElement, ResourceBundle resourceBundle, OdfContext odfContext, String textStyle, OrganisationPerson orgPerson, Organisation organisation, Person person, Country country) {
        String countryString;
        String postalAddress;
        String organisationName;
        String titleWithCommonName = PersonHelper.getCommonNameWithTitle(resourceBundle, person);
        if (titleWithCommonName != null) {
            TextFactory.constructTextNode((Node)parentElement, (String)titleWithCommonName, (String)textStyle);
        }
        if ((organisationName = organisation.getName()) != null) {
            TextFactory.constructTextNode((Node)parentElement, (String)organisationName, (String)textStyle);
        }
        if ((postalAddress = orgPerson.getPostalAddress()) != null) {
            CdesExportHelper.constructTextNodeWithLineBreaks(parentElement, postalAddress, textStyle);
        }
        String postalCodeWithLocalityRaw = resourceBundle.getString("postalCodeWithLocality");
        String postalCode = orgPerson.getPostalCode();
        String localityName = orgPerson.getLocalityName();
        String postalCodeWithLocality = null;
        postalCodeWithLocality = postalCode != null ? (localityName != null ? MessageFormat.format(postalCodeWithLocalityRaw, postalCode, localityName) : postalCode) : (localityName != null ? localityName : null);
        if (postalCodeWithLocality != null) {
            TextFactory.constructTextNode((Node)parentElement, (String)postalCodeWithLocality, (String)textStyle);
        }
        if ((countryString = country.getDescDe()) != null) {
            TextFactory.constructTextNode((Node)parentElement, (String)countryString, (String)textStyle);
        }
    }
}

