/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.ProjectParticipantHistoryPart;
import at.cdes.api.joinDto.ProjectParticipantHistoryPartJoin;
import at.cdes.impl.dao.ProjectParticipantHistoryPartDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcProjectParticipantHistoryPartDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcProjectParticipantHistoryPartDAO
extends AbstractJdbcProjectParticipantHistoryPartDAO
implements ProjectParticipantHistoryPartDAO {
    @Override
    public List<ProjectParticipantHistoryPart> getByProject(final Long projectId) {
        String sql = "SELECT " + JdbcProjectParticipantHistoryPartDAO.getSelectClauseForDto() + "FROM ((        project_participation LEFT JOIN project_participant                     ON project_participant.participation_id = project_participation.id) JOIN project_participant_history_part        ON project_participant_history_part.project_participant_id = project_participant.id) WHERE project_participation.project_id = ? ";
        List projectParticipantHistoryParts = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipantHistoryPart>>(){

            public List<ProjectParticipantHistoryPart> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipantHistoryPart> ret = new ArrayList<ProjectParticipantHistoryPart>();
                while (rs.next()) {
                    ret.add(JdbcProjectParticipantHistoryPartDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
        return projectParticipantHistoryParts;
    }

    @Override
    public List<ProjectParticipantHistoryPart> getByParticipation(final Long projectParticipationId) {
        String sql = "SELECT " + JdbcProjectParticipantHistoryPartDAO.getSelectClauseForDto() + "FROM ((        project_participation LEFT JOIN project_participant                     ON project_participant.participation_id = project_participation.id) JOIN project_participant_history_part        ON project_participant_history_part.project_participant_id = project_participant.id) WHERE project_participation.id = ? ";
        List projectParticipantHistoryParts = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipantHistoryPart>>(){

            public List<ProjectParticipantHistoryPart> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectParticipationId);
                ResultSet rs = statement.executeQuery();
                ArrayList<ProjectParticipantHistoryPart> ret = new ArrayList<ProjectParticipantHistoryPart>();
                while (rs.next()) {
                    ret.add(JdbcProjectParticipantHistoryPartDAO.this.fillDtoFromResultSet(rs));
                }
                return ret;
            }
        });
        return projectParticipantHistoryParts;
    }

    @Override
    public ProjectParticipantHistoryPart getNewestByParticipant(final Long participantId) {
        String sql = "SELECT " + JdbcProjectParticipantHistoryPartDAO.getSelectClauseForDto() + "FROM project_participant_history_part WHERE project_participant_history_part.project_participant_id = ? AND project_participant_history_part.start_date = (SELECT MAX(local_history_part.start_date) FROM project_participant_history_part local_history_part WHERE local_history_part.project_participant_id = ?)";
        ProjectParticipantHistoryPart maxHistoryPart = (ProjectParticipantHistoryPart)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<ProjectParticipantHistoryPart>(){

            public ProjectParticipantHistoryPart perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participantId);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)participantId);
                ResultSet rs = statement.executeQuery();
                ProjectParticipantHistoryPart maxHistoryPart = null;
                while (rs.next()) {
                    maxHistoryPart = JdbcProjectParticipantHistoryPartDAO.this.fillDtoFromResultSet(rs);
                }
                return maxHistoryPart;
            }
        });
        return maxHistoryPart;
    }

    @Override
    public List<ProjectParticipantHistoryPartJoin> getJoinByParticipation(final Long participationId) {
        String sql = "SELECT " + JdbcProjectParticipantHistoryPartDAO.getProjectParticipantHistoryPartJoinSelectClause() + "FROM  \t\tproject_participant_history_part  JOIN\t\t\tproject_participant                               ON project_participant_history_part.project_participant_id = project_participant.id LEFT JOIN\tproject_participation                             ON project_participant.participation_id = project_participation.id LEFT JOIN\torganisation_person affected_organisation_person  ON project_participant.organisation_person_id = affected_organisation_person.id LEFT JOIN\tperson affected_person                            ON affected_organisation_person.person_id = affected_person.id LEFT JOIN    organisation affected_organisation                ON affected_organisation_person.organisation_id = affected_organisation.id LEFT JOIN \torganisation_person modifying_organisation_person ON project_participant_history_part.organisation_person_id = modifying_organisation_person.id LEFT JOIN\tperson modifying_person                           ON modifying_organisation_person.person_id = modifying_person.id WHERE project_participation.id = ?;";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ProjectParticipantHistoryPartJoin>>(){

            public List<ProjectParticipantHistoryPartJoin> perform(PreparedStatement stmt) throws Exception {
                int currIndex = 1;
                stmt.setLong(currIndex, participationId);
                ResultSet rs = stmt.executeQuery();
                ArrayList<ProjectParticipantHistoryPartJoin> joins = new ArrayList<ProjectParticipantHistoryPartJoin>();
                while (rs.next()) {
                    joins.add(AbstractJdbcProjectParticipantHistoryPartDAO.fillProjectParticipantHistoryPartJoinFromResultSet(rs));
                }
                return joins;
            }
        });
    }
}

