/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.Network;
import at.cdes.api.dto.Person;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.Search;
import at.cdes.api.joinDto.SearchJoin;
import at.cdes.impl.dao.GenSearchDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public abstract class AbstractJdbcSearchDAO
extends AbstrIdDAO<Search>
implements GenSearchDAO {
    public AbstractJdbcSearchDAO() {
        super(Search.class, "id", "search", new String[]{"id", "person_id", "name", "page_name", "project", "content", "network_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return AbstractJdbcSearchDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "person_id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "page_name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "content") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return AbstractJdbcSearchDAO.getSelectClauseForDto("search", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return AbstractJdbcSearchDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".person_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "person_id") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".page_name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "page_name") + "," + entityLocalName + ".project" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "project") + "," + entityLocalName + ".content" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "content") + "," + entityLocalName + ".network_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_id") + " ";
    }

    protected Search fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        Search search = new Search();
        search.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        search.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        search.setName(rs.getString(++columnIndex));
        search.setPageName(rs.getString(++columnIndex));
        search.setProject(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        search.setContent(rs.getString(++columnIndex));
        search.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return search;
    }

    public static Search fillSearchFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        Search search = new Search();
        search.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        search.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        search.setName(rs.getString(columnIndex.incrementAndGet()));
        search.setPageName(rs.getString(columnIndex.incrementAndGet()));
        search.setProject(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        search.setContent(rs.getString(columnIndex.incrementAndGet()));
        search.setNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return search;
    }

    public static Search fillSearchFromResultSet(ResultSet rs) throws SQLException {
        return AbstractJdbcSearchDAO.fillSearchFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 7;
    }

    public static SearchJoin fillSearchJoinFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        SearchJoin searchJoin = new SearchJoin();
        searchJoin.setPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        searchJoin.setPersonGivenName(rs.getString(++columnIndex));
        searchJoin.setPersonSurName(rs.getString(++columnIndex));
        searchJoin.setSearchId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        searchJoin.setSearchPersonId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        searchJoin.setSearchName(rs.getString(++columnIndex));
        searchJoin.setSearchPageName(rs.getString(++columnIndex));
        searchJoin.setSearchProject(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        searchJoin.setSearchContent(rs.getString(++columnIndex));
        searchJoin.setSearchNetworkId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return searchJoin;
    }

    public static int getNumberOfSearchJoinAttributes() {
        return 10;
    }

    protected String getSelectClauseForSearchJoinUnion(String ... localNames) {
        String result = "";
        HashSet<String> localNamesSet = new HashSet<String>();
        for (int n = 0; n < localNames.length; ++n) {
            localNamesSet.add(localNames[n]);
        }
        result = localNamesSet.contains("person") ? result + "person.id, person.givenName, person.surName" : result + "NULL, NULL, NULL";
        result = result + ", ";
        result = localNamesSet.contains("search") ? result + "search.id, search.person_id, search.name, search.page_name, search.project, search.content, search.network_id" : result + "NULL, NULL, NULL, NULL, NULL, NULL, NULL";
        return result;
    }

    public int update(Search dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<Search> dtos) {
        Iterator<Search> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    public static String getSearchJoinSelectClause() {
        return "person.id, person.givenName, person.surName, search.id, search.person_id, search.name, search.page_name, search.project, search.content, search.network_id ";
    }

    public static String getPrefixedSearchJoinSelectClause() {
        return "person.id AS person_id, person.givenName AS person_givenName, person.surName AS person_surName, search.id AS search_id, search.person_id AS search_person_id, search.name AS search_name, search.page_name AS search_page_name, search.project AS search_project, search.content AS search_content, search.network_id AS search_network_id ";
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, Search search) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)search.getId());
        JDBCHelper.setLong((PreparedStatement)statement, (int)2, (Number)search.getPersonId());
        statement.setString(3, search.getName());
        statement.setString(4, search.getPageName());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)search.getProject());
        statement.setString(6, search.getContent());
        JDBCHelper.setLong((PreparedStatement)statement, (int)7, (Number)search.getNetworkId());
    }

    @Override
    public List<Search> getByPerson(Person person) {
        return this.getByPerson(person.getId());
    }

    @Override
    public List<Search> getByPerson(final Long personId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"person_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, personId);
            }
        });
    }

    @Override
    public List<Search> getByProject(Project project) {
        return this.getByProject(project.getId());
    }

    @Override
    public List<Search> getByProject(final Long projectId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, projectId);
            }
        });
    }

    @Override
    public List<Search> getByNetwork(Network network) {
        return this.getByNetwork(network.getId());
    }

    @Override
    public List<Search> getByNetwork(final Long networkId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkId);
            }
        });
    }

    @Override
    public List<Search> getByPersons(Collection<Long> personId) {
        if (personId.isEmpty()) {
            return new ArrayList<Search>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[personId.size()];
        int n = 0;
        Iterator<Long> it = personId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"person_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Search> getByProjects(Collection<Long> projectId) {
        if (projectId.isEmpty()) {
            return new ArrayList<Search>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[projectId.size()];
        int n = 0;
        Iterator<Long> it = projectId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"project"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }

    @Override
    public List<Search> getByNetworks(Collection<Long> networkId) {
        if (networkId.isEmpty()) {
            return new ArrayList<Search>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkId.size()];
        int n = 0;
        Iterator<Long> it = networkId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

