/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.DocumentNumberPart;
import at.cdes.api.joinDto.DocumentNumberGenJoin;
import at.cdes.impl.dao.DocumentNumberPartDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcDocumentNumberPartDAO;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcDocumentNumberPartDAO
extends AbstractJdbcDocumentNumberPartDAO
implements DocumentNumberPartDAO {
    @Override
    public List<DocumentNumberPart> getDocumentNumberPartsForSubProject(final Long subProjectId) {
        String sql = "SELECT " + JdbcDocumentNumberPartDAO.getSelectClauseForDto() + "FROM ((          document_number_part JOIN project              ON document_number_part.group_id = project.document_number_part_group_id) JOIN sub_project          ON sub_project.project_id = project.id) WHERE sub_project.id = ? ORDER BY document_number_part.position ASC ";
        List documentNumberParts = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentNumberPart>>(){

            public List<DocumentNumberPart> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)subProjectId);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<DocumentNumberPart> ret = new ArrayList<DocumentNumberPart>();
                while (resultSet.next()) {
                    ret.add(JdbcDocumentNumberPartDAO.this.fillDtoFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return documentNumberParts;
    }

    @Override
    public List<DocumentNumberPart> getDocumentNumberPartsForProject(final Long projectId) {
        String sql = "SELECT " + JdbcDocumentNumberPartDAO.getSelectClauseForDto() + "FROM (          document_number_part JOIN project              ON document_number_part.group_id = project.document_number_part_group_id) WHERE project.id = ? ORDER BY document_number_part.position ASC ";
        List documentNumberParts = (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<DocumentNumberPart>>(){

            public List<DocumentNumberPart> perform(PreparedStatement statement) throws Exception {
                JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)projectId);
                ResultSet resultSet = statement.executeQuery();
                ArrayList<DocumentNumberPart> ret = new ArrayList<DocumentNumberPart>();
                while (resultSet.next()) {
                    ret.add(JdbcDocumentNumberPartDAO.this.fillDtoFromResultSet(resultSet));
                }
                return ret;
            }
        });
        return documentNumberParts;
    }

    @Override
    public List<DocumentNumberGenJoin> getGenJoinsByObjectListReleaseId(Long objectListReleaseId) {
        String sql = "SELECT " + JdbcDocumentNumberPartDAO.getDocumentNumberGenJoinSelectClause() + "FROM object_list_release LEFT JOIN object_release                    ON object_release.object_list_release_id = object_list_release.id LEFT JOIN object_type object_type_release   ON object_release.object_type_id = object_type_release.id LEFT JOIN object_planner_release            ON object_planner_release.object_id = object_release.id LEFT JOIN project_participation             ON object_planner_release.planner_id = project_participation.id LEFT JOIN sub_project                       ON object_list_release.sub_project_id = sub_project.id LEFT JOIN sub_project_type                  ON sub_project.sub_project_type_id = sub_project_type.id LEFT JOIN project                           ON sub_project.project_id = project.id LEFT JOIN object_planner                    ON object_planner_release.object_planner_id = object_planner.id LEFT JOIN object                            ON object_planner.object_id = object.id LEFT JOIN object_type                       ON object.object_type_id = object_type.id LEFT JOIN document                          ON     document.object_planner_id = object_planner.id AND document.invalidated = 0 LEFT JOIN document_type                     ON document.document_type_id = document_type.id LEFT JOIN document_type document_type_group ON document_type.document_type_group_id = document_type_group.id WHERE object_list_release.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcDocumentNumberPartDAO::fillDocumentNumberGenJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)objectListReleaseId);
        });
    }

    @Override
    public List<DocumentNumberGenJoin> getGenJoinsByObjectPlannerId(Long object_planner_Id) {
        String sql = "SELECT " + JdbcDocumentNumberPartDAO.getDocumentNumberGenJoinSelectClause() + "FROM object_list_release LEFT JOIN object_release                    ON object_release.object_list_release_id = object_list_release.id LEFT JOIN object_type object_type_release   ON object_release.object_type_id = object_type_release.id LEFT JOIN object_planner_release            ON object_planner_release.object_id = object_release.id LEFT JOIN project_participation             ON object_planner_release.planner_id = project_participation.id LEFT JOIN sub_project                       ON object_list_release.sub_project_id = sub_project.id LEFT JOIN sub_project_type                  ON sub_project.sub_project_type_id = sub_project_type.id LEFT JOIN project                           ON sub_project.project_id = project.id LEFT JOIN object_planner                    ON object_planner_release.object_planner_id = object_planner.id LEFT JOIN object                            ON object_planner.object_id = object.id LEFT JOIN object_type                       ON object.object_type_id = object_type.id LEFT JOIN document                          ON     document.object_planner_id = object_planner.id AND document.invalidated = 0 LEFT JOIN document_type                     ON document.document_type_id = document_type.id LEFT JOIN document_type document_type_group ON document_type.document_type_group_id = document_type_group.id WHERE object_planner.id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcDocumentNumberPartDAO::fillDocumentNumberGenJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)object_planner_Id);
        });
    }

    @Override
    public List<DocumentNumberPart> getByNetworkId(Long networkId) {
        String sql = "SELECT " + JdbcDocumentNumberPartDAO.getSelectClauseForDto() + "FROM document_number_part JOIN document_number_part_group ON document_number_part.group_id = document_number_part_group.id WHERE document_number_part_group.network_id = ? ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)networkId);
        });
    }
}

