/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.NetworkType;
import at.cdes.api.dto.ObjectTypeDefault;
import at.cdes.impl.dao.ObjectTypeDefaultDAO;
import java.io.UnsupportedEncodingException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.clazzes.util.sql.SQLFragment;
import org.clazzes.util.sql.criteria.SQLCondition;
import org.clazzes.util.sql.criteria.SQLConstruct;
import org.clazzes.util.sql.criteria.SQLValue;
import org.clazzes.util.sql.dao.AbstrIdDAO;
import org.clazzes.util.sql.dao.StatementPreparer;
import org.clazzes.util.sql.helper.JDBCHelper;

public class JdbcObjectTypeDefaultDAO
extends AbstrIdDAO<ObjectTypeDefault>
implements ObjectTypeDefaultDAO {
    public JdbcObjectTypeDefaultDAO() {
        super(ObjectTypeDefault.class, "id", "object_type_default", new String[]{"id", "code", "name", "comment", "network_type_id"});
    }

    private static String getStringWithoutException(byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] getBytesWithoutException(String s) {
        try {
            return s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSelectNullClauseForDto() {
        return JdbcObjectTypeDefaultDAO.getSelectNullClauseForDto(null);
    }

    public static String getSelectNullClauseForDto(String columnNamePrefix) {
        return "NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + ",NULL" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + " ";
    }

    public static String getSelectClauseForDto() {
        return JdbcObjectTypeDefaultDAO.getSelectClauseForDto("object_type_default", null);
    }

    public static String getSelectClauseForDto(String entityLocalName) {
        return JdbcObjectTypeDefaultDAO.getSelectClauseForDto(entityLocalName, null);
    }

    public static String getSelectClauseForDto(String entityLocalName, String columnNamePrefix) {
        return entityLocalName + ".id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "id") + "," + entityLocalName + ".code" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "code") + "," + entityLocalName + ".name" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "name") + "," + entityLocalName + ".comment" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "comment") + "," + entityLocalName + ".network_type_id" + (columnNamePrefix == null ? "" : " AS " + columnNamePrefix + "network_type_id") + " ";
    }

    protected ObjectTypeDefault fillDtoFromResultSet(ResultSet rs) throws SQLException {
        int columnIndex = 0;
        ObjectTypeDefault objectTypeDefault = new ObjectTypeDefault();
        objectTypeDefault.setId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        objectTypeDefault.setCode(rs.getString(++columnIndex));
        objectTypeDefault.setName(rs.getString(++columnIndex));
        objectTypeDefault.setComment(rs.getString(++columnIndex));
        objectTypeDefault.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)(++columnIndex)));
        return objectTypeDefault;
    }

    public static ObjectTypeDefault fillObjectTypeDefaultFromResultSet(ResultSet rs, AtomicInteger columnIndex) throws SQLException {
        ObjectTypeDefault objectTypeDefault = new ObjectTypeDefault();
        objectTypeDefault.setId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        objectTypeDefault.setCode(rs.getString(columnIndex.incrementAndGet()));
        objectTypeDefault.setName(rs.getString(columnIndex.incrementAndGet()));
        objectTypeDefault.setComment(rs.getString(columnIndex.incrementAndGet()));
        objectTypeDefault.setNetworkTypeId(JDBCHelper.getLong((ResultSet)rs, (int)columnIndex.incrementAndGet()));
        return objectTypeDefault;
    }

    public static ObjectTypeDefault fillObjectTypeDefaultFromResultSet(ResultSet rs) throws SQLException {
        return JdbcObjectTypeDefaultDAO.fillObjectTypeDefaultFromResultSet(rs, new AtomicInteger(0));
    }

    public static int getNumberOfDtoAttributes() {
        return 5;
    }

    public int update(ObjectTypeDefault dto) {
        if (dto.isOnlyPartialInstance()) {
            throw new UnsupportedOperationException("Instance is partial, i.e. attributes are not set.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.update((Object)dto);
    }

    public int[] updateBatch(Collection<ObjectTypeDefault> dtos) {
        Iterator<ObjectTypeDefault> it = dtos.iterator();
        while (it.hasNext()) {
            if (!it.next().isOnlyPartialInstance()) continue;
            throw new UnsupportedOperationException("Instance is partial, i.e. maybe some of the attributes were not read from the database before.  Please check the attributes clause of a corresponding JoinDto.");
        }
        return super.updateBatch(dtos);
    }

    protected void fillPreparedStatementFromDto(PreparedStatement statement, ObjectTypeDefault objectTypeDefault) throws SQLException {
        JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)objectTypeDefault.getId());
        statement.setString(2, objectTypeDefault.getCode());
        statement.setString(3, objectTypeDefault.getName());
        statement.setString(4, objectTypeDefault.getComment());
        JDBCHelper.setLong((PreparedStatement)statement, (int)5, (Number)objectTypeDefault.getNetworkTypeId());
    }

    @Override
    public List<ObjectTypeDefault> getByNetworkType(NetworkType networkType) {
        return this.getByNetworkType(networkType.getId());
    }

    @Override
    public List<ObjectTypeDefault> getByNetworkType(final Long networkTypeId) {
        SQLCondition cond = SQLCondition.eq((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLValue.INSERT_VALUE);
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
                statement.setLong(1, networkTypeId);
            }
        });
    }

    @Override
    public List<ObjectTypeDefault> getByNetworkTypes(Collection<Long> networkTypeId) {
        if (networkTypeId.isEmpty()) {
            return new ArrayList<ObjectTypeDefault>();
        }
        SQLValue[] foreignEntityValues = new SQLValue[networkTypeId.size()];
        int n = 0;
        Iterator<Long> it = networkTypeId.iterator();
        while (it.hasNext()) {
            foreignEntityValues[n] = this.getSQLValueForId(it.next());
            ++n;
        }
        SQLCondition cond = SQLCondition.in((SQLFragment)SQLValue.tableColumn((String)this.getTableName(), (String)"network_type_id"), (SQLFragment)SQLConstruct.commaParenthesis((SQLFragment[])foreignEntityValues));
        return this.getListWithCondition(cond, new StatementPreparer(){

            public void fillInsertValues(PreparedStatement statement) throws SQLException {
            }
        });
    }
}

