/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.dao.jdbc;

import at.cdes.api.dto.BaseTask;
import at.cdes.api.joinDto.ContextJoin;
import at.cdes.api.joinDto.ReviewTaskDoneJoin;
import at.cdes.api.joinDto.ReviewTaskJoin;
import at.cdes.api.joinDto.TaskJoin;
import at.cdes.api.joinDto.TaskTreeJoin;
import at.cdes.api.task.dto.TaskCountLine;
import at.cdes.api.task.searchModel.TaskSearchModel;
import at.cdes.api.task.voc.TaskDeputyMode;
import at.cdes.api.task.voc.TaskSearchMode;
import at.cdes.api.task.voc.TaskType;
import at.cdes.impl.dao.TaskDAO;
import at.cdes.impl.dao.jdbc.AbstractJdbcBaseTaskDAO;
import at.cdes.impl.dao.unionComponent.TaskJoinComponent;
import at.cdes.impl.util.DateHelper;
import at.cdes.impl.util.QueryHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.clazzes.util.aop.jdbc.JdbcDAOSupport;
import org.clazzes.util.aop.jdbc.JdbcPreparedStatementAction;
import org.clazzes.util.sql.helper.JDBCHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcTaskDAO
extends AbstractJdbcBaseTaskDAO
implements TaskDAO {
    private static final Logger log = LoggerFactory.getLogger(JdbcTaskDAO.class);
    private static String sameParticipationJoins = "     FROM organisation_person decide_organisation_person\n     JOIN project_participant decide_project_participant\n                                        ON  decide_project_participant.inactive_flag = 0\n                                        AND decide_project_participant.organisation_person_id = decide_organisation_person.id\n     JOIN project_participation         ON  project_participation.invalidated = 0\n                                        AND decide_project_participant.participation_id = project_participation.id\n";
    private static String sameProjectJoins = "     FROM organisation_person decide_organisation_person\n     JOIN project_participant decide_project_participant\n                                        ON  decide_project_participant.inactive_flag = 0\n                                        AND decide_project_participant.organisation_person_id = decide_organisation_person.id\n     JOIN project_participation decide_project_participation\n                                        ON  decide_project_participation.invalidated = 0\n                                        AND decide_project_participant.participation_id = decide_project_participation.id\n     JOIN project_participation         ON  project_participation.invalidated = 0\n                                        AND decide_project_participation.project_id = project_participation.project_id\n";
    private static final String TASK_MODE_OWN_WHERE_CLAUSE = "";
    private static final String TASK_MODE_BATCH_WHERE_CLAUSE = "AND (review_task.task_status = 1 OR attached_review_task.task_status = 1) ";

    @Override
    public List<TaskJoin> getLateTaskJoins(final Long projectId) {
        final String sql = "SELECT " + this.getTaskUnionSelectClause(TaskJoinComponent.REVIEW_TASK, "task", "documentVersion", "document", "organisation", "person", "reviewCycleNode", "reviewCycleCell") + "FROM project_participant JOIN project_participation       ON project_participant.participation_id = project_participation.id JOIN project                     ON project_participation.project_id = project.id AND project.access != 0 AND project.access != 3 JOIN document_version_task       ON document_version_task.project_participation_id = project_participation.id JOIN review_task                 ON review_task.task_id = document_version_task.task_id JOIN task                        ON document_version_task.task_id = task.id JOIN document_version            ON document_version_task.document_version_id = document_version.id JOIN document                    ON document_version.document_id = document.id JOIN review_cycle_node_instance  ON document_version.active_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_node           ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id JOIN review_cycle_cell           ON review_cycle_node.review_cycle_cell_id = review_cycle_cell.id JOIN project_participant main_participant         ON    main_participant.participation_id = project_participation.id AND main_participant.main_participant_flag = 1 JOIN organisation_person         ON main_participant.organisation_person_id = organisation_person.id AND organisation_person.retired_flag = 0 JOIN organisation                ON organisation_person.organisation_id = organisation.id JOIN person                      ON organisation_person.person_id = person.id WHERE project_participation.project_id = ? AND task.end_date < ? UNION ALL SELECT " + this.getTaskUnionSelectClause(TaskJoinComponent.ATTACHED_REVIEW_TASK, "task", "documentVersion", "document", "organisation", "person", "reviewCycleNode", "reviewCycleCell") + "FROM project_participant JOIN project_participation       ON project_participant.participation_id = project_participation.id JOIN project                     ON project_participation.project_id = project.id AND project.access != 0 AND project.access != 3 JOIN document_version_task       ON document_version_task.project_participation_id = project_participation.id JOIN attached_review_task        ON attached_review_task.task_id = document_version_task.task_id JOIN task                        ON document_version_task.task_id = task.id JOIN document_version            ON document_version_task.document_version_id = document_version.id JOIN document                    ON document_version.document_id = document.id JOIN review_cycle_node_instance  ON document_version.active_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_node           ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id JOIN review_cycle_cell           ON review_cycle_node.review_cycle_cell_id = review_cycle_cell.id JOIN project_participant main_participant         ON    main_participant.participation_id = project_participation.id AND main_participant.main_participant_flag = 1 JOIN organisation_person         ON main_participant.organisation_person_id = organisation_person.id AND organisation_person.retired_flag = 0 JOIN organisation                ON organisation_person.organisation_id = organisation.id JOIN person                      ON organisation_person.person_id = person.id WHERE project_participation.project_id = ? AND task.end_date < ? UNION ALL SELECT " + this.getTaskUnionSelectClause(TaskJoinComponent.SELECT_CELL_CONNECTION_TASK, "task", "documentVersion", "document", "organisation", "person", "reviewCycleNode", "reviewCycleCell") + "FROM project_participant JOIN project_participation       ON project_participant.participation_id = project_participation.id JOIN project                     ON project_participation.project_id = project.id AND project.access != 0 AND project.access != 3 JOIN document_version_task       ON document_version_task.project_participation_id = project_participation.id JOIN select_cell_connection_task ON select_cell_connection_task.task_id = document_version_task.task_id JOIN task                        ON document_version_task.task_id = task.id JOIN document_version            ON document_version_task.document_version_id = document_version.id JOIN document                    ON document_version.document_id = document.id JOIN review_cycle_node_instance  ON document_version.active_node_instance_id = review_cycle_node_instance.id JOIN review_cycle_node           ON review_cycle_node_instance.review_cycle_node_id = review_cycle_node.id JOIN review_cycle_cell           ON review_cycle_node.review_cycle_cell_id = review_cycle_cell.id JOIN project_participant main_participant         ON    main_participant.participation_id = project_participation.id AND main_participant.main_participant_flag = 1 JOIN organisation_person         ON main_participant.organisation_person_id = organisation_person.id AND organisation_person.retired_flag = 0 JOIN organisation                ON organisation_person.organisation_id = organisation.id JOIN person                      ON organisation_person.person_id = person.id WHERE project_participation.project_id = ? AND task.end_date < ? UNION ALL SELECT " + this.getTaskUnionSelectClause(TaskJoinComponent.REVIEW_CYCLE_ENTRY_TASK, "task", "document", "organisation", "person") + "FROM project_participant JOIN project_participation       ON project_participant.participation_id = project_participation.id JOIN project                     ON project_participation.project_id = project.id  AND project.access != 0 AND project.access != 3 JOIN document_task               ON document_task.project_participation_id = project_participation.id JOIN review_cycle_entry_task     ON review_cycle_entry_task.task_id = document_task.task_id JOIN task                        ON document_task.task_id = task.id JOIN document                    ON document_task.document_id = document.id JOIN project_participant main_participant         ON    main_participant.participation_id = project_participation.id AND main_participant.main_participant_flag = 1 JOIN organisation_person         ON main_participant.organisation_person_id = organisation_person.id AND organisation_person.retired_flag = 0 JOIN organisation                ON organisation_person.organisation_id = organisation.id JOIN person                      ON organisation_person.person_id = person.id WHERE project_participation.project_id = ? AND task.end_date < ? ";
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<TaskJoin>>(){

            public List<TaskJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                Double now = DateHelper.getCurrentUtcSeconds();
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)now);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)now);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)now);
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)projectId);
                JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)now);
                QueryHelper.checkNumberOfWildcards(sql, currIndex);
                if (log.isDebugEnabled()) {
                    log.debug("Will query sql for projectId [" + projectId + "]: " + sql);
                }
                ArrayList<TaskJoin> results = new ArrayList<TaskJoin>();
                ResultSet rs = statement.executeQuery();
                while (rs.next()) {
                    TaskJoin joinDto = AbstractJdbcBaseTaskDAO.fillTaskJoinFromResultSet(rs);
                    currIndex = AbstractJdbcBaseTaskDAO.getNumberOfTaskJoinAttributes() + 1;
                    joinDto.setUnionClause(JDBCHelper.getInt((ResultSet)rs, (int)currIndex++));
                    results.add(joinDto);
                }
                return results;
            }
        });
    }

    private String getTaskUnionSelectClause(TaskJoinComponent component, String ... localNames) {
        String selectClauseForUnion = this.getSelectClauseForTaskJoinUnion(localNames);
        return (selectClauseForUnion.length() > 0 ? selectClauseForUnion + ", " : TASK_MODE_OWN_WHERE_CLAUSE) + component.getValue() + " ";
    }

    private String getReviewTaskSql(String selectClause, String reviewTask, String reviewCycleEntryTask, String originalDocumentTask, String plotOrderAcceptanceTask, String reviewCyclePlotTask, String attachedReviewTask, String selectCellConnectionTask, String additionalStartJoins, String additionalJoins, String additionalConditions, ProjectSearchMode projectSearchMode) {
        String prefix = QueryHelper.getLargeQueryPrefix((JdbcDAOSupport)this);
        return prefix + "SELECT " + selectClause + "\n" + (projectSearchMode == ProjectSearchMode.SAME_PARTICIPATION ? sameParticipationJoins : sameProjectJoins) + additionalStartJoins + "     JOIN (SELECT document_task.task_id, document_task.project_participation_id, document_task.object_planner_id, document_task.document_id\nFROM document_task\nUNION ALL\nSELECT document_version_task.task_id, document_version_task.project_participation_id, document_version_task.object_planner_id, document_version.document_id\nFROM document_version_task JOIN document_version ON document_version_task.document_version_id = document_version.id) as t\nON t.project_participation_id = project_participation.id\n     JOIN task                          ON task.id = t.task_id\nLEFT JOIN document_task                 ON document_task.task_id = t.task_id\nLEFT JOIN document_version_task         ON document_version_task.task_id = t.task_id\n     JOIN project                       ON project_participation.project_id = project.id\n     JOIN network                       ON project.network_id = network.id\nLEFT JOIN project_participant           ON     project_participant.participation_id = project_participation.id\nAND project_participant.inactive_flag = 0\nLEFT JOIN organisation_person           ON project_participant.organisation_person_id = organisation_person.id\nAND organisation_person.retired_flag = 0\nJOIN certificate          \t\t\t\tON organisation_person.id = certificate.organisation_person_id\nAND certificate.may_sign = 1 AND certificate.may_login = 1\nLEFT JOIN organisation                  ON organisation.id = organisation_person.organisation_id\nLEFT JOIN person                        ON organisation_person.person_id = person.id\nLEFT JOIN object_planner                ON object_planner.id = t.object_planner_id\nLEFT JOIN object                        ON object_planner.object_id = object.id\nLEFT JOIN object_list                   ON object.object_list_id = object_list.id\nLEFT JOIN object_list_release           ON object_list_release.object_list_id = object_list.id AND object_list_release.version = (object_list.version - 1)\nLEFT JOIN object_release                ON object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id\nLEFT JOIN sub_project                   ON object_list.sub_project_id = sub_project.id\nLEFT JOIN document_version              ON document_version_task.document_version_id = document_version.id\nLEFT JOIN document                      ON document.id = t.document_id\nLEFT JOIN document_list                 ON document_list.id = document.document_list_id\nLEFT JOIN document_list_release         ON document_list_release.document_list_id = document_list.id\n                                       AND document_list_release.version = (document_list.version - 1)\nLEFT JOIN document_release              ON document_release.document_list_id = document_list_release.id\n                                       AND document_release.document_id = document.id\nLEFT JOIN " + reviewCycleEntryTask + "      ON " + reviewCycleEntryTask + ".task_id = task.id\nLEFT JOIN " + originalDocumentTask + "      ON " + originalDocumentTask + ".task_id = task.id\nLEFT JOIN " + plotOrderAcceptanceTask + "   ON " + plotOrderAcceptanceTask + ".task_id = task.id\nLEFT JOIN " + reviewCyclePlotTask + "       ON " + reviewCyclePlotTask + ".task_id = task.id\nLEFT JOIN " + reviewTask + "                ON " + reviewTask + ".task_id = task.id\nLEFT JOIN " + attachedReviewTask + "        ON " + attachedReviewTask + ".task_id = task.id\nLEFT JOIN " + selectCellConnectionTask + "  ON " + selectCellConnectionTask + ".task_id = task.id\n" + additionalJoins + "WHERE decide_organisation_person.person_id = ?\nAND decide_organisation_person.retired_flag = 0\n AND ((" + reviewCyclePlotTask + ".task_id IS NOT NULL)\n     OR (" + plotOrderAcceptanceTask + ".task_id IS NOT NULL)\n     OR object.read_only = 0)\nAND sub_project.read_only = 0\nAND project.access = 2\n" + additionalConditions;
    }

    private String getReviewTaskDoneSql() {
        String prefix = QueryHelper.getLargeQueryPrefix((JdbcDAOSupport)this);
        return prefix + "SELECT " + JdbcTaskDAO.getReviewTaskDoneJoinSelectClause() + "\n     FROM organisation_person decide_organisation_person\n     JOIN project_participant decide_project_participant\n                                        ON  decide_project_participant.inactive_flag = 0\n                                        AND decide_project_participant.organisation_person_id = decide_organisation_person.id\n     JOIN project_participation         ON  project_participation.invalidated = 0\n                                        AND decide_project_participant.participation_id = project_participation.id\n     JOIN (SELECT document_task.task_id, document_task.project_participation_id, document_task.object_planner_id, document_task.document_id\nFROM document_task\nUNION ALL\nSELECT document_version_task.task_id, document_version_task.project_participation_id, document_version_task.object_planner_id, document_version.document_id\nFROM document_version_task JOIN document_version ON document_version_task.document_version_id = document_version.id) as t\nON t.project_participation_id = project_participation.id\n     JOIN task                          ON task.id = t.task_id\nLEFT JOIN document_task                 ON document_task.task_id = t.task_id\nLEFT JOIN document_version_task         ON document_version_task.task_id = t.task_id\n     JOIN project                       ON project_participation.project_id = project.id\n     JOIN network                       ON project.network_id = network.id\nLEFT JOIN project_participant           ON     project_participant.participation_id = project_participation.id\nAND project_participant.inactive_flag = 0\nLEFT JOIN organisation_person           ON project_participant.organisation_person_id = organisation_person.id\nLEFT JOIN organisation                  ON organisation.id = organisation_person.organisation_id\nLEFT JOIN person                        ON organisation_person.person_id = person.id\nLEFT JOIN object_planner                ON object_planner.id = t.object_planner_id\nLEFT JOIN object                        ON object_planner.object_id = object.id\nLEFT JOIN object_list                   ON object.object_list_id = object_list.id\nLEFT JOIN object_list_release           ON object_list_release.object_list_id = object_list.id AND object_list_release.version = (object_list.version - 1)\nLEFT JOIN object_release                ON object_release.object_list_release_id = object_list_release.id AND object_release.object_id = object.id\nLEFT JOIN sub_project                   ON object_list.sub_project_id = sub_project.id\nLEFT JOIN document_version              ON document_version_task.document_version_id = document_version.id\nLEFT JOIN document                      ON document.id = t.document_id\nLEFT JOIN document_list                 ON document_list.id = document.document_list_id\nLEFT JOIN document_list_release         ON document_list_release.document_list_id = document_list.id\n                                       AND document_list_release.version = (document_list.version - 1)\nLEFT JOIN document_release              ON document_release.document_list_id = document_list_release.id\n                                       AND document_release.document_id = document.id\nLEFT JOIN (\nSELECT review_cycle_entry_task_done.task_id, review_cycle_entry_task_done.done_date,\nreview_cycle_entry_task_done.review_cycle_entry_result_id,\nNULL as review_cycle_cell_connection_result_id,\n0 as is_plot_task, NULL as order_step_id, NULL as plot_order_id\nFROM review_cycle_entry_task_done\nUNION ALL\nSELECT original_document_task_done.task_id, original_document_task_done.done_date,\nNULL as review_cycle_entry_result_id, NULL as review_cycle_cell_connection_result_id,\n0 as is_plot_task, NULL as order_step_id, NULL as plot_order_id\nFROM original_document_task_done\nUNION ALL\nSELECT plot_order_acceptance_task_done.task_id, plot_order_acceptance_task_done.done_date,\nNULL as review_cycle_entry_result_id, NULL as review_cycle_cell_connection_result_id,\n1 as is_plot_task, plot_order_acceptance_task_done.order_step_id, plot_order_acceptance_task_done.order_id as plot_order_id\nFROM plot_order_acceptance_task_done\nUNION ALL\nSELECT review_cycle_plott_task_done.task_id, review_cycle_plott_task_done.done_date,\nNULL as review_cycle_entry_result_id, NULL as review_cycle_cell_connection_result_id,\n1 as is_plot_task, review_cycle_plott_task_done.order_step_id, review_cycle_plott_task_done.order_id as plot_order_id\nFROM review_cycle_plott_task_done\nUNION ALL\nSELECT review_task_done.task_id, review_task_done.done_date,\nNULL as review_cycle_entry_result_id, NULL as review_cycle_cell_connection_result_id,\n0 as is_plot_task, NULL as order_step_id, NULL as plot_order_id\nFROM review_task_done\nUNION ALL\nSELECT attached_review_task_done.task_id, attached_review_task_done.done_date,\nNULL as review_cycle_entry_result_id, NULL as review_cycle_cell_connection_result_id,\n0 as is_plot_task, NULL as order_step_id, NULL as plot_order_id\nFROM attached_review_task_done\nUNION ALL\nSELECT select_cell_connection_task_done.task_id, select_cell_connection_task_done.done_date,\nNULL as review_cycle_entry_result_id,\nselect_cell_connection_task_done.review_cycle_cell_connection_result_id,\n0 as is_plot_task, NULL as order_step_id, NULL as plot_order_id\nFROM select_cell_connection_task_done) as sub_task\nON sub_task.task_id = t.task_id\nLEFT JOIN plott_order plot_order        ON sub_task.plot_order_id = plot_order.id\nLEFT JOIN review_cycle_entry_task_done  ON review_cycle_entry_task_done.task_id = t.task_id\nLEFT JOIN original_document_task_done   ON original_document_task_done.task_id = t.task_id\nLEFT JOIN plot_order_acceptance_task_done ON plot_order_acceptance_task_done.task_id = t.task_id\nLEFT JOIN review_cycle_plott_task_done  ON review_cycle_plott_task_done.task_id = t.task_id\nLEFT JOIN review_task_done              ON review_task_done.task_id = t.task_id\nLEFT JOIN attached_review_task_done     ON attached_review_task_done.task_id = t.task_id\nLEFT JOIN select_cell_connection_task_done ON select_cell_connection_task_done.task_id = t.task_id\nLEFT JOIN review_task_done_results_map  ON review_task_done_results_map.review_task_done_id = sub_task.task_id\nLEFT JOIN review_cycle_position_result  ON review_cycle_position_result.id = review_task_done_results_map.review_cycle_position_result_id\nLEFT JOIN project_participant position_result_participant ON review_cycle_position_result.project_participant_id = position_result_participant.id LEFT JOIN organisation_person position_result_org_person ON position_result_participant.organisation_person_id = position_result_org_person.id LEFT JOIN organisation position_result_organisation ON position_result_org_person.organisation_id = position_result_organisation.id LEFT JOIN person position_result_person ON position_result_org_person.person_id = position_result_person.id LEFT JOIN review_cycle_result_option    ON review_cycle_result_option.id = review_cycle_position_result.review_cycle_result_option_id\nLEFT JOIN review_cycle_entry_result     ON review_cycle_entry_result.id = sub_task.review_cycle_entry_result_id\nLEFT JOIN document_version review_cycle_entry_result_document_version\n                                        ON review_cycle_entry_result_document_version.id = review_cycle_entry_result.document_version_id\nLEFT JOIN realm                         ON realm.id = review_cycle_position_result.realm_id\nLEFT JOIN review_cycle_cell_connection_result\n                                        ON review_cycle_cell_connection_result.id = sub_task.review_cycle_cell_connection_result_id\nLEFT JOIN order_step                    ON sub_task.order_step_id = order_step.id\nLEFT JOIN signature                     ON (   review_cycle_position_result.signature_id = signature.id\n     OR review_cycle_cell_connection_result.signature_id = signature.id\n     OR review_cycle_entry_result.signature_id = signature.id\n     OR order_step.signature_id = signature.id)\nLEFT JOIN project_participant pp_res ON pp_res.id = signature.project_participant_id\nLEFT JOIN organisation_person pp_res_orgp ON pp_res.organisation_person_id = pp_res_orgp.id\nLEFT JOIN person signer_person          ON pp_res_orgp.person_id = signer_person.id\nLEFT JOIN organisation signer_organisation ON pp_res_orgp.organisation_id = signer_organisation.id\nWHERE decide_organisation_person.person_id = ?\nAND (sub_task.is_plot_task = 1 OR object.read_only = 0)\nAND sub_project.read_only = 0\nAND project.access = 2\n";
    }

    private static String taskModeLateWhereClause(boolean decide) {
        return "AND task.end_date <= CURRENT_TIMESTAMP AND project.access = 2 AND EXISTS (SELECT *\nFROM cdes_role\nJOIN role_type ON role_type.id = cdes_role.type_id\nJOIN role_action_rule ON role_action_rule.cdes_role_id = cdes_role.id\nJOIN action_rule ON action_rule.id = role_action_rule.action_rule_id\nJOIN action ON action.id = action_rule.action_id\nWHERE action.name IN ('monitorLateReviews', 'overrideLateReviews')\n  AND cdes_role.id = " + (decide ? "decide_" : TASK_MODE_OWN_WHERE_CLAUSE) + "project_participation.role_id\n  AND role_type.type = 2) \n";
    }

    @Override
    public List<ReviewTaskJoin> getReviewTaskJoins(final Long personId, TaskSearchModel searchModel) {
        final Long organisationPersonId = searchModel.getOrganisationPersonId();
        final TaskSearchMode mode = searchModel.getSearchMode();
        TaskDeputyMode deputyMode = searchModel.getDeputyMode();
        final Double fromTs = searchModel.getFromTs();
        final Double toTs = searchModel.getToTs();
        Double now = (double)Instant.now().toEpochMilli() / 1000.0;
        String sql = this.getReviewTaskSql(JdbcTaskDAO.getReviewTaskJoinSelectClause(), "review_task", "review_cycle_entry_task", "original_document_task", "plot_order_acceptance_task", "review_cycle_plott_task", "attached_review_task", "select_cell_connection_task", TASK_MODE_OWN_WHERE_CLAUSE, "LEFT JOIN plott_order plot_order        ON    plot_order_acceptance_task.order_id = plot_order.id OR review_cycle_plott_task.order_id = plot_order.id LEFT JOIN review_task_position_map      ON review_task_position_map.review_task_id = review_task.task_id\nLEFT JOIN review_cycle_node_position_released\n                                        ON review_cycle_node_position_released.id = review_task_position_map.review_cycle_node_position_released_id\nLEFT JOIN review_cycle_node_instance    ON review_cycle_node_instance.id = document_version.active_node_instance_id\n\nLEFT JOIN project_participant review_cycle_participant\n                                        ON review_cycle_participant.participation_id = review_cycle_node_position_released.project_participation_id\n\nLEFT JOIN review_cycle_position_result  ON review_cycle_position_result.document_version_id = document_version.id\n                                        AND review_cycle_position_result.review_cycle_node_id = review_cycle_node_instance.review_cycle_node_id\n                                        AND review_cycle_position_result.realm_id = review_cycle_node_position_released.realm_id\n                                        AND review_cycle_position_result.comment_reference_id IS NULL\n                                        AND review_cycle_position_result.signature_id IS NULL\n                                        AND (review_cycle_position_result.project_participant_id = review_cycle_participant.id\n                                           OR review_cycle_position_result.project_participant_id = decide_project_participant.id)\nLEFT JOIN project_participant position_result_participant ON review_cycle_position_result.project_participant_id = position_result_participant.id LEFT JOIN organisation_person position_result_org_person ON position_result_participant.organisation_person_id = position_result_org_person.id LEFT JOIN organisation position_result_organisation ON position_result_org_person.organisation_id = position_result_organisation.id LEFT JOIN person position_result_person ON position_result_org_person.person_id = position_result_person.id \nLEFT JOIN realm                         ON realm.id = review_cycle_node_position_released.realm_id\nLEFT JOIN review_cycle_result_option    ON review_cycle_result_option.id = review_cycle_position_result.review_cycle_result_option_id ", "AND task.done = 0\n", mode == TaskSearchMode.LATE ? ProjectSearchMode.SAME_PROJECT : ProjectSearchMode.SAME_PARTICIPATION);
        if (deputyMode == TaskDeputyMode.MAIN_PARTICIPANT) {
            sql = sql + "AND " + (mode != TaskSearchMode.LATE ? "decide_" : TASK_MODE_OWN_WHERE_CLAUSE) + "project_participant.main_participant_flag = 1\n";
        } else if (deputyMode == TaskDeputyMode.DEPUTY) {
            sql = sql + "AND " + (mode != TaskSearchMode.LATE ? "decide_" : TASK_MODE_OWN_WHERE_CLAUSE) + "project_participant.main_participant_flag = 0\n";
        }
        if (organisationPersonId != null) {
            sql = sql + "AND decide_organisation_person.id = ?\n";
        }
        if (mode == TaskSearchMode.OWN) {
            sql = sql + "\n";
        } else if (mode == TaskSearchMode.BATCH) {
            sql = sql + "AND (review_task.task_status = 1 OR attached_review_task.task_status = 1) \n";
        } else {
            if (mode == TaskSearchMode.DONE) {
                throw new RuntimeException("Use getReviewTaskDoneJoins instead.");
            }
            if (mode == TaskSearchMode.LATE) {
                sql = sql + JdbcTaskDAO.taskModeLateWhereClause(true);
            }
        }
        if (mode == TaskSearchMode.OWN || mode == TaskSearchMode.BATCH || mode == TaskSearchMode.LATE) {
            if (fromTs != null) {
                sql = sql + "AND task.end_date >= ?\n";
            }
            if (toTs != null) {
                sql = sql + "AND task.end_date <= ?\n";
            }
        }
        final String fsql = sql;
        return (List)this.performWithPreparedStatement(sql, (JdbcPreparedStatementAction)new JdbcPreparedStatementAction<List<ReviewTaskJoin>>(){

            public List<ReviewTaskJoin> perform(PreparedStatement statement) throws Exception {
                int currIndex = 1;
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
                if (organisationPersonId != null) {
                    JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
                }
                if (mode == TaskSearchMode.OWN || mode == TaskSearchMode.BATCH || mode == TaskSearchMode.LATE) {
                    if (fromTs != null) {
                        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)fromTs);
                    }
                    if (toTs != null) {
                        JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)toTs);
                    }
                }
                QueryHelper.checkNumberOfWildcards(fsql, currIndex);
                if (log.isDebugEnabled()) {
                    log.debug("Will query sql for personId [" + personId + "]: " + fsql);
                }
                long beforeMillis = System.currentTimeMillis();
                ArrayList<ReviewTaskJoin> results = new ArrayList<ReviewTaskJoin>();
                ResultSet rs = statement.executeQuery();
                long afterMillis = System.currentTimeMillis();
                log.info("Duration for query: [" + new Double(afterMillis - beforeMillis) / 1000.0 + "s]");
                HashMap<String, ReviewTaskJoin> keyToJoin = new HashMap<String, ReviewTaskJoin>();
                while (rs.next()) {
                    ReviewTaskJoin joinDto = AbstractJdbcBaseTaskDAO.fillReviewTaskJoinFromResultSet(rs);
                    Long taskId = joinDto.getBaseTaskId();
                    Long participantId = joinDto.getProjectParticipantId();
                    String key = taskId + " " + (participantId != null ? participantId.toString() : "null");
                    keyToJoin.put(key, joinDto);
                }
                results.addAll(keyToJoin.values());
                return results;
            }
        });
    }

    @Override
    public List<ReviewTaskDoneJoin> getReviewTaskDoneJoins(Long personId, TaskSearchModel searchModel) {
        if (searchModel.getSearchMode() != TaskSearchMode.DONE) {
            throw new RuntimeException("getReviewTaskDoneJoins can only be used for TaskSearchMode DONE");
        }
        Long organisationPersonId = searchModel.getOrganisationPersonId();
        TaskDeputyMode deputyMode = searchModel.getDeputyMode();
        Double fromTs = searchModel.getFromTs();
        Double toTs = searchModel.getToTs();
        String sql = this.getReviewTaskDoneSql();
        if (deputyMode == TaskDeputyMode.MAIN_PARTICIPANT) {
            sql = sql + "AND pp_res_orgp.person_id = ?\n";
        } else if (deputyMode == TaskDeputyMode.DEPUTY) {
            sql = sql + "AND pp_res_orgp.person_id != ?\n";
        }
        if (organisationPersonId != null) {
            sql = sql + "AND decide_organisation_person.id = ?\n";
        }
        String fsql = sql = sql + "AND sub_task.done_date BETWEEN ? AND ?\n";
        return (List)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
            if (deputyMode != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)personId);
            }
            if (organisationPersonId != null) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)organisationPersonId);
            }
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)fromTs);
            JDBCHelper.setUtcSeconds((PreparedStatement)statement, (int)currIndex++, (Double)toTs);
            QueryHelper.checkNumberOfWildcards(fsql, currIndex);
            if (log.isDebugEnabled()) {
                log.debug("Will query sql for personId [" + personId + "]: " + fsql);
            }
            long beforeMillis = System.currentTimeMillis();
            ArrayList results = new ArrayList();
            ResultSet rs = statement.executeQuery();
            long afterMillis = System.currentTimeMillis();
            log.info("Duration for query: [" + new Double(afterMillis - beforeMillis) / 1000.0 + "s]");
            HashMap<String, ReviewTaskDoneJoin> keyToJoin = new HashMap<String, ReviewTaskDoneJoin>();
            while (rs.next()) {
                ReviewTaskDoneJoin joinDto = JdbcTaskDAO.fillReviewTaskDoneJoinFromResultSet(rs);
                Long taskId = joinDto.getBaseTaskId();
                Long participantId = joinDto.getProjectParticipantId();
                String key = taskId + " " + (participantId != null ? participantId.toString() : "null");
                keyToJoin.put(key, joinDto);
            }
            results.addAll(keyToJoin.values());
            return results;
        });
    }

    @Override
    public ContextJoin getContext(Long taskId) {
        String sql = "SELECT " + this.getContextJoinSelectClause() + "\n     FROM task\nLEFT JOIN document_version_task ON document_version_task.task_id = task.id\nLEFT JOIN document_task         ON document_task.task_id = task.id\n     JOIN object_planner        ON (object_planner.id = document_version_task.object_planner_id OR ((document_version_task.task_id IS NULL) AND object_planner.id = document_task.object_planner_id))\n     JOIN object                ON object.id = object_planner.object_id\n     JOIN object_list           ON object_list.id = object.object_list_id\n     JOIN sub_project           ON sub_project.id = object_list.sub_project_id\n\t\tJOIN sub_project_type      ON sub_project.sub_project_type_id = sub_project_type.id\n     JOIN project               ON project.id = sub_project.project_id\n     JOIN localisation          ON localisation.id = project.localisation_id\n     JOIN countries project_country ON project_country.id = localisation.country_id\n     JOIN network               ON project.network_id = network.id\nWHERE task.id = ?\n";
        return (ContextJoin)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)taskId);
            ResultSet rs = statement.executeQuery();
            if (rs.next()) {
                return JdbcTaskDAO.fillContextJoinFromResultSet(rs);
            }
            return null;
        });
    }

    @Override
    public void deleteNodeTasks(Long documentVersionTaskId) {
        String sql = "DELETE FROM task\nWHERE task.id IN (SELECT COALESCE(\n                    next_review.task_id,\n                    next_review_done.task_id,\n                    next_attached_review.task_id,\n                    next_attached_review_done.task_id,\n                    next_select_cell_connection.task_id,\n                    next_select_cell_connection_done.task_id)\n     FROM document_version_task curr\nLEFT JOIN review_task curr_review                                           ON curr_review.task_id = curr.task_id\nLEFT JOIN review_task_done curr_review_done                                 ON curr_review_done.task_id = curr.task_id\nLEFT JOIN attached_review_task curr_attached_review                         ON curr_attached_review.task_id = curr.task_id\nLEFT JOIN attached_review_task_done curr_attached_review_done               ON curr_attached_review_done.task_id = curr.task_id\nLEFT JOIN select_cell_connection_task_done curr_select_cell_connection_done ON curr_select_cell_connection_done.task_id = curr.task_id\nLEFT JOIN select_cell_connection_task curr_select_cell_connection           ON curr_select_cell_connection.task_id = curr.task_id\n     JOIN review_cycle_node_instance                                        ON review_cycle_node_instance.id = COALESCE(\n                                        curr_review.review_cycle_node_instance_id,\n                                        curr_review_done.review_cycle_node_instance_id,\n                                        curr_attached_review.review_cycle_node_instance_id,\n                                        curr_attached_review_done.review_cycle_node_instance_id,\n                                        curr_select_cell_connection.review_cycle_node_instance_id,\n                                        curr_select_cell_connection_done.review_cycle_node_instance_id)\n     JOIN document_version_task next                                        ON next.document_version_id = curr.document_version_id\nLEFT JOIN review_task next_review                                           ON next_review.review_cycle_node_instance_id = review_cycle_node_instance.id\n                                                                           AND next_review.task_id = next.task_id\nLEFT JOIN review_task_done next_review_done                                 ON next_review_done.review_cycle_node_instance_id = review_cycle_node_instance.id\n                                                                           AND next_review_done.task_id = next.task_id\nLEFT JOIN attached_review_task next_attached_review                         ON next_attached_review.review_cycle_node_instance_id = review_cycle_node_instance.id\n                                                                           AND next_attached_review.task_id = next.task_id\nLEFT JOIN attached_review_task_done next_attached_review_done               ON next_attached_review_done.review_cycle_node_instance_id = review_cycle_node_instance.id\n                                                                           AND next_attached_review_done.task_id = next.task_id\nLEFT JOIN select_cell_connection_task_done next_select_cell_connection_done ON next_select_cell_connection_done.review_cycle_node_instance_id = review_cycle_node_instance.id\n                                                                           AND next_select_cell_connection_done.task_id = next.task_id\nLEFT JOIN select_cell_connection_task next_select_cell_connection           ON next_select_cell_connection.review_cycle_node_instance_id = review_cycle_node_instance.id\n                                                                           AND next_select_cell_connection.task_id = next.task_id\nWHERE curr.task_id = ?\n)";
        this.performWithPreparedStatement(sql, statement -> {
            JDBCHelper.setLong((PreparedStatement)statement, (int)1, (Number)documentVersionTaskId);
            statement.execute();
            return null;
        });
    }

    private Collection<Long> getTaskIdsBySubProject(Long subProjectId, String secondLevelTaskTable, String thirdLevelTaskTable) {
        String sql = "SELECT " + secondLevelTaskTable + ".task_id FROM " + secondLevelTaskTable + " JOIN " + thirdLevelTaskTable + " ON " + thirdLevelTaskTable + ".task_id = " + secondLevelTaskTable + ".task_id JOIN object_planner           ON " + secondLevelTaskTable + ".object_planner_id = object_planner.id JOIN object                   ON object_planner.object_id = object.id JOIN object_list              ON object.object_list_id = object_list.id WHERE object_list.sub_project_id = ? ";
        return (Collection)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
            ResultSet rs = statement.executeQuery();
            HashSet<Long> taskIds = new HashSet<Long>();
            while (rs.next()) {
                taskIds.add(JDBCHelper.getLong((ResultSet)rs, (int)1));
            }
            return taskIds;
        });
    }

    @Override
    public Collection<Long> getReviewCycleEntryTaskIdsBySubProject(Long subProjectId) {
        return this.getTaskIdsBySubProject(subProjectId, "document_task", "review_cycle_entry_task");
    }

    @Override
    public Collection<Long> getOriginalDocumentTaskIdsBySubProject(Long subProjectId) {
        return this.getTaskIdsBySubProject(subProjectId, "document_version_task", "original_document_task");
    }

    @Override
    public Collection<Long> getReviewCyclePlotTaskIdsBySubProject(Long subProjectId) {
        return this.getTaskIdsBySubProject(subProjectId, "document_version_task", "review_cycle_plott_task");
    }

    @Override
    public Collection<Long> getReviewTaskIdsBySubProject(Long subProjectId) {
        return this.getTaskIdsBySubProject(subProjectId, "document_version_task", "review_task");
    }

    @Override
    public Collection<Long> getAttachedReviewTaskIdsBySubProject(Long subProjectId) {
        return this.getTaskIdsBySubProject(subProjectId, "document_version_task", "attached_review_task");
    }

    @Override
    public Collection<Long> getSelectCellConnectionTaskIdsBySubProject(Long subProjectId) {
        return this.getTaskIdsBySubProject(subProjectId, "document_version_task", "select_cell_connection_task");
    }

    @Override
    public Collection<Long> getInvalidatePlotOrderAcceptanceTaskIdsBySubProject(Long subProjectId) {
        String sql = "SELECT document_version_task.task_id FROM document_version_task JOIN plot_order_acceptance_task ON document_version_task.task_id = plot_order_acceptance_task.task_id JOIN object_planner           ON document_version_task.object_planner_id = object_planner.id JOIN object                   ON object_planner.object_id = object.id JOIN object_list              ON object.object_list_id = object_list.id JOIN plott_order              ON plot_order_acceptance_task.order_id = plott_order.id WHERE object_list.sub_project_id = ? AND NOT EXISTS (SELECT 1 FROM plott_order_item JOIN document_version  ON plott_order_item.document_version_id = document_version.id JOIN document          ON document_version.document_id = document.id JOIN document_list     ON document.document_list_id = document_list.id WHERE document_list.sub_project_id != ?) ";
        return (Collection)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
            ResultSet rs = statement.executeQuery();
            HashSet<Long> taskIds = new HashSet<Long>();
            while (rs.next()) {
                taskIds.add(JDBCHelper.getLong((ResultSet)rs, (int)1));
            }
            return taskIds;
        });
    }

    @Override
    public List<BaseTask> getPlotOrderAcceptanceTasksToMarkDone(Long plotOrderId) {
        String sql = "SELECT " + JdbcTaskDAO.getSelectClauseForDto() + "FROM plott_order plot_order JOIN plot_order_acceptance_task ON plot_order_acceptance_task.order_id = plot_order.id JOIN document_version_task      ON document_version_task.task_id = plot_order_acceptance_task.task_id JOIN task                       ON document_version_task.task_id = task.id WHERE plot_order.id = ? AND NOT EXISTS (SELECT 1 FROM plott_order_item plot_order_item JOIN order_step ON order_step.order_item_id = plot_order_item.id WHERE plot_order_item.order_contract_id = plot_order.id AND order_step.signature_id IS NULL) ";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, this::fillDtoFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)plotOrderId);
        });
    }

    @Override
    public TaskType getTaskType(Long taskId) {
        String sql = "SELECT ? FROM task JOIN attached_review_task ON attached_review_task.task_id = task.id WHERE task.id = ? UNION ALL SELECT ? FROM task JOIN original_document_task ON original_document_task.task_id = task.id WHERE task.id = ? UNION ALL SELECT ? FROM task JOIN plot_order_acceptance_task ON plot_order_acceptance_task.task_id = task.id WHERE task.id = ? UNION ALL SELECT ? FROM task JOIN review_cycle_entry_task ON review_cycle_entry_task.task_id = task.id WHERE task.id = ? UNION ALL SELECT ? FROM task JOIN review_cycle_plott_task ON review_cycle_plott_task.task_id = task.id WHERE task.id = ? UNION ALL SELECT ? FROM task JOIN review_task ON review_task.task_id = task.id WHERE task.id = ? UNION ALL SELECT ? FROM task JOIN select_cell_connection_task ON select_cell_connection_task.task_id = task.id WHERE task.id = ? ";
        return (TaskType)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            statement.setString(currIndex++, TaskType.ATTACHED_REVIEW_TASK.getValue());
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)taskId);
            statement.setString(currIndex++, TaskType.ORIGINAL_DOCUMENT_TASK.getValue());
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)taskId);
            statement.setString(currIndex++, TaskType.PLOT_ORDER_ACCEPTANCE_TASK.getValue());
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)taskId);
            statement.setString(currIndex++, TaskType.REVIEW_CYCLE_ENTRY_TASK.getValue());
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)taskId);
            statement.setString(currIndex++, TaskType.REVIEW_CYCLE_PLOT_TASK.getValue());
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)taskId);
            statement.setString(currIndex++, TaskType.REVIEW_TASK.getValue());
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)taskId);
            statement.setString(currIndex++, TaskType.SELECT_CELL_CONNECTION_TASK.getValue());
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)taskId);
            ResultSet rs = statement.executeQuery();
            TaskType taskType = null;
            while (rs.next()) {
                if (taskType == null) {
                    taskType = TaskType.getByValue((String)rs.getString(1));
                    continue;
                }
                throw new RuntimeException("Found multiple task types for taskId [" + taskId + "]; one of them is [" + taskType + "], this is strange, please inspect.");
            }
            return taskType;
        });
    }

    private String getTaskCountsFromPrefix(boolean late, boolean done) {
        String fromPrefix = "FROM (SELECT 1 as e FROM organisation_person JOIN project_participant     ON project_participant.organisation_person_id = organisation_person.id ";
        fromPrefix = late ? fromPrefix + "JOIN project_participation decide_project_participation ON     project_participant.participation_id = decide_project_participation.id AND decide_project_participation.invalidated = 0 JOIN project_participation   ON project_participation.project_id = decide_project_participation.project_id " : fromPrefix + "JOIN project_participation   ON project_participant.participation_id = project_participation.id ";
        fromPrefix = fromPrefix + "JOIN (SELECT document_task.task_id, document_task.project_participation_id, document_task.object_planner_id FROM document_task UNION ALL SELECT document_version_task.task_id, document_version_task.project_participation_id, document_version_task.object_planner_id FROM document_version_task) AS t ON t.project_participation_id = project_participation.id JOIN task                    ON task.id = t.task_id JOIN object_planner          ON object_planner.id = t.object_planner_id JOIN object                  ON object_planner.object_id = object.id JOIN object_list             ON object.object_list_id = object_list.id JOIN sub_project             ON object_list.sub_project_id = sub_project.id JOIN project                 ON project_participation.project_id = project.id ";
        fromPrefix = done ? fromPrefix + "LEFT JOIN review_cycle_plott_task_done ON review_cycle_plott_task_done.task_id = task.id LEFT JOIN plot_order_acceptance_task_done ON plot_order_acceptance_task_done.task_id = task.id " : fromPrefix + "LEFT JOIN review_cycle_plott_task ON review_cycle_plott_task.task_id = task.id LEFT JOIN plot_order_acceptance_task ON plot_order_acceptance_task.task_id = task.id ";
        return fromPrefix;
    }

    private String getTaskCountsWherePrefix(boolean done) {
        String wherePrefix = "WHERE organisation_person.person_id = ? ";
        wherePrefix = done ? wherePrefix + "AND ((    review_cycle_plott_task_done.task_id IS NOT NULL)      OR (plot_order_acceptance_task_done.task_id IS NOT NULL)      OR object.read_only = 0) " : wherePrefix + "AND ((    review_cycle_plott_task.task_id IS NOT NULL)      OR (plot_order_acceptance_task.task_id IS NOT NULL)      OR object.read_only = 0) ";
        wherePrefix = wherePrefix + "AND sub_project.read_only = 0 AND project.access = 2 AND organisation_person.retired_flag = 0 AND project_participant.inactive_flag = 0 AND project_participation.invalidated = 0 ";
        return wherePrefix;
    }

    @Override
    public List<TaskCountLine> getTaskCounts(Long personId) {
        String sql = "SELECT '" + TaskSearchMode.OWN.getValue() + "' as search_mode, '" + TaskDeputyMode.MAIN_PARTICIPANT.getValue() + "' as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, false) + "LEFT JOIN review_task           ON review_task.task_id = t.task_id LEFT JOIN attached_review_task  ON attached_review_task.task_id = t.task_id " + this.getTaskCountsWherePrefix(false) + "AND task.done = 0 " + TASK_MODE_OWN_WHERE_CLAUSE + "AND project_participant.main_participant_flag = 1 GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.OWN.getValue() + "' as search_mode, '" + TaskDeputyMode.DEPUTY.getValue() + "' as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, false) + "LEFT JOIN review_task           ON review_task.task_id = t.task_id LEFT JOIN attached_review_task  ON attached_review_task.task_id = t.task_id " + this.getTaskCountsWherePrefix(false) + "AND task.done = 0 " + TASK_MODE_OWN_WHERE_CLAUSE + "AND project_participant.main_participant_flag = 0 GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.BATCH.getValue() + "' as search_mode, '" + TaskDeputyMode.MAIN_PARTICIPANT.getValue() + "' as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, false) + "LEFT JOIN review_task           ON review_task.task_id = t.task_id LEFT JOIN attached_review_task  ON attached_review_task.task_id = t.task_id " + this.getTaskCountsWherePrefix(false) + "AND task.done = 0 " + TASK_MODE_BATCH_WHERE_CLAUSE + "AND project_participant.main_participant_flag = 1 GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.BATCH.getValue() + "' as search_mode, '" + TaskDeputyMode.DEPUTY.getValue() + "' as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, false) + "LEFT JOIN review_task           ON review_task.task_id = t.task_id LEFT JOIN attached_review_task  ON attached_review_task.task_id = t.task_id " + this.getTaskCountsWherePrefix(false) + "AND task.done = 0 " + TASK_MODE_BATCH_WHERE_CLAUSE + "AND project_participant.main_participant_flag = 0 GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.DONE.getValue() + "' as search_mode, '" + TaskDeputyMode.MAIN_PARTICIPANT.getValue() + "' as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, true) + this.getTaskCountsWherePrefix(true) + "AND task.done = 1 AND project_participant.main_participant_flag = 1 GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.DONE.getValue() + "' as search_mode, '" + TaskDeputyMode.DEPUTY.getValue() + "' as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, true) + this.getTaskCountsWherePrefix(true) + "AND task.done = 1 AND project_participant.main_participant_flag = 0 GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.LATE.getValue() + "' as search_mode, '" + TaskDeputyMode.MAIN_PARTICIPANT.getValue() + "' as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, false) + this.getTaskCountsWherePrefix(false) + "AND task.done = 0 " + JdbcTaskDAO.taskModeLateWhereClause(false) + "AND project_participant.main_participant_flag = 1 GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.LATE.getValue() + "' as search_mode, '" + TaskDeputyMode.DEPUTY.getValue() + "' as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, false) + this.getTaskCountsWherePrefix(false) + "AND task.done = 0 " + JdbcTaskDAO.taskModeLateWhereClause(false) + "AND project_participant.main_participant_flag = 0 GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.OWN.getValue() + "' as search_mode, NULL as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, false) + "LEFT JOIN review_task           ON review_task.task_id = t.task_id LEFT JOIN attached_review_task  ON attached_review_task.task_id = t.task_id " + this.getTaskCountsWherePrefix(false) + "AND task.done = 0 " + TASK_MODE_OWN_WHERE_CLAUSE + "GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.BATCH.getValue() + "' as search_mode, NULL as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, false) + "LEFT JOIN review_task           ON review_task.task_id = t.task_id LEFT JOIN attached_review_task  ON attached_review_task.task_id = t.task_id " + this.getTaskCountsWherePrefix(false) + "AND task.done = 0 " + TASK_MODE_BATCH_WHERE_CLAUSE + "GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.DONE.getValue() + "' as search_mode, NULL as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(false, true) + this.getTaskCountsWherePrefix(true) + "AND task.done = 1 GROUP BY t.task_id) as c UNION ALL SELECT '" + TaskSearchMode.LATE.getValue() + "' as search_mode, NULL as deputy_mode, COUNT(1) as c " + this.getTaskCountsFromPrefix(true, false) + this.getTaskCountsWherePrefix(false) + "AND task.done = 0 " + JdbcTaskDAO.taskModeLateWhereClause(true) + "GROUP BY t.task_id) as c ";
        if (log.isDebugEnabled()) {
            log.info(sql);
        }
        return (List)this.performWithPreparedStatement(sql, statement -> {
            for (int n = 1; n <= 12; ++n) {
                JDBCHelper.setLong((PreparedStatement)statement, (int)n, (Number)personId);
            }
            ResultSet rs = statement.executeQuery();
            ArrayList<TaskCountLine> taskCountLines = new ArrayList<TaskCountLine>();
            while (rs.next()) {
                String searchModeString = rs.getString(1);
                TaskSearchMode searchMode = TaskSearchMode.getByValue((String)searchModeString);
                String deputyModeString = rs.getString(2);
                TaskDeputyMode deputyMode = TaskDeputyMode.getByValue((String)deputyModeString);
                Integer count = JDBCHelper.getInt((ResultSet)rs, (int)3);
                TaskCountLine taskCountLine = new TaskCountLine();
                taskCountLine.setSearchMode(searchMode);
                taskCountLine.setDeputyMode(deputyMode);
                taskCountLine.setCount(count);
                taskCountLines.add(taskCountLine);
            }
            return taskCountLines;
        });
    }

    @Override
    public List<TaskTreeJoin> getTaskTreeJoinsByVersionId(Long documentVersionId) {
        String sql = "SELECT " + JdbcTaskDAO.getTaskTreeJoinSelectClause() + "FROM task LEFT JOIN document_version_task       ON document_version_task.task_id = task.id LEFT JOIN document_task               ON document_task.task_id = task.id LEFT JOIN review_cycle_entry_task     ON review_cycle_entry_task.task_id = task.id LEFT JOIN original_document_task      ON original_document_task.task_id = task.id LEFT JOIN plot_order_acceptance_task  ON plot_order_acceptance_task.task_id = task.id LEFT JOIN plott_order_item ON plott_order_item.document_version_id = ? LEFT JOIN review_cycle_plott_task review_cycle_plot_task ON (review_cycle_plot_task.order_id = plott_order_item.order_contract_id                                                          AND review_cycle_plot_task.task_id = task.id) LEFT JOIN review_task                 ON review_task.task_id = task.id LEFT JOIN attached_review_task        ON attached_review_task.task_id = task.id LEFT JOIN select_cell_connection_task ON select_cell_connection_task.task_id = task.id WHERE (document_version_task.document_version_id = ?    OR ((review_task.task_id IS NULL    \tAND select_cell_connection_task.task_id is NULL    \tAND original_document_task.task_id is NULL AND document_version_task.document_version_id = ?)    \tAND review_cycle_entry_task.task_id is NULL    \tAND plott_order_item.document_version_id = ?)) AND task.done = 0 ";
        return (List)this.performWithPreparedStatement(sql, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)documentVersionId);
            ResultSet rs = statement.executeQuery();
            ArrayList<TaskTreeJoin> taskTreeJoins = new ArrayList<TaskTreeJoin>();
            while (rs.next()) {
                taskTreeJoins.add(JdbcTaskDAO.fillTaskTreeJoinFromResultSet(rs));
            }
            return taskTreeJoins;
        });
    }

    @Override
    public TaskTreeJoin getTaskTreeJoinByTaskId(Long taskId) {
        String sql = "SELECT " + JdbcTaskDAO.getTaskTreeJoinSelectClause() + "FROM task LEFT JOIN document_version_task       ON document_version_task.task_id = task.id LEFT JOIN document_task               ON document_task.task_id = task.id LEFT JOIN review_cycle_entry_task     ON review_cycle_entry_task.task_id = task.id LEFT JOIN original_document_task      ON original_document_task.task_id = task.id LEFT JOIN plot_order_acceptance_task  ON plot_order_acceptance_task.task_id = task.id LEFT JOIN review_cycle_plott_task review_cycle_plot_task ON review_cycle_plot_task.task_id = task.id LEFT JOIN review_task                 ON review_task.task_id = task.id LEFT JOIN attached_review_task        ON attached_review_task.task_id = task.id LEFT JOIN select_cell_connection_task ON select_cell_connection_task.task_id = task.id WHERE task.id = ? ";
        return QueryHelper.getUniqueWithSql((JdbcDAOSupport)this, sql, AbstractJdbcBaseTaskDAO::fillTaskTreeJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)taskId);
        });
    }

    @Override
    public List<TaskTreeJoin> getSelectCellConnectionTaskTreeJoinsBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcTaskDAO.getTaskTreeJoinSelectClause() + "FROM task JOIN document_version_task       ON document_version_task.task_id = task.id JOIN object_planner              ON document_version_task.object_planner_id = object_planner.id JOIN object                      ON object_planner.object_id = object.id JOIN object_list                 ON object.object_list_id = object_list.id LEFT JOIN document_task               ON document_task.task_id = task.id LEFT JOIN review_cycle_entry_task     ON review_cycle_entry_task.task_id = task.id LEFT JOIN original_document_task      ON original_document_task.task_id = task.id LEFT JOIN plot_order_acceptance_task  ON plot_order_acceptance_task.task_id = task.id LEFT JOIN review_cycle_plott_task review_cycle_plot_task ON review_cycle_plot_task.task_id = task.id LEFT JOIN review_task                 ON review_task.task_id = task.id LEFT JOIN attached_review_task        ON attached_review_task.task_id = task.id LEFT JOIN select_cell_connection_task ON select_cell_connection_task.task_id = task.id WHERE object_list.sub_project_id = ? AND select_cell_connection_task.task_id IS NOT NULL";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcBaseTaskDAO::fillTaskTreeJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }

    @Override
    public List<TaskTreeJoin> getReviewCycleEntryTaskTreeJoinsBySubProject(Long subProjectId) {
        String sql = "SELECT " + JdbcTaskDAO.getTaskTreeJoinSelectClause() + "FROM task JOIN document_task               ON document_task.task_id = task.id JOIN object_planner              ON document_task.object_planner_id = object_planner.id JOIN object                      ON object_planner.object_id = object.id JOIN object_list                 ON object.object_list_id = object_list.id LEFT JOIN document_version_task       ON document_version_task.task_id = task.id LEFT JOIN review_cycle_entry_task     ON review_cycle_entry_task.task_id = task.id LEFT JOIN original_document_task      ON original_document_task.task_id = task.id LEFT JOIN plot_order_acceptance_task  ON plot_order_acceptance_task.task_id = task.id LEFT JOIN review_cycle_plott_task review_cycle_plot_task ON review_cycle_plot_task.task_id = task.id LEFT JOIN review_task                 ON review_task.task_id = task.id LEFT JOIN attached_review_task        ON attached_review_task.task_id = task.id LEFT JOIN select_cell_connection_task ON select_cell_connection_task.task_id = task.id WHERE object_list.sub_project_id = ? AND review_cycle_entry_task.task_id IS NOT NULL";
        return QueryHelper.getListWithSql((JdbcDAOSupport)this, sql, AbstractJdbcBaseTaskDAO::fillTaskTreeJoinFromResultSet, statement -> {
            int currIndex = 1;
            JDBCHelper.setLong((PreparedStatement)statement, (int)currIndex++, (Number)subProjectId);
        });
    }

    private static enum ProjectSearchMode {
        SAME_PROJECT,
        SAME_PARTICIPATION;

    }
}

