/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.sec.signature;

import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.Signature;
import at.cdes.api.sec.SignatureCalculator;
import at.cdes.impl.certificate.KeyHelper;
import at.cdes.impl.sec.util.CertificateHelper;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;

public class PKCS7SignatureCalculatorV2
implements SignatureCalculator {
    public byte[] getSignature(byte[] bytes, Certificate cert, String password) {
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        try {
            KeyPair kp = KeyHelper.openKeyPair(cert.getPrivateKey(), password);
            PrivateKey privKey = kp.getPrivate();
            X509Certificate x509Cert = CertificateHelper.getX509Certificate(cert.getCertificate());
            ContentSigner sha1Signer = new JcaContentSignerBuilder("SHA1withRSA").setProvider("BC").build(privKey);
            gen.addSignerInfoGenerator(new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider("BC").build()).build(sha1Signer, x509Cert));
            ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
            certList.add(x509Cert);
            JcaCertStore certs = new JcaCertStore(certList);
            gen.addCertificates((Store)certs);
            CMSProcessableByteArray content = new CMSProcessableByteArray(bytes);
            CMSSignedData data = gen.generate((CMSTypedData)content, true);
            return data.getEncoded();
        }
        catch (OperatorCreationException e) {
            throw new SecurityException("Calculating PKCS7 Signature", e);
        }
        catch (CertificateException e) {
            throw new SecurityException("Calculating PKCS7 Signature", e);
        }
        catch (CMSException e) {
            throw new SecurityException("Calculating PKCS7 Signature", e);
        }
        catch (IOException e) {
            throw new SecurityException("Calculating PKCS7 Signature", e);
        }
    }

    public boolean verify(ContentInfo info, Certificate cert) {
        try {
            CMSSignedData data = new CMSSignedData(info.getEncoded());
            SignerInformationStore signers = data.getSignerInfos();
            Collection c = signers.getSigners();
            Iterator it = c.iterator();
            X509Certificate x509Cert = CertificateHelper.getX509Certificate(cert.getCertificate());
            while (it.hasNext()) {
                SignerInformation signer = (SignerInformation)it.next();
                if (!signer.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider("BC").build(x509Cert))) continue;
                return true;
            }
            return true;
        }
        catch (CMSException e) {
            throw new SecurityException("Verifying PKCS7 Signature", e);
        }
        catch (CertificateException e) {
            throw new SecurityException("Verifying PKCS7 Signature", e);
        }
        catch (OperatorCreationException e) {
            throw new SecurityException("Calculating PKCS7 Signature", e);
        }
        catch (IOException e) {
            throw new SecurityException("Verifying PKCS7 Signature", e);
        }
    }

    public Signature createSignature(ProjectParticipant pp, String content, Certificate cert, String password) {
        Long projectParticipantId = pp != null ? pp.getId() : null;
        return this.createSignature(projectParticipantId, content, cert, password);
    }

    public Signature createSignature(Long projectParticipantId, String content, Certificate cert, String password) {
        Signature sign = new Signature();
        sign.setProjectParticipantId(projectParticipantId);
        sign.setTime(Double.valueOf(new Double(System.currentTimeMillis()) / 1000.0));
        sign.setSignatureCalculatorId(Long.valueOf(2L));
        try {
            sign.setContent(content.getBytes("US-ASCII"));
            sign.setCertificateId(cert.getId());
            sign.setSignature(this.getPKCS7String(this.getSignature(content.getBytes(), cert, password)).getBytes("US-ASCII"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return sign;
    }

    public String getPKCS7String(byte[] content) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("-----BEGIN PKCS7-----\n");
        char[] buf = new char[64];
        byte[] bytes = Base64.encode((byte[])content);
        for (int i = 0; i < bytes.length; i += buf.length) {
            int index;
            for (index = 0; index != buf.length && i + index < bytes.length; ++index) {
                buf[index] = (char)bytes[i + index];
            }
            buffer.append(buf, 0, index);
            buffer.append("\n");
        }
        buffer.append("-----END PKCS7-----\n");
        return buffer.toString();
    }

    public boolean verifySignature(Signature sign) {
        throw new UnsupportedOperationException("Not yet implemented.  How to get the certificate here?");
    }
}

