/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.db.trx;

import at.cdes.api.dto.Trx;
import at.cdes.api.service.TransactionService;
import java.lang.reflect.Method;
import java.util.regex.Pattern;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.clazzes.util.aop.ThreadLocalManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionLogInterceptor
implements MethodInterceptor {
    private static final Logger log = LoggerFactory.getLogger(TransactionLogInterceptor.class);
    private Pattern includeMethods;
    private Pattern excludeMethods;
    private Boolean omitFinalUpdate;
    private TransactionService transactionService;
    private String trxIdThreadLocalKey;

    public void setIncludeMethods(Pattern includeMethods) {
        this.includeMethods = includeMethods;
    }

    public void setExcludeMethods(Pattern excludeMethods) {
        this.excludeMethods = excludeMethods;
    }

    public void setOmitFinalUpdate(Boolean omitFinalUpdate) {
        this.omitFinalUpdate = omitFinalUpdate;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setTrxIdThreadLocalKey(String trxIdThreadLocalKey) {
        this.trxIdThreadLocalKey = trxIdThreadLocalKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation invocation) throws Throwable {
        String methodName = invocation.getMethod().getName();
        if (this.excludeMethods != null && this.excludeMethods.matcher(methodName).matches()) {
            return invocation.proceed();
        }
        if (this.includeMethods != null && !this.includeMethods.matcher(methodName).matches()) {
            return invocation.proceed();
        }
        try {
            Trx trx = new Trx();
            trx.setFromTs(Long.valueOf(System.currentTimeMillis()));
            trx.setToTs(null);
            trx.setUsername(ThreadLocalManager.getLoginPrincipal().getName());
            Method method = invocation.getMethod();
            String packageName = method.getDeclaringClass().getCanonicalName();
            trx.setFct(packageName + "." + methodName);
            trx = this.transactionService.save(trx);
            ThreadLocalManager.bindResource((String)this.trxIdThreadLocalKey, (Object)trx.getId());
            if (log.isDebugEnabled()) {
                log.debug("Opened transaction with id [" + trx.getId() + "] for method [" + trx.getFct() + "]");
            }
            Object object = invocation.proceed();
            return object;
        }
        finally {
            Long trxId = (Long)ThreadLocalManager.unbindResource((String)this.trxIdThreadLocalKey);
            if (!(trxId == null || this.omitFinalUpdate != null && this.omitFinalUpdate.booleanValue())) {
                Trx trx = this.transactionService.getTransaction(trxId);
                if (trx != null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Recording transaction with id [" + trx.getId() + "] for method [" + trx.getFct() + "] finished.");
                    }
                    trx.setToTs(Long.valueOf(System.currentTimeMillis()));
                    this.transactionService.update(trx);
                } else {
                    log.warn("Cannot declare transaction with id [" + trxId + "] finished, as it cannot be found in database.");
                }
            }
        }
    }
}

