/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.planDeliver;

import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentDateHistoryPart;
import at.cdes.api.dto.DocumentList;
import at.cdes.api.dto.DocumentListRelease;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentTask;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentDateHistoryPartDAO;
import at.cdes.impl.dao.DocumentListDAO;
import at.cdes.impl.dao.DocumentListReleaseDAO;
import at.cdes.impl.dao.DocumentReleaseDAO;
import at.cdes.impl.dao.DocumentTaskDAO;
import at.cdes.impl.dao.SignatureDAO;
import at.cdes.impl.task.TaskUtils;
import at.cdes.impl.util.QueryHelper;
import java.util.ArrayList;
import java.util.List;

public class PlanDeliverUtils {
    private DocumentDAO documentDAO;
    private DocumentReleaseDAO documentReleaseDAO;
    private DocumentDateHistoryPartDAO documentDateHistoryPartDAO;
    private DocumentListDAO documentListDAO;
    private DocumentListReleaseDAO documentListReleaseDAO;
    private DocumentTaskDAO documentTaskDAO;
    private TaskUtils taskUtils;
    private SignatureDAO signatureDAO;

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentReleaseDAO(DocumentReleaseDAO documentReleaseDAO) {
        this.documentReleaseDAO = documentReleaseDAO;
    }

    public void setDocumentDateHistoryPartDAO(DocumentDateHistoryPartDAO documentDateHistoryPartDAO) {
        this.documentDateHistoryPartDAO = documentDateHistoryPartDAO;
    }

    public void setDocumentListDAO(DocumentListDAO documentListDAO) {
        this.documentListDAO = documentListDAO;
    }

    public void setDocumentListReleaseDAO(DocumentListReleaseDAO documentListReleaseDAO) {
        this.documentListReleaseDAO = documentListReleaseDAO;
    }

    public void setDocumentTaskDAO(DocumentTaskDAO documentTaskDAO) {
        this.documentTaskDAO = documentTaskDAO;
    }

    public void setTaskUtils(TaskUtils taskUtils) {
        this.taskUtils = taskUtils;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void deleteNonReleasedDocumentListBySubProjectId(Long subProjectId) {
        List<DocumentList> documentLists = this.documentListDAO.getBySubProject(subProjectId);
        List<Document> documents = this.documentDAO.getBySubProject(subProjectId);
        List<DocumentDateHistoryPart> documentDateHistoryParts = this.documentDateHistoryPartDAO.getBySubProject(subProjectId);
        List<DocumentTask> documentTasks = this.documentTaskDAO.getBySubProjectId(subProjectId);
        List<Long> documentListIds = QueryHelper.getPersistentIds(documentLists);
        List<Long> documentIds = QueryHelper.getPersistentIds(documents);
        List<Long> documentDateHistoryPartIds = QueryHelper.getPersistentIds(documentDateHistoryParts);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (DocumentTask documentTask : documentTasks) {
            taskIds.add(documentTask.getTaskId());
        }
        this.taskUtils.deleteReviewCycleEntryTasks(taskIds);
        if (documentDateHistoryPartIds.size() > 0) {
            this.documentDateHistoryPartDAO.deleteBatch(documentDateHistoryPartIds);
        }
        if (documentIds.size() > 0) {
            this.documentDAO.deleteBatch(documentIds);
        }
        if (documentListIds.size() > 0) {
            this.documentListDAO.deleteBatch(documentListIds);
        }
    }

    public void deleteReleasedDocumentListBySubProjectId(Long subProjectId) {
        List<DocumentListRelease> documentListReleases = this.documentListReleaseDAO.getBySubProject(subProjectId);
        List<Long> documentListReleaseIds = QueryHelper.getPersistentIds(documentListReleases);
        ArrayList<Long> documentListReleaseSignatureIds = new ArrayList<Long>();
        for (DocumentListRelease documentListRelease : documentListReleases) {
            documentListReleaseSignatureIds.add(documentListRelease.getSignatureId());
        }
        List<DocumentRelease> documentReleases = this.documentReleaseDAO.getByDocumentLists(documentListReleaseIds);
        List<Long> documentReleaseIds = QueryHelper.getPersistentIds(documentReleases);
        List<DocumentDateHistoryPart> documentDateHistoryParts = this.documentDateHistoryPartDAO.getBySubProject(subProjectId);
        List<Long> documentDateHistoryPartIds = QueryHelper.getPersistentIds(documentDateHistoryParts);
        List<DocumentTask> documentTasks = this.documentTaskDAO.getBySubProjectId(subProjectId);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (DocumentTask documentTask : documentTasks) {
            taskIds.add(documentTask.getTaskId());
        }
        this.taskUtils.deleteReviewCycleEntryTasks(taskIds);
        if (documentDateHistoryPartIds.size() > 0) {
            this.documentDateHistoryPartDAO.deleteBatch(documentDateHistoryPartIds);
        }
        if (documentReleaseIds.size() > 0) {
            this.documentReleaseDAO.deleteBatch(documentReleaseIds);
        }
        if (documentListReleaseIds.size() > 0) {
            this.documentListReleaseDAO.deleteBatch(documentListReleaseIds);
            this.signatureDAO.deleteBatch(documentListReleaseSignatureIds);
        }
    }
}

