/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Project;
import at.cdes.api.dto.ReviewCycleCellInstance;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.impl.reviewCycle.DurationCalcContext;
import at.cdes.impl.reviewCycle.InstanceDurationCalcContext;
import at.cdes.impl.service.TaskServiceImpl;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import org.apache.xerces.dom.DocumentImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewCycleHelper {
    private static final Logger log = LoggerFactory.getLogger(TaskServiceImpl.class);

    public static ReviewCycleNodeInstanceReleased getFirstInstance(DurationCalcContext cycleContext, ReviewCycleCellInstanceReleased cellInstanceReleased) {
        ReviewCycleNodeInstanceReleased retInstanceReleased = null;
        ReviewCycleNode retNode = null;
        for (ReviewCycleNodeInstanceReleased candidate : cycleContext.getNodeInstanceReleasedsByCellInstanceReleasedId(cellInstanceReleased.getId())) {
            Long currNodeId = candidate.getReviewCycleNodeId();
            ReviewCycleNode candidateNode = cycleContext.getNodeById(currNodeId);
            if (retInstanceReleased != null && candidateNode.getPosition() >= retNode.getPosition()) continue;
            retInstanceReleased = candidate;
            retNode = candidateNode;
        }
        return retInstanceReleased;
    }

    public static ReviewCycleNodeInstance getFirstInstance(InstanceDurationCalcContext cycleContext, ReviewCycleCellInstance cellInstance) {
        ReviewCycleNodeInstance retInstance = null;
        ReviewCycleNode retNode = null;
        for (ReviewCycleNodeInstance candidate : cycleContext.getNodeInstanceByCellInstanceId(cellInstance.getId())) {
            Long currNodeId = candidate.getReviewCycleNodeId();
            ReviewCycleNode candidateNode = cycleContext.getNodeById(currNodeId);
            if (retInstance != null && candidateNode.getPosition() >= retNode.getPosition()) continue;
            retInstance = candidate;
            retNode = candidateNode;
        }
        return retInstance;
    }

    public static ReviewCycleNodeInstanceReleased getNextInstance(DurationCalcContext cycleContext, ReviewCycleCellInstanceReleased cellInstanceReleased, ReviewCycleNodeInstanceReleased nodeInstanceReleased) {
        Long givenNodeId = nodeInstanceReleased.getReviewCycleNodeId();
        ReviewCycleNode givenNode = cycleContext.getNodeById(givenNodeId);
        List<ReviewCycleNodeInstanceReleased> nodeInstancesReleased = cycleContext.getNodeInstanceReleasedsByCellInstanceReleasedId(cellInstanceReleased.getId());
        ReviewCycleNodeInstanceReleased retInstanceReleased = null;
        ReviewCycleNode retNode = null;
        for (ReviewCycleNodeInstanceReleased currNodeInstanceReleased : nodeInstancesReleased) {
            Long currNodeId = currNodeInstanceReleased.getReviewCycleNodeId();
            ReviewCycleNode currNode = cycleContext.getNodeById(currNodeId);
            if (currNode.getPosition() <= givenNode.getPosition() || retInstanceReleased != null && currNode.getPosition() >= retNode.getPosition()) continue;
            retInstanceReleased = currNodeInstanceReleased;
            retNode = currNode;
        }
        return retInstanceReleased;
    }

    public static ReviewCycleNodeInstance getNextInstance(InstanceDurationCalcContext cycleContext, ReviewCycleCellInstance cellInstance, ReviewCycleNodeInstance nodeInstance) {
        Long givenNodeId = nodeInstance.getReviewCycleNodeId();
        ReviewCycleNode givenNode = cycleContext.getNodeById(givenNodeId);
        List<ReviewCycleNodeInstance> nodeInstances = cycleContext.getNodeInstanceByCellInstanceId(cellInstance.getId());
        ReviewCycleNodeInstance retInstance = null;
        ReviewCycleNode retNode = null;
        for (ReviewCycleNodeInstance currNodeInstance : nodeInstances) {
            Long currNodeId = currNodeInstance.getReviewCycleNodeId();
            ReviewCycleNode currNode = cycleContext.getNodeById(currNodeId);
            if (currNode.getPosition() <= givenNode.getPosition() || retInstance != null && currNode.getPosition() >= retNode.getPosition()) continue;
            retInstance = currNodeInstance;
            retNode = currNode;
        }
        return retInstance;
    }

    public static boolean verifyReviewCycleNodeSkippingRule(ReviewCycleNodeInstance rcni, DocumentVersion dv, OrganisationPerson asBuiltContractorOrgPerson) {
        return false;
    }

    public static boolean verifyReviewCycleNodeSkippingRuleForDocument(ReviewCycleNode node, DocumentImpl document, OrganisationPerson asBuiltContractorOrgPerson) {
        return false;
    }

    public static Boolean evaluateBooleanOgnlRule(String rule, OgnlContext context) {
        return ReviewCycleHelper.evaluateBooleanOgnlRule(rule, context, false);
    }

    public static Boolean evaluateBooleanOgnlRule(String rule, OgnlContext context, boolean defaultValue) {
        if (rule == null || rule.trim().isEmpty()) {
            return defaultValue;
        }
        Object expression = null;
        try {
            expression = Ognl.parseExpression(rule);
        }
        catch (OgnlException e) {
            log.error("OGNL parse error in expression [" + rule + "]: " + e);
            return null;
        }
        try {
            Object res = Ognl.getValue(expression, (Map)context, (Object)context);
            if (res == null) {
                return null;
            }
            if (log.isDebugEnabled()) {
                log.debug("OGNL evaluation: expression [" + rule + "], res [" + res + "].");
            }
            return Boolean.parseBoolean(String.valueOf(res));
        }
        catch (OgnlException e) {
            log.error("OGNL evaluation error in expression [" + rule + "]: " + e);
            return null;
        }
    }

    public static boolean verifyReviewCycleNodeSkippingRuleForProject(ReviewCycleNode node, Project project) {
        String rule = node.getSkippingRule();
        if (rule == null || rule.isEmpty() || rule.trim().isEmpty()) {
            return false;
        }
        rule = "#key=\"showNode\", " + rule;
        Object expression = null;
        try {
            expression = Ognl.parseExpression(rule);
        }
        catch (OgnlException e) {
            log.error("OGNL parse error in expression [" + rule + "]: " + e);
        }
        OgnlContext context = new OgnlContext();
        context.put("document", (Object)null);
        context.put("documentVersion", (Object)null);
        context.put("asBuiltReference", (Object)null);
        context.put("asBuiltDocument", (Object)null);
        context.put("plannerOrgPerson", (Object)null);
        context.put("asBuiltContractorOrgPerson", (Object)null);
        context.put("project", project);
        try {
            Object res = Ognl.getValue(expression, (Map)context, (Object)context);
            if (res == null) {
                return false;
            }
            if (log.isDebugEnabled()) {
                log.debug("OGNL evaluation: expression [" + rule + "], res [" + res + "].");
            }
            return Boolean.parseBoolean(String.valueOf(res));
        }
        catch (OgnlException e) {
            log.error("OGNL evaluation error in expression [" + rule + "]: " + e);
            return false;
        }
    }
}

