/*
 * Decompiled with CFR 0.152.
 */
package at.cdes.impl.reviewCycle;

import at.cdes.api.document.ListenerExecutor;
import at.cdes.api.dto.AttachedReviewTaskDone;
import at.cdes.api.dto.Attachment;
import at.cdes.api.dto.Certificate;
import at.cdes.api.dto.Document;
import at.cdes.api.dto.DocumentRelease;
import at.cdes.api.dto.DocumentVersion;
import at.cdes.api.dto.DocumentVersionStatusChange;
import at.cdes.api.dto.EmailSnippet;
import at.cdes.api.dto.IReviewCycleNodePosition;
import at.cdes.api.dto.ISignedObject;
import at.cdes.api.dto.ObjectPlannerPositionDefinition;
import at.cdes.api.dto.ObjectPlannerPositionRelease;
import at.cdes.api.dto.OrganisationPerson;
import at.cdes.api.dto.Persistent;
import at.cdes.api.dto.ProjectParticipant;
import at.cdes.api.dto.ProjectParticipation;
import at.cdes.api.dto.Realm;
import at.cdes.api.dto.ReviewCycle;
import at.cdes.api.dto.ReviewCycleCell;
import at.cdes.api.dto.ReviewCycleCellInstance;
import at.cdes.api.dto.ReviewCycleCellInstanceReleased;
import at.cdes.api.dto.ReviewCycleCellResult;
import at.cdes.api.dto.ReviewCycleEntryTask;
import at.cdes.api.dto.ReviewCycleInstance;
import at.cdes.api.dto.ReviewCycleInstanceReleased;
import at.cdes.api.dto.ReviewCycleNode;
import at.cdes.api.dto.ReviewCycleNodeInstance;
import at.cdes.api.dto.ReviewCycleNodeInstanceNotification;
import at.cdes.api.dto.ReviewCycleNodeInstancePlottOrderListener;
import at.cdes.api.dto.ReviewCycleNodeInstanceReleased;
import at.cdes.api.dto.ReviewCycleNodePosition;
import at.cdes.api.dto.ReviewCycleNodePositionReleased;
import at.cdes.api.dto.ReviewCycleNodeProjectParticipationsNotification;
import at.cdes.api.dto.ReviewCycleNodeResult;
import at.cdes.api.dto.ReviewCyclePositionResult;
import at.cdes.api.dto.ReviewCycleResultOption;
import at.cdes.api.dto.ReviewTaskDone;
import at.cdes.api.dto.Signature;
import at.cdes.api.dto.StatusEmailSnippet;
import at.cdes.api.joinDto.AttachmentMailJoin;
import at.cdes.api.joinDto.DocumentVersionContextJoin;
import at.cdes.api.joinDto.IObjectPlannerReleaseObjectJoin;
import at.cdes.api.joinDto.ListenerJoin;
import at.cdes.api.joinDto.ReviewCycleSelectJoin;
import at.cdes.api.joinDto.ReviewCycleTreeJoin;
import at.cdes.api.obj.voc.ObjectPlannerPositionDefinitionStatus;
import at.cdes.api.ognl.OgnlEvaluator;
import at.cdes.api.review.compositeDto.ReviewCycleInfo;
import at.cdes.api.review.compositeDto.ReviewCycleTreeInfo;
import at.cdes.api.sec.SignatureCalculator;
import at.cdes.api.voc.DocumentVersionStatus;
import at.cdes.api.voc.StatusEmailSnippetType;
import at.cdes.impl.dao.AttachedReviewTaskDoneDAO;
import at.cdes.impl.dao.AttachmentDAO;
import at.cdes.impl.dao.DigestCalculatorDAO;
import at.cdes.impl.dao.DocumentDAO;
import at.cdes.impl.dao.DocumentReleaseDAO;
import at.cdes.impl.dao.DocumentVersionDAO;
import at.cdes.impl.dao.DocumentVersionStatusChangeDAO;
import at.cdes.impl.dao.EmailAttachmentDAO;
import at.cdes.impl.dao.EmailSnippetDAO;
import at.cdes.impl.dao.FutureEmailDAO;
import at.cdes.impl.dao.ObjectPlannerPositionDefinitionDAO;
import at.cdes.impl.dao.ObjectPlannerPositionReleaseDAO;
import at.cdes.impl.dao.OrganisationPersonDAO;
import at.cdes.impl.dao.PersonVariablesDAO;
import at.cdes.impl.dao.PositionResultAttachmentMapDAO;
import at.cdes.impl.dao.ProjectParticipantDAO;
import at.cdes.impl.dao.ProjectParticipationDAO;
import at.cdes.impl.dao.RealmDAO;
import at.cdes.impl.dao.ReviewCycleCellDAO;
import at.cdes.impl.dao.ReviewCycleCellInstanceDAO;
import at.cdes.impl.dao.ReviewCycleCellInstanceReleasedDAO;
import at.cdes.impl.dao.ReviewCycleCellResultDAO;
import at.cdes.impl.dao.ReviewCycleEntryTaskDAO;
import at.cdes.impl.dao.ReviewCycleInstanceDAO;
import at.cdes.impl.dao.ReviewCycleInstanceReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodeDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstanceDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstanceNotificationDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstancePlottOrderListenerDAO;
import at.cdes.impl.dao.ReviewCycleNodeInstanceReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodeListenerDAO;
import at.cdes.impl.dao.ReviewCycleNodePositionDAO;
import at.cdes.impl.dao.ReviewCycleNodePositionReleasedDAO;
import at.cdes.impl.dao.ReviewCycleNodeProjectParticipationsNotificationDAO;
import at.cdes.impl.dao.ReviewCycleNodeResultDAO;
import at.cdes.impl.dao.ReviewCyclePositionResultDAO;
import at.cdes.impl.dao.ReviewCycleResultOptionDAO;
import at.cdes.impl.dao.ReviewTaskDoneDAO;
import at.cdes.impl.dao.SignatureDAO;
import at.cdes.impl.dao.StatusEmailSnippetDAO;
import at.cdes.impl.dao.TaskEmailSnippetDAO;
import at.cdes.impl.debug.DebugContext;
import at.cdes.impl.document.DocumentUtils;
import at.cdes.impl.document.util.DocumentVersionHelper;
import at.cdes.impl.i18n.CdesImplMessages;
import at.cdes.impl.reviewCycle.ReviewCycleNodeInstanceNotificationListener;
import at.cdes.impl.reviewCycle.ReviewCycleNodeInstancePlotOrderListener;
import at.cdes.impl.reviewCycle.ReviewOgnlHelper;
import at.cdes.impl.reviewCycle.ReviewProtocolContext;
import at.cdes.impl.reviewCycle.ReviewProtocolSvgRenderer;
import at.cdes.impl.task.TaskHelper;
import at.cdes.impl.task.TaskUtils;
import at.cdes.impl.util.QueryHelper;
import at.cdes.impl.util.i18n.I18nHelper;
import at.cdes.impl.util.odf.OdfHelper;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.clazzes.util.lang.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReviewUtils {
    private static final Logger log = LoggerFactory.getLogger(ReviewUtils.class);
    private AttachedReviewTaskDoneDAO attachedReviewTaskDoneDAO;
    private AttachmentDAO attachmentDAO;
    private DocumentDAO documentDAO;
    private DocumentReleaseDAO documentReleaseDAO;
    private DocumentUtils documentUtils;
    private DocumentVersionDAO documentVersionDAO;
    private DocumentVersionStatusChangeDAO documentVersionStatusChangeDAO;
    private EmailAttachmentDAO emailAttachmentDAO;
    private EmailSnippetDAO emailSnippetDAO;
    private FutureEmailDAO futureEmailDAO;
    private ListenerExecutor listenerExecutor;
    private ReviewProtocolSvgRenderer reviewProtocolSvgRenderer;
    private ObjectPlannerPositionReleaseDAO objectPlannerPositionReleaseDAO;
    private ObjectPlannerPositionDefinitionDAO objectPlannerPositionDefinitionDAO;
    private OrganisationPersonDAO organisationPersonDAO;
    private PersonVariablesDAO personVariablesDAO;
    private PositionResultAttachmentMapDAO positionResultAttachmentMapDAO;
    private ProjectParticipantDAO projectParticipantDAO;
    private ProjectParticipationDAO projectParticipationDAO;
    private RealmDAO realmDAO;
    private ReviewCycleCellResultDAO reviewCycleCellResultDAO;
    private ReviewCycleCellDAO reviewCycleCellDAO;
    private ReviewCycleEntryTaskDAO reviewCycleEntryTaskDAO;
    private ReviewCycleNodeInstanceNotificationListener reviewCycleNodeInstanceNotificationListener;
    private ReviewCycleNodeInstancePlotOrderListener reviewCycleNodeInstancePlotOrderListener;
    private ReviewCycleNodeListenerDAO reviewCycleNodeListenerDAO;
    private ReviewCyclePositionResultDAO reviewCyclePositionResultDAO;
    private ReviewCycleResultOptionDAO reviewCycleResultOptionDAO;
    private ReviewOgnlHelper reviewOgnlHelper;
    private ReviewTaskDoneDAO reviewTaskDoneDAO;
    private OgnlEvaluator ognlEvaluator;
    private SignatureDAO signatureDAO;
    private StatusEmailSnippetDAO statusEmailSnippetDAO;
    private DigestCalculatorDAO digestCalculatorDAO;
    private SignatureCalculator signatureCalculator;
    private ReviewCycleInstanceDAO reviewCycleInstanceDAO;
    private ReviewCycleInstanceReleasedDAO reviewCycleInstanceReleasedDAO;
    private ReviewCycleCellInstanceDAO reviewCycleCellInstanceDAO;
    private ReviewCycleCellInstanceReleasedDAO reviewCycleCellInstanceReleasedDAO;
    private ReviewCycleNodeDAO reviewCycleNodeDAO;
    private ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO;
    private ReviewCycleNodeInstanceReleasedDAO reviewCycleNodeInstanceReleasedDAO;
    private ReviewCycleNodePositionDAO reviewCycleNodePositionDAO;
    private ReviewCycleNodePositionReleasedDAO reviewCycleNodePositionReleasedDAO;
    private ReviewCycleNodeResultDAO reviewCycleNodeResultDAO;
    private ReviewCycleNodeInstanceNotificationDAO reviewCycleNodeInstanceNotificationDAO;
    private ReviewCycleNodeProjectParticipationsNotificationDAO reviewCycleNodeProjectParticipationsNotificationDAO;
    private ReviewCycleNodeInstancePlottOrderListenerDAO reviewCycleNodeInstancePlottOrderListenerDAO;
    private TaskEmailSnippetDAO taskEmailSnippetDAO;
    private TaskUtils taskUtils;

    public void setAttachedReviewTaskDoneDAO(AttachedReviewTaskDoneDAO attachedReviewTaskDoneDAO) {
        this.attachedReviewTaskDoneDAO = attachedReviewTaskDoneDAO;
    }

    public void setAttachmentDAO(AttachmentDAO attachmentDAO) {
        this.attachmentDAO = attachmentDAO;
    }

    public void setDocumentDAO(DocumentDAO documentDAO) {
        this.documentDAO = documentDAO;
    }

    public void setDocumentReleaseDAO(DocumentReleaseDAO documentReleaseDAO) {
        this.documentReleaseDAO = documentReleaseDAO;
    }

    public void setDocumentUtils(DocumentUtils documentUtils) {
        this.documentUtils = documentUtils;
    }

    public void setDocumentVersionDAO(DocumentVersionDAO documentVersionDAO) {
        this.documentVersionDAO = documentVersionDAO;
    }

    public void setDocumentVersionStatusChangeDAO(DocumentVersionStatusChangeDAO documentVersionStatusChangeDAO) {
        this.documentVersionStatusChangeDAO = documentVersionStatusChangeDAO;
    }

    public void setEmailAttachmentDAO(EmailAttachmentDAO emailAttachmentDAO) {
        this.emailAttachmentDAO = emailAttachmentDAO;
    }

    public void setEmailSnippetDAO(EmailSnippetDAO emailSnippetDAO) {
        this.emailSnippetDAO = emailSnippetDAO;
    }

    public void setFutureEmailDAO(FutureEmailDAO futureEmailDAO) {
        this.futureEmailDAO = futureEmailDAO;
    }

    public void setListenerExecutor(ListenerExecutor listenerExecutor) {
        this.listenerExecutor = listenerExecutor;
    }

    public void setReviewProtocolSvgRenderer(ReviewProtocolSvgRenderer reviewProtocolSvgRenderer) {
        this.reviewProtocolSvgRenderer = reviewProtocolSvgRenderer;
    }

    public void setObjectPlannerPositionReleaseDAO(ObjectPlannerPositionReleaseDAO objectPlannerPositionReleaseDAO) {
        this.objectPlannerPositionReleaseDAO = objectPlannerPositionReleaseDAO;
    }

    public void setObjectPlannerPositionDefinitionDAO(ObjectPlannerPositionDefinitionDAO objectPlannerPositionDefinitionDAO) {
        this.objectPlannerPositionDefinitionDAO = objectPlannerPositionDefinitionDAO;
    }

    public void setOrganisationPersonDAO(OrganisationPersonDAO organisationPersonDAO) {
        this.organisationPersonDAO = organisationPersonDAO;
    }

    public void setPersonVariablesDAO(PersonVariablesDAO personVariablesDAO) {
        this.personVariablesDAO = personVariablesDAO;
    }

    public void setPositionResultAttachmentMapDAO(PositionResultAttachmentMapDAO positionResultAttachmentMapDAO) {
        this.positionResultAttachmentMapDAO = positionResultAttachmentMapDAO;
    }

    public void setProjectParticipantDAO(ProjectParticipantDAO projectParticipantDAO) {
        this.projectParticipantDAO = projectParticipantDAO;
    }

    public void setProjectParticipationDAO(ProjectParticipationDAO projectParticipationDAO) {
        this.projectParticipationDAO = projectParticipationDAO;
    }

    public void setRealmDAO(RealmDAO realmDAO) {
        this.realmDAO = realmDAO;
    }

    public void setReviewCycleCellResultDAO(ReviewCycleCellResultDAO reviewCycleCellResultDAO) {
        this.reviewCycleCellResultDAO = reviewCycleCellResultDAO;
    }

    public void setReviewCycleCellDAO(ReviewCycleCellDAO reviewCycleCellDAO) {
        this.reviewCycleCellDAO = reviewCycleCellDAO;
    }

    public void setReviewCycleEntryTaskDAO(ReviewCycleEntryTaskDAO reviewCycleEntryTaskDAO) {
        this.reviewCycleEntryTaskDAO = reviewCycleEntryTaskDAO;
    }

    public void setReviewCycleNodeInstanceNotificationListener(ReviewCycleNodeInstanceNotificationListener reviewCycleNodeInstanceNotificationListener) {
        this.reviewCycleNodeInstanceNotificationListener = reviewCycleNodeInstanceNotificationListener;
    }

    public void setReviewCycleNodeInstancePlotOrderListener(ReviewCycleNodeInstancePlotOrderListener reviewCycleNodeInstancePlotOrderListener) {
        this.reviewCycleNodeInstancePlotOrderListener = reviewCycleNodeInstancePlotOrderListener;
    }

    public void setReviewCycleNodeListenerDAO(ReviewCycleNodeListenerDAO reviewCycleNodeListenerDAO) {
        this.reviewCycleNodeListenerDAO = reviewCycleNodeListenerDAO;
    }

    public void setReviewCyclePositionResultDAO(ReviewCyclePositionResultDAO reviewCyclePositionResultDAO) {
        this.reviewCyclePositionResultDAO = reviewCyclePositionResultDAO;
    }

    public void setReviewCycleResultOptionDAO(ReviewCycleResultOptionDAO reviewCycleResultOptionDAO) {
        this.reviewCycleResultOptionDAO = reviewCycleResultOptionDAO;
    }

    public void setReviewOgnlHelper(ReviewOgnlHelper reviewOgnlHelper) {
        this.reviewOgnlHelper = reviewOgnlHelper;
    }

    public void setReviewTaskDoneDAO(ReviewTaskDoneDAO reviewTaskDoneDAO) {
        this.reviewTaskDoneDAO = reviewTaskDoneDAO;
    }

    public void setOgnlEvaluator(OgnlEvaluator ognlEvaluator) {
        this.ognlEvaluator = ognlEvaluator;
    }

    public void setSignatureDAO(SignatureDAO signatureDAO) {
        this.signatureDAO = signatureDAO;
    }

    public void setStatusEmailSnippetDAO(StatusEmailSnippetDAO statusEmailSnippetDAO) {
        this.statusEmailSnippetDAO = statusEmailSnippetDAO;
    }

    public void setDigestCalculatorDAO(DigestCalculatorDAO digestCalculatorDAO) {
        this.digestCalculatorDAO = digestCalculatorDAO;
    }

    public void setSignatureCalculator(SignatureCalculator signatureCalculator) {
        this.signatureCalculator = signatureCalculator;
    }

    public void setReviewCycleInstanceDAO(ReviewCycleInstanceDAO reviewCycleInstanceDAO) {
        this.reviewCycleInstanceDAO = reviewCycleInstanceDAO;
    }

    public void setReviewCycleInstanceReleasedDAO(ReviewCycleInstanceReleasedDAO reviewCycleInstanceReleasedDAO) {
        this.reviewCycleInstanceReleasedDAO = reviewCycleInstanceReleasedDAO;
    }

    public void setReviewCycleCellInstanceDAO(ReviewCycleCellInstanceDAO reviewCycleCellInstanceDAO) {
        this.reviewCycleCellInstanceDAO = reviewCycleCellInstanceDAO;
    }

    public void setReviewCycleCellInstanceReleasedDAO(ReviewCycleCellInstanceReleasedDAO reviewCycleCellInstanceReleasedDAO) {
        this.reviewCycleCellInstanceReleasedDAO = reviewCycleCellInstanceReleasedDAO;
    }

    public void setReviewCycleNodeDAO(ReviewCycleNodeDAO reviewCycleNodeDAO) {
        this.reviewCycleNodeDAO = reviewCycleNodeDAO;
    }

    public void setReviewCycleNodeInstanceDAO(ReviewCycleNodeInstanceDAO reviewCycleNodeInstanceDAO) {
        this.reviewCycleNodeInstanceDAO = reviewCycleNodeInstanceDAO;
    }

    public void setReviewCycleNodeInstanceReleasedDAO(ReviewCycleNodeInstanceReleasedDAO reviewCycleNodeInstanceReleasedDAO) {
        this.reviewCycleNodeInstanceReleasedDAO = reviewCycleNodeInstanceReleasedDAO;
    }

    public void setReviewCycleNodePositionDAO(ReviewCycleNodePositionDAO reviewCycleNodePositionDAO) {
        this.reviewCycleNodePositionDAO = reviewCycleNodePositionDAO;
    }

    public void setReviewCycleNodePositionReleasedDAO(ReviewCycleNodePositionReleasedDAO reviewCycleNodePositionReleasedDAO) {
        this.reviewCycleNodePositionReleasedDAO = reviewCycleNodePositionReleasedDAO;
    }

    public void setReviewCycleNodeResultDAO(ReviewCycleNodeResultDAO reviewCycleNodeResultDAO) {
        this.reviewCycleNodeResultDAO = reviewCycleNodeResultDAO;
    }

    public void setReviewCycleNodeInstanceNotificationDAO(ReviewCycleNodeInstanceNotificationDAO reviewCycleNodeInstanceNotificationDAO) {
        this.reviewCycleNodeInstanceNotificationDAO = reviewCycleNodeInstanceNotificationDAO;
    }

    public void setReviewCycleNodeProjectParticipationsNotificationDAO(ReviewCycleNodeProjectParticipationsNotificationDAO reviewCycleNodeProjectParticipationsNotificationDAO) {
        this.reviewCycleNodeProjectParticipationsNotificationDAO = reviewCycleNodeProjectParticipationsNotificationDAO;
    }

    public void setReviewCycleNodeInstancePlottOrderListenerDAO(ReviewCycleNodeInstancePlottOrderListenerDAO reviewCycleNodeInstancePlottOrderListenerDAO) {
        this.reviewCycleNodeInstancePlottOrderListenerDAO = reviewCycleNodeInstancePlottOrderListenerDAO;
    }

    public void setTaskEmailSnippetDAO(TaskEmailSnippetDAO taskEmailSnippetDAO) {
        this.taskEmailSnippetDAO = taskEmailSnippetDAO;
    }

    public void setTaskUtils(TaskUtils taskUtils) {
        this.taskUtils = taskUtils;
    }

    public Pair<String, Integer> renderStatusSvg(ReviewProtocolContext context, double totalWidth, double totalHeight, String personVariablesUserLocale) {
        return this.reviewProtocolSvgRenderer.render(context, totalWidth, totalHeight, personVariablesUserLocale);
    }

    public static String generateName(Long id, String type) {
        return id.toString() + "-" + System.currentTimeMillis() + (type != null ? "." + type : "");
    }

    public ReviewCycleNodeInstanceReleased getValidNodeInstanceReleasedForTask(Long documentId, Long reviewCycleCellId, Long objectPlannerId, Long releasedObjectPlannerId, boolean checkForPositions) {
        OrganisationPerson asBuiltContractorOrgnisationPerson = this.organisationPersonDAO.getAsBuiltContractorOrganisationPerson(objectPlannerId);
        List<ReviewCycleNodeInstanceReleased> nodeInstanceReleasedCandidates = this.reviewCycleNodeInstanceReleasedDAO.getCandidateNodeInstanceReleasesForTask(releasedObjectPlannerId, reviewCycleCellId);
        for (ReviewCycleNodeInstanceReleased nodeInstanceReleasedCandidate : nodeInstanceReleasedCandidates) {
            List<ReviewCycleNodePositionReleased> positions = this.reviewCycleNodePositionReleasedDAO.getByReviewCycleNodeInstance(nodeInstanceReleasedCandidate.getId());
            boolean toSkip = this.reviewOgnlHelper.verifyReviewCycleNodeSkippingRuleForDocument(nodeInstanceReleasedCandidate.getId(), documentId, asBuiltContractorOrgnisationPerson);
            if (toSkip || checkForPositions && positions.isEmpty()) continue;
            log.debug("using ReviewCycleNodeInstanceReleased {}", (Object)nodeInstanceReleasedCandidate.getId());
            return nodeInstanceReleasedCandidate;
        }
        return null;
    }

    public boolean hasCellReleasingNode(Long reviewCycleCellId) {
        boolean cellHasReleasingNode = false;
        ReviewCycleCell cell = (ReviewCycleCell)this.reviewCycleCellDAO.get(reviewCycleCellId);
        List<ReviewCycleNode> cellsNodes = this.reviewCycleNodeDAO.getByReviewCycleCell(cell.getId());
        for (ReviewCycleNode reviewCycleNode : cellsNodes) {
            List<ReviewCycleResultOption> resultOptions = this.reviewCycleResultOptionDAO.getByReviewCycleNode(reviewCycleNode.getId());
            for (ReviewCycleResultOption resultOption : resultOptions) {
                if (resultOption.getDocumentVersionStatus() == null || !resultOption.getDocumentVersionStatus().equals(DocumentVersionStatus.RELEASEDPOSITIV.getValue())) continue;
                cellHasReleasingNode = true;
                break;
            }
            if (!cellHasReleasingNode) continue;
            break;
        }
        return cellHasReleasingNode;
    }

    public ReviewCycleTreeInfo getReviewCycleMaps(String personVariablesUserLocale, List<String> contentLocales, List<ReviewCycleSelectJoin> reviewCycleSelectJoins) {
        ReviewCycleTreeInfo treeInfo = new ReviewCycleTreeInfo();
        List reviewCycles = treeInfo.getReviewCycles();
        Map reviewCycleIdToCells = treeInfo.getReviewCycleIdToCells();
        Map reviewCycleCellIdToNodes = treeInfo.getReviewCycleCellIdToNodes();
        HashSet<Long> addedReviewCycleIds = new HashSet<Long>();
        HashMap reviewCycleIdToAddedCells = new HashMap();
        HashMap reviewCycleCellIdToAddedNodes = new HashMap();
        for (ReviewCycleSelectJoin join : reviewCycleSelectJoins) {
            Long reviewCycleNodeId;
            Long reviewCycleCellId;
            String reviewCycleNodeName = join.getReviewCycleNodeName();
            reviewCycleNodeName = I18nHelper.convertDatabaseToJs(reviewCycleNodeName, personVariablesUserLocale, contentLocales);
            join.setReviewCycleNodeName(reviewCycleNodeName);
            String reviewCycleCellName = join.getReviewCycleCellName();
            reviewCycleCellName = I18nHelper.convertDatabaseToJs(reviewCycleCellName, personVariablesUserLocale, contentLocales);
            join.setReviewCycleCellName(reviewCycleCellName);
            ReviewCycle reviewCycle = join.getReviewCycle();
            ReviewCycleCell reviewCycleCell = join.getReviewCycleCell();
            ReviewCycleNode reviewCycleNode = join.getReviewCycleNode();
            String reviewCycleName = reviewCycle.getName();
            reviewCycleName = I18nHelper.convertDatabaseToJs(reviewCycleName, personVariablesUserLocale, contentLocales);
            reviewCycle.setName(reviewCycleName);
            Long reviewCycleId = reviewCycle.getId();
            if (!addedReviewCycleIds.contains(reviewCycleId)) {
                reviewCycles.add(reviewCycle);
                addedReviewCycleIds.add(reviewCycleId);
            }
            if ((reviewCycleCellId = reviewCycleCell.getId()) != null) {
                if (!reviewCycleIdToAddedCells.containsKey(reviewCycleId)) {
                    reviewCycleIdToAddedCells.put(reviewCycleId, new HashSet());
                }
                if (!((Set)reviewCycleIdToAddedCells.get(reviewCycleId)).contains(reviewCycleCellId)) {
                    if (!reviewCycleIdToCells.containsKey(reviewCycleId)) {
                        reviewCycleIdToCells.put(reviewCycleId, new ArrayList());
                    }
                    ((List)reviewCycleIdToCells.get(reviewCycleId)).add(reviewCycleCell);
                    ((Set)reviewCycleIdToAddedCells.get(reviewCycleId)).add(reviewCycleCellId);
                }
            }
            if ((reviewCycleNodeId = reviewCycleNode.getId()) == null) continue;
            if (!reviewCycleCellIdToAddedNodes.containsKey(reviewCycleCellId)) {
                reviewCycleCellIdToAddedNodes.put(reviewCycleCellId, new HashSet());
            }
            if (((Set)reviewCycleCellIdToAddedNodes.get(reviewCycleCellId)).contains(reviewCycleNodeId)) continue;
            if (!reviewCycleCellIdToNodes.containsKey(reviewCycleCellId)) {
                reviewCycleCellIdToNodes.put(reviewCycleCellId, new ArrayList());
            }
            ((List)reviewCycleCellIdToNodes.get(reviewCycleCellId)).add(reviewCycleNode);
            ((Set)reviewCycleCellIdToAddedNodes.get(reviewCycleCellId)).add(reviewCycleNodeId);
        }
        return treeInfo;
    }

    public <T extends ISignedObject> Signature signObject(T object, String digestCalculatorName, Supplier<String> getDigest, Supplier<String> getSignableContent, Long projectParticipantId, Certificate cert, String password) {
        object.setDigestCalculatorId(this.digestCalculatorDAO.getByName(digestCalculatorName).getId());
        object.setDigest(getDigest.get());
        Signature signature = this.signatureCalculator.createSignature(projectParticipantId, getSignableContent.get(), cert, password);
        this.signatureDAO.save(signature);
        object.setSignatureId(signature.getId());
        return signature;
    }

    public void deleteNonReleasedReviewCycleInstanceBySubProject(Long subProjectId) {
        List<ReviewCycleInstance> reviewCycleInstances = this.reviewCycleInstanceDAO.getBySubProject(subProjectId);
        List<ReviewCycleCellInstance> reviewCycleCellInstances = this.reviewCycleCellInstanceDAO.getBySubProject(subProjectId);
        List<ReviewCycleNodeInstance> reviewCycleNodeInstances = this.reviewCycleNodeInstanceDAO.getBySubProject(subProjectId);
        List<ReviewCycleNodePosition> reviewCycleNodePositions = this.reviewCycleNodePositionDAO.getBySubProject(subProjectId);
        List<ReviewCycleNodeInstanceNotification> reviewCycleNodeInstanceNotifications = this.reviewCycleNodeInstanceNotificationDAO.getBySubProject(subProjectId);
        List<ReviewCycleNodeProjectParticipationsNotification> reviewCycleNodeProjectParticipationsNotifications = this.reviewCycleNodeProjectParticipationsNotificationDAO.getBySubProject(subProjectId);
        List<ReviewCycleNodeInstancePlottOrderListener> reviewCycleNodeInstancePlottOrderListeners = this.reviewCycleNodeInstancePlottOrderListenerDAO.getBySubProject(subProjectId);
        List<Long> reviewCycleInstanceIds = QueryHelper.getPersistentIds(reviewCycleInstances);
        List<Long> reviewCycleCellInstanceIds = QueryHelper.getPersistentIds(reviewCycleCellInstances);
        List<Long> reviewCycleNodeInstanceIds = QueryHelper.getPersistentIds(reviewCycleNodeInstances);
        List<Long> reviewCycleNodePositionIds = QueryHelper.getPersistentIds(reviewCycleNodePositions);
        List<Long> reviewCycleNodeInstanceNotificationIds = QueryHelper.getPersistentIds(reviewCycleNodeInstanceNotifications);
        List<Long> reviewCycleNodeInstancePlottOrderListenerIds = QueryHelper.getPersistentIds(reviewCycleNodeInstancePlottOrderListeners);
        if (reviewCycleNodeInstanceNotificationIds.size() > 0) {
            for (Long id : reviewCycleNodeInstanceNotificationIds) {
                this.reviewCycleNodeProjectParticipationsNotificationDAO.deleteByNotification(id);
            }
            this.reviewCycleNodeInstanceNotificationDAO.deleteBatch(reviewCycleNodeInstanceNotificationIds);
        }
        if (reviewCycleNodeInstancePlottOrderListenerIds.size() > 0) {
            this.reviewCycleNodeInstancePlottOrderListenerDAO.deleteBatch(reviewCycleNodeInstancePlottOrderListenerIds);
        }
        if (reviewCycleNodePositionIds.size() > 0) {
            this.reviewCycleNodePositionDAO.deleteBatch(reviewCycleNodePositionIds);
        }
        if (reviewCycleNodeInstanceIds.size() > 0) {
            this.reviewCycleNodeInstanceDAO.deleteBatch(reviewCycleNodeInstanceIds);
        }
        if (reviewCycleCellInstanceIds.size() > 0) {
            this.reviewCycleCellInstanceDAO.deleteBatch(reviewCycleCellInstanceIds);
        }
        if (reviewCycleInstanceIds.size() > 0) {
            this.reviewCycleInstanceDAO.deleteBatch(reviewCycleInstanceIds);
        }
    }

    public void deleteReleasedReviewCycleInstanceBySubProject(Long subProjectId) {
        List<ReviewCycleInstanceReleased> reviewCycleInstanceReleases = this.reviewCycleInstanceReleasedDAO.getBySubProject(subProjectId);
        List<Long> reviewCycleInstanceReleaseIds = QueryHelper.getPersistentIds(reviewCycleInstanceReleases);
        List<ReviewCycleCellInstanceReleased> reviewCycleCellInstanceReleases = this.reviewCycleCellInstanceReleasedDAO.getByReviewCycleInstances(reviewCycleInstanceReleaseIds);
        List<Long> reviewCycleCellInstanceReleaseIds = QueryHelper.getPersistentIds(reviewCycleCellInstanceReleases);
        List<ReviewCycleNodeInstanceReleased> reviewCycleNodeInstanceReleases = this.reviewCycleNodeInstanceReleasedDAO.getByReviewCycleCellInstances(reviewCycleCellInstanceReleaseIds);
        List<Long> reviewCycleNodeInstanceReleaseIds = QueryHelper.getPersistentIds(reviewCycleNodeInstanceReleases);
        List<ReviewCycleNodePositionReleased> reviewCycleNodePositionReleases = this.reviewCycleNodePositionReleasedDAO.getByReviewCycleNodeInstances(reviewCycleNodeInstanceReleaseIds);
        List<Long> reviewCycleNodePositionReleaseIds = QueryHelper.getPersistentIds(reviewCycleNodePositionReleases);
        List<ReviewCycleNodeInstanceNotification> reviewCycleNodeInstanceNotifications = this.reviewCycleNodeInstanceNotificationDAO.getBySubProject(subProjectId);
        List<Long> reviewCycleNodeInstanceNotificationIds = QueryHelper.getPersistentIds(reviewCycleNodeInstanceNotifications);
        List<ReviewCycleNodeProjectParticipationsNotification> reviewCycleNodeProjectParticipationsNotifications = this.reviewCycleNodeProjectParticipationsNotificationDAO.getBySubProject(subProjectId);
        List<ReviewCycleNodeInstancePlottOrderListener> reviewCycleNodeInstancePlottOrderListeners = this.reviewCycleNodeInstancePlottOrderListenerDAO.getBySubProject(subProjectId);
        List<Long> reviewCycleNodeInstancePlottOrderListenerIds = QueryHelper.getPersistentIds(reviewCycleNodeInstancePlottOrderListeners);
        if (reviewCycleNodeInstanceNotificationIds.size() > 0) {
            for (Long id : reviewCycleNodeInstanceNotificationIds) {
                this.reviewCycleNodeProjectParticipationsNotificationDAO.deleteByNotification(id);
            }
            this.reviewCycleNodeInstanceNotificationDAO.deleteBatch(reviewCycleNodeInstanceNotificationIds);
        }
        if (reviewCycleNodeInstancePlottOrderListenerIds.size() > 0) {
            this.reviewCycleNodeInstancePlottOrderListenerDAO.deleteBatch(reviewCycleNodeInstancePlottOrderListenerIds);
        }
        if (reviewCycleNodePositionReleaseIds.size() > 0) {
            this.reviewCycleNodePositionReleasedDAO.deleteBatch(reviewCycleNodePositionReleaseIds);
        }
        if (reviewCycleNodeInstanceReleaseIds.size() > 0) {
            this.reviewCycleNodeInstanceReleasedDAO.deleteBatch(reviewCycleNodeInstanceReleaseIds);
        }
        if (reviewCycleCellInstanceReleaseIds.size() > 0) {
            this.reviewCycleCellInstanceReleasedDAO.deleteBatch(reviewCycleCellInstanceReleaseIds);
        }
        if (reviewCycleInstanceReleaseIds.size() > 0) {
            this.reviewCycleInstanceReleasedDAO.deleteBatch(reviewCycleInstanceReleaseIds);
        }
    }

    public void deleteRealmsByProjectId(Long projectId) {
        List<Realm> realms = this.realmDAO.getByProject(projectId);
        List<Long> realmIds = QueryHelper.getPersistentIds(realms);
        if (realmIds.size() > 0) {
            this.realmDAO.deleteBatch(realmIds);
        }
    }

    public DocumentVersion moveDocumentVersionToNextNode(DebugContext debugContext, List<String> messages, ReviewCycleNodeInstanceReleased nodeInstance, IObjectPlannerReleaseObjectJoin objectJoin, ReviewCycleNodeResult nodeResult, DocumentVersion documentVersion, boolean hasBreakingResults) {
        boolean isEndNode;
        debugContext.openDebugNode("moveDocumentVersionToNextNode");
        ReviewCycleCellInstanceReleased cellInstance = (ReviewCycleCellInstanceReleased)this.reviewCycleCellInstanceReleasedDAO.get(nodeInstance.getReviewCycleCellInstanceId());
        ReviewCycleNodeInstanceReleased nextNodeInstanceRel = this.reviewCycleNodeInstanceReleasedDAO.getNextNodeInstance(nodeInstance.getId());
        ReviewCycleResultOption emptyOption = this.reviewCycleResultOptionDAO.getEmptyNodeOptionByReviewCycleCell(cellInstance.getReviewCycleCellId());
        ReviewCycleResultOption resultOption = null;
        if (nodeResult.getReviewCycleResultOptionId() != null) {
            resultOption = (ReviewCycleResultOption)this.reviewCycleResultOptionDAO.get(nodeResult.getReviewCycleResultOptionId());
        }
        if (isEndNode = this.reviewCycleResultOptionDAO.getByReviewCycleNode(nodeInstance.getReviewCycleNodeId()).isEmpty()) {
            debugContext.closeDebugNode("isEndNode --> return");
            return documentVersion;
        }
        if (nextNodeInstanceRel == null) {
            String msg = "There is no next ReviewCycleNode after the node has received all reviews.";
            log.error(msg);
            throw new RuntimeException();
        }
        List<ReviewCycleResultOption> nextNodeResultOptions = this.reviewCycleResultOptionDAO.getByReviewCycleNode(nextNodeInstanceRel.getReviewCycleNodeId());
        List<IReviewCycleNodePosition> actualPositions = this.reviewCycleNodePositionDAO.getByNodeInstanceReleasedAndDocumentVersion(nodeInstance.getId(), documentVersion.getId());
        Long objectListReleaseId = objectJoin.getObjectListReleaseId();
        Long objectPlannerReleaseId = objectJoin.getObjectPlannerReleaseId();
        Long reviewCycleInstanceReleasedId = objectJoin.getObjectPlannerReleaseReviewCycleInstanceId();
        if (hasBreakingResults || resultOption != null && resultOption.getFinishCellFlag().booleanValue()) {
            nextNodeInstanceRel = this.reviewCycleNodeInstanceReleasedDAO.getLastByReviewCycleCellInstance(cellInstance.getId());
        } else {
            while (!nextNodeResultOptions.isEmpty()) {
                List<IReviewCycleNodePosition> nextPosition;
                OrganisationPerson asBuiltContractorOrgPerson = this.organisationPersonDAO.getAsBuiltContractorOrganisationPerson(objectJoin.getObjectPlannerReleaseObjectPlannerId());
                if (!this.reviewOgnlHelper.verifyReviewCycleNodeSkippingRule(nextNodeInstanceRel.getId(), documentVersion.getId(), asBuiltContractorOrgPerson) && !(nextPosition = this.reviewCycleNodePositionDAO.getByNodeInstanceReleasedAndDocumentVersion(nextNodeInstanceRel.getId(), documentVersion.getId())).isEmpty()) break;
                if (actualPositions.isEmpty()) {
                    nodeResult.setReviewCycleResultOptionId(emptyOption.getId());
                }
                this.finishReviewCycleNode(debugContext, messages, nodeInstance, nodeResult, objectListReleaseId, objectJoin.getObjectPlannerId(), objectPlannerReleaseId, documentVersion, nextNodeInstanceRel != null ? nextNodeInstanceRel.getReviewCycleNodeId() : null);
                nodeResult = this.moveDocumentVersionToNode(debugContext, messages, nextNodeInstanceRel, objectListReleaseId, objectPlannerReleaseId, reviewCycleInstanceReleasedId, nodeResult, documentVersion);
                nodeInstance = nextNodeInstanceRel;
                nextNodeInstanceRel = this.reviewCycleNodeInstanceReleasedDAO.getNextNodeInstance(nodeInstance.getId());
                if (nextNodeInstanceRel == null) {
                    String msg = "There is no next ReviewCycleNode while serching for the next node to be reviewed.";
                    log.error(msg);
                    throw new RuntimeException("");
                }
                nextNodeResultOptions = this.reviewCycleResultOptionDAO.getByReviewCycleNode(nextNodeInstanceRel.getReviewCycleNodeId());
            }
        }
        if (actualPositions.isEmpty()) {
            nodeResult.setReviewCycleResultOptionId(emptyOption.getId());
            nextNodeResultOptions = this.reviewCycleResultOptionDAO.getByReviewCycleNode(nextNodeInstanceRel.getReviewCycleNodeId());
        }
        this.finishReviewCycleNode(debugContext, messages, nodeInstance, nodeResult, objectJoin.getObjectListReleaseId(), objectJoin.getObjectPlannerId(), objectJoin.getObjectPlannerReleaseId(), documentVersion, nextNodeInstanceRel != null ? nextNodeInstanceRel.getReviewCycleNodeId() : null);
        resultOption = (ReviewCycleResultOption)this.reviewCycleResultOptionDAO.get(nodeResult.getReviewCycleResultOptionId());
        if (resultOption != null && resultOption.getFinishCellFlag().booleanValue()) {
            nextNodeInstanceRel = this.reviewCycleNodeInstanceReleasedDAO.getLastByReviewCycleCellInstance(nodeInstance.getReviewCycleCellInstanceId());
        }
        nodeResult = this.moveDocumentVersionToNode(debugContext, messages, nextNodeInstanceRel, objectListReleaseId, objectPlannerReleaseId, reviewCycleInstanceReleasedId, nodeResult, documentVersion);
        this.logDebug(messages, "Aufruf: Bereits existierende Methode [TaskUtils.generateReviewTasks]");
        this.taskUtils.generateReviewTasks(debugContext, documentVersion.getId(), nextNodeInstanceRel.getId(), nodeResult, false);
        nextNodeResultOptions = this.reviewCycleResultOptionDAO.getByReviewCycleNode(nextNodeInstanceRel.getReviewCycleNodeId());
        if (nextNodeResultOptions.isEmpty()) {
            this.logDebug(messages, "Aufruf: Bereits existierende Methode [TaskUtils.generateSelectCellTask]");
            this.taskUtils.generateSelectCellTask(debugContext, objectJoin.getObjectListReleaseId(), documentVersion.getId(), nextNodeInstanceRel.getId(), false, resultOption.getEvaluateCellConnections());
        }
        debugContext.closeDebugNode();
        return null;
    }

    public void finishReviewCycleNode(DebugContext debugContext, List<String> messages, ReviewCycleNodeInstanceReleased nodeInstanceReleased, ReviewCycleNodeResult result, Long objectListReleaseId, Long objectPlannerId, Long objectPlannerReleaseId, DocumentVersion documentVersion, Long nextNodeId) {
        ReviewCycleResultOption opt;
        debugContext.openDebugNode("finishReviewCycleNode");
        result.setDepartureDate(Double.valueOf((double)Instant.now().toEpochMilli() / 1000.0));
        result.setFinished(Boolean.valueOf(true));
        result.setDepartureObjectListId(objectListReleaseId);
        log.info("Will finishReviewCycleNode for [ReviewCycleNodeResultId=" + result.getId() + "] [documentVersionId=" + documentVersion.getId() + "]");
        if (result.getReviewCycleResultOptionId() == null) {
            opt = this.calculateNodeResult(nodeInstanceReleased, result, documentVersion, objectPlannerId);
            if (opt == null) {
                throw new RuntimeException("Could not calculate NodeResult.");
            }
            result.setReviewCycleResultOptionId(opt.getId());
        } else {
            opt = (ReviewCycleResultOption)this.reviewCycleResultOptionDAO.get(result.getReviewCycleResultOptionId());
        }
        this.firePostListenersEvent(debugContext, documentVersion, nodeInstanceReleased, objectPlannerReleaseId);
        this.setDocumentVersionStatus(debugContext, messages, documentVersion, opt, objectPlannerReleaseId);
        this.reviewCycleNodeResultDAO.update(result);
        debugContext.addUpdateNodeResultMessage(result);
        this.logDebug(messages, "UPDATE: ReviewCycleNodeResult [" + result.getId() + "], new values: ");
        this.logDebug(messages, "... reviewCycleResultOptionId [" + result.getReviewCycleResultOptionId() + "]");
        this.logDebug(messages, "... reviewCycleCellResultId [" + result.getReviewCycleCellResultId() + "]");
        this.logDebug(messages, "... documentVersionId [" + result.getDocumentVersionId() + "]");
        this.logDebug(messages, "... arrivalDate/ObjectList [" + result.getArrivalDate() + "] / [" + result.getArrivalObjectListId() + "]");
        this.logDebug(messages, "... departureDate/ObjectList [" + result.getDepartureDate() + "] / [" + result.getDepartureObjectListId() + "]");
        this.logDebug(messages, "... finished [" + result.getFinished() + "]");
        if (nextNodeId != null && this.reviewCycleResultOptionDAO.getByReviewCycleNode(nextNodeId).isEmpty()) {
            this.finishReviewCycleCell(debugContext, messages, (ReviewCycleCellResult)this.reviewCycleCellResultDAO.get(result.getReviewCycleCellResultId()), (ReviewCycleResultOption)this.reviewCycleResultOptionDAO.get(result.getReviewCycleResultOptionId()));
        }
        debugContext.closeDebugNode();
    }

    public void firePreListenersEvent(DebugContext debugContext, List<String> messages, DocumentVersion documentVersion, ReviewCycleNodeInstanceReleased nodeInstanceReleased, Long objectPlannerReleaseId) {
        debugContext.openDebugNode("ReviewUtils.firePreListenersEvent");
        this.fireListenersEvent(debugContext, documentVersion, nodeInstanceReleased, objectPlannerReleaseId, true);
        debugContext.closeDebugNode();
    }

    private void fireListenersEvent(DebugContext debugContext, DocumentVersion documentVersion, ReviewCycleNodeInstanceReleased nodeInstanceReleased, Long objectPlannerReleaseId, boolean isPreListener) {
        debugContext.openDebugNode("ReviewUtils.fireListenersEvent");
        Long documentVersionId = documentVersion.getId();
        List<ListenerJoin> joins = this.reviewCycleNodeInstanceNotificationDAO.getListenerJoins(nodeInstanceReleased.getReviewCycleNodeInstanceId(), false);
        log.info("Will fireListenersEvent for [nodeInstanceReleased=" + nodeInstanceReleased.getId() + "] [documentVersionId=" + documentVersionId + "]");
        for (ListenerJoin join : joins) {
            if (!join.getReviewCycleNodeListenerIsPreListener().equals(isPreListener)) continue;
            if (join.getReviewCycleNodeInstanceNotificationId() != null) {
                this.reviewCycleNodeInstanceNotificationListener.listen(debugContext, join, documentVersion, nodeInstanceReleased);
                continue;
            }
            if (join.getReviewCycleNodeInstancePlottOrderListenerId() == null) continue;
            this.reviewCycleNodeInstancePlotOrderListener.listen(debugContext, join, documentVersion, nodeInstanceReleased, objectPlannerReleaseId);
        }
        debugContext.closeDebugNode();
    }

    public void firePostListenersEvent(DebugContext debugContext, DocumentVersion documentVersion, ReviewCycleNodeInstanceReleased nodeInstanceReleased, Long objectPlannerReleaseId) {
        debugContext.openDebugNode("firePostListenersEvent");
        this.fireListenersEvent(debugContext, documentVersion, nodeInstanceReleased, objectPlannerReleaseId, false);
        debugContext.closeDebugNode();
    }

    public ReviewCycleNodeResult moveDocumentVersionToNode(DebugContext debugContext, List<String> messages, ReviewCycleNodeInstanceReleased nextNodeInstance, Long objectListReleaseId, Long objectPlannerReleaseId, Long reviewCycleInstanceReleasedId, ReviewCycleNodeResult nodeResult, DocumentVersion documentVersion) {
        debugContext.openDebugNode("ReviewUtils.moveDocumentVersionToNode");
        documentVersion.setActiveNodeInstanceId(nextNodeInstance.getReviewCycleNodeInstanceId());
        this.documentVersionDAO.update(documentVersion);
        debugContext.addUpdateDocumentVersionMessage(documentVersion);
        this.logDebug(messages, "UPDATE: DocumentVersion [" + documentVersion.getId() + ":" + documentVersion.getName() + "]");
        this.logDebug(messages, "... activeNodeInstance [" + documentVersion.getActiveNodeInstanceId() + "] for ReviewCycleNode [" + nextNodeInstance.getReviewCycleNodeId() + "]");
        ReviewCycleNodeResult destNodeResult = this.reviewCycleNodeResultDAO.getByNodeAndDocumentVersion(nextNodeInstance.getReviewCycleNodeId(), documentVersion.getId());
        if (destNodeResult == null) {
            destNodeResult = this.insertReviewCycleNodeResult(debugContext, messages, documentVersion, this.reviewCycleNodeDAO.getActiveByDocumentVersion(documentVersion.getId()), objectListReleaseId, objectPlannerReleaseId, reviewCycleInstanceReleasedId, (ReviewCycleCellResult)this.reviewCycleCellResultDAO.get(nodeResult.getReviewCycleCellResultId()));
        }
        debugContext.closeDebugNode();
        return destNodeResult;
    }

    private ReviewCycleResultOption calculateNodeResult(ReviewCycleNodeInstanceReleased nodeInstanceRel, ReviewCycleNodeResult result, DocumentVersion documentVersion, Long objectPlannerId) {
        boolean skipNode = false;
        OrganisationPerson asBuiltContractorOrganisationPerson = this.organisationPersonDAO.getAsBuiltContractorOrganisationPerson(objectPlannerId);
        skipNode = this.reviewOgnlHelper.verifyReviewCycleNodeSkippingRule(nodeInstanceRel.getId(), documentVersion.getId(), asBuiltContractorOrganisationPerson);
        List<IReviewCycleNodePosition> positions = null;
        if (nodeInstanceRel != null) {
            positions = this.reviewCycleNodePositionDAO.getByNodeInstanceReleasedAndDocumentVersion(nodeInstanceRel.getId(), documentVersion.getId());
        }
        if (positions == null || positions.isEmpty() || skipNode) {
            return this.reviewCycleResultOptionDAO.getEmptyNodeOptionByReviewCycleCell(((ReviewCycleNode)this.reviewCycleNodeDAO.get(result.getReviewCycleNodeId())).getReviewCycleCellId());
        }
        List<ReviewCyclePositionResult> reviews = this.reviewCyclePositionResultDAO.getByReviewCycleNodeAndDocumentVersion(nodeInstanceRel.getReviewCycleNodeId(), documentVersion.getId());
        Map resultOptions = this.reviewCycleResultOptionDAO.getByReviewCycleNode(nodeInstanceRel.getReviewCycleNodeId()).stream().collect(Collectors.toMap(Persistent::getId, Function.identity()));
        HashMap<Long, Integer> results = new HashMap<Long, Integer>();
        for (IReviewCycleNodePosition position : positions) {
            for (ReviewCyclePositionResult res : reviews) {
                if (res.getReviewCycleResultOptionId() == null || res.getRealmId() == null || !res.getRealmId().equals(position.getRealmId()) || !position.getProjectParticipationId().equals(((ProjectParticipant)this.projectParticipantDAO.get(res.getProjectParticipantId())).getParticipationId())) continue;
                ReviewCycleResultOption opt = (ReviewCycleResultOption)resultOptions.get(res.getReviewCycleResultOptionId());
                if (opt.isFinishCellFlag().booleanValue()) {
                    return opt;
                }
                results.compute(res.getReviewCycleResultOptionId(), (key, num) -> num == null ? 1 : num + 1);
            }
        }
        ReviewCycleResultOption ret = null;
        for (Map.Entry num2 : results.entrySet()) {
            if (ret != null && (Integer)num2.getValue() <= (Integer)results.get(ret.getId())) continue;
            ret = (ReviewCycleResultOption)resultOptions.get(num2.getKey());
        }
        return ret;
    }

    private void setDocumentVersionStatus(DebugContext debugContext, List<String> messages, DocumentVersion documentVersion, ReviewCycleResultOption opt, Long objectPlannerReleaseId) {
        debugContext.openDebugNode("ReviewUtils.setDocumentVersionStatus");
        if (opt == null || opt.getDocumentVersionStatus() == null) {
            debugContext.closeDebugNode("no documentVersionStatus set");
            return;
        }
        if (opt.getDocumentVersionStatus() > 0) {
            DocumentVersionStatusChange change = new DocumentVersionStatusChange();
            change.setChangeDate(Double.valueOf((double)Instant.now().toEpochMilli() / 1000.0));
            change.setDocumentVersionId(documentVersion.getId());
            change.setFileName(documentVersion.getFileName());
            change.setName(documentVersion.getName());
            change.setOldStatus(documentVersion.getStatus());
            change.setNewStatus(opt.getDocumentVersionStatus());
            change.setReviewCycleNodeId(Long.valueOf(0L));
            change = (DocumentVersionStatusChange)this.documentVersionStatusChangeDAO.save(change);
            debugContext.addSaveDocumentVersionStatusChange(change);
            this.logDebug(messages, "INSERT: DocumentVersionStatusChange [" + change.getId() + "] for DocumentVersion [" + change.getDocumentVersionId() + ":" + documentVersion.getName() + "]");
            this.logDebug(messages, "... changeDate [" + change.getChangeDate() + "]");
            this.logDebug(messages, "... fileName [" + change.getFileName() + "]");
            this.logDebug(messages, "... oldStatus [" + DocumentVersionStatus.getByValue((Integer)change.getOldStatus()) + "] --> newStatus [" + DocumentVersionStatus.getByValue((Integer)change.getNewStatus()) + "]");
            documentVersion.setStatus(opt.getDocumentVersionStatus());
            this.documentVersionDAO.update(documentVersion);
            debugContext.addUpdateDocumentVersionStatusStatusChange(documentVersion);
            this.logDebug(messages, "UPDATE: DocumentVersion [" + documentVersion.getId() + ":" + documentVersion.getName() + "] zu Status [" + DocumentVersionStatus.getByValue((Integer)documentVersion.getStatus()) + "]");
            this.createObjectPlannerDefinitionEMailSnippets(debugContext, messages, documentVersion, objectPlannerReleaseId);
        }
        debugContext.closeDebugNode();
    }

    private void finishReviewCycleCell(DebugContext debugContext, List<String> messages, ReviewCycleCellResult reviewCycleCellResult, ReviewCycleResultOption reviewCycleResultOption) {
        debugContext.openDebugNode("ReviewUtils.finishedReviewCycleCell");
        reviewCycleCellResult.setFinished(Boolean.valueOf(true));
        reviewCycleCellResult.setReviewCycleResultOptionId(reviewCycleResultOption.getId());
        this.reviewCycleCellResultDAO.update(reviewCycleCellResult);
        debugContext.addUpdateReviewCycleCellResultMessage(reviewCycleCellResult);
        this.logDebug(messages, "UPDATE: ReviewCycleCellResult [" + reviewCycleCellResult.getId() + "] for ReviewCycleCell [" + reviewCycleCellResult.getReviewCycleCellId() + "] and DocumentVersion [" + reviewCycleCellResult.getDocumentVersionId() + "]");
        this.logDebug(messages, "... Finished [" + reviewCycleCellResult.getFinished() + "]");
        this.logDebug(messages, "... ResultOption [" + reviewCycleCellResult.getReviewCycleResultOptionId() + ":" + reviewCycleResultOption.getName() + "]");
        debugContext.closeDebugNode();
    }

    public ReviewCycleNodeResult insertReviewCycleNodeResult(DebugContext debugContext, List<String> messages, DocumentVersion documentVersion, ReviewCycleNode activeByDocumentVersion, Long objectListReleaseId, Long objectPlannerReleaseId, Long reviewCycleInstanceReleasedId, ReviewCycleCellResult newCellResult) {
        debugContext.openDebugNode("ReviewUtils.insertReviewCycleNodeResult");
        ReviewCycleNodeResult result = new ReviewCycleNodeResult();
        result.setArrivalObjectListId(objectListReleaseId);
        result.setArrivalDate(Double.valueOf((double)Instant.now().toEpochMilli() / 1000.0));
        result.setDocumentVersionId(documentVersion.getId());
        result.setFinished(Boolean.valueOf(false));
        result.setReviewCycleNodeId(activeByDocumentVersion.getId());
        result.setReviewCycleCellResultId(newCellResult.getId());
        result.setReviewCycleResultOptionId(null);
        result = (ReviewCycleNodeResult)this.reviewCycleNodeResultDAO.save(result);
        debugContext.addUpdateNodeResultMessage(result);
        this.logDebug(messages, "INSERT: ReviewCycleNodeResult [" + result.getId() + "] zu DocumentVersion [" + result.getDocumentVersionId() + ":" + documentVersion.getName() + "]");
        this.logDebug(messages, "... arrivalDate [" + result.getArrivalDate() + "]; arrivalObjectList(Release) [" + objectListReleaseId + "]");
        this.logDebug(messages, "... finished [" + result.getFinished() + "]");
        this.logDebug(messages, "... ReviewCycleNode [" + result.getReviewCycleNodeId() + ":" + activeByDocumentVersion.getName() + "]");
        this.logDebug(messages, "... ReviewCycleCellResult [" + result.getReviewCycleCellResultId() + "] zu ReviewCycleCell [" + newCellResult.getReviewCycleCellId() + "] mit ResultOption [" + newCellResult.getReviewCycleResultOptionId() + "]");
        this.logDebug(messages, "... ResultOptionId [" + result.getReviewCycleResultOptionId() + "]");
        ReviewCycleNodeInstanceReleased nodeInstanceReleased = this.reviewCycleNodeInstanceReleasedDAO.getByReviewCycleInstanceReleased(reviewCycleInstanceReleasedId, activeByDocumentVersion.getId());
        this.firePreListenersEvent(debugContext, messages, documentVersion, nodeInstanceReleased, objectPlannerReleaseId);
        debugContext.closeDebugNode();
        return result;
    }

    public void createObjectPlannerDefinitionEMailSnippets(DebugContext debugContext, List<String> messages, DocumentVersion documentVersion, Long objectPlannerReleaseId) {
        debugContext.openDebugNode("ReviewUtils.createObjectPlannerDefinitionEmailSnippets");
        if (documentVersion.getStatus().intValue() != DocumentVersionStatus.DELETED.getValue() && documentVersion.getStatus().intValue() != DocumentVersionStatus.INVALIDATEDALL.getValue() && documentVersion.getStatus().intValue() != DocumentVersionStatus.INVALIDATEDVERSION.getValue() && documentVersion.getStatus().intValue() != DocumentVersionStatus.RELEASEDNEGATIV.getValue() && documentVersion.getStatus().intValue() != DocumentVersionStatus.RELEASEDPOSITIV.getValue()) {
            debugContext.closeDebugNode("status not appropriate for function");
            return;
        }
        List<ObjectPlannerPositionRelease> positions = this.objectPlannerPositionReleaseDAO.getByObjectPlanner(objectPlannerReleaseId);
        List objectPlannerPositionDefinitionIds = positions.stream().map(ObjectPlannerPositionRelease::getDefinitionId).collect(Collectors.toList());
        HashMap definitions = objectPlannerPositionDefinitionIds.size() > 0 ? this.objectPlannerPositionDefinitionDAO.getBatch(objectPlannerPositionDefinitionIds).stream().collect(Collectors.toMap(Persistent::getId, Function.identity())) : new HashMap();
        List participationIds = positions.stream().map(ObjectPlannerPositionRelease::getProjectParticipationId).collect(Collectors.toList());
        HashMap projectParticipations = participationIds.size() > 0 ? this.projectParticipationDAO.getBatch(participationIds).stream().collect(Collectors.toMap(Persistent::getId, Function.identity())) : new HashMap();
        Map<Long, List<ProjectParticipant>> projectParticipants = this.projectParticipantDAO.getByParticipations(projectParticipations.keySet()).stream().collect(Collectors.groupingBy(ProjectParticipant::getParticipationId));
        List organisationPersonIds = projectParticipants.values().stream().flatMap(a -> a.stream()).map(ProjectParticipant::getOrganisationPersonId).collect(Collectors.toList());
        HashMap organisationPersons = organisationPersonIds.size() > 0 ? this.organisationPersonDAO.getBatch(organisationPersonIds).stream().collect(Collectors.toMap(Persistent::getId, Function.identity())) : new HashMap();
        List<DocumentVersion> revisedDocumentVersions = this.documentVersionDAO.getByRevisedDocumentVersion(documentVersion);
        Collections.sort(revisedDocumentVersions, new Comparator<DocumentVersion>(){

            @Override
            public int compare(DocumentVersion dv1, DocumentVersion dv2) {
                Double uploadedOne = dv1.getUploaded();
                Double uploadedTwo = dv2.getUploaded();
                if (uploadedOne < uploadedTwo) {
                    return -1;
                }
                if (uploadedOne > uploadedTwo) {
                    return 1;
                }
                return 0;
            }
        });
        DocumentVersion lastRevision = revisedDocumentVersions.size() > 0 ? revisedDocumentVersions.get(revisedDocumentVersions.size() - 1) : null;
        int dvStatus = documentVersion.getStatus();
        boolean isRevision = false;
        if (dvStatus == DocumentVersionStatus.INVALIDATEDVERSION.getValue() && lastRevision != null && lastRevision.getStatus().intValue() == DocumentVersionStatus.RELEASEDPOSITIV.getValue()) {
            isRevision = true;
        }
        int mask = 1;
        if (dvStatus == DocumentVersionStatus.RELEASEDNEGATIV.getValue()) {
            mask = 1 << ObjectPlannerPositionDefinitionStatus.RELEASEDNEGATIV.getValue() - 1;
        } else if (dvStatus == DocumentVersionStatus.INVALIDATEDVERSION.getValue() && !isRevision) {
            mask = 1 << ObjectPlannerPositionDefinitionStatus.INVALIDATEDVERSION.getValue() - 1;
        } else if (dvStatus == DocumentVersionStatus.INVALIDATEDALL.getValue()) {
            mask = 1 << ObjectPlannerPositionDefinitionStatus.INVALIDATEDALL.getValue() - 1;
        } else if (dvStatus == DocumentVersionStatus.DELETED.getValue()) {
            mask = 1 << ObjectPlannerPositionDefinitionStatus.DELETED.getValue() - 1;
        } else if (isRevision) {
            mask = 1 << ObjectPlannerPositionDefinitionStatus.REVISED.getValue() - 1;
        }
        for (ObjectPlannerPositionRelease position : positions) {
            ProjectParticipation participation;
            StatusEmailSnippetType snippetType;
            ObjectPlannerPositionDefinition definition = (ObjectPlannerPositionDefinition)definitions.get(position.getDefinitionId());
            int check = definition.getStatusNotification() & mask;
            if (check == 0 || (snippetType = this.getSnippetType(DocumentVersionStatus.getByValue((Integer)documentVersion.getStatus()))) == null || !(participation = (ProjectParticipation)projectParticipations.get(position.getProjectParticipationId())).getInvalidated().equals(0)) continue;
            for (ProjectParticipant participant : projectParticipants.get(participation.getId())) {
                OrganisationPerson organisationPerson = (OrganisationPerson)organisationPersons.get(participant.getOrganisationPersonId());
                if (organisationPerson.getRetiredFlag().booleanValue() || participant.isInactiveFlag().booleanValue()) continue;
                StatusEmailSnippet statusSnippet = new StatusEmailSnippet();
                EmailSnippet snippet = new EmailSnippet();
                statusSnippet.setDocumentVersionId(documentVersion.getId());
                snippet.setOrganisationPersonId(organisationPerson.getId());
                snippet.setSendTime(Double.valueOf((double)Instant.now().toEpochMilli() / 1000.0));
                statusSnippet.setType(Integer.valueOf(snippetType.getValue()));
                this.emailSnippetDAO.save(snippet);
                debugContext.addSaveEmailSnippetMessage(snippet, null);
                this.logDebug(messages, "INSERT: EmailSnippet; OP [" + snippet.getOrganisationPersonId() + "], sendTime [" + snippet.getSendTime() + "]");
                statusSnippet.setEmailSnippetId(snippet.getId());
                this.statusEmailSnippetDAO.save(statusSnippet);
                debugContext.addSaveStatusEmailSnippetMessage(statusSnippet);
                this.logDebug(messages, "INSERT: StatusEmailSnippet; DV [" + statusSnippet.getDocumentVersionId() + "]; type [" + statusSnippet.getType() + "]; emailSnippetId [" + statusSnippet.getEmailSnippetId() + "]");
            }
            this.taskUtils.createSelectCellConnectionAttachmentMail(debugContext, (AttachmentMailJoin)this.emailAttachmentDAO.getAttachmentJoin(documentVersion.getId(), participation.getId()));
            this.logDebug(messages, "Ausgef\u00fchrt: Bereits bisher vorhandene Methode [TaskUtils.createSelectCellConnectionAttachmentMail]");
        }
        debugContext.closeDebugNode();
    }

    private StatusEmailSnippetType getSnippetType(DocumentVersionStatus status) {
        switch (status) {
            case DELETED: {
                return StatusEmailSnippetType.DOCUMENT_VERSION_DELETED;
            }
            case INVALIDATEDVERSION: {
                return StatusEmailSnippetType.DOCUMENT_VERSION_INVALIDATED;
            }
            case INVALIDATEDALL: {
                return StatusEmailSnippetType.DOCUMENT_INVALIDATED;
            }
            case RELEASEDPOSITIV: {
                return StatusEmailSnippetType.RELEASED;
            }
            case RELEASEDNEGATIV: {
                return StatusEmailSnippetType.DOCUMENT_RELEASE_DENIED;
            }
        }
        return null;
    }

    public void deleteReviewCyclePositionResultsWithSubElementsId(Long reviewCyclePositionResultId, ReviewCycleNodeResult reviewCycleNodeResult, ReviewCycleCellResult reviewCycleCellResult, DocumentVersion documentVersion, ReviewCycleResultOption reviewCycleResultOption, boolean checkNodeIsFinished, boolean isCommentReference) {
        DocumentVersionStatus documentVersionStatus;
        List<Attachment> attachments;
        List<Long> attachmentIds;
        if (checkNodeIsFinished || isCommentReference) {
            throw new UnsupportedOperationException("Not yet implemented case, please inspect old code and implement.");
        }
        Long documentVersionId = documentVersion.getId();
        List<ReviewTaskDone> reviewTasksDone = this.reviewTaskDoneDAO.getByDocumentVersionAndPositionResult(documentVersionId, reviewCyclePositionResultId);
        List<AttachedReviewTaskDone> attachedReviewTasksDone = this.attachedReviewTaskDoneDAO.getByDocumentVersionAndPositionResult(documentVersionId, reviewCyclePositionResultId);
        ArrayList<Long> taskIds = new ArrayList<Long>();
        for (ReviewTaskDone reviewTaskDone : reviewTasksDone) {
            taskIds.add(reviewTaskDone.getTaskId());
        }
        for (AttachedReviewTaskDone attachedReviewTaskDone : attachedReviewTasksDone) {
            taskIds.add(attachedReviewTaskDone.getTaskId());
        }
        if (taskIds.size() > 0) {
            TaskHelper.deleteTaskEmails(taskIds, this.emailSnippetDAO, this.taskEmailSnippetDAO, this.futureEmailDAO);
            this.taskUtils.deleteReviewTasksDone(taskIds);
            this.taskUtils.deleteAttachedReviewTasksDone(taskIds);
        }
        if ((attachmentIds = QueryHelper.getPersistentIds(attachments = this.attachmentDAO.getByPositionResult(reviewCyclePositionResultId))).size() > 0) {
            for (Attachment attachment : attachments) {
                log.info("deleteReviewCyclePositionResultsWithSubElementsId: DocumentVersion [" + documentVersion.getId() + ":" + documentVersion.getName() + "]: positionResultId [" + reviewCyclePositionResultId + "]:");
                log.info("Deleting Attachment [" + attachment.getId() + "] with filename [" + attachment.getFilename() + "].");
            }
            this.attachmentDAO.deleteBatch(attachmentIds);
        }
        this.positionResultAttachmentMapDAO.deleteByPositionResultId(reviewCyclePositionResultId);
        this.reviewCyclePositionResultDAO.delete(reviewCyclePositionResultId);
        DocumentVersionStatus documentVersionStatus2 = documentVersionStatus = reviewCycleResultOption != null && reviewCycleResultOption.getId() != null ? DocumentVersionStatus.getByValue((Integer)reviewCycleResultOption.getDocumentVersionStatus()) : null;
        if (documentVersionStatus != null && (documentVersionStatus == DocumentVersionStatus.INVALIDATEDVERSION || documentVersionStatus == DocumentVersionStatus.INVALIDATEDALL || documentVersionStatus == DocumentVersionStatus.DELETED)) {
            if (documentVersionStatus == DocumentVersionStatus.DELETED) {
                Long documentId = documentVersion.getDocumentId();
                Document document = (Document)this.documentDAO.get(documentId);
                document.setHasDocumentVersions(Boolean.valueOf(true));
                this.documentDAO.update(document);
                DocumentRelease documentRelease = this.documentReleaseDAO.getReleasedDocument(documentId);
                if (documentRelease != null) {
                    documentRelease.setHasDocumentVersions(Boolean.valueOf(true));
                    this.documentReleaseDAO.update(documentRelease);
                }
            }
            reviewCycleNodeResult.setFinished(Boolean.valueOf(false));
            reviewCycleNodeResult.setReviewCycleResultOptionId(null);
            reviewCycleNodeResult.setDepartureDate(null);
            reviewCycleNodeResult.setArrivalObjectListId(null);
            this.reviewCycleNodeResultDAO.update(reviewCycleNodeResult);
            reviewCycleCellResult.setFinished(Boolean.valueOf(false));
            reviewCycleCellResult.setReviewCycleResultOptionId(reviewCycleNodeResult.getReviewCycleResultOptionId());
            this.reviewCycleCellResultDAO.update(reviewCycleCellResult);
            documentVersion.setStatus(Integer.valueOf(DocumentVersionStatus.INREVIEW.getValue()));
            this.documentVersionDAO.update(documentVersion);
            return;
        }
    }

    public boolean hasReviewCycleNodePositionReleasedWithPositions(Long reviewCycleNodePositionReleasedId, Long documentId, Long documentVersionId, OrganisationPerson asBuiltContractorOrgPerson) {
        List<ReviewCycleNodeInstanceReleased> candidates = this.reviewCycleNodeInstanceReleasedDAO.getPopulatedReviewCycleNodeInstanceReleaseds(reviewCycleNodePositionReleasedId);
        for (ReviewCycleNodeInstanceReleased candidate : candidates) {
            Long candidateNodeInstanceReleasedId = candidate.getId();
            boolean skipNode = false;
            skipNode = documentVersionId != null ? this.reviewOgnlHelper.verifyReviewCycleNodeSkippingRule(candidateNodeInstanceReleasedId, documentVersionId, asBuiltContractorOrgPerson) : this.reviewOgnlHelper.verifyReviewCycleNodeSkippingRuleForDocument(candidateNodeInstanceReleasedId, documentId, asBuiltContractorOrgPerson);
            if (skipNode) continue;
            return true;
        }
        return false;
    }

    private void logDebug(List<String> messages, String message) {
        if (log.isDebugEnabled()) {
            log.debug(message);
        }
        if (messages != null) {
            messages.add(message);
        }
    }

    public ReviewCycleInfo constructReviewCycleInfoByTreeJoins(List<ReviewCycleTreeJoin> joins, String personVariablesUserLocale, List<String> contentLocales) {
        ReviewCycleInfo reviewCycleInfo = new ReviewCycleInfo();
        HashMap<Long, ReviewCycle> idToCycle = new HashMap<Long, ReviewCycle>();
        HashMap<Long, ReviewCycleCell> idToCell = new HashMap<Long, ReviewCycleCell>();
        HashMap<Long, ReviewCycleNode> idToNode = new HashMap<Long, ReviewCycleNode>();
        HashSet<Long> endNodeIds = new HashSet<Long>();
        HashMap cycleIdToCells = new HashMap();
        HashMap cellIdToNodes = new HashMap();
        HashMap cellIdToLeavingConnections = new HashMap();
        HashMap cellIdToIncomingConnections = new HashMap();
        HashSet<Long> processedCellIds = new HashSet<Long>();
        HashSet<Long> processedNodeIds = new HashSet<Long>();
        for (ReviewCycleTreeJoin join : joins) {
            Long cycleId = join.getReviewCycleId();
            Long cellId = join.getReviewCycleCellId();
            Long nodeId = join.getReviewCycleNodeId();
            Long endNodeId = join.getEndNodeId();
            Long sourceCellId = join.getReviewCycleCellConnectionSourceCellId();
            Long destinationCellId = join.getReviewCycleCellConnectionDestinationCellId();
            String reviewCycleName = join.getReviewCycleName();
            reviewCycleName = I18nHelper.convertDatabaseToJs(reviewCycleName, personVariablesUserLocale, contentLocales);
            join.setReviewCycleName(reviewCycleName);
            String reviewCycleCellName = join.getReviewCycleCellName();
            reviewCycleCellName = I18nHelper.convertDatabaseToJs(reviewCycleCellName, personVariablesUserLocale, contentLocales);
            join.setReviewCycleCellName(reviewCycleCellName);
            String reviewCycleNodeName = join.getReviewCycleNodeName();
            reviewCycleNodeName = I18nHelper.convertDatabaseToJs(reviewCycleNodeName, personVariablesUserLocale, contentLocales);
            join.setReviewCycleNodeName(reviewCycleNodeName);
            if (cycleId != null) {
                idToCycle.put(cycleId, join.getReviewCycle());
            }
            if (cellId != null && !processedCellIds.contains(cellId)) {
                idToCell.put(cellId, join.getReviewCycleCell());
                if (!cycleIdToCells.containsKey(cycleId)) {
                    cycleIdToCells.put(cycleId, new ArrayList());
                }
                ((List)cycleIdToCells.get(cycleId)).add(join.getReviewCycleCell());
                processedCellIds.add(cellId);
            }
            if (nodeId != null && !processedNodeIds.contains(nodeId)) {
                idToNode.put(nodeId, join.getReviewCycleNode());
                if (!cellIdToNodes.containsKey(cellId)) {
                    cellIdToNodes.put(cellId, new ArrayList());
                }
                ((List)cellIdToNodes.get(cellId)).add(join.getReviewCycleNode());
                processedNodeIds.add(nodeId);
            }
            if (endNodeId != null) {
                endNodeIds.add(endNodeId);
            }
            if (sourceCellId != null) {
                if (!cellIdToLeavingConnections.containsKey(sourceCellId)) {
                    cellIdToLeavingConnections.put(sourceCellId, new ArrayList());
                }
                ((List)cellIdToLeavingConnections.get(sourceCellId)).add(join.getReviewCycleCellConnection());
            }
            if (destinationCellId == null) continue;
            if (!cellIdToIncomingConnections.containsKey(destinationCellId)) {
                cellIdToIncomingConnections.put(destinationCellId, new ArrayList());
            }
            ((List)cellIdToIncomingConnections.get(destinationCellId)).add(join.getReviewCycleCellConnection());
        }
        reviewCycleInfo.setIdToCycle(idToCycle);
        reviewCycleInfo.setIdToCell(idToCell);
        reviewCycleInfo.setIdToNode(idToNode);
        reviewCycleInfo.setEndNodeIds(endNodeIds);
        reviewCycleInfo.setCycleIdToCells(cycleIdToCells);
        reviewCycleInfo.setCellIdToNodes(cellIdToNodes);
        reviewCycleInfo.setCellIdToLeavingConnections(cellIdToLeavingConnections);
        reviewCycleInfo.setCellIdToIncomingConnections(cellIdToIncomingConnections);
        List resultOptions = this.reviewCycleResultOptionDAO.getAll();
        for (ReviewCycleResultOption resultOption : resultOptions) {
            String resultOptionName = resultOption.getName();
            resultOptionName = I18nHelper.convertDatabaseToJs(resultOptionName, personVariablesUserLocale, contentLocales);
            resultOption.setName(resultOptionName);
        }
        reviewCycleInfo.setResultOptions(resultOptions);
        return reviewCycleInfo;
    }

    public List<ReviewCycleResultOption> fetchAndConvertResultOptions(String personVariablesUserLocale, List<String> contentLocales) {
        List resultOptions = this.reviewCycleResultOptionDAO.getAll();
        for (ReviewCycleResultOption resultOption : resultOptions) {
            String name = I18nHelper.convertDatabaseToJs(resultOption.getName(), personVariablesUserLocale, contentLocales);
            resultOption.setName(name);
        }
        return resultOptions;
    }

    public void abortDocumentsVersionOfObject(Long organisationPersonId, Long objectId, Certificate certificate, ProjectParticipant signer, String password) {
        List<DocumentVersionContextJoin> contextJoins = this.documentVersionDAO.getContextJoinsByObject(objectId);
        HashSet<Long> objectPlannerIds = new HashSet<Long>();
        for (DocumentVersionContextJoin documentVersionContextJoin : contextJoins) {
            objectPlannerIds.add(documentVersionContextJoin.getObjectPlannerId());
        }
        HashMap<Long, ReviewCycleResultOption> objectPlannerIdToAbortedOption = new HashMap<Long, ReviewCycleResultOption>();
        for (Long objectPlannerId : objectPlannerIds) {
            ReviewCycleResultOption abortedOption = this.reviewCycleResultOptionDAO.getAbortedOptionByObjectPlannerViaCycleInstance(objectPlannerId);
            objectPlannerIdToAbortedOption.put(objectPlannerId, abortedOption);
        }
        String string = OdfHelper.getPersonVariablesUserLocaleByPrincipal(this.personVariablesDAO);
        ResourceBundle resourceBundle = CdesImplMessages.getResourceBundle(string);
        String abortedLabel = resourceBundle.getString("objectListChangeAccessReviewAbortedLabel");
        for (DocumentVersionContextJoin documentVersionContextJoin : contextJoins) {
            DocumentVersion documentVersion = documentVersionContextJoin.getDocumentVersion();
            Long objectPlannerId = documentVersionContextJoin.getObjectPlannerId();
            ReviewCycleResultOption abortedOption = (ReviewCycleResultOption)objectPlannerIdToAbortedOption.get(objectPlannerId);
            Long abortedOptionId = abortedOption.getId();
            if (documentVersionContextJoin.getDocumentId() == null || DocumentVersionHelper.isDeleted(documentVersion) || !DocumentVersionHelper.isInAction(documentVersion) || abortedOptionId == null || documentVersion.getStatus().longValue() == abortedOption.getDocumentVersionStatus().longValue()) continue;
            Long documentVersionId = documentVersion.getId();
            this.documentUtils.invalidateDocumentVersionForAbort(organisationPersonId, documentVersionId, signer, certificate, password, abortedLabel, abortedOption);
        }
        HashSet<Long> documentIds = new HashSet<Long>();
        for (DocumentVersionContextJoin contextJoin : contextJoins) {
            documentIds.add(contextJoin.getDocumentId());
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        for (Long documentId : documentIds) {
            ReviewCycleEntryTask task = this.reviewCycleEntryTaskDAO.getByDocument(documentId);
            if (task == null) continue;
            hashSet.add(task.getTaskId());
        }
        this.taskUtils.deleteReviewCycleEntryTasks(hashSet);
    }
}

